/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript;

import Preferences.Cereal;
import Preferences.CerealRegistry;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import Utilities.CerealUtils;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class CutletPrefsPanel
extends KTitledPanel
implements Cereal,
Serializable,
ActionListener {
    private static CutletPrefsPanel singleInstance = null;
    private String version = "";
    private KTitledPanel author = new KTitledPanel("Author Signature");
    private JLabel pwdLabel = new JLabel("password   ");
    private JPasswordField pwdField = new JPasswordField();
    private KButton pwdButton = new KButton("set");
    private String encodedHashedPassword = "";
    private KTitledPanel trusted = new KTitledPanel("Trusted Others");
    private JLabel[] trustedLabel = new JLabel[2];
    private JPasswordField[] trustedField = new JPasswordField[]{new JPasswordField(), new JPasswordField()};
    private KButton trustedButton = new KButton("set");
    private String[] trustees = new String[2];
    private Font labelFont;

    public static String getAuthor() {
        return CutletPrefsPanel.singleInstance.encodedHashedPassword;
    }

    public static String[] getTrustees() {
        return CutletPrefsPanel.singleInstance.trustees;
    }

    public static CutletPrefsPanel getInstance() {
        if (singleInstance == null) {
            Object obj = CerealUtils.readFromFile("CutletPrefsPanel.ser");
            if (obj == null) {
                singleInstance = new CutletPrefsPanel();
                return singleInstance;
            }
            singleInstance = (CutletPrefsPanel)obj;
            singleInstance.setEnabled(true);
        }
        return singleInstance;
    }

    private CutletPrefsPanel() {
        super(" Cutlets ", "CutletPrefsPanel.info");
        this.add(this.author, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 11, 2, new Insets(0, 0, 2, 0)));
        this.add(this.trusted, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 11, 2, new Insets(0, 0, 2, 0)));
        this.labelFont = new Font(Cutter.defaultFont.name, Cutter.defaultFont.style, Cutter.defaultFont.size);
        this.pwdLabel.setFont(this.labelFont);
        this.pwdButton.setMargin(new Insets(0, 6, 0, 6));
        this.pwdButton.addActionListener(this);
        this.author.add(this.pwdLabel, new GBC(0, 0, 2, 1, 0.0, 0.0, 0, 0, 11, 2, new Insets(0, 10, 2, 0)));
        this.author.add(this.pwdField, new GBC(2, 0, 2, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 10, 2, 10)));
        this.author.add(this.pwdButton, new GBC(3, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(0, 10, 2, 10)));
        this.trustedLabel[0] = new JLabel("password 1 ");
        this.trustedLabel[1] = new JLabel("password 2 ");
        this.trustedLabel[0].setFont(this.labelFont);
        this.trustedLabel[1].setFont(this.labelFont);
        this.trustedButton.setMargin(new Insets(0, 6, 0, 6));
        this.trustedButton.addActionListener(this);
        this.trusted.add(this.trustedLabel[0], new GBC(0, 0, 2, 1, 0.0, 0.0, 0, 0, 11, 2, new Insets(0, 10, 2, 0)));
        this.trusted.add(this.trustedField[0], new GBC(2, 0, 2, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 10, 2, 10)));
        this.trusted.add(this.trustedLabel[1], new GBC(0, 1, 2, 1, 0.0, 0.0, 0, 0, 11, 2, new Insets(0, 10, 2, 0)));
        this.trusted.add(this.trustedField[1], new GBC(2, 1, 2, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 10, 2, 10)));
        this.trusted.add(this.trustedButton, new GBC(3, 2, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(0, 10, 2, 10)));
    }

    public void initLabels() {
        this.pwdLabel.setFont(Cutter.defaultFont.font);
        this.trustedLabel[0].setFont(Cutter.defaultFont.font);
        this.trustedLabel[1].setFont(Cutter.defaultFont.font);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.pwdButton) {
            String user = new String(this.pwdField.getPassword()).trim();
            if (user.length() == 0) {
                return;
            }
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA");
                byte[] data = new byte[user.length()];
                for (int n = 0; n < user.length(); ++n) {
                    data[n] = (byte)user.charAt(n);
                }
                sha.update(data);
                byte[] result = sha.digest();
                this.encodedHashedPassword = new String("" + new BigInteger(result));
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception: CutletPrefPanel.actionPerformed()\n\t" + ex.toString());
            }
        } else if (e.getSource() == this.trustedButton) {
            for (int j = 0; j < this.trustedField.length; ++j) {
                String user = new String(this.trustedField[j].getPassword());
                if ((user = user.trim()).length() == 0) {
                    this.trustees[j] = null;
                    continue;
                }
                try {
                    MessageDigest sha = MessageDigest.getInstance("SHA");
                    byte[] data = new byte[user.length()];
                    for (int n = 0; n < user.length(); ++n) {
                        data[n] = (byte)user.charAt(n);
                    }
                    sha.update(data);
                    byte[] result = sha.digest();
                    this.trustees[j] = new String("" + new BigInteger(result));
                    continue;
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception: CutletPrefPanel.actionPerformed()\n\t" + ex.toString());
                }
            }
        }
    }

    @Override
    public void registerSelf() {
        CerealRegistry.add(this);
    }

    @Override
    public String getCerealName() {
        return "CutletPrefsPanel";
    }

    @Override
    public void serializeSelf() {
        CerealUtils.writeToFile(this);
    }

    @Override
    public void setVersion() {
        this.version = Cutter.version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    static {
        CutletPrefsPanel.getInstance();
    }
}

