/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.receive.CmdHandlers.MessageCmdHandler;
import UI_Desktop.Cutter;
import UI_Script.BuildMsgListener;
import UI_Script.PixarDev.AbstractDevkit.DevkitScriptHandler;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.io.File;

public class BuildCmdHandler
extends CmdHandler
implements BuildMsgListener {
    private String activeSenderIP = "";
    private boolean buildFailed = false;
    private DevkitScriptHandler devkitHandler = null;
    private String allBuildStrs = "";
    private int msgCount = 0;

    public int prepareData() throws Exception {
        Cutter.setLog("    Info:BuildCmdHandler.prepareData()");
        return 0;
    }

    @Override
    public boolean canHandle(CutletCmd cmd) {
        boolean out = cmd.noun.equals("build");
        return out;
    }

    @Override
    public boolean canHandle(String noun) {
        boolean out = noun.equals("build");
        return out;
    }

    @Override
    public void buildStarted() {
        this.buildFailed = false;
        this.allBuildStrs = "";
        this.msgCount = 0;
    }

    @Override
    public void buildSentString(String msg) {
        if (msg == null) {
            return;
        }
        this.allBuildStrs = this.allBuildStrs + msg + "\n";
    }

    @Override
    public void buildFinished(String msg) {
        if (msg == null) {
            MessageCmdHandler.replyToSender(this.activeSenderIP, "buildFinished() - received a null string");
        }
        if (!this.buildFailed) {
            this.allBuildStrs = this.allBuildStrs + "Successful Build";
        }
        MessageCmdHandler.replyToSender(this.activeSenderIP, this.allBuildStrs);
        this.allBuildStrs = "";
        this.msgCount = 0;
        this.devkitHandler.removeBuildListener(this);
    }

    @Override
    public void buildFailed(String msg) {
        this.buildFailed = true;
        this.allBuildStrs = this.allBuildStrs + "Failed Build\n";
    }

    @Override
    public void execute(CutletCmd cmd) throws Exception {
        CutletCmd.CutletArg sender = cmd.getArgWithName("-sender");
        this.activeSenderIP = sender.value;
        CutletCmd.CutletArg src = cmd.getArgWithName("-src");
        CutletCmd.CutletArg dest = cmd.getArgWithName("-target");
        String action = cmd.verb;
        if (src != null && dest != null) {
            String msg;
            dest.value = TextUtils.trimTrailingChar(dest.value, '/');
            File destDir = new File(dest.value);
            src.value = TextUtils.trimTrailingChar(src.value, '/');
            String unixpath = FileUtils.toUnixPath(src.value);
            unixpath = TextUtils.trimTrailingChar(unixpath, '/');
            File srcFile = new File(unixpath);
            String destName = srcFile.getName();
            File destFile = new File(destDir, destName);
            if (!destDir.exists()) {
                msg = "Error: The destination directory \"" + destDir.getPath() + "\" does not exist!\nCannot write \"" + destName + "\"";
                MessageCmdHandler.replyToSender(this.activeSenderIP, msg);
            }
            if (action.equals("write") && destDir.exists() && cmd.dataBytes != null) {
                FileUtils.writeAsBinary(destFile, cmd.dataBytes);
                Cutter.setLog("    Info:BuildCmdHandler.execute() - Wrote " + cmd.dataBytes.length + " bytes to " + destFile.getPath());
                MessageCmdHandler.replyToSender(sender.value, "Wrote " + cmd.dataBytes.length + " bytes to \"" + destFile.getPath() + "\"\n");
            }
            if (destFile.exists()) {
                ScriptHandler handler = ScriptRegistry.getHandlerForFile(destFile);
                if (handler != null && handler instanceof DevkitScriptHandler) {
                    this.devkitHandler = (DevkitScriptHandler)handler;
                    this.devkitHandler.addBuildListener(this);
                    this.devkitHandler.execute(destFile);
                }
            } else {
                msg = "Failure Build: cannot find \"" + destFile.getPath() + "\".\nEnsure the \".cpp write permission\" checkbox is selected.";
                MessageCmdHandler.replyToSender(sender.value, msg);
            }
        }
    }

    @Override
    public void checkSyntax(CutletCmd cmd) throws Exception {
    }
}

