/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.PointRunner;
import UI_Desktop.Cutter;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class CmdHandler {
    public abstract boolean canHandle(CutletCmd var1);

    public abstract boolean canHandle(String var1);

    public abstract void execute(CutletCmd var1) throws Exception;

    public void checkSyntax(CutletCmd cmd) throws Exception {
        if (cmd.getArgWithName("-name") == null) {
            throw new Exception("The command \"" + cmd.noun + "." + cmd.verb + "\" does not have a \"-name\" flag.\nAll Cutlet commands must specify a -name \"value\".");
        }
    }

    protected void addDefaults(CutletCmd cmd) {
    }

    protected void doTimedTask(int delay_milliseconds, ActionListener l) {
        Timer timer = new Timer(delay_milliseconds, l);
        timer.setRepeats(false);
        timer.start();
    }

    public static void invokeLater(Runnable runner) {
        try {
            SwingUtilities.invokeLater(runner);
        }
        catch (Exception e) {
            Cutter.setLog("    Warning: CmdHandler.invokeLater()\n\t" + e.toString());
        }
    }

    public static void invokeAndWait(Runnable runner) {
        try {
            SwingUtilities.invokeAndWait(runner);
        }
        catch (Exception e) {
            Cutter.setLog("    Warning: CmdHandler.invokeAndWait(PointRunner)\n\t" + e.toString());
        }
    }

    public static void invokeAndWait(PointRunner runner) {
        try {
            SwingUtilities.invokeAndWait(runner);
        }
        catch (Exception e) {
            Cutter.setLog("    Warning: CmdHandler.invokeAndWait(PointRunner)\n\t" + e.toString());
        }
    }

    public static void sleep(int millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: CmdHandler.sleep()\n\t" + e.toString());
        }
    }
}

