/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.send.CutletExecutor;
import UI_Desktop.Cutter;
import UI_Tools.Zipper.ZipInput;
import Utilities.FileUtils;
import java.io.File;

public class FileCmdsHandler
extends CmdHandler {
    @Override
    public boolean canHandle(CutletCmd cmd) {
        return cmd.noun.equals("file");
    }

    @Override
    public boolean canHandle(String noun) {
        return noun.equals("file");
    }

    @Override
    public void checkSyntax(CutletCmd cmd) throws Exception {
        super.checkSyntax(cmd);
        CutletCmd.CutletArg srcArg = cmd.getArgWithName("-src");
        if (cmd.verb.equals("save") && srcArg == null) {
            throw new Exception("The following cutlet:\n\n    " + cmd.toString() + " \n\ndoes not have a -src argument. File commands must have  \na -src argument that specifies the path to a source data\nfile. The path can be absolute or relative to the Cutter\ndirectory.\n");
        }
        if (cmd.verb.equals("save")) {
            File f = CutletCmd.getSrcFile(cmd);
            if (f == null || !f.exists()) {
                throw new Exception("The source file specified by:\n\n    " + cmd.toString() + "\n\ndoes not exist. Check the path and try running the script\nagain. The path can be absolute or relative to the Cutter\ndirectory.\n");
            }
            if (!f.isDirectory() && f.length() <= 0L) {
                throw new Exception("The source file specified by:\n\n    " + cmd.toString() + "\n\nis an invalid data file. It is zero bytes in size! Check the\nfile and try running the script again.\n\n");
            }
        }
    }

    @Override
    public void execute(CutletCmd cmd) throws Exception {
        this.addDefaults(cmd);
        if (cmd.verb.equals("save") && cmd.args.length >= 1) {
            File f;
            File tmp = CutletCmd.getOutFile(cmd);
            if (tmp != null && tmp.getName().endsWith("zip")) {
                tmp = new File(tmp.getParentFile(), tmp.getName().substring(0, tmp.getName().length() - 4));
                Cutter.setLog("    Info:FileCmdsHandler.execute() - file.save deleting >" + tmp.getPath() + "<");
                FileUtils.deleteAll(tmp);
            }
            if ((f = CutletCmd.writeDataToFile(cmd)) == null) {
                throw new Exception("FileCmdsHandler.handleCmd(save) no data");
            }
            if (!cmd.srcIsDirectory) {
                return;
            }
            ZipInput zipinput = new ZipInput(f, null, null);
            try {
                String topDir = zipinput.getRootDirPath();
                File dir = new File(f.getParent(), topDir);
                if (!dir.mkdir()) {
                    return;
                }
                zipinput.restore(dir.getPath());
                Cutter.setLog("    Info: FileCmdsHandler.handleCmd(save) unzipping\n            \"" + f.getPath() + "\"");
                f = zipinput.unZipFile(true);
                if (f != null) {
                    f.delete();
                }
            }
            catch (Exception ex) {
                throw new Exception("FileCmdsHandler.handleCmd(save)\n\t" + ex.toString());
            }
            return;
        }
        if (cmd.verb.equals("delete") && cmd.args.length >= 1) {
            File f = CutletCmd.getOutFile(cmd);
            Cutter.setLog("    Info: FileUtils.doCutlet() - deleting " + f.getPath());
            FileUtils.deleteAll(f);
            return;
        }
        if (cmd.verb.equals("move")) {
            // empty if block
        }
        if (cmd.verb.equals("send")) {
            CutletCmd.CutletArg s1 = cmd.getArgWithName("-sessions");
            CutletCmd.CutletArg s2 = cmd.getArgWithName("-ip");
            if (s1 != null && s2 != null) {
                File f = new File(FileUtils.getPWDFile(), s1.value);
                String script = "file.save -src \"" + f.getPath() + "\" -name \"" + s2.value + "_sessions.txt\"\n\n" + s2.value;
                CutletExecutor ce = new CutletExecutor();
                ce.execute(script);
            } else {
                Cutter.setLog("    Error:FileCmdsHandler.execute() - the command is not properly formed. It should look like this:");
                Cutter.setLog("    file.send -sessions \"Cutter_Prefs/sessions.txt\" -ip \"192.168.1.97\"");
            }
            return;
        }
    }
}

