/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Tools.KTools;
import Utilities.MenuUtils;
import Utilities.RobotUtils;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Point;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class MenuCmdsHandler
extends CmdHandler {
    @Override
    public boolean canHandle(CutletCmd cmd) {
        return cmd.noun.equals("menu");
    }

    @Override
    public boolean canHandle(String noun) {
        return noun.equals("menu");
    }

    @Override
    public void checkSyntax(CutletCmd cmd) throws Exception {
        super.checkSyntax(cmd);
    }

    @Override
    protected void addDefaults(CutletCmd cmd) {
        super.addDefaults(cmd);
        cmd.addArg("-key", "");
        cmd.addArg("-pause", "0.05");
    }

    @Override
    public void execute(CutletCmd cmd) throws Exception {
        JMenuItem lastMenuItem;
        RobotUtils.clickOff(1000);
        CutletCmd.CutletArg nameArg = cmd.getArgWithName("-name");
        String[] parts = TextUtils.tokenize(nameArg.value, "|");
        if (parts == null || parts.length <= 0) {
            throw new Exception("Arg -name expected a value but got \"" + nameArg.value + "\"");
        }
        this.addDefaults(cmd);
        CutletCmd.CutletArg pauseArg = cmd.getArgWithName("-pause");
        int pauseMillis = (int)(1000.0 * (double)Float.parseFloat(pauseArg.value));
        if (pauseMillis < 100) {
            pauseMillis = 100;
        }
        JMenuItem menuItem = null;
        boolean menuFound = true;
        Object comp = null;
        Vector<JMenuItem> listOfMenus = new Vector<JMenuItem>();
        KTools tool = null;
        tool = KTools.getToolWithName(parts[0]);
        if (tool != null && !tool.isVisible()) {
            if (parts[0].equalsIgnoreCase("rman tool")) {
                KDesktop.openRmanToolItem.doClick();
                CmdHandler.sleep(500);
            } else {
                tool.menuItem.doClick();
            }
        }
        int index = 1;
        if (tool == null) {
            menuItem = MenuUtils.getMenuWithName(KDesktop.menuBar, parts[0]);
            if (menuItem != null) {
                listOfMenus.addElement(menuItem);
            }
        } else {
            menuItem = MenuUtils.getMenuWithName(tool, parts[index]);
            if (menuItem != null) {
                listOfMenus.addElement(menuItem);
            }
            index = 2;
        }
        while (menuItem != null && index <= parts.length - 1) {
            if ((menuItem = MenuUtils.getMenuWithName(menuItem, parts[index])) != null) {
                listOfMenus.addElement(menuItem);
            } else {
                menuFound = false;
            }
            ++index;
        }
        if (listOfMenus.size() == 0) {
            throw new Exception("Cannot find menuItem named \"" + nameArg.value + "\"");
        }
        if (menuFound && listOfMenus.size() > 1) {
            listOfMenus.removeElementAt(listOfMenus.size() - 1);
            menuFound = false;
        }
        if (menuFound && listOfMenus.size() == 1 && listOfMenus.elementAt(0) instanceof JMenu) {
            final JMenu menu = (JMenu)listOfMenus.elementAt(0);
            Cutter.setLog("clicking root level menu = " + menu.getText());
            CmdHandler.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    menu.doClick();
                }
            });
            return;
        }
        if (listOfMenus.size() >= 1) {
            JComponent parent = tool;
            if (tool == null) {
                parent = KDesktop.menuBar;
            }
            MenuUtils.clickOnMenusInList(listOfMenus, parent);
        }
        if (!menuFound && (lastMenuItem = (JMenuItem)listOfMenus.lastElement()) instanceof JMenu) {
            MenuCmdsHandler.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    lastMenuItem.doClick();
                }
            });
            int count = ((JMenu)lastMenuItem).getItemCount();
            for (int n = 0; n < count; ++n) {
                Component c = ((JMenu)lastMenuItem).getMenuComponent(n);
                JMenuItem mi = MenuUtils.getMenuWithName(c, parts[parts.length - 1]);
                if (mi == null) continue;
                listOfMenus.addElement(mi);
            }
        }
        JMenuItem[] items = MenuUtils.toMenuItemArray(listOfMenus);
        menuItem = items[items.length - 1];
        CutletCmd.CutletArg keyboardArg = cmd.getArgWithName("-key");
        Point rollOverPoint = SwingUtilities.convertPoint(menuItem, 0, 0, Cutter.desktop);
        RobotUtils.rollRobotOverItems(rollOverPoint.x, rollOverPoint.y, menuItem);
        JMenuItem item = menuItem;
        Point hitPoint = new Point(rollOverPoint.x + 5, rollOverPoint.y + 5);
        try {
            RobotUtils.moveRobotTo(hitPoint, 0);
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception ep) {
            Cutter.setLog("    Exception: MenuCmdsHandler.doMouseEventOn()\n\t" + ep.toString());
        }
        if (cmd.verb.equals("show")) {
            return;
        }
        if (cmd.verb.equals("click")) {
            Thread.currentThread();
            Thread.sleep(pauseMillis);
            if (keyboardArg != null && keyboardArg.value.equals("alt")) {
                MenuUtils.clickOnMenu(menuItem, 512);
            } else {
                MenuUtils.clickOnMenu(menuItem, 0);
            }
        }
    }
}

