/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import ClientServer.ClientServer.client.KClient;
import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.send.CutletExecutor;
import UI_Desktop.Cutter;
import UI_Tools.Monitor.Monitor;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class MessageCmdHandler
extends CmdHandler {
    public static final String SUBSTITUTE_NEWLINE = " ___NEWLINE___ ";
    public static final char SUBSTITUTE_QUOTATION = '\'';
    public static final String SUBSTITUTE_HASH = " __HASH__ ";
    public static final String SUCCESSFUL_BUILD = "Successful Build";
    public static final String FAILED_BUILD = "Failed Build";

    @Override
    public boolean canHandle(CutletCmd cmd) {
        boolean out = cmd.noun.equals("message");
        return out;
    }

    @Override
    public boolean canHandle(String noun) {
        boolean out = noun.equals("message");
        return out;
    }

    public static String[] tokenize(String input, String delim) {
        if (input == null || input.length() == 0 || input.trim().length() == 0) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, delim);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        return VectorUtils.toStringArray(v);
    }

    @Override
    public void execute(CutletCmd cmd) throws Exception {
        CutletCmd.CutletArg msg = cmd.getArgWithName("-text");
        final CutletCmd.CutletArg name = cmd.getArgWithName("-name");
        if (msg == null || msg.value == null) {
            Cutter.setLog("    Debug:MessageCmdHandler.execute() - ignoring null text");
            return;
        }
        msg.value = msg.value.replace('\'', '\"');
        msg.value = TextUtils.replaceAll(msg.value, SUBSTITUTE_NEWLINE, "\n", true, false);
        msg.value = TextUtils.replaceAll(msg.value, SUBSTITUTE_HASH, "#", true, false);
        final String[] lines = MessageCmdHandler.tokenize(msg.value, "\n");
        if (cmd.verb.equals("monitor")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (lines == null) {
                        return;
                    }
                    for (int n = 0; n < lines.length; ++n) {
                        if (lines[n].startsWith(MessageCmdHandler.SUCCESSFUL_BUILD) || lines[n].startsWith(MessageCmdHandler.FAILED_BUILD)) {
                            Monitor.appendPanelText(name.value, lines[n] + "\n", 3);
                            continue;
                        }
                        Monitor.appendPanelText(name.value, lines[n] + "\n");
                    }
                }
            });
        }
    }

    public static void replyToSender(String ip, String msg) {
        if (msg == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        String ipAddress = KClient.getLocalIP();
        String hostName = KClient.getLocalHostName();
        msg = msg.replace('\"', '\'');
        msg = msg.replaceAll("(#)", SUBSTITUTE_HASH);
        msg = msg.replaceAll("(\n)", SUBSTITUTE_NEWLINE);
        buf.append("message.monitor -src \"\" -text \"" + msg + "\" -name \"" + ipAddress + "\"\n");
        buf.append(ip);
        CutletExecutor ce = new CutletExecutor();
        ce.execute(buf.toString());
    }
}

