/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive.CmdHandlers;

import ClientServer.ClientServer.client.Client;
import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.beans.PropertyVetoException;
import java.io.File;

public class WindowCmdsHandler
extends CmdHandler {
    @Override
    public boolean canHandle(CutletCmd cmd) {
        return cmd.noun.equals("window");
    }

    @Override
    public boolean canHandle(String noun) {
        return noun.equals("window");
    }

    @Override
    public void checkSyntax(CutletCmd cmd) throws Exception {
    }

    @Override
    protected void addDefaults(CutletCmd cmd) {
        cmd.addArg("-type", "NOT_DEFINED");
        cmd.addArg("-address", Client.getLocalIP());
        cmd.addArg("-state", "off");
        cmd.addArg("-panel", "hide");
    }

    @Override
    public void execute(CutletCmd cmd) throws Exception {
        KAbstractWindow w;
        this.addDefaults(cmd);
        CutletCmd.CutletArg arg = cmd.getArgWithName("-name");
        if (arg == null || arg.value.equals("")) {
            throw new Exception("    Error: KTextWindow.handleCutletCommand(window.xxxx) no -name arg");
        }
        final String windowname = arg.value;
        if (cmd.verb.equals("open")) {
            if (cmd.permission == 0) {
                Cutter.setLog("    Error:WindowCmdsHandler.execute() - insufficient privileges to open a window on this client");
                return;
            }
            File srcFile = null;
            Object srcText = null;
            String data = null;
            KAbstractWindow w2 = KAbstractDesktop.getWindowWithTitle(windowname);
            if (w2 != null) {
                Cutter.setLog("    Info:WindowCmdsHandler.execute() - a window named \"" + windowname + "\" already exists. Will not create a new one");
                KAbstractDesktop.toFront(w2);
                return;
            }
            if (w2 == null && (srcFile = CutletCmd.getSrcFile(cmd)) != null && srcFile.exists()) {
                Cutter.setLog("    Info:WindowCmdsHandler.execute() - attempting to read \"" + srcFile.getPath() + "\"");
                data = FileUtils.read(srcFile);
                if (data == null || data.trim().length() == 0) {
                    Cutter.setLog("    Info:WindowCmdsHandler.execute() - cannot read \"" + srcFile.getPath() + "\"");
                }
            }
            final String text = data;
            Thread runner = new Thread(){

                @Override
                public void run() {
                    Cutter.setLog("    Info:WindowCmdsHandler.execute() - creating window with title \"" + windowname + "\"");
                    if (text == null) {
                        KTextWindow.addWindow(windowname);
                    } else {
                        KTextWindow.addWindow(windowname, text, true, true, true, true);
                    }
                }
            };
            WindowCmdsHandler.invokeAndWait(runner);
        }
        if ((w = KAbstractDesktop.getWindowWithTitle(windowname)) == null || !(w instanceof KTextWindow)) {
            return;
        }
        KTextWindow ktw = (KTextWindow)w;
        if (cmd.verb.equals("save") && cmd.permission == 2) {
            File file = CutletCmd.getOutFile(cmd);
            if (file == null) {
                return;
            }
            ktw.setFile(file);
            ktw.saveFile(1);
        }
        if (cmd.verb.equals("close") && cmd.permission == 2) {
            block36: {
                w = KAbstractDesktop.getWindowWithTitle(windowname);
                try {
                    w.setClosed(true);
                }
                catch (PropertyVetoException ee) {
                    if (!Cutter.input.debug) break block36;
                    Cutter.setLog("    Debug:KAbstractDesktop.CloseDocAction() exception");
                    Cutter.setLog("         " + ee.toString());
                }
            }
            return;
        }
        CutletCmd.CutletArg typeArg = cmd.getArgWithName("-type");
        if (typeArg.value.equals("NOT_DEFINED")) {
            return;
        }
        CutletCmd.CutletArg addrArg = cmd.getArgWithName("-address");
        CutletCmd.CutletArg stateArg = cmd.getArgWithName("-state");
        CutletCmd.CutletArg panelArg = cmd.getArgWithName("-panel");
        if (!ktw.upperPanel.netPanel.isVisible() && panelArg.value.equals("show")) {
            ktw.upperPanel.netButton.doClick();
        }
        if (typeArg == null) {
            return;
        }
        if (typeArg.value.equals("tcp listener")) {
            ktw.upperPanel.netPanel.popup.combo.setSelectedIndex(4);
        } else if (typeArg.value.equals("server")) {
            ktw.upperPanel.netPanel.popup.combo.setSelectedIndex(3);
        } else if (typeArg.value.equals("client")) {
            ktw.upperPanel.netPanel.popup.combo.setSelectedIndex(2);
        } else if (typeArg.value.equals("houdini")) {
            ktw.upperPanel.netPanel.popup.combo.setSelectedIndex(1);
        } else if (typeArg.value.equals("maya")) {
            ktw.upperPanel.netPanel.popup.combo.setSelectedIndex(0);
        } else {
            return;
        }
        String IP = null;
        String port = null;
        if (addrArg != null) {
            String[] tokens = TextUtils.tokenize(addrArg.value, ":");
            if (tokens == null) {
                Cutter.setLog("    Info: KTextWindow.handleCutletCommand() no IP or port specified");
                return;
            }
            if (tokens.length == 2) {
                IP = tokens[0];
                port = tokens[1];
            } else if (tokens.length == 1 && tokens[0].trim().length() > 0) {
                try {
                    Integer.parseInt(tokens[0]);
                    port = tokens[0];
                }
                catch (NumberFormatException e) {
                    IP = tokens[0];
                }
            }
        }
        if (IP != null) {
            ktw.upperPanel.netPanel.setIPFor(typeArg.value, IP);
        }
        if (port != null) {
            ktw.upperPanel.netPanel.setPortFor(typeArg.value, port);
        }
        if (stateArg == null) {
            return;
        }
        if (stateArg.value.equals("on") || stateArg.value.equals("off")) {
            ktw.upperPanel.netPanel.setActiveFor(typeArg.value, stateArg.value.equals("on"));
        }
    }
}

