/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.CutletPermissions;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.receive.CmdHandlers.CmdHandlerRegistry;
import UI_CutletScript.receive.CmdHandlers.TimeCmdsHandler;
import UI_CutletScript.receive.TCPObjectEventListener;
import UI_CutletScript.receive.TcpCutletIn;
import UI_CutletScript.send.CutletBlockDB;
import UI_Desktop.Cutter;
import Utilities.RobotUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.InetAddress;

public class CutletEventHandler
implements TCPObjectEventListener {
    public static int SLEEP_FOR_MAIN_EVENT_THREAD = 200;
    public static final int DEFAULT_CUTLET_PORT = 18990;
    private TcpCutletIn tcpListener = null;
    private StringBuffer buff = new StringBuffer();
    private String eventHostName = "";
    private String eventIPAddress = "";
    public static int globalTimePause = -1;
    public static int localTimePause = -1;

    public CutletEventHandler() {
        try {
            this.tcpListener = new TcpCutletIn(18990, this);
            this.tcpListener.start();
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: CutletEventHandler()");
            Cutter.setLog("           " + e.toString());
        }
    }

    @Override
    public synchronized void tcpObjectEventHappened(CutletBlockDB db) {
        int n;
        if (db == null) {
            return;
        }
        int status = CutletPermissions.getAuthorStatus(db.author, this.eventIPAddress);
        for (n = 0; n < db.cmds.length; ++n) {
            db.cmds[n].permission = status;
        }
        for (n = 0; n < db.cmds.length; ++n) {
            this.handleCutletCommand(n, db.cmds[n]);
            try {
                Thread.currentThread();
                Thread.sleep(SLEEP_FOR_MAIN_EVENT_THREAD);
                continue;
            }
            catch (Exception e) {
                Cutter.setLog("    Warning: CutletEventHandler.tcpObjectEventHappened()\n\t" + e.toString());
            }
        }
    }

    @Override
    public void tcpConnectionHappened(InetAddress ia) {
        this.eventHostName = ia.getHostName();
        this.eventIPAddress = ia.getHostAddress();
    }

    private synchronized void handleCutletCommand(int index, CutletCmd cmd) {
        if (cmd == null) {
            return;
        }
        try {
            CmdHandler handler = CmdHandlerRegistry.getCmdHandler(cmd);
            if (handler == null) {
                Cutter.setLog("    Error: CutletEventHandler.handleCutletCommand() - cannot get cmd handler");
                return;
            }
            if (handler instanceof TimeCmdsHandler) {
                handler.execute(cmd);
                this.doTimedPauses(index);
            } else {
                this.doTimedPauses(index);
                handler.execute(cmd);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Debug:CutletEventHandler.handleCutletCommand()\n\t" + e.toString());
            Cutter.setLog("             cutlet command >" + cmd + "<");
        }
    }

    private void doTimedPauses(int index) throws Exception {
        if (index == 0) {
            return;
        }
        if (globalTimePause > 0 || localTimePause > 0) {
            if (globalTimePause > 0) {
                Thread.currentThread();
                Thread.sleep(globalTimePause);
            }
            if (localTimePause > 0) {
                Thread.currentThread();
                Thread.sleep(localTimePause);
                localTimePause = -1;
            }
            Rectangle rect = Cutter.desktop.getBounds();
            RobotUtils.clickRobotAt(new Point(5, rect.height - 23), 0);
        }
    }

    public void stop() {
        if (this.tcpListener != null) {
            this.tcpListener.stopListening();
        }
    }
}

