/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.receive;

import UI_CutletScript.receive.TCPObjectEventListener;
import UI_CutletScript.send.CutletBlockDB;
import UI_Desktop.Cutter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpCutletIn
extends Thread {
    private StringBuffer stringBuffer = new StringBuffer(1024);
    private boolean canListen = true;
    private TCPObjectEventListener listener = null;
    private InternalThread thread = null;
    private ServerSocket listeningSocket = null;
    private boolean threadStop = false;

    public TcpCutletIn(int portID, TCPObjectEventListener listener) throws IOException {
        super("TcpCutletIn_thread");
        this.listener = listener;
        try {
            this.listeningSocket = new ServerSocket(portID);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: TcpCutletIn() - constructor");
            Cutter.setLog("           " + e.toString());
            throw e;
        }
        if (this.listeningSocket == null) {
            Cutter.setLog("    Error: TcpCutletIn() - constructor failed to get listeningSocket on port " + portID);
        }
        this.listeningSocket.setReuseAddress(true);
        this.canListen = true;
    }

    public void stopListening() {
        this.canListen = false;
    }

    @Override
    public void run() {
        try {
            while (this.canListen) {
                if (this.listeningSocket == null) {
                    Cutter.setLog("    Error: TcpCutletIn.run() - the listeningSocket has become unexpectedly set to null!");
                }
                this.thread = new InternalThread(this.listeningSocket.accept());
                this.thread.start();
            }
            this.threadStop = true;
            this.listeningSocket.close();
            this.canListen = false;
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: TcpCutletIn.run()\n" + e.toString());
        }
    }

    private class InternalThread
    extends Thread {
        private DataInputStream instream = null;
        private Socket socket = null;
        private byte[] buffer = new byte[8192];

        public InternalThread(Socket socket) {
            this.socket = socket;
            socket.getRemoteSocketAddress();
            InetAddress ia = socket.getInetAddress();
            String hostName = "unknown";
            if (ia != null) {
                hostName = ia.getHostName();
            }
            TcpCutletIn.this.listener.tcpConnectionHappened(ia);
        }

        @Override
        public void run() {
            try {
                ObjectInputStream objInputStream = new ObjectInputStream(this.socket.getInputStream());
                Object object = objInputStream.readObject();
                if (object == null) {
                    this.socket.close();
                    Cutter.setLog("    Info: TcpCutletIn.InternalThread.run() ObjectInputStream returned null");
                    return;
                }
                CutletBlockDB db = (CutletBlockDB)object;
                objInputStream.close();
                this.socket.close();
                TcpCutletIn.this.listener.tcpObjectEventHappened(db);
            }
            catch (Exception e) {
                Cutter.setLog("    Exception: TcpCutletIn.InternalThread.run()");
                Cutter.setLog("    " + e.toString());
                return;
            }
        }
    }
}

