/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.send;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandlerRegistry;
import UI_CutletScript.send.CutletBlockDB;
import UI_CutletScript.send.CutletParser;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CutletBlock {
    public CutletBlockDB db = new CutletBlockDB();

    public static CutletBlock[] toArray(Vector v) {
        if (v == null || v.size() == 0) {
            return null;
        }
        CutletBlock[] out = new CutletBlock[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (CutletBlock)v.elementAt(n);
        }
        return out;
    }

    public CutletBlock(Vector input) throws Exception {
        String s;
        String[] lines = VectorUtils.toStringArray(input);
        Vector<String> v1 = new Vector<String>();
        Vector<String> v2 = new Vector<String>();
        for (int n = 0; n < input.size(); ++n) {
            s = (String)input.elementAt(n);
            if (CutletParser.getRangeOfIPs(s.trim()) != null) {
                String[] ip = CutletParser.getRangeOfIPs(s.trim());
                for (int j = 0; j < ip.length; ++j) {
                    v2.addElement(ip[j]);
                }
                continue;
            }
            if (CutletParser.isIPAddress(s.trim())) {
                v2.addElement(s.trim());
                continue;
            }
            v1.addElement(s.trim());
        }
        this.db.ipStrs = VectorUtils.toStringArray(v2);
        Vector<String> v = new Vector<String>();
        StringBuffer b = new StringBuffer();
        String[] strs = null;
        for (int n = 0; n < v1.size(); ++n) {
            s = (String)v1.elementAt(n);
            strs = TextUtils.tokenize(s, ".");
            if (strs == null) continue;
            if (CmdHandlerRegistry.isACommand(strs[0])) {
                if (b.length() > 0) {
                    v.addElement(b.toString());
                }
                b.setLength(0);
                b.append(s).append(" ");
                continue;
            }
            b.append(s).append(" ");
        }
        if (b.length() > 0) {
            v.addElement(b.toString());
        }
        Vector<CutletCmd> listOfCmds = new Vector<CutletCmd>();
        CutletCmd cmd = null;
        for (int n = 0; n < v.size(); ++n) {
            cmd = new CutletCmd((String)v.elementAt(n));
            listOfCmds.addElement(cmd);
        }
        this.db.cmds = CutletCmd.toCmdArray(listOfCmds);
    }

    public void prepareData() throws Exception {
        for (int n = 0; n < this.db.cmds.length; ++n) {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Runtime.getRuntime().gc();
                }
            });
            this.db.totalBytesOfData += this.db.cmds[n].prepareData();
        }
    }

    public String toString() {
        int n;
        StringBuffer b = new StringBuffer();
        if (this.db.cmds == null) {
            b.append("Error: no commands\n");
        } else {
            for (n = 0; n < this.db.cmds.length; ++n) {
                b.append(this.db.cmds[n].toString()).append("\n");
            }
        }
        if (this.db.ipStrs == null) {
            b.append("Error: no IP addresses\n");
        } else {
            for (n = 0; n < this.db.ipStrs.length; ++n) {
                b.append(this.db.ipStrs[n]).append("\n");
            }
        }
        return b.toString();
    }

    public String[] getIPs() {
        return this.db.ipStrs;
    }

    public CutletCmd[] getCommands() {
        return this.db.cmds;
    }
}

