/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.send;

import ClientServer.ClientServer.client.Client;
import UI_Desktop.Cutter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class CutletClient
extends Thread {
    public static String error = null;
    protected boolean kill = false;
    protected Socket socket = null;
    protected int localPortID = -1;
    protected PrintStream toServer = null;
    protected BufferedReader fromServer = null;
    protected String lineFromServer = new String();
    protected String serverAddress = "unknown";
    protected String sender = "unknown";
    protected String address = "unknown";
    protected boolean connected = false;
    private String helloStr = "Cutter";

    public CutletClient(String recipientIP, int portID) throws Exception {
        this(recipientIP, portID, "Cutter");
    }

    public CutletClient(String serverAddress, int serverPort, String helloStr) throws Exception {
        this.serverAddress = serverAddress;
        this.helloStr = helloStr;
        this.sender = Client.getLocalIP();
        try {
            this.address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (IOException e) {
            this.address = "unknown";
        }
        try {
            this.socket = new Socket(serverAddress, serverPort);
            this.toServer = new PrintStream(this.socket.getOutputStream(), true);
            this.fromServer = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (UnknownHostException e) {
            error = "Cannot locate a computer with the IP address \"" + serverAddress + "\". \nCheck the IP address of the computer from whom you wish to receive broadcasts.";
            throw e;
        }
        catch (IOException e) {
            error = "Cannot connect to \"" + serverAddress + "\" probably because \nCutter on that computer is either not broadcasting\non port \"" + serverPort + "\", or is not broadcasting at all!";
            throw e;
        }
        this.localPortID = this.socket.getLocalPort();
        error = null;
        this.socket.setReuseAddress(true);
    }

    @Override
    public void run() {
        String lineFromServer = "";
        while (!this.kill) {
            this.toServer.println("");
            while (!this.kill && lineFromServer != null) {
                try {
                    lineFromServer = this.fromServer.readLine();
                }
                catch (IOException iOException) {}
            }
        }
        this.terminate();
    }

    public void sendString(String str) {
        if (str == null) {
            return;
        }
        this.toServer.println(str);
        this.toServer.println("");
    }

    public void writeBytes(byte[] buf, int offset, int len) {
        if (buf == null) {
            this.toServer.println();
            return;
        }
        this.toServer.write(buf, offset, len);
    }

    public void close() {
        this.kill = true;
    }

    private void terminate() {
        this.toServer.println("");
        this.toServer.flush();
        this.toServer.close();
        this.connected = false;
        try {
            this.fromServer.close();
            this.socket.close();
        }
        catch (IOException e) {
            Cutter.setLog("Error: terminate()" + this.serverAddress);
        }
    }

    public static String getLocalIP() {
        String out = "unknown";
        try {
            out = InetAddress.getLocalHost().getHostAddress();
        }
        catch (IOException e) {
            out = "unknown";
        }
        return out;
    }
}

