/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.send;

import UI_CutletScript.CutletPrefsPanel;
import UI_CutletScript.send.CutletBlockDB;
import UI_CutletScript.send.CutletParser;
import UI_CutletScript.send.TcpCutletOut;
import UI_Desktop.Cutter;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import Utilities.MsgDialogUtils;
import java.io.File;
import java.io.ObjectOutputStream;

public class CutletExecutor {
    private String script = null;
    public int EXECUTOR_SLEEP_PERIOD = 2000;

    public void execute(File file) {
        this.script = FileUtils.read(file);
        if (this.script == null) {
            Cutter.setLog("    Error: CutletExecutor() - cannot read cutlet script " + file.getName());
            return;
        }
        this.execute(this.script);
    }

    public void execute(final String script) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                CutletParser parser = null;
                try {
                    parser = new CutletParser(script);
                }
                catch (Exception e) {
                    Cutter.setLog("    Debug:CutletExecutor() - ignoring exception\n\t" + e.toString());
                    return;
                }
                if (parser.blocks == null) {
                    Cutter.setLog("    Error: CutletExecutor() - parser.blocks is null");
                    return;
                }
                for (int i = 0; i < parser.blocks.length; ++i) {
                    TcpCutletOut client = null;
                    String[] IPs = parser.blocks[i].getIPs();
                    if (IPs == null) continue;
                    for (int n = 0; n < IPs.length; ++n) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(CutletExecutor.this.EXECUTOR_SLEEP_PERIOD);
                        }
                        catch (Exception ex) {
                            Cutter.setLog("    Exception: CutletExecutor() - sleep " + IPs[n] + " " + ex.toString());
                            client = null;
                            continue;
                        }
                        try {
                            client = new TcpCutletOut(IPs[n], 18990);
                        }
                        catch (Exception e) {
                            Cutter.setLog("    Exception: CutletExecutor() 2 - " + IPs[n] + " " + e.toString());
                            client = null;
                            String[] msg = new String[]{"Computer with IP: " + IPs[n], e.toString().replace(':', '\n')};
                            DialogUtils.showErrorMessage("Connection Error", msg);
                            continue;
                        }
                        client.start();
                        CutletBlockDB db = parser.blocks[i].db;
                        try {
                            parser.blocks[i].prepareData();
                        }
                        catch (Exception e) {
                            Cutter.setLog("    Exception:CutletExecutor.CutletExecutor() 3 - " + e.toString());
                            MsgDialogUtils.showMessage(e, "Cutlet prepareData Error");
                        }
                        db.author = CutletPrefsPanel.getAuthor();
                        try {
                            ObjectOutputStream oout = new ObjectOutputStream(client.outputStream);
                            oout.writeObject(db);
                            client.outputStream.flush();
                            oout.close();
                            continue;
                        }
                        catch (Exception e) {
                            Cutter.setLog("    Exception:CutletExecutor.constructor() 4 \n\t        " + e.toString());
                            return;
                        }
                    }
                }
            }
        };
        thread.start();
    }
}

