/*
 * Decompiled with CFR 0.152.
 */
package UI_CutletScript.send;

import UI_CutletScript.CutletCmd;
import UI_CutletScript.receive.CmdHandlers.CmdHandler;
import UI_CutletScript.receive.CmdHandlers.CmdHandlerRegistry;
import UI_CutletScript.receive.CmdHandlers.FileCmdsHandler;
import UI_CutletScript.send.CutletBlock;
import UI_Desktop.Cutter;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CutletParser {
    static final Pattern ipPattern = Pattern.compile("([0-9]+)[.]([0-9]+)[.]([0-9]+)[.]([0-9]+)");
    public CutletBlock[] blocks = null;

    public CutletParser(String input) throws Exception {
        int n;
        String[] lines = this.removeComments(input);
        Vector<String> blockText = new Vector<String>();
        Vector<CutletBlock> listOfBlocks = new Vector<CutletBlock>();
        for (n = 0; n < lines.length; ++n) {
            if (n + 1 == lines.length || (CutletParser.isIPAddress(lines[n]) || CutletParser.getRangeOfIPs(lines[n]) != null) && !CutletParser.isIPAddress(lines[n + 1]) && CutletParser.getRangeOfIPs(lines[n + 1]) == null) {
                blockText.addElement(lines[n]);
                listOfBlocks.addElement(new CutletBlock(blockText));
                blockText.removeAllElements();
                continue;
            }
            blockText.addElement(lines[n]);
        }
        this.blocks = CutletBlock.toArray(listOfBlocks);
        for (n = 0; n < listOfBlocks.size(); ++n) {
            CutletBlock block = (CutletBlock)listOfBlocks.elementAt(n);
            int grossInputByteCount = 0;
            for (int i = 0; i < block.db.cmds.length; ++i) {
                Thread.sleep(1000L);
                CutletCmd cmd = block.db.cmds[i];
                CmdHandler handler = CmdHandlerRegistry.getCmdHandler(cmd);
                if (handler == null) {
                    Cutter.setLog("    Error:CutletParser.CutletParser() - cannot get a script handler.");
                    continue;
                }
                handler.checkSyntax(cmd);
                if (!(handler instanceof FileCmdsHandler)) continue;
                grossInputByteCount += CutletCmd.getDirSize(cmd);
            }
        }
    }

    private String[] removeComments(String input) {
        String[] lines = CutletCmd.tokenize(input, "\n");
        Vector<String> v = new Vector<String>();
        for (int n = 0; n < lines.length; ++n) {
            if (lines[n] == null || lines[n].trim().length() == 0 || lines[n].trim().startsWith("#")) continue;
            String[] s = TextUtils.tokenize(lines[n], "#");
            v.addElement(s[0]);
        }
        return VectorUtils.toStringArray(v);
    }

    public static String[] getRangeOfIPs(String line) {
        int lastNumber2;
        int lastNumber0;
        String[] digits2;
        String[] tokens;
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        if (line.trim().startsWith(":")) {
            try {
                InetAddress ia = InetAddress.getByName(line.trim().substring(1));
                String ipStr = ia.getHostAddress();
                Cutter.setLog("Name >" + line.trim().substring(1) + "<");
                Cutter.setLog("IP >" + ipStr + "<");
            }
            catch (UnknownHostException e) {
                Cutter.setLog("    Exception:CutletParser.getRangeOfIPs()");
                Cutter.setLog("        " + e.toString());
            }
        }
        if ((tokens = TextUtils.tokenize(line.trim(), " ")) == null || tokens.length != 3) {
            return null;
        }
        if (!tokens[1].equals("to")) {
            return null;
        }
        Matcher m0 = ipPattern.matcher(tokens[0]);
        Matcher m2 = ipPattern.matcher(tokens[2]);
        if (!m0.matches() || !m2.matches()) {
            return null;
        }
        String[] digits0 = TextUtils.tokenize(tokens[0].trim(), ".");
        if (digits0.length != (digits2 = TextUtils.tokenize(tokens[2].trim(), ".")).length) {
            return null;
        }
        try {
            lastNumber0 = Integer.parseInt(digits0[digits0.length - 1]);
            lastNumber2 = Integer.parseInt(digits2[digits2.length - 1]);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: CutletParser.isIPRange()\n\t" + e.toString());
            return null;
        }
        if (lastNumber0 > lastNumber2) {
            int tmp = lastNumber2;
            lastNumber2 = lastNumber0;
            lastNumber0 = tmp;
        }
        int diff = lastNumber2 - lastNumber0;
        int[] tail = new int[diff + 1];
        for (int n = 0; n <= diff; ++n) {
            tail[n] = lastNumber0 + n;
        }
        String[] out = new String[tail.length];
        for (int n = 0; n < out.length; ++n) {
            out[n] = "";
            for (int i = 0; i < digits0.length - 1; ++i) {
                int n2 = n;
                out[n2] = out[n2] + digits0[i] + ".";
            }
            int n3 = n;
            out[n3] = out[n3] + tail[n];
        }
        return out;
    }

    public static boolean isIPAddress(String line) {
        if (line == null || line.trim().length() == 0) {
            return false;
        }
        String[] tokens = TextUtils.tokenize(line.trim(), " ");
        if (tokens == null || tokens.length == 3 && tokens[1].equals("to")) {
            return false;
        }
        if (tokens == null || tokens.length != 1) {
            return false;
        }
        Matcher m = ipPattern.matcher(tokens[0]);
        if (m.matches()) {
            return true;
        }
        try {
            InetAddress.getByName(line.trim());
        }
        catch (UnknownHostException uhe) {
            Cutter.setLog("    Error: CutletParser.isIPAddress()\n\t" + uhe.toString());
            return false;
        }
        catch (SecurityException se) {
            Cutter.setLog("    Error: CutletParser.isIPAddress()\n\t" + se.toString());
            return false;
        }
        return true;
    }
}

