/*
 * Decompiled with CFR 0.152.
 */
package UI_Delegates;

import UI_Delegates.CutrUtils;
import UI_Delegates.KToolsUI;
import UI_Delegates.MetalBumps;
import UI_Tools.KTools;
import Utilities.ResourceUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CutrLineEditorTitlePane
extends MetalInternalFrameTitlePane {
    private static final long serialVersionUID = 1L;
    protected int buttonsWidth = 0;
    protected MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    static Icon toolCloseIcon = ResourceUtils.getIconResource("/resources/closeWindow.gif");
    static int CONSTRAINED_HEIGHT = 15;

    public CutrLineEditorTitlePane(final JInternalFrame f) {
        super(f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Rectangle r = f.getBounds();
                Dimension d = f.getPreferredSize();
                if (e.getClickCount() == 2) {
                    if (r.height > KToolsUI.CALLAPSED_HEIGHT) {
                        if (f instanceof KTools) {
                            ((KTools)f).callapseWindow(true);
                        }
                    } else if (f instanceof KTools) {
                        ((KTools)f).callapseWindow(false);
                    }
                }
            }
        });
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    protected void createCloseButton() {
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(new CloseAction(this.frame));
        this.closeButton.setIcon(toolCloseIcon);
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(this.closeButton);
    }

    @Override
    protected LayoutManager createLayout() {
        if (this.closeButton == null) {
            this.createCloseButton();
        }
        return new CutrTitlePaneLayout(this.frame, this.closeButton);
    }

    protected void setButtonsWidth(int w) {
        this.buttonsWidth = w;
    }

    @Override
    public void paintComponent(Graphics g) {
        int bumpXOffset;
        int bumpLength;
        boolean leftToRight = CutrUtils.isLeftToRight(this.frame);
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorUIResource background = null;
        ColorUIResource foreground = null;
        ColorUIResource shadow = null;
        background = MetalLookAndFeel.getWindowTitleInactiveBackground();
        foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
        shadow = MetalLookAndFeel.getControlDarkShadow();
        MetalBumps bumps = this.inactiveBumps;
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        g.setColor(shadow);
        g.drawLine(0, height - 1, width, height - 1);
        g.drawLine(0, 0, 0, 0);
        g.drawLine(width - 1, 0, width - 1, 0);
        int titleLength = 0;
        int xOffset = leftToRight ? 5 : width - 5;
        String frameTitle = this.frame.getTitle();
        if (frameTitle != null) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            int fHeight = fm.getHeight();
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rect = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rect = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rect = this.closeButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                frameTitle = this.getTitle(frameTitle, fm, titleW);
                xOffset -= SwingUtilities.computeStringWidth(fm, frameTitle);
            }
            titleLength = SwingUtilities.computeStringWidth(fm, frameTitle);
            g.drawString(frameTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
        if (leftToRight) {
            bumpLength = width - this.buttonsWidth - xOffset - 5;
            bumpXOffset = xOffset;
        } else {
            bumpLength = xOffset - this.buttonsWidth - 5;
            bumpXOffset = this.buttonsWidth + 5;
        }
        int bumpYOffset = 3;
        int bumpHeight = this.getHeight() - 2 * bumpYOffset;
        bumps.setBumpArea(bumpLength, bumpHeight);
        bumps.paintIcon(this, g, bumpXOffset, bumpYOffset);
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(true);
        }
    }

    public class CloseAction
    extends AbstractAction {
        private JInternalFrame f = null;

        public CloseAction(JInternalFrame frame) {
            this.f = frame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.f.isClosable()) {
                this.f.doDefaultCloseAction();
            }
        }
    }

    protected class CutrTitlePaneLayout
    implements LayoutManager {
        protected JInternalFrame toolFrame = null;
        protected JButton toolCloseButton = null;

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public CutrTitlePaneLayout(JInternalFrame f, JButton b) {
            this.toolFrame = f;
            this.toolCloseButton = b;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (this.toolFrame.isClosable()) {
                width += 21;
            }
            if (this.toolFrame.isMaximizable()) {
                width += 16 + (this.toolFrame.isClosable() ? 10 : 4);
            }
            if (this.toolFrame.isIconifiable()) {
                width += 16 + (this.toolFrame.isMaximizable() ? 2 : (this.toolFrame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = CutrLineEditorTitlePane.this.getFontMetrics(CutrLineEditorTitlePane.this.getFont());
            String frameTitle = this.toolFrame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(this.toolFrame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            Icon icon = this.toolFrame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            height = fontHeight;
            return new Dimension(width, CONSTRAINED_HEIGHT);
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = CutrUtils.isLeftToRight(this.toolFrame);
            int w = CutrLineEditorTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int y = 2;
            if (this.toolCloseButton == null) {
                System.out.println("fail 1");
            }
            if (this.toolCloseButton.getIcon() == null) {
                System.out.println("fail 2");
            }
            int buttonHeight = this.toolCloseButton.getIcon().getIconHeight();
            int buttonWidth = this.toolCloseButton.getIcon().getIconWidth();
            if (this.toolFrame.isClosable()) {
                int spacing = 4;
                this.toolCloseButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            CutrLineEditorTitlePane.this.setButtonsWidth(leftToRight ? w - x : x);
        }
    }
}

