/*
 * Decompiled with CFR 0.152.
 */
package UI_Delegates;

import UI_Desktop.Cutter;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalToolTipUI;

public class CutrToolTipUI
extends MetalToolTipUI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] strs;
    public int maxWidth = 0;
    public int maxHeight = 0;
    private String text = null;
    private FontMetrics metrics = new JToolTip().getFontMetrics((Font)UIManager.get("ToolTip.font"));

    public CutrToolTipUI() {
    }

    public CutrToolTipUI(String text) {
        this.text = text;
        this.initLinesOfText();
    }

    public void setTipText(String tiptext) {
        this.text = this.text;
        this.initLinesOfText();
    }

    private void initLinesOfText() {
        BufferedReader br = new BufferedReader(new StringReader(this.text));
        int maxWidth = 0;
        Vector<String> v = new Vector<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int width = SwingUtilities.computeStringWidth(this.metrics, line);
                maxWidth = maxWidth < width ? width : maxWidth;
                v.addElement(line);
            }
        }
        catch (IOException ex) {
            Cutter.setLog("    Exception: MultiLineToolTip.ex.initLinesOfText() " + ex.toString());
        }
        int lines = v.size();
        if (lines < 1) {
            this.strs = null;
            lines = 1;
        } else {
            this.strs = new String[lines];
            int i = 0;
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                this.strs[i] = (String)e.nextElement();
                ++i;
            }
        }
        int height = this.metrics.getHeight() * lines;
        this.maxWidth = maxWidth + 6;
        this.maxHeight = height + 4;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c.getForeground());
        if (this.strs != null) {
            for (int i = 0; i < this.strs.length; ++i) {
                g.drawString(this.strs[i], 3, this.metrics.getHeight() * (i + 1));
            }
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        c.setBackground(Cutter.PALE_YELLOW);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(this.maxWidth, this.maxHeight);
    }
}

