/*
 * Decompiled with CFR 0.152.
 */
package UI_Delegates;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.io.Serializable;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CutterLF
extends MetalLookAndFeel
implements Serializable {
    public static final String THEME_METAL = "metal";
    public static final String THEME_SLATE = "ktheme";
    public static final String THEME_OCEAN = "ocean";
    private static Color slateDesktop;
    private static Color desktopBackground;
    public static Color menuBarBackground;
    public static Color menuBarForeground;
    public static Color windowTitleInactiveText;
    public static Color windowTitleActiveText;
    public static Color windowOutline;
    public static Color scrollBarThumb_windowGroove;
    public static Color scrollBarBackground_windowTitlePane;
    public static Color toolTitleText;
    public static Color toolTitleBackground;
    public static Color toolTitleBumps;
    public static Color toolTitleBumpsShadow;
    public static Color saveFileSelectionBackground;
    public static Color openFileSelectionBackground;

    public static long serialVersionUID() {
        return 0L;
    }

    public static boolean isUsingSlate() {
        String theme = Preferences.get(Preferences.GUI_SWING_THEME);
        return theme.equals(THEME_SLATE);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        String theme = Preferences.get(Preferences.GUI_SWING_THEME);
        if (theme.equals(THEME_METAL)) {
            desktopBackground = (Color)table.get("Desktop.background");
            menuBarBackground = (Color)table.get("MenuBar.background");
        } else {
            desktopBackground = slateDesktop;
        }
        Color usersDesktopColor = this.getUsersDesktopColor();
        if (usersDesktopColor != null) {
            desktopBackground = usersDesktopColor;
        }
        FontUIResource font = new FontUIResource("Arial", 1, 11);
        Object[] defaults = new Object[]{"ToolTip.background", new Color(255, 255, 220), "Desktop.background", desktopBackground, "MenuBar.background", menuBarBackground, "Tools.titleFont", font};
        table.putDefaults(defaults);
        Class<MetalLookAndFeel> c = MetalLookAndFeel.class;
        table.putDefaults(new Object[]{"OptionPane.errorIcon", LookAndFeel.makeIcon(c, "icons/Error.gif"), "OptionPane.informationIcon", LookAndFeel.makeIcon(c, "icons/Inform.gif"), "OptionPane.warningIcon", LookAndFeel.makeIcon(c, "icons/Warn.gif"), "OptionPane.questionIcon", LookAndFeel.makeIcon(c, "icons/Question.gif")});
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"KInfoButtonUI", "UI_Delegates.KInfoButtonUI", "KToolsUI", "UI_Delegates.KToolsUI", "KLineEditorWindowUI", "UI_Delegates.KLineEditorWindowUI", "KInternalFrameUI", "UI_Delegates.KInternalFrameUI"};
        table.putDefaults(uiDefaults);
    }

    private Color getUsersDesktopColor() {
        int b;
        int g;
        int r;
        String inputColorStr = Cutter.input.desktopColor;
        if (inputColorStr.trim().length() == 0) {
            return null;
        }
        String[] t = TextUtils.tokenize(inputColorStr = inputColorStr.replace(',', ' '));
        if (t == null || t.length != 3) {
            return null;
        }
        try {
            r = NumberUtils.strToInt(t[0]);
            g = NumberUtils.strToInt(t[1]);
            b = NumberUtils.strToInt(t[2]);
            r = r > 255 ? 255 : r;
            r = r < 0 ? 0 : r;
            g = g > 255 ? 255 : g;
            g = g < 0 ? 0 : g;
            b = b > 255 ? 255 : b;
            b = b < 0 ? 0 : b;
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:KTheme.getUsersDesktopColor() - " + ex.toString());
            return null;
        }
        return new Color(r, g, b);
    }

    @Override
    public String getID() {
        return "CutterLF";
    }

    @Override
    public String getName() {
        return "Cutter Look and Feel";
    }

    @Override
    public String getDescription() {
        return "CutterLF is a minor extension of MetalLF";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    static {
        desktopBackground = slateDesktop = new Color(143, 143, 143);
        menuBarBackground = new Color(90, 90, 90);
        menuBarForeground = Color.white;
        windowTitleInactiveText = new Color(102, 102, 102);
        windowTitleActiveText = new Color(255, 255, 255);
        windowOutline = new Color(102, 102, 102);
        scrollBarThumb_windowGroove = new Color(153, 153, 153);
        scrollBarBackground_windowTitlePane = new Color(140, 140, 140);
        toolTitleText = new Color(0, 0, 0);
        toolTitleBackground = new Color(160, 160, 160);
        toolTitleBumps = new Color(255, 255, 255);
        toolTitleBumpsShadow = new Color(120, 120, 120);
        saveFileSelectionBackground = new Color(220, 220, 220);
        openFileSelectionBackground = new Color(220, 220, 220);
    }
}

