/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop;

import ClientServer.ClientServer.client.KClient;
import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_CutletScript.receive.CmdHandlers.BuildCmdHandler;
import UI_CutletScript.receive.CmdHandlers.CmdHandlerRegistry;
import UI_CutletScript.receive.CmdHandlers.FileCmdsHandler;
import UI_CutletScript.receive.CmdHandlers.MenuCmdsHandler;
import UI_CutletScript.receive.CmdHandlers.MessageCmdHandler;
import UI_CutletScript.receive.CmdHandlers.TimeCmdsHandler;
import UI_CutletScript.receive.CmdHandlers.WindowCmdsHandler;
import UI_CutletScript.receive.CutletEventHandler;
import UI_Delegates.CutterLF;
import UI_Delegates.KTheme;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Desktop.MenuItems.KRecentDocsMenu;
import UI_Script.Help.KAbstractHelp;
import UI_Window.KWindow.HTMLWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import UI_Window.KWindow.LogFrame;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class Cutter {
    public static int WARNING_FILE_TOO_LARGE_TO_OPEN = 768000;
    public static final String BACKUPS_DIRECTORY_NAME = "Cutter_Backups";
    public static Input input = new Input();
    public static DefaultFont defaultFont;
    public static int MONITOR_PANEL_WIDTH;
    public static int MONITOR_PANEL_HEIGHT;
    public static int TEXT_WINDOW_WIDTH;
    public static double TEXT_WINDOW_HEIGHT_PROPORTION;
    public static int BROWSER_WINDOW_WIDTH;
    public static final String INFO_COPYRIGHT;
    public static String CUTTER_USERS_DIR;
    public static String CUTTER_APP_DIR;
    public static String MAYA_USER_DIR;
    public static Color defaultBackground;
    public static Color PALE_YELLOW;
    public static final int kMaxPopups = 20;
    public static String version;
    public static String compiled;
    public static boolean testWindowsBatFile;
    public static boolean EXPOSE_RMS4;
    public static boolean EXPOSE_RPS17;
    public static boolean EXPOSE_RMS19;
    public static boolean EXPOSE_RMS20;
    public static boolean DONT_USE_TOOLKIT;
    public static KDesktop desktop;
    public static boolean activateNet;
    private static LogFrame log;
    private static StringBuffer logbuffer;
    public static final String MITRE10 = "10";
    public static HTMLWindow htmlWindow;
    private static JButton sampleUiItem;
    public static Vector<File> listOfDirPresets;
    public static String defaultTextPaneFontName;
    public static CutletEventHandler cutletEventHandler;
    private static long memory;
    private static boolean doOpen;
    private static int count;

    public static Font getKButtonFont() {
        Font fb = (Font)UIManager.get("Button.font");
        return new Font(fb.getName(), 1, 11);
    }

    private static void writeFontlistFile() {
        String[] data = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (data == null || data.length == 0) {
            return;
        }
        String name = "linux_font_list.txt";
        if (EnvUtils.isWinEnvironment()) {
            name = "window_font_list.txt";
        } else if (EnvUtils.isOSXEnvironment()) {
            name = "macosx_font_list.txt";
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < data.length; ++n) {
            buf.append(data[n]).append("\n");
        }
        File f = new File(FileUtils.getPWDFile(), name);
        FileUtils.writeFile(f, buf.toString());
        Cutter.setLog("    Wrote list of available fonts to \"" + f.getPath() + "\"");
    }

    public static void init(String[] args) {
        Preferences.init();
        defaultTextPaneFontName = Preferences.get(Preferences.TEXT_FONT_NAME);
        ResourceUtils.loadInfoStrings();
        Cutter.readInputArgs(args);
        try {
            String theme = Preferences.get(Preferences.GUI_SWING_THEME);
            if (theme.equals("metal")) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            } else {
                MetalLookAndFeel.setCurrentTheme(new KTheme());
            }
            CutterLF cutrLF = new CutterLF();
            UIManager.LookAndFeelInfo cutrLF_Info = new UIManager.LookAndFeelInfo(((LookAndFeel)cutrLF).getName(), cutrLF.getClass().getName());
            UIManager.installLookAndFeel(cutrLF_Info);
            UIManager.setLookAndFeel(cutrLF);
        }
        catch (Exception e) {
            System.out.println("Cutter cannot load its graphical interface. Exception = " + e);
        }
        MAYA_USER_DIR = EnvUtils.getEnvVariable("MAYA_USER_DIR");
        if (MAYA_USER_DIR.equals("")) {
            MAYA_USER_DIR = EnvUtils.getEnvVariable("MAYA_APP_DIR");
        }
        if (MAYA_USER_DIR.equals("")) {
            Cutter.setLog("    Neither the MAYA_APP_DIR nor the MAYA_USER_DIR environment variable has been set.");
        } else {
            Cutter.setLog("    The users maya directory is located at \"" + MAYA_USER_DIR + "\"");
            if (!new File(MAYA_USER_DIR).exists()) {
                Cutter.setLog("    Error: The users maya directory cannot be found at \"" + MAYA_USER_DIR + "\"");
                MAYA_USER_DIR = "";
            }
        }
        boolean fileWereExtracted = KAbstractHelp.extractHelpFiles();
        desktop = new KDesktop(Cutter.getTitle());
        String theme = Preferences.get(Preferences.GUI_SWING_THEME);
        if (theme.equals("ktheme")) {
            // empty if block
        }
        Cutter.setLog("Cutter version: " + version);
        Cutter.setLog(UIManager.getLookAndFeel().toString());
        Cutter.setLog("Built: " + compiled);
        if (Cutter.input.debug) {
            Cutter.setLog("Debug is active");
        }
        Cutter.setLog("Host OS is " + EnvUtils.getOSName());
        Cutter.setLog("Users account name is \"" + EnvUtils.getUsersAccountName() + "\"");
        String cud = EnvUtils.getEnvVariable(CUTTER_USERS_DIR);
        if (cud.length() == 0) {
            Cutter.setLog("The environment variable \"" + CUTTER_USERS_DIR + "\" has not been found.");
        } else {
            Cutter.setLog("The value of the environment variable \"" + CUTTER_USERS_DIR + "\" is \"" + cud + "\"");
        }
        String cad = EnvUtils.getEnvVariable(CUTTER_APP_DIR);
        if (cad.length() == 0) {
            Cutter.setLog("The environment variable \"" + CUTTER_APP_DIR + "\" has not been found.");
        } else {
            Cutter.setLog("The value of the environment variable \"" + CUTTER_APP_DIR + "\" is \"" + cad + "\"");
        }
        Cutter.setLog("Users $HOME directory is \"" + EnvUtils.getUsersHomeDir() + "\"");
        Cutter.setLog("Users PWD is \"" + EnvUtils.getUsersPWD() + "\"");
        log = new LogFrame(logbuffer.toString());
        if (Preferences.get(Preferences.WINDOW_LOG).equals("open")) {
            log.setVisibility(KDesktop.logItem);
        }
        htmlWindow = HTMLWindow.getInstance();
        KRecentDocsMenu.AUTO_OPEN_MAX_FILE_SIZE = 153600L;
        KRecentDocsMenu.openLastDocAction().actionPerformed(null);
        cutletEventHandler = new CutletEventHandler();
        CmdHandlerRegistry.add(new FileCmdsHandler());
        CmdHandlerRegistry.add(new WindowCmdsHandler());
        CmdHandlerRegistry.add(new MenuCmdsHandler());
        CmdHandlerRegistry.add(new TimeCmdsHandler());
        CmdHandlerRegistry.add(new BuildCmdHandler());
        CmdHandlerRegistry.add(new MessageCmdHandler());
    }

    private static String getTitle() {
        String ipAddress = KClient.getLocalIP();
        String hostName = KClient.getLocalHostName();
        String title = "Cutter " + version;
        title = title + "   [IP " + (ipAddress.equals("unknown") ? "" : ipAddress);
        title = hostName.trim().length() == 0 ? title + "]" : title + " Name: \"" + hostName + "\"]";
        return title;
    }

    private static void writeUIDefaultToFile() {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration en = defaults.keys();
        String osname = EnvUtils.getOSName();
        File outdefs = new File(FileUtils.getPWDFile().getPath(), "UIDefaults_" + osname + ".txt");
        Vector<String> vect = new Vector<String>();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            if (key == null) continue;
            Object value = defaults.get(key);
            if (value == null) {
                vect.add("no value for ?" + key.toString());
                continue;
            }
            vect.add(key.toString() + ": " + value.toString());
        }
        String[] defs = VectorUtils.toStringArray(vect);
        defs = TextUtils.sortByAlpha(defs);
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < defs.length; ++j) {
            buf.append(defs[j]).append("\n");
        }
        FileUtils.writeFile(outdefs, buf.toString());
    }

    private static void MemoryUseageTest1() {
        final Runtime runtime = Runtime.getRuntime();
        memory = runtime.totalMemory() / 1024L;
        Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (doOpen) {
                    KRecentDocsMenu.openLastDocAction().actionPerformed(null);
                } else {
                    KAbstractWindow window = BBxt.frontWindow();
                    if (window == null) {
                        return;
                    }
                    try {
                        window.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                doOpen = !doOpen;
                Cutter.setLog("MemoryUseageTest = " + count++ + " increase " + (runtime.totalMemory() / 1024L - memory));
                memory = runtime.totalMemory() / 1024L;
            }
        });
        timer.setInitialDelay(2500);
        timer.setRepeats(true);
        timer.start();
    }

    private static void MemoryUseageTest2() {
        final Vector listOfIncreases = new Vector();
        final Runtime runtime = Runtime.getRuntime();
        memory = runtime.totalMemory() / 1024L;
        Timer timer = new Timer(4000, new ActionListener(){
            long prevFree = 0L;
            long currentFree = 0L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (doOpen) {
                    KAbstractDesktop.OpenPreviousSessionAction action = new KAbstractDesktop.OpenPreviousSessionAction();
                    action.actionPerformed(null);
                } else {
                    KAbstractWindow[] windows = KDesktop.getAllWindows();
                    if (windows == null || windows.length == 0) {
                        return;
                    }
                    for (int n = 0; n < windows.length; ++n) {
                        if (windows[n] == null) continue;
                        windows[n].setTouched(false);
                        try {
                            windows[n].setClosed(true);
                            continue;
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
                long increase = runtime.totalMemory() / 1024L - memory;
                this.currentFree = runtime.freeMemory() / 1024L;
                if (!doOpen && increase == 0L) {
                    Cutter.setLog("MemoryTest = " + count++);
                } else if (!doOpen) {
                    Cutter.setLog("MemoryTest = " + count + " increase " + increase + " free: " + this.prevFree);
                    String[] items = VectorUtils.toStringArray(listOfIncreases);
                    if (items != null) {
                        StringBuffer list = new StringBuffer();
                        for (int n = 0; n < items.length; ++n) {
                            if (n < items.length - 1) {
                                list.append(items[n] + ",");
                                continue;
                            }
                            list.append(items[n]);
                        }
                        Cutter.setLog("    Occurances [" + list.toString() + "]");
                    }
                    listOfIncreases.addElement("" + count);
                    count++;
                }
                memory = runtime.totalMemory() / 1024L;
                doOpen = !doOpen;
                this.prevFree = this.currentFree;
            }
        });
        timer.setInitialDelay(2000);
        timer.setRepeats(true);
        timer.start();
    }

    private static void MemoryUseageTest3() {
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (doOpen) {
                    KAbstractDesktop.OpenPreviousSessionAction action = new KAbstractDesktop.OpenPreviousSessionAction();
                    action.actionPerformed(null);
                    KAbstractWindow[] windows = KDesktop.getAllWindows();
                    if (windows == null || windows.length == 0) {
                        return;
                    }
                    for (int n = 0; n < windows.length; ++n) {
                        if (windows[n] == null || !(windows[n] instanceof KTextWindow)) continue;
                        ((KTextWindow)windows[n]).viewHistory();
                    }
                } else {
                    KAbstractWindow[] windows = KDesktop.getAllWindows();
                    if (windows == null || windows.length == 0) {
                        return;
                    }
                    for (int n = 0; n < windows.length; ++n) {
                        if (windows[n] == null || !(windows[n] instanceof KTextWindow)) continue;
                        try {
                            windows[n].setClosed(true);
                            continue;
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
                doOpen = !doOpen;
                Cutter.setLog("MemoryUseageTest = " + count++);
            }
        });
        timer.setInitialDelay(5000);
        timer.setRepeats(true);
        timer.start();
    }

    private static void MemoryUseageTest4() {
        Timer timer = new Timer(2500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (doOpen) {
                    KAbstractDesktop.NewDocAction action = new KAbstractDesktop.NewDocAction();
                    for (int n = 0; n < 6; ++n) {
                        action.actionPerformed(null);
                    }
                } else {
                    KAbstractWindow[] windows = KDesktop.getAllWindows();
                    if (windows == null || windows.length == 0) {
                        return;
                    }
                    for (int n = 0; n < windows.length; ++n) {
                        if (windows[n] == null || !(windows[n] instanceof KTextWindow)) continue;
                        windows[n].setTouched(false);
                        try {
                            windows[n].setClosed(true);
                            continue;
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
                doOpen = !doOpen;
                Cutter.setLog("MemoryUseageTest = " + count++);
            }
        });
        timer.setInitialDelay(5000);
        timer.setRepeats(true);
        timer.start();
    }

    private static void readInputArgs(String[] args) {
        if (args != null && args.length > 0) {
            for (int n = 0; n < args.length; ++n) {
                if (args[n].equalsIgnoreCase("-debug")) {
                    Cutter.input.debug = true;
                }
                if (args[n].equalsIgnoreCase("-nometal")) {
                    Cutter.input.nometal = true;
                }
                if (args[n].equalsIgnoreCase("-d")) {
                    Cutter.input.debug = true;
                }
                if (args[n].equalsIgnoreCase("-qt")) {
                    Cutter.input.qt = true;
                }
                if (args[n].equalsIgnoreCase("-w")) {
                    Cutter.input.workshop = true;
                }
                if (args[n].equalsIgnoreCase("-nokill")) {
                    Cutter.input.nokill = true;
                }
                if (args[n].equalsIgnoreCase("-deferRender")) {
                    Cutter.input.deferRender = true;
                }
                if (args[n].equalsIgnoreCase("-rslflags")) {
                    Cutter.input.rslflags = true;
                }
                if (args[n].equalsIgnoreCase("-ignoreStreams")) {
                    Cutter.input.ignoreStreams = true;
                }
                if (args[n].equalsIgnoreCase("-ignoreStdOutStream")) {
                    Cutter.input.ignoreStdOutStream = true;
                }
                if (args[n].equalsIgnoreCase("-ignoreStdErrStream")) {
                    Cutter.input.ignoreStdErrStream = true;
                }
                if (args[n].equalsIgnoreCase("-syntax")) {
                    String string = Cutter.input.syntax = n + 1 < args.length ? args[n + 1] : "";
                }
                if (args[n].equalsIgnoreCase("-parsetime")) {
                    Cutter.input.parsetime = true;
                }
                if (args[n].equalsIgnoreCase("-mail_grades")) {
                    Cutter.input.mail_grades = true;
                }
                if (args[n].equalsIgnoreCase("-terminal")) {
                    Cutter.input.terminal = true;
                }
                if (args[n].equalsIgnoreCase("-fileread")) {
                    String string = Cutter.input.fileread = n + 1 < args.length ? args[n + 1] : "2";
                }
                if (args[n].equalsIgnoreCase("-charcount")) {
                    String string = Cutter.input.charcount = n + 1 < args.length ? args[n + 1] : "";
                }
                if (args[n].equalsIgnoreCase("-prefsPath")) {
                    String string = Cutter.input.prefsPath = n + 1 < args.length ? args[n + 1] : "";
                }
                if (args[n].equalsIgnoreCase("-desktopColor")) {
                    String string = Cutter.input.desktopColor = n + 1 < args.length ? args[n + 1] : "";
                }
                if (args[n].equalsIgnoreCase("-m")) {
                    Cutter.input.memtest = true;
                }
                if (!args[n].equalsIgnoreCase("-dso_server")) continue;
                Cutter.input.dso_server = n + 1 < args.length ? args[n + 1] : "";
            }
        }
    }

    public static void saveLog() {
        if (log == null) {
            return;
        }
        log.save();
        log.saveState();
    }

    public static void appendLog(char c) {
        if (log == null) {
            logbuffer.append(c);
            return;
        }
        log.appendText(c + "");
    }

    public static void appendLog(String str) {
        if (log == null) {
            logbuffer.append(str);
            return;
        }
        log.appendText(str);
    }

    public static void appendLog(char[] data) {
        if (data == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < data.length; ++n) {
            if (log == null) {
                logbuffer.append(data[n] + " ");
                continue;
            }
            buf.append(data[n] + " ");
        }
        if (log != null) {
            log.setText(buf.toString());
        }
    }

    public static void setLog(int n) {
        if (log == null) {
            logbuffer.append("" + n);
            return;
        }
        log.setText("" + n);
    }

    public static void setLog(String str) {
        if (Cutter.input.terminal && str.trim().startsWith("Debug")) {
            System.out.println(str);
        }
        if (str.trim().startsWith("Debug") && !Cutter.input.debug) {
            return;
        }
        if (log == null) {
            logbuffer.append(str + '\n');
            return;
        }
        log.setText(str);
    }

    public static void setLog(StringBuffer buf) {
        if (log == null) {
            logbuffer.append(buf.toString() + '\n');
            return;
        }
        log.setText(buf.toString());
    }

    public static void setLog(String[] strs) {
        Cutter.setLog(strs, 0);
    }

    public static void setLog(String[] strs, int tabs) {
        if (strs == null) {
            return;
        }
        for (int n = 0; n < strs.length; ++n) {
            if (log == null) {
                if (tabs > 0) {
                    logbuffer.append('\t');
                }
                logbuffer.append(strs[n] + '\n');
                continue;
            }
            if (tabs > 0) {
                log.appendText("\t");
            }
            log.setText(strs[n]);
        }
    }

    public static void setLog(File[] files) {
        Cutter.setLog(files, 0);
    }

    public static void setLog(File[] files, int tabs) {
        if (files == null) {
            return;
        }
        for (int n = 0; n < files.length; ++n) {
            if (log == null) {
                if (tabs > 0) {
                    logbuffer.append('\t');
                }
                logbuffer.append(files[n].getPath() + '\n');
                continue;
            }
            if (tabs > 0) {
                log.appendText("\t");
            }
            log.setText(files[n].getPath());
        }
    }

    public static void setLog(int[] data) {
        if (data == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < data.length; ++n) {
            if (log == null) {
                logbuffer.append(data[n] + " ");
                continue;
            }
            buf.append(data[n] + " ");
        }
        if (log != null) {
            log.setText(buf.toString());
        }
    }

    public static void setLog(char[] data) {
        if (data == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < data.length; ++n) {
            if (log == null) {
                logbuffer.append(data[n] + " ");
                continue;
            }
            buf.append(data[n] + " ");
        }
        if (log != null) {
            log.setText(buf.toString());
        }
    }

    public static void setLog(Vector listOfStrings) {
        if (listOfStrings == null) {
            return;
        }
        for (int n = 0; n < listOfStrings.size(); ++n) {
            String str = (String)listOfStrings.elementAt(n);
            if (str == null) {
                return;
            }
            if (log == null) {
                logbuffer.append(str + '\n');
                continue;
            }
            log.setText(str);
        }
    }

    public static void setLog(JMenuItem item) {
        if (log == null) {
            return;
        }
        log.setVisibility(item);
    }

    public static void setLog(Exception e) {
        Cutter.setLog(e.toString());
    }

    public static void clearLog() {
        if (log == null) {
            return;
        }
        log.clearText();
    }

    public static boolean logSelected() {
        if (log == null) {
            return false;
        }
        return log.isSelected();
    }

    public static void addDebug(Class cls, Field[] field) {
        if (cls == null || field == null || log == null) {
            return;
        }
        LogFrame.debugMenu.add(cls, field);
    }

    public static File getParentDir() {
        File f = FileUtils.getPWDFile();
        if (f.getParentFile() == null) {
            return f;
        }
        return f.getParentFile();
    }

    private static void displayGridBagConstraints() {
        GridBagConstraints gbc = new GridBagConstraints();
        System.out.println("RELATIVE = -1");
        System.out.println("REMAINDER = 0");
        System.out.println("NONE = 0");
        System.out.println("BOTH = 1");
        System.out.println("HORIZONTAL = 2");
        System.out.println("VERTICAL = 3");
        System.out.println("NORTH = 11");
        System.out.println("NORTHEAST = 12");
        System.out.println("NORTHWEST = 18");
        System.out.println("SOUTH = 15");
        System.out.println("SOUTHEAST = 14");
        System.out.println("SOUTHWEST = 16");
        System.out.println("WEST = 17");
        System.out.println("EAST = 13");
        System.out.println("CENTER = 10");
        System.out.println("gridx = " + gbc.gridx);
        System.out.println("gridy = " + gbc.gridy);
        System.out.println("gridwidth = " + gbc.gridwidth);
        System.out.println("gridheight = " + gbc.gridheight);
        System.out.println("weightx = " + gbc.weightx);
        System.out.println("weighty = " + gbc.weighty);
        System.out.println("ipadx = " + gbc.ipadx);
        System.out.println("ipady = " + gbc.ipady);
        System.out.println("anchor = " + gbc.anchor);
        System.out.println("fill = " + gbc.fill);
    }

    public static void getAllJarEntries(File file) {
        try {
            JarFile jarfile = new JarFile(file);
            Enumeration<JarEntry> e = jarfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!entry.getName().endsWith("puts.htm")) continue;
                System.out.println(entry.getName() + " " + entry.getSize());
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
    }

    static {
        MONITOR_PANEL_WIDTH = 550;
        MONITOR_PANEL_HEIGHT = 145;
        TEXT_WINDOW_WIDTH = 500;
        TEXT_WINDOW_HEIGHT_PROPORTION = 0.75;
        BROWSER_WINDOW_WIDTH = 625;
        INFO_COPYRIGHT = new String("\u00a9") + " Malcolm Kesson\n    2001-2023\n\n";
        CUTTER_USERS_DIR = "CUTTER_USERS_DIR";
        CUTTER_APP_DIR = "CUTTER_APP_DIR";
        MAYA_USER_DIR = "";
        PALE_YELLOW = new Color(255, 255, 220);
        version = "8.3.7";
        compiled = "Tuesday Jan 10 2023";
        testWindowsBatFile = true;
        EXPOSE_RMS4 = true;
        EXPOSE_RPS17 = true;
        EXPOSE_RMS19 = true;
        EXPOSE_RMS20 = true;
        DONT_USE_TOOLKIT = true;
        activateNet = true;
        log = null;
        logbuffer = new StringBuffer();
        htmlWindow = null;
        listOfDirPresets = null;
        defaultTextPaneFontName = EnvUtils.isWinEnvironment() ? "Courier New" : "monospaced";
        sampleUiItem = new JButton("Unix");
        Font f = sampleUiItem.getFont();
        defaultFont = new DefaultFont(new Font(f.getName(), f.getStyle(), f.getSize() == 10 ? 10 : 12));
        defaultBackground = sampleUiItem.getBackground();
        boolean doAdd = true;
        listOfDirPresets = new Vector();
        cutletEventHandler = null;
        doOpen = false;
        count = 1;
    }

    public static class Input {
        public boolean parsetime = false;
        public boolean cursorAdjust = false;
        public boolean debug = false;
        public boolean qt = false;
        public boolean memtest = false;
        public boolean deferRender = false;
        public boolean workshop = false;
        public boolean nokill = false;
        public boolean nometal = false;
        public boolean rslflags = false;
        public boolean ignoreStreams = false;
        public boolean ignoreStdOutStream = false;
        public boolean ignoreStdErrStream = false;
        public boolean mail_grades = false;
        public boolean terminal = false;
        public String syntax = "";
        public String fileread = "2";
        public String charcount = "";
        public String prefsPath = "";
        public String desktopColor = "";
        public String dso_server = "";
    }

    public static class DefaultFont {
        public Font font;
        public int size;
        public String name;
        public int style;

        public DefaultFont(Font f) {
            this.font = f;
            this.size = f.getSize();
            this.name = f.getName();
            this.style = f.getStyle();
        }
    }
}

