/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.Desktop;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.FocusManager.KFocusManager;
import UI_DragDrop.DnDGlassPane;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.TabWindowsTool.TabWindowsTool;
import UI_Window.KWindow.HTMLWindow;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import UI_Window.KWindow.LogFrame;
import Utilities.ComponentUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;

public class ExtendedDesktopPane
extends JDesktopPane
implements FocusListener {
    protected int nextX = 0;
    protected int nextY = 0;
    protected int offsetX = 12;
    protected int offsetY = 24;
    protected static final int DEFAULT_OFFSETX = 12;
    protected static final int DEFAULT_OFFSETY = 24;
    protected static final int UNUSED_HEIGHT = 48;
    private boolean hasBeenReported = false;

    @Override
    public void focusGained(FocusEvent e) {
        Cutter.setLog("ExtendedDesktopPane.focusGained <---");
    }

    @Override
    public void focusLost(FocusEvent e) {
        Cutter.setLog("ExtendedDesktopPane.focusLost <---");
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Exception e) {
            if (Cutter.input.debug) {
                final Exception ee = e;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Cutter.setLog("   Debug:ExtendedDesktopPane.paint() caught\n        " + ee.toString());
                    }
                });
            }
            return;
        }
    }

    public ExtendedDesktopPane() {
        this.addFocusListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                KeyboardFocusManager man;
                Component comp;
                ExtendedDesktopPane.this.requestFocusInWindow();
                if (!ExtendedDesktopPane.this.hasFocus() && (comp = (man = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) == null) {
                    if (Cutter.input.debug) {
                        Cutter.setLog("    Debug:ExtendedDesktopPane.mouseClicked() - no focus owner");
                    }
                    KFocusManager.clearGlobalFocus_Owner();
                    KFocusManager.setPermanentFocusOwner(ExtendedDesktopPane.this);
                    ExtendedDesktopPane.this.grabFocus();
                }
            }
        });
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1004) {
            // empty if block
        }
        if (e.getID() == 1005) {
            // empty if block
        }
        if (e == null || e.getID() == 1004) {
            DnDGlassPane.setup(Cutter.desktop);
            if (e == null) {
                KTextWindow win;
                KTextPane textpane;
                KAbstractWindow kaw = KAbstractDesktop.getFrontWindow();
                if (kaw != null && kaw instanceof KTextWindow && (textpane = (win = (KTextWindow)kaw).getTextPane()) != null) {
                    textpane.setSelectionStart(0);
                    textpane.setSelectionEnd(0);
                    win.setSelected(true);
                }
                return;
            }
            Component comp = e.getOppositeComponent();
            if (comp != null && comp instanceof KTextPane) {
                KAbstractTextWindow window = ((KTextPane)comp).getFrame();
                if (window != null) {
                    window.setSelected(false);
                }
            } else if (comp != null && comp instanceof HTMLWindow.HTMLEditorPane) {
                KAbstractWindow window = ((HTMLWindow.HTMLEditorPane)comp).getFrame();
                if (window != null) {
                    window.setSelected(false);
                }
            } else if (comp != null) {
                Component c = ComponentUtils.getParentOfClass(comp, "HTMLWindow");
                if (c != null) {
                    ((HTMLWindow)c).setSelected(false);
                } else {
                    KAbstractWindow window = KAbstractDesktop.getFrontWindow();
                    if (window != null && window instanceof KAbstractWindow) {
                        window.setSelected(false);
                    }
                }
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
    }

    public synchronized void addCascaded(Component comp, Integer layer) {
        KAbstractWindow w = KAbstractDesktop.getFrontWindow();
        if (w != null && w instanceof HTMLWindow) {
            this.nextX = 0;
            this.nextY = 0;
        }
        this.add(comp, layer);
        if (comp instanceof JInternalFrame) {
            this.cascade(comp);
            if (comp instanceof LogFrame) {
                this.nextY = 0;
                this.nextX = 0;
            }
        }
        this.moveToFront(comp);
    }

    public void cascadeAll() {
        Component[] comps = this.getComponents();
        int count = comps.length;
        this.nextX = 0;
        this.nextY = 0;
        for (int i = count - 1; i >= 0; --i) {
            Component comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible() || ((JInternalFrame)comp).getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            this.cascade(comp);
        }
    }

    public void tileAll() {
        Component comp;
        DesktopManager manager = this.getDesktopManager();
        if (manager == null) {
            return;
        }
        Component[] comps = this.getComponents();
        int count = 0;
        for (int i = 0; i < comps.length; ++i) {
            comp = comps[i];
            if (!(comp instanceof JInternalFrame) || !comp.isVisible() || ((JInternalFrame)comp).getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
            ++count;
        }
        if (count != 0) {
            double root = Math.sqrt(count);
            int rows = (int)root;
            int columns = count / rows;
            int spares = count - columns * rows;
            Dimension paneSize = this.getSize();
            int columnWidth = paneSize.width / columns;
            int availableHeight = paneSize.height - 48;
            int mainHeight = availableHeight / rows;
            int smallerHeight = availableHeight / (rows + 1);
            int rowHeight = mainHeight;
            int x = 0;
            int y = 0;
            int thisRow = rows;
            int normalColumns = columns - spares;
            for (int i = comps.length - 1; i >= 0; --i) {
                comp = comps[i];
                if (!(comp instanceof JInternalFrame) || !comp.isVisible() || ((JInternalFrame)comp).getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
                manager.setBoundsForFrame((JComponent)comp, x, y, columnWidth, rowHeight);
                y += rowHeight;
                if (--thisRow != 0) continue;
                y = 0;
                x += columnWidth;
                if (--normalColumns <= 0) {
                    thisRow = rows + 1;
                    rowHeight = smallerHeight;
                    continue;
                }
                thisRow = rows;
            }
        }
    }

    public void setCascadeOffsets(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setCascadeOffsets(Point pt) {
        this.offsetX = pt.x;
        this.offsetY = pt.y;
    }

    public Point getCascadeOffsets() {
        return new Point(this.offsetX, this.offsetY);
    }

    public void tabAllWindows() throws Exception {
        Component[] comps = this.getComponents();
        if (comps != null && comps.length > 0) {
            int count = comps.length;
            this.nextX = 0;
            this.nextY = 0;
            for (int i = count - 1; i >= 0; --i) {
                Component comp = comps[i];
                if (!(comp instanceof JInternalFrame) || !comp.isVisible() || ((JInternalFrame)comp).getLayer() != JLayeredPane.DEFAULT_LAYER.intValue()) continue;
                this.tab(comp);
            }
        }
        if (Cutter.htmlWindow != null) {
            this.tab(Cutter.htmlWindow);
        }
    }

    public void tab(Component comp) {
        Dimension paneSize = this.getSize();
        int targetWidth = paneSize.width;
        int targetHeight = paneSize.height;
        if (comp == null) {
            Cutter.setLog("    Warning:ExtendedDesktopPane.tab() - been passed a null component!");
            return;
        }
        comp.setBounds(TabWindowsTool.DEFAULT_WIDTH, 0, targetWidth - TabWindowsTool.DEFAULT_WIDTH, targetHeight);
    }

    protected void cascade(Component comp) {
        DesktopManager manager;
        Dimension paneSize = this.getSize();
        int targetWidth = comp instanceof HTMLWindow ? Cutter.BROWSER_WINDOW_WIDTH : Cutter.TEXT_WINDOW_WIDTH;
        int targetHeight = (int)((double)paneSize.height * Cutter.TEXT_WINDOW_HEIGHT_PROPORTION);
        if (targetHeight == 0) {
            targetHeight = 400;
        }
        if ((manager = this.getDesktopManager()) == null) {
            comp.setBounds(0, 0, targetWidth, targetHeight);
            return;
        }
        if (this.nextX + targetWidth > paneSize.width || this.nextY + targetHeight > paneSize.height) {
            this.nextX = 0;
            this.nextY = 0;
        }
        manager.setBoundsForFrame((JComponent)comp, this.nextX, this.nextY, targetWidth, targetHeight);
        this.nextX += this.offsetX;
        this.nextY += this.offsetY;
    }

    @Override
    public Dimension getSize() {
        Rectangle r = this.getVisibleRect();
        return new Dimension(r.width, r.height);
    }
}

