/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.Desktop;

import History.KTextHistoryDB;
import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.Dialog.OpenFileDialog;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.ExtendedDesktopPane;
import UI_Desktop.KDesktop;
import UI_Desktop.MenuItems.KRecentDocsMenu;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Help.OpenSelectionHandler;
import UI_Script.Html.HtmlListener;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Tools.Rman.RenderInfo;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.FileUtils;
import Utilities.HTMLUtils;
import Utilities.KFileFilter;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public abstract class KAbstractDesktop
extends JFrame {
    public static boolean _windowExists = false;
    private static int asciID;
    private static int frameCount;
    public static ExtendedDesktopPane desktopPane;
    public CutAction cutAction = new CutAction();
    public CopyAction copyAction = new CopyAction();
    public PasteAction pasteAction = new PasteAction();
    public SelectAllAction selectAllAction = new SelectAllAction();
    public PopupAction popupAction = new PopupAction();
    private static OpenFileDialog chooser;
    public static final Integer WINDOW_LAYER;
    public static final Integer PALETTE_LAYER;
    public static final Integer LOG_LAYER;
    static PageFormat pageFormat;

    public KAbstractDesktop(String title) {
        super(title);
        desktopPane = new ExtendedDesktopPane();
    }

    public static File[] openFileChooser(KFileFilter filter) {
        chooser = OpenFileDialog.getInstance(Cutter.desktop);
        return chooser.showSelf(filter, "Open", 2);
    }

    public static DesktopManager getDesktopManager() {
        return desktopPane.getDesktopManager();
    }

    public static Dimension getDesktopSize() {
        Rectangle r = desktopPane.getVisibleRect();
        return new Dimension(r.width, r.height);
    }

    public static void setDesktopManager(DesktopManager dtm) {
        desktopPane.setDesktopManager(dtm);
    }

    public static void toFront(KAbstractWindow window) {
        KAbstractDesktop.toFront(window, false);
    }

    public static void toFront(KAbstractWindow window, boolean doForce) {
        if (window == null) {
            Cutter.setLog("    Warning:KAbstractDesktop.toFront() - window is null");
            return;
        }
        if (window == Cutter.htmlWindow && !doForce) {
            return;
        }
        if (window.isIcon()) {
            desktopPane.getDesktopManager().activateFrame(window);
            try {
                window.setIcon(false);
            }
            catch (PropertyVetoException ex) {
                Cutter.setLog("   Exception:KAbstractDesktop.toFront():\n        " + ex.toString());
            }
        }
        window.toFront();
        window.requestFocus();
        window.setVisible(true);
        window.setSelected(true);
    }

    public static KAbstractWindow getFrontWindow() {
        Component[] comp = null;
        try {
            comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        }
        catch (Exception ex) {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:KAbstractDesktop.getFrontWindow()\n        " + ex.toString());
            }
            return null;
        }
        if (comp == null) {
            return null;
        }
        for (int n = 0; n < comp.length; ++n) {
            if (!KAbstractDesktop.isFrontWindow((JComponent)comp[n])) continue;
            return (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
        }
        return null;
    }

    public static boolean isFrontWindow(JComponent comp) {
        return desktopPane.getPosition(comp) == 0;
    }

    public static KAbstractWindow[] getAllWindows() {
        Component[] comp;
        try {
            comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:KAbstractDesktop.getAllWindows()\n\t" + e.toString());
            return null;
        }
        if (comp == null || comp.length == 0) {
            return null;
        }
        KAbstractWindow[] window = new KAbstractWindow[comp.length];
        Object w = null;
        for (int n = 0; n < comp.length; ++n) {
            if (comp[n] instanceof JInternalFrame.JDesktopIcon) {
                window[n] = (KAbstractWindow)((JInternalFrame.JDesktopIcon)comp[n]).getInternalFrame();
                continue;
            }
            if (comp[n] instanceof KAbstractWindow) {
                window[n] = (KAbstractWindow)comp[n];
                continue;
            }
            Cutter.setLog("    Error: KAbstractDesktop.getAllWindows()");
        }
        return window;
    }

    public static KTextWindow[] getAllWindowsWithExt(String extNoDot) {
        KAbstractWindow[] wins = KAbstractDesktop.getAllWindows();
        if (wins == null || wins.length == 0) {
            return null;
        }
        Vector<KTextWindow> v = new Vector<KTextWindow>();
        for (int n = 0; n < wins.length; ++n) {
            if (!(wins[n] instanceof KTextWindow) || !wins[n].getTitle().endsWith(extNoDot)) continue;
            v.addElement((KTextWindow)wins[n]);
        }
        KTextWindow[] out = new KTextWindow[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (KTextWindow)v.elementAt(n);
        }
        return out;
    }

    public static void deactivateAllWindows() {
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        if (windows == null) {
            return;
        }
        for (int n = 0; n < windows.length; ++n) {
            windows[n].setSleep(true);
        }
    }

    public static void activateAllWindows() {
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        if (windows == null) {
            return;
        }
        for (int n = 0; n < windows.length; ++n) {
            windows[n].setSleep(false);
        }
    }

    public static boolean hasUnsavedWindows() {
        Cutter.setLog("    Debug:KAbstractDesktop.hasUnsavedWindows()");
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        if (windows == null) {
            return false;
        }
        for (int n = 0; n < windows.length; ++n) {
            KAbstractWindow window = windows[n];
            if (window == null || !window.getTouched() || !window.getSaveable()) continue;
            return true;
        }
        return false;
    }

    private static KTools[] getAllPalettes() {
        Component[] comp = desktopPane.getComponentsInLayer(PALETTE_LAYER);
        if (comp == null || comp.length == 0) {
            return null;
        }
        KTools[] tools = new KTools[comp.length];
        for (int n = 0; n < comp.length; ++n) {
            if (comp[n] instanceof KTools) {
                tools[n] = (KTools)comp[n];
                continue;
            }
            Cutter.setLog("    Error: KAbstractDesktop.getAllPalettes() - expected an instance of \"KTools\" but got:");
        }
        return tools;
    }

    public static void deactivateAllPalettes() {
        KTools[] tools = KAbstractDesktop.getAllPalettes();
        if (tools == null) {
            return;
        }
        for (int n = 0; n < tools.length; ++n) {
            tools[n].deactivateSelf();
        }
    }

    public static void activateAllPalettes() {
        KTools[] tools = KAbstractDesktop.getAllPalettes();
        if (tools == null) {
            return;
        }
        for (int n = 0; n < tools.length; ++n) {
            tools[n].activateSelf();
        }
    }

    public static KAbstractWindow getWindowAtPosition(int index) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        for (int n = 0; n < comp.length; ++n) {
            if (desktopPane.getPosition(comp[n]) != index) continue;
            return (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
        }
        return null;
    }

    public static int getWindowIndex(KAbstractWindow comp) {
        return desktopPane.getIndexOf(comp);
    }

    public static int getWindowPosition(KAbstractWindow comp) {
        return desktopPane.getPosition(comp);
    }

    public static Component[] getComponentsInLayer(int layer) {
        return desktopPane.getComponentsInLayer(layer);
    }

    public static KAbstractWindow getWindowAtIndex(int index) {
        return KAbstractDesktop.getWindowAtIndex(WINDOW_LAYER, index);
    }

    public static KAbstractWindow getWindowAtIndex(int layer, int index) {
        Component[] comp = desktopPane.getComponentsInLayer(layer);
        if (comp == null || index >= comp.length) {
            return null;
        }
        if (KAbstractDesktop.getInternalFrameFrom(comp[index]) instanceof KAbstractWindow) {
            return (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[index]);
        }
        Cutter.setLog("    Error: KAbstractDesktop.getWindowAtIndex() has been returned an object");
        Cutter.setLog("    of a class called " + comp[index].getClass().getName() + " . It was expecting an object of class KAbstractWindow");
        return null;
    }

    public static boolean windowExists(File file) {
        if (_windowExists) {
            Cutter.setLog("KAbstractDesktop.windowExists(File)");
        }
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        JInternalFrame window = null;
        if (file == null) {
            Cutter.setLog("KAbstractDesktop.windowExists(File) - argument is null");
            return false;
        }
        if (comp == null) {
            Cutter.setLog("KAbstractDesktop.windowExists(File) - can't get components in layer WINDOW_LAYER");
            return false;
        }
        for (int n = 0; n < comp.length; ++n) {
            if (comp[n] == null) continue;
            if (comp[n] instanceof JInternalFrame.JDesktopIcon) {
                window = ((JInternalFrame.JDesktopIcon)comp[n]).getInternalFrame();
            } else if (comp[n] instanceof KAbstractWindow) {
                window = (JInternalFrame)comp[n];
            }
            if (window == null || !(window instanceof KAbstractWindow)) continue;
            File f = ((KAbstractWindow)window).getFile();
            if (f == null && _windowExists) {
                Cutter.setLog("KAbstractDesktop.windowExists(File) - window named \"" + window.getTitle() + "\" has null file");
                continue;
            }
            if (f == null || !file.getPath().equals(f.getPath())) continue;
            return true;
        }
        return false;
    }

    public static boolean windowExists(String title) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        JInternalFrame window = null;
        for (int n = 0; n < comp.length; ++n) {
            if (comp[n] == null) continue;
            if (comp[n] instanceof JInternalFrame.JDesktopIcon) {
                window = ((JInternalFrame.JDesktopIcon)comp[n]).getInternalFrame();
            } else if (comp[n] instanceof KAbstractWindow) {
                window = (JInternalFrame)comp[n];
            } else {
                Cutter.setLog("    Error: KAbstractDesktop.windowExists(String)");
            }
            if (window == null || !window.getTitle().equals(title)) continue;
            return true;
        }
        return false;
    }

    public static boolean windowExists(KAbstractWindow w) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        for (int n = 0; n < comp.length; ++n) {
            if ((KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]) != w) continue;
            return true;
        }
        return false;
    }

    public static KAbstractWindow getWindowOfClass(String name) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        KAbstractWindow window = null;
        for (int n = 0; n < comp.length; ++n) {
            Class<?> cls;
            window = (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
            if (window == null || (cls = window.getClass()) == null || !cls.getName().equals(name)) continue;
            return window;
        }
        return null;
    }

    public static KAbstractWindow getWindowWithTitle(String title) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        KAbstractWindow window = null;
        for (int n = 0; n < comp.length; ++n) {
            window = (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
            if (window == null) {
                return null;
            }
            String str = window.getTitle();
            if ((str = TextUtils.remove(str, '*')).endsWith(" [NOT EDITABLE]")) {
                int len = " [NOT EDITABLE]".length();
                str = str.substring(0, str.length() - len).trim();
            }
            if (!str.equals(title)) continue;
            return window;
        }
        return null;
    }

    public static KAbstractWindow getWindowWithFile(File file) {
        if (file == null) {
            return null;
        }
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        KAbstractWindow w = null;
        String fullpath = file.getPath();
        for (int n = 0; n < comp.length; ++n) {
            w = (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
            File f = w.getFile();
            if (f == null || !w.getFile().getPath().equals(fullpath)) continue;
            return w;
        }
        return null;
    }

    public static KAbstractWindow getWindowWithPath(String fullpath) {
        Component[] comp = desktopPane.getComponentsInLayer(WINDOW_LAYER);
        KAbstractWindow w = null;
        for (int n = 0; n < comp.length; ++n) {
            w = (KAbstractWindow)KAbstractDesktop.getInternalFrameFrom(comp[n]);
            File f = w.getFile();
            if (f == null) {
                return null;
            }
            if (!w.getFile().getPath().equals(fullpath)) continue;
            return w;
        }
        return null;
    }

    private static JInternalFrame getInternalFrameFrom(Component comp) {
        if (comp instanceof JInternalFrame.JDesktopIcon) {
            return ((JInternalFrame.JDesktopIcon)comp).getInternalFrame();
        }
        if (comp instanceof JInternalFrame) {
            return (JInternalFrame)comp;
        }
        Cutter.setLog("    Error: KAbstractDesktop.getInternalFrameFrom() - found a class called " + comp.getClass().getName());
        return null;
    }

    private void ______INNER_ACTION_CLASSES______() {
    }

    public static int getFrameCount() {
        return frameCount;
    }

    public static void incrFrameCount() {
        ++frameCount;
    }

    static PageFormat getPageFormat() {
        if (pageFormat == null) {
            pageFormat = PrinterJob.getPrinterJob().defaultPage();
        }
        Paper defaultPaper = pageFormat.getPaper();
        double paperWidth = defaultPaper.getWidth();
        double paperHeight = defaultPaper.getHeight();
        double x = defaultPaper.getImageableX();
        double y = defaultPaper.getImageableY();
        double width = defaultPaper.getImageableWidth();
        double height = defaultPaper.getImageableHeight();
        defaultPaper.setImageableArea(18.0, 18.0, paperWidth - 36.0, paperHeight - 36.0);
        pageFormat.setPaper(defaultPaper);
        return pageFormat;
    }

    static {
        try {
            Field[] fields = new Field[]{KAbstractDesktop.class.getDeclaredField("_windowExists")};
            Cutter.addDebug(KAbstractDesktop.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: KAbstractDesktop.static - " + ex.toString());
        }
        asciID = 0;
        frameCount = 0;
        chooser = null;
        WINDOW_LAYER = JLayeredPane.DEFAULT_LAYER;
        PALETTE_LAYER = JLayeredPane.PALETTE_LAYER;
        LOG_LAYER = WINDOW_LAYER + 1;
        pageFormat = null;
    }

    public class CutAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BBxt.cut();
        }
    }

    public class CopyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BBxt.copy();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class PasteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BBxt.paste();
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BBxt.selectAll();
        }
    }

    public static class PopupAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KCaret caret = BBxt.getKCaret();
            if (caret == null) {
                return;
            }
            JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
            try {
                Rectangle rect = textpane.modelToView(BBxt.getSelectionEnd());
                MouseEvent fakeEvent = new MouseEvent(textpane, 500, System.currentTimeMillis(), 0, rect.x, rect.y, 1, true);
                caret.notifyPopupTriggerListeners(fakeEvent);
            }
            catch (Exception ex) {
                Cutter.setLog("    Info:KAbstractDesktop.PopupAction\n           " + ex.toString());
            }
        }
    }

    public static class SelectBlockAction
    extends AbstractAction {
        private KTextPane textpane = null;
        private Document doc = null;
        private Segment segment = null;
        SyntaxListener listener = null;
        private int caretAt = -1;
        private Color cmntColor = null;
        private Color strColor = null;

        public SelectBlockAction(KTextPane textpane, int caretAt) {
            this.textpane = textpane;
            this.doc = textpane.getDocument();
            this.listener = textpane.getSyntaxListener();
            this.segment = DocumentUtils.getSegment(this.doc, 0, this.doc.getLength());
            this.caretAt = caretAt;
            this.cmntColor = StyleConstants.getForeground(textpane.styleContext.commentStyle1);
            this.strColor = StyleConstants.getForeground(textpane.styleContext.stringStyle1);
        }

        private boolean doIgnore(int offset) {
            Color c = DocumentUtils.getCharacterStyleColor(this.doc, offset);
            return c == this.cmntColor || c == this.strColor;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            char c;
            int blockOpenOffset = -1;
            int blockCloseOffset = -1;
            int beginAt = this.segment.offset + this.caretAt;
            int openCount = 1;
            for (int offset = beginAt; offset < this.segment.count; ++offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset)) continue;
                if (c == '(' || c == '{') {
                    ++openCount;
                } else if (c == '}' || c == ')') {
                    --openCount;
                }
                if (openCount != 0) continue;
                blockCloseOffset = offset;
                break;
            }
            if (blockCloseOffset == -1) {
                return;
            }
            int closeCount = 0;
            int openOffset = -1;
            for (int offset = beginAt = blockCloseOffset; offset >= this.segment.offset; --offset) {
                c = this.segment.array[offset + this.segment.offset];
                if (this.doIgnore(offset)) continue;
                if (c == '}' || c == ')') {
                    ++closeCount;
                } else if (c == '{' || c == '(') {
                    --closeCount;
                }
                if (closeCount != 0) continue;
                blockOpenOffset = offset;
                break;
            }
            if (blockOpenOffset == -1) {
                return;
            }
            this.textpane.setSelectionStart(blockOpenOffset);
            this.textpane.setSelectionEnd(blockCloseOffset + 1);
            this.textpane.requestFocus();
        }
    }

    public static class PrintDocAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    KAbstractWindow w = BBxt.frontWindow();
                    if (w instanceof KTextWindow) {
                        try {
                            PrinterJob job = PrinterJob.getPrinterJob();
                            job.setPrintable((KTextWindow)w, KAbstractDesktop.getPageFormat());
                            if (job.printDialog()) {
                                job.print();
                            }
                        }
                        catch (Exception ex) {
                            Cutter.setLog("    Exception:KAbstractDesktop.PrintDocAction - " + ex.toString());
                        }
                    }
                }
            };
            thread.start();
        }
    }

    public static class PageSetupAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            PrinterJob job = PrinterJob.getPrinterJob();
            if (pageFormat == null) {
                pageFormat = job.defaultPage();
            }
            pageFormat = job.pageDialog(pageFormat);
        }
    }

    public static class OpenPreviousSessionAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            String str = Preferences.get(Preferences.DOCUMENT_LAST_SESSION_PATHS);
            if (str == null || str.trim().length() == 0) {
                return;
            }
            String[] items = TextUtils.tokenize(str, "'");
            for (int n = 0; n < items.length; ++n) {
                FileUtils.applyFileSeparator(items[n]);
            }
            Vector<String> vector = new Vector<String>();
            for (int n = 0; n < items.length; ++n) {
                if (vector.contains(items[n])) continue;
                vector.addElement(items[n]);
            }
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                File file;
                String item = e.nextElement().toString();
                if (item == null || !(file = new File(item)).exists() || file.length() > KRecentDocsMenu.AUTO_OPEN_MAX_FILE_SIZE) continue;
                if (KAbstractDesktop.windowExists(file)) {
                    KAbstractWindow window = KAbstractDesktop.getWindowWithFile(file);
                    if (window == null) {
                        return;
                    }
                    KAbstractDesktop.toFront(window);
                    continue;
                }
                BBxt.newDocument(file);
            }
        }

        public File[] getFiles() {
            Vector<File> listOfFiles = new Vector<File>();
            String str = Preferences.get(Preferences.DOCUMENT_LAST_SESSION_PATHS);
            if (str == null || str.trim().length() == 0) {
                return null;
            }
            String[] items = TextUtils.tokenize(str, "'");
            for (int n = 0; n < items.length; ++n) {
                FileUtils.applyFileSeparator(items[n]);
            }
            Vector<String> vector = new Vector<String>();
            for (int n = 0; n < items.length; ++n) {
                if (vector.contains(items[n])) continue;
                vector.addElement(items[n]);
            }
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                File file;
                String item = e.nextElement().toString();
                if (item == null || !(file = new File(item)).exists()) continue;
                listOfFiles.addElement(file);
            }
            return VectorUtils.toFileArray(listOfFiles);
        }

        public String[] getNames() {
            File[] files = this.getFiles();
            if (files == null || files.length == 0) {
                return null;
            }
            String[] out = new String[files.length];
            for (int n = 0; n < files.length; ++n) {
                out[n] = files[n].getName();
            }
            return out;
        }
    }

    public static class ExecuteControlSpaceAction
    extends AbstractAction {
        private boolean shiftDown;

        public ExecuteControlSpaceAction() {
            this.shiftDown = this.shiftDown = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class ExecuteShiftAction
    extends AbstractAction {
        private boolean shiftDown = false;

        public ExecuteShiftAction(boolean shiftDown) {
            this.shiftDown = shiftDown;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BBxt.execute(this.shiftDown);
        }
    }

    public static class BraakLinesAction
    extends AbstractAction {
        private KAbstractHelp.KPopupMenuItem mi = null;
        private Vanilla tok = new Vanilla();

        public BraakLinesAction() {
        }

        public BraakLinesAction(KAbstractHelp.KPopupMenuItem mi) {
            this.mi = mi;
        }

        private String makeTabStr(int tabs) {
            StringBuffer b = new StringBuffer();
            for (int n = 0; n < tabs; ++n) {
                b.append('\t');
            }
            return b.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JEditorPane pane = BBxt.getTextPane();
            if (pane instanceof KTextPane) {
                KTextPane textpane = (KTextPane)pane;
                KAbstractTextWindow atw = textpane.getFrame();
                int tabChars = atw.getTabSize();
                Document doc = ((KTextPane)pane).getDocument();
                String str = Preferences.get(Preferences.DOCUMENT_RIGHT_MARGIN_WIDTH);
                int targetWidth = NumberUtils.strToInt(str, 100);
                String tabStr = "";
                int selBegin = textpane.getSelectionStart();
                int selEnd = textpane.getSelectionEnd();
                int[] beginData = DocumentUtils.getLineNumberAt(doc, selBegin);
                int[] endData = DocumentUtils.getLineNumberAt(doc, selEnd);
                String rawText = textpane.getSelection();
                String[] lines = TextUtils.tokenize(rawText, '\n');
                if (lines == null || lines.length == 0) {
                    return;
                }
                StringBuffer buf = new StringBuffer();
                int charCount = 100;
                int tabs0 = TextUtils.countTabs(lines[0]);
                int tabs = DocumentUtils.countTabStopsAtOffset(doc, selBegin);
                Element first = DocumentUtils.getParagraphElement(doc, selBegin);
                Segment seg = DocumentUtils.getSegment(doc, first);
                tabs = TextUtils.countTabs(seg.toString());
                tabStr = this.makeTabStr(tabs);
                buf.append(tabStr);
                charCount = tabChars *= tabs;
                for (int n = 0; n < lines.length; ++n) {
                    String line = TextUtils.trimTrailingChar(lines[n], '\n');
                    this.tok.setBuffer(line.trim());
                    String s = this.tok.getNextStr();
                    while (!s.equals("")) {
                        String peek = this.tok.peekNextStr();
                        if (charCount + s.length() >= targetWidth) {
                            buf.append("\n").append(tabStr);
                            charCount = tabChars;
                        }
                        charCount += s.length() + 1;
                        if (s.equals("(")) {
                            buf.append(s);
                            s = this.tok.getNextStr();
                            continue;
                        }
                        if (s.equals(")") && peek.startsWith(";")) {
                            buf.append(s);
                            s = this.tok.getNextStr();
                            continue;
                        }
                        if (peek.startsWith(")")) {
                            buf.append(s);
                            s = this.tok.getNextStr();
                            continue;
                        }
                        if (peek.startsWith(",") || peek.startsWith(".")) {
                            buf.append(s);
                            s = this.tok.getNextStr();
                            continue;
                        }
                        buf.append(s).append(" ");
                        s = this.tok.getNextStr();
                    }
                }
                if (selBegin > beginData[1]) {
                    selBegin = beginData[1];
                }
                if (selEnd == endData[1]) {
                    --selEnd;
                }
                textpane.setSelectionStart(selBegin);
                textpane.setSelectionEnd(selEnd);
                String result = TextUtils.trimTrailingChar(buf.toString(), ' ');
                textpane.replaceSelection(result);
            }
        }

        private class Vanilla
        extends Tokenizer {
            public Vanilla() {
                this.setDefaultDelimitors();
                this.removeDelimitor("=<>,;.:!");
                this.addQuotation("\"", "\"", '\\');
            }

            @Override
            public String gnsGrabCSystemHeader(char c) {
                return null;
            }
        }
    }

    public static class LineMarginAction
    extends AbstractAction {
        private KAbstractHelp.KPopupMenuItem mi = null;

        public LineMarginAction() {
        }

        public LineMarginAction(KAbstractHelp.KPopupMenuItem mi) {
            this.mi = mi;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow fw = BBxt.frontWindow();
            if (fw != null && fw instanceof KTextWindow) {
                KTextWindow textWindow = (KTextWindow)fw;
                boolean flag = textWindow.lineMarginIsVisible();
                if (!flag) {
                    textWindow.showLineMargin();
                } else {
                    textWindow.hideLineMargin();
                }
            }
        }
    }

    public static class LineNumberingAction
    extends AbstractAction {
        private KAbstractHelp.KPopupMenuItem mi = null;

        public LineNumberingAction() {
        }

        public LineNumberingAction(KAbstractHelp.KPopupMenuItem mi) {
            this.mi = mi;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow fw = BBxt.frontWindow();
            if (fw != null && fw instanceof KTextWindow) {
                KTextWindow textWindow;
                boolean flag = (textWindow = (KTextWindow)fw).lineNumberingIsVisible();
                textWindow.showLineNumbering(!flag);
            }
        }
    }

    public static class ExportHtmlAction
    extends AbstractAction {
        private JEditorPane editor = null;
        private boolean openInWindow = true;
        public String htmlText = "";

        public ExportHtmlAction() {
        }

        public ExportHtmlAction(JEditorPane editor) {
            if (editor != null) {
                this.openInWindow = false;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int begin = BBxt.getSelectionStart();
            int end = BBxt.getSelectionEnd();
            if (begin == -1 || end == -1) {
                Cutter.setLog("    Error:KAbstractDesktop.ExportHtmlAction - cannot get start and end offsets of the selection");
                return;
            }
            this.htmlText = HTMLUtils.generateHTML(this.editor, this.openInWindow);
        }
    }

    public static class HtmlBRAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            SyntaxListener sl;
            JEditorPane textpane = BBxt.getTextPane();
            if (textpane == null || !(textpane instanceof KTextPane)) {
                return;
            }
            if (textpane instanceof KTextPane && (sl = ((KTextPane)textpane).getSyntaxListener()) != null && sl instanceof HtmlListener) {
                BBxt.paste("<BR>");
            }
        }
    }

    public static class HtmlSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            SyntaxListener sl;
            JEditorPane textpane = BBxt.getTextPane();
            if (textpane == null || !(textpane instanceof KTextPane)) {
                return;
            }
            if (textpane instanceof KTextPane && (sl = ((KTextPane)textpane).getSyntaxListener()) != null && sl instanceof HtmlListener) {
                BBxt.paste("&nbsp;");
            }
        }
    }

    public class ExecuteAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            BBxt.execute();
        }
    }

    protected class TextToASCIAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Segment source;
            Cutter.setLog("Info: TextToASCIAction() selection");
            Segment segment = source = BBxt.getSelectionStart() == BBxt.getSelectionEnd() ? BBxt.getWindowText(null) : BBxt.getSelection(null);
            if (source == null || source.count == 0) {
                Cutter.setLog("    Error: TextToASCIAction() cannot get selection");
                return;
            }
            Cutter.setLog("Info: TextToASCIAction() selection = " + source.toString());
            String title = TextUtils.remove(BBxt.getWindowTitle(), '*');
            KTextWindow.addWindow(title + "_asci_codes" + ++asciID + ".txt");
            StringBuffer buffer = new StringBuffer();
            for (int n = 0; n < source.count; ++n) {
                buffer.append((int)source.array[source.offset + n]);
                if (source.array[source.offset + n] == '\n') {
                    buffer.append('\n');
                    continue;
                }
                buffer.append(" ");
            }
            BBxt.paste(buffer.toString());
        }
    }

    protected class OpenClientWindowAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KTextWindow[] windows = KTextWindow.addWindow("untitled_" + frameCount++);
            if (windows == null || windows.length < 1) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cannot open a Cutter client window", "Error 1 - Unable to Open New Window", 0);
                return;
            }
            KTextWindow window = windows[0];
            if (window == null) {
                JOptionPane.showMessageDialog(KDesktop.desktopPane, "Cannot open a Cutter client window", "Error 2 - Unable to Open New Window", 0);
                return;
            }
            window.upperPanel.netPanel.popup.setSelectedItem("Cutter Client");
            String address = Preferences.get(Preferences.CUTTER_CLIENT_ADDRESS);
            if (address.trim().length() == 0) {
                address = "10.7.223.21";
            }
            window.upperPanel.netPanel.setIPFor("client", address);
            window.upperPanel.showNetPanel();
        }
    }

    protected class OpenBroadcasterAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    protected class CascadeWindowsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            desktopPane.cascadeAll();
        }
    }

    protected class TileWindowsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            desktopPane.tileAll();
        }
    }

    protected class RestoreFromHistoryAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            KTextHistoryDB.restoreTextDocumentFromHistoryZipFile();
        }
    }

    protected class OpenHistoryWindowAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            BBxt.openHistoryWindow();
        }
    }

    protected class reloadPrefsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            KTextWindow prefWindow = (KTextWindow)KAbstractDesktop.getWindowWithTitle(Preferences.PREFS_NAME);
            if (prefWindow != null && prefWindow.getTouched()) {
                prefWindow.saveFile();
            }
            Preferences.init();
            RenderInfo.init();
        }
    }

    protected class prefsEditAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            BBxt.newDocument(new File(Preferences.PREFS_NAME));
        }
    }

    protected class OpenHiddenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            KTextWindow.addWindow(new KFileFilter(".", "Hidden Files"));
        }
    }

    protected class SaveDocAsCopyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow window = BBxt.frontWindow();
            if (window != null && window instanceof KAbstractTextWindow) {
                String[] str;
                if (window.saveFile(3) && DialogUtils.confirm("Open Copy", "Open", str = new String[]{"Do you wish to open the copy?"})) {
                    BBxt.newDocument(((KAbstractTextWindow)window).lastSaveAsCopy);
                }
            } else {
                Cutter.setLog("    Warning: KAbstractDesktop.SaveDocAsCopyAction.actionPerformed() - BBxt cannot find a front window to save!");
            }
        }
    }

    protected class SaveDocAsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow window = BBxt.frontWindow();
            if (window != null) {
                window.saveFile(2);
            } else {
                Cutter.setLog("    Warning: KAbstractDesktop.SaveDocAsAction.actionPerformed() - BBxt cannot find a front window to save!");
            }
        }
    }

    protected class SaveDocAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow window = BBxt.frontWindow();
            if (window != null) {
                window.saveFile();
            } else {
                Cutter.setLog("    Warning: KAbstractDesktop.SaveDocAction.actionPerformed() - BBxt cannot find a front window to save!");
            }
        }
    }

    public class CloseDocAction
    extends AbstractAction {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow window = KAbstractDesktop.getFrontWindow();
            if (window == null) {
                Cutter.setLog("KAbstractDesktop.CloseDocAction() getFrontWindow() returned null");
                return;
            }
            int mod = e.getModifiers();
            if ((mod & 1) != 0) {
                KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
                if (windows == null || windows.length == 0) {
                    return;
                }
                for (int n = 0; n < windows.length; ++n) {
                    if (windows[n] == null) continue;
                    try {
                        windows[n].setClosed(true);
                        continue;
                    }
                    catch (Exception ee) {
                        Cutter.setLog("    Exception:KAbstractDesktop.CloseDocAction - " + ee.toString());
                    }
                }
                return;
            } else {
                try {
                    window.setClosed(true);
                    return;
                }
                catch (PropertyVetoException ee) {
                    if (!Cutter.input.debug) return;
                    Cutter.setLog("    Debug:KAbstractDesktop.CloseDocAction() exception");
                    Cutter.setLog("          " + ee.toString());
                }
            }
        }
    }

    protected class OpenDocAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean handled = false;
            try {
                OpenSelectionHandler h = new OpenSelectionHandler();
                h.openSelection();
                handled = true;
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:DocOpenAction - " + ex.toString());
            }
            if (!handled) {
                KTextWindow.addWindow(null, null);
            }
        }
    }

    public static class NewDocAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KTextWindow.addWindow("untitled_" + frameCount++);
        }
    }
}

