/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop;

import Preferences.CerealRegistry;
import Preferences.Preferences;
import Session.SessionManager;
import UI_BBXT.BBxt;
import UI_Components.Dialog.DirPresetsPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Script.ScriptRegistry;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ExitManager
extends AbstractAction
implements WindowListener {
    private static final long serialVersionUID = 1L;
    static boolean promptIsOpen = false;

    public static void handleQuit() {
        Cutter.setLog("    Debug:ExitManager.handleQuit()");
        ExitManager em = new ExitManager();
        boolean f = em.finalCheckBeforeCloseDesktopWindow();
        if (f) {
            em.exit();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        ExitManager.handleQuit();
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        this.exit();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.finalCheckBeforeCloseDesktopWindow()) {
            Cutter.desktop.dispose();
        }
    }

    private boolean finalCheckBeforeCloseDesktopWindow() {
        File f;
        KAbstractWindow kaw;
        if (promptIsOpen) {
            return false;
        }
        promptIsOpen = true;
        KDesktop.saveSession();
        boolean result = false;
        if (KAbstractDesktop.hasUnsavedWindows()) {
            int response = JOptionPane.showConfirmDialog(KAbstractDesktop.desktopPane, "Save documents before Exit?");
            switch (response) {
                case 0: {
                    result = false;
                    if (!KDesktop.closeAllWindows()) break;
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                    break;
                }
                case -1: {
                    result = false;
                }
            }
        } else {
            result = true;
        }
        if (result && (kaw = BBxt.frontWindow()) != null && (f = kaw.getFile()) != null && f.exists()) {
            KDesktop.lastFileClosed = f;
            Preferences.write(Preferences.DOCUMENT_LAST_OPEN, f.getPath());
        }
        KDesktop.updateRecentMenu(true);
        KDesktop.saveRecentMenu();
        promptIsOpen = false;
        return result;
    }

    private void exit() {
        KAbstractWindow[] w = KAbstractDesktop.getAllWindows();
        for (int n = 0; n < w.length; ++n) {
            File f;
            w[n].removeMayaClient();
            w[n].removeHoudiniClient();
            w[n].removeCutterClient();
            if (w[n] instanceof KTextWindow) {
                ((KTextWindow)w[n]).writeToPrefs();
            }
            if (!(w[n] instanceof KTextWindow) || (f = w[n].getFile()) == null) continue;
            SessionManager.getInstance().closed(f.getPath());
        }
        this.cleanup();
        KTools.saveAll();
        Preferences.save();
        Preferences.updateBackup();
        ScriptRegistry.deleteTmpFiles();
        CerealRegistry.write();
        Cutter.htmlWindow.saveURLs();
        DirPresetsPanel.getInstance().saveSelf();
        Cutter.setLog("Cutter exited at " + TextUtils.getDateTime(true));
        Cutter.saveLog();
        if (Cutter.cutletEventHandler != null) {
            Cutter.cutletEventHandler.stop();
        }
        SessionManager.getInstance().writeToFile();
        System.exit(0);
    }

    private void cleanup() {
        String[] names;
        String userPath = new File(System.getProperty("user.dir")).getAbsolutePath();
        File tmp = new File(userPath, "tmp.mov");
        if (tmp.exists()) {
            Cutter.setLog("Cleanup: removing tmp.mov: " + tmp.delete());
        }
        if ((names = FileUtils.getListOfFileNames(FileUtils.getPWDFile())) == null) {
            return;
        }
        for (int n = 0; n < names.length; ++n) {
            File f = new File(names[n]);
            if (f != null && f.getName().startsWith("tmp.") && f.exists()) {
                f.delete();
            }
            if (!f.getName().endsWith(".depth")) continue;
            f.delete();
        }
    }
}

