/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop;

import ClientServer.ClientServer.client.KClient;
import Preferences.Preferences;
import Processes.ProcessManager;
import UI_Actions.AddCommentsAction;
import UI_Actions.AlphaSortAction;
import UI_Actions.ColorEditAction;
import UI_Actions.RedoAction;
import UI_Actions.RemoveCommentsAction;
import UI_Actions.ReverseSlashesAction;
import UI_Actions.ReverseStringsAction;
import UI_Actions.TextShiftAction;
import UI_Actions.ToLowerCaseAction;
import UI_Actions.ToUpperCaseAction;
import UI_Actions.UI_FindNextAction;
import UI_Actions.UI_FindReplaceAction;
import UI_Actions.UI_ReplaceFindAction;
import UI_Actions.UndoAction;
import UI_BBXT.BBxt;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.KMenu;
import UI_Components.KMenuBar;
import UI_Components.KMenuBarMenu;
import UI_Components.KMenuItem;
import UI_CutletScript.CutletCmd;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.ExitManager;
import UI_Desktop.FocusManager.KFocusManager;
import UI_Desktop.MenuItems.EditMenuListener;
import UI_Desktop.MenuItems.FileMenuListener;
import UI_Desktop.MenuItems.HelpMenuListener;
import UI_Desktop.MenuItems.HistoryMenuListener;
import UI_Desktop.MenuItems.KRecentDocsMenu;
import UI_Desktop.MenuItems.KTutorialMenu;
import UI_Desktop.MenuItems.NetworkMenuListener;
import UI_Desktop.MenuItems.ScriptMenuListener;
import UI_Desktop.MenuItems.WindowsMenuListener;
import UI_Desktop.StatusBar;
import UI_Desktop.TemplatesManager.TemplatesManager;
import UI_DragDrop.DnDGlassPane;
import UI_Script.Args.ArgsScriptHandler;
import UI_Script.Bat.BatScriptHandler;
import UI_Script.C.CScriptHandler;
import UI_Script.Cpp.CppScriptHandler;
import UI_Script.Cutlet.CutletScriptHandler;
import UI_Script.Default.KDefaultScriptHandler;
import UI_Script.H.HScriptHandler;
import UI_Script.Html.HtmlScriptHandler;
import UI_Script.Ifd.IfdScriptHandler;
import UI_Script.Java.JavaScriptHandler;
import UI_Script.Json.JsonScriptHandler;
import UI_Script.Lpe.LpeScriptHandler;
import UI_Script.Make.MakeScriptHandler;
import UI_Script.Mel.MelHelp;
import UI_Script.Mel.MelScriptHandler;
import UI_Script.Mtd.MtdScriptHandler;
import UI_Script.Osl.OslScriptHandler;
import UI_Script.Perl.PerlScriptHandler;
import UI_Script.PixarDev.BrickMap.BrickMapScriptHandler;
import UI_Script.PixarDev.DeepTexture.DeepTextureScriptHandler;
import UI_Script.PixarDev.ImplicitPlugin.ImplicitPluginScriptHandler;
import UI_Script.PixarDev.PointCloud.PointCloudScriptHandler;
import UI_Script.PixarDev.ProceduralPrimitive.ProceduralPrimitiveScriptHandler;
import UI_Script.PixarDev.RifPlugin.RifPluginScriptHandler;
import UI_Script.PixarDev.RixPlugins.RixPluginScriptHandler;
import UI_Script.Python.PythonScriptHandler;
import UI_Script.Rib.RibScriptHandler;
import UI_Script.Rman.RmanScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Script.See.SeeScriptHandler;
import UI_Script.SolidAngleDev.Ass.AssScriptHandler;
import UI_Script.SolidAngleDev.Shaders.AiShaderScriptHandler;
import UI_Script.Tcl.TclHelp;
import UI_Script.Tcl.TclScriptHandler;
import UI_Script.Vfl.VflHelp;
import UI_Script.Vfl.VflScriptHandler;
import UI_Text.KTextPane.KCaret;
import UI_Text.KTextPane.KTextPane;
import UI_Text.KeyMaps.KKeyMaps;
import UI_Tools.CCompile.CCompileTool;
import UI_Tools.DsoServer.DsoServerTool;
import UI_Tools.Find.FindTool;
import UI_Tools.FtpSendTool.FtpSendTool;
import UI_Tools.HTMLSearchTool.HTMLSearchTool;
import UI_Tools.Journal.JournalManager.KJournalManager;
import UI_Tools.KTools;
import UI_Tools.LPE.ExprReaderTool;
import UI_Tools.Mail.SendMailTool;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Mover.MoverTool;
import UI_Tools.Net.NetTool;
import UI_Tools.Preferences.PrefsTool;
import UI_Tools.RemoteBuild.RemoteBuildTool;
import UI_Tools.Rif.RifTool;
import UI_Tools.Rman.RmanTool;
import UI_Tools.Session.SessionTool;
import UI_Tools.TabWindowsTool.TabWindowsTool;
import UI_Tools.TransformsTool.TransformsTool;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.Zipper.ZipperTool;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import UI_Window.KWindow.LogFrame;
import Utilities.BrowserUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.JPEGUtils;
import Utilities.KFileFilter;
import Utilities.RibUtils;
import Utilities.TextUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class KDesktop
extends KAbstractDesktop
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    public static KMenuBar menuBar = new KMenuBar();
    private static KMenuBarMenu fileMenu = new KMenuBarMenu("File");
    private static KMenuBarMenu editMenu = new KMenuBarMenu("Edit");
    private static KMenuBarMenu toolMenu = new KMenuBarMenu("Tools");
    public static KMenuBarMenu windowMenu = new KMenuBarMenu("Window");
    public static KMenuBarMenu historyMenu = new KMenuBarMenu("History");
    private static KMenuBarMenu networkMenu = new KMenuBarMenu("Mail");
    private static KMenuBarMenu templateMenu = new KMenuBarMenu("Templates");
    private static KMenuBarMenu scriptMenu = new KMenuBarMenu("Script");
    private static KTutorialMenu tutorialMenu = null;
    public static KMenuBarMenu helpMenu = new KMenuBarMenu("Help");
    private static KMenuBarMenu debugMenu = new KMenuBarMenu("Debug");
    private static KMenu indicesMenu = new KMenu("Documentation");
    private static KMenu movieMenu = new KMenu("Movies");
    private static TemplatesManager templatesManager = null;
    public static JMenuItem saveItem;
    public static JMenuItem newItem;
    public static JMenuItem undoItem;
    public static JMenuItem openRmanToolItem;
    public static JMenuItem tileItem;
    public static JMenuItem viewHistoryItem;
    public static JMenuItem showNetItem;
    public static JMenuItem executeItem;
    public static JMenuItem aboutItem;
    public static JMenuItem openItem;
    public static JMenuItem redoItem;
    public static JMenuItem transformToolItem;
    public static JMenuItem cascadeItem;
    public static JMenuItem restoreHistoryItem;
    public static JMenuItem sendMailItem;
    public static JMenuItem makeItem;
    public static JMenuItem fundzaItem;
    public static JMenuItem openSpecialItem;
    public static JMenuItem cutItem;
    public static JMenuItem htmlSearchItem;
    public static JMenuItem tabbedItem;
    public static JMenuItem openHistoryItem;
    public static JMenuItem runItem;
    public static JMenuItem pixar21IndexItem;
    public static JMenuItem openRibItem;
    public static JMenuItem copyItem;
    public static JMenuItem lpeReaderItem;
    public static JMenuItem logItem;
    public static JMenuItem pixar20IndexItem;
    public static JMenuItem openKeyItem;
    public static JMenuItem pasteItem;
    public static JMenuItem zipperItem;
    public static JMenuItem iconifyAllItem;
    public static JMenuItem oslIndexItem;
    public static JMenuItem openSLItem;
    public static JMenuItem selectAllItem;
    public static JMenuItem ccompilerItem;
    public static JMenuItem deIconfyAllItem;
    public static JMenuItem arnoldOSLindexItem;
    public static JMenuItem openSLIItem;
    public static JMenuItem textShiftRightItem;
    public static JMenuItem netItem;
    public static JMenuItem arnoldCPPindexItem;
    public static JMenuItem openVFLItem;
    public static JMenuItem textShiftLeftItem;
    public static JMenuItem processItem;
    public static JMenuItem seexprIndexItem;
    public static JMenuItem openCItem;
    public static JMenuItem addCommentsItem;
    public static JMenuItem xpmIconItem;
    public static JMenuItem pyside2IndexItem;
    public static JMenuItem openHItem;
    public static JMenuItem removeCommentsItem;
    public static JMenuItem rifItem;
    public static JMenuItem rmsIndexItem;
    public static JMenuItem openCPPItem;
    public static JMenuItem toUpperCaseItem;
    public static JMenuItem remoteBuildItem;
    public static JMenuItem melIndexItem;
    public static JMenuItem openMelItem;
    public static JMenuItem toLowerCaseItem;
    public static JMenuItem dsoServerItem;
    public static JMenuItem vflIndexItem;
    public static JMenuItem openHTMLItem;
    public static JMenuItem reverseSlashesItem;
    public static JMenuItem ftpSendItem;
    public static JMenuItem tclIndexItem;
    public static JMenuItem openTCLItem;
    public static JMenuItem alphaSortItem;
    public static JMenuItem moverItem;
    public static JMenuItem openPERLItem;
    public static JMenuItem reverseStrsItem;
    public static JMenuItem openJAVAItem;
    public static JMenuItem wackItem;
    public static JMenuItem openHiddenItem;
    public static JMenuItem findReplaceItem;
    public static JMenuItem findNextItem;
    public static JMenuItem replaceFindItem;
    public static JMenuItem colorEditItem;
    public static JMenuItem prefsGUIItem;
    public static JMenuItem closeItem;
    public static JMenuItem openSessionItem;
    public static JMenuItem openSessionToolItem;
    public static JMenuItem reloadDocItem;
    public static JMenuItem openClientWindow;
    public static JMenuItem saveAsItem;
    public static JMenuItem saveAsTemplateItem;
    public static JMenuItem exportAsHtmlItem;
    public static JMenuItem journalItem;
    public static JMenuItem addToJournalItem;
    public static JMenuItem openJournalItem;
    public static JMenuItem sendFileItem;
    public static JMenuItem saveCopyItem;
    public static JMenuItem printItem;
    public static JMenuItem quitItem;
    public static KRecentDocsMenu openRecentItem;
    public static JMenuItem showCodesItem;
    public static JMenuItem lookAtElementsItem;
    public static JMenuItem rawClientItem;
    public static JMenuItem clientSysOutItem;
    public static JMenuItem senderSysOutItem;
    public static JMenuItem syntaxItem;
    public static ColorEditAction colorEditAction;
    public static KAbstractDesktop.SaveDocAction saveDocAction;
    public static ActionListener addToJournalAction;
    public static StatusBar status;
    public static TabWindowsTool tabWindowsTool;
    static JEditorPane currentEditorPane;
    static KAbstractWindow currentFrontWindow;
    SessionTool sessionTool = null;
    public static File lastFileClosed;
    private RmanTool rmantool;
    String pathToIt = null;
    String pathToSlim = null;
    DsoServerTool bst = null;
    public String URL_VSFX160 = "http://fundza.com/tishela/vsfx160";
    public String URL_VSFX319 = "http://fundza.com/tishela/vsfx319";
    public String URL_VSFX419 = "http://fundza.com/tishela/vsfx419";
    public String URL_VSFX705 = "http://fundza.com/tishela/vsfx705";
    public String URL_VSFX755 = "http://fundza.com/tishela/vsfx755";
    public String URL_VSFX502 = "http://fundza.com/tishela/vsfx502";
    public String URL_TECH312 = "http://fundza.com/tishela/tech312";
    public String URL_VSFX310 = "http://fundza.com/tishela/vsfx310";

    private void setBackgroundColor(Color color) {
        if (color != null) {
            desktopPane.setBackground(color);
        }
    }

    public KDesktop(String title) {
        super(title);
        Cutter.desktop = this;
        DnDGlassPane.setup(this);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        desktopPane.setRequestFocusEnabled(true);
        this.registerKeyboardShortCuts();
        this.setDefaultCloseOperation(0);
        this.addDefaultListeners();
        contentPane.add((Component)desktopPane, "Center");
        contentPane.add((Component)status, "South");
        this.setBounds(KDesktop.getPreferredDesktopBounds());
        this.setJMenuBar(menuBar);
        menuBar.add(this.fileMenu());
        menuBar.add(this.editMenu());
        menuBar.add(this.toolMenu());
        menuBar.add(this.windowsMenu());
        menuBar.add(this.historyMenu());
        String smtp = Preferences.get(Preferences.SMTP_SERVER);
        String port = Preferences.get(Preferences.SMTP_PORT);
        if (smtp.trim().length() > 0 && port.trim().length() > 0) {
            menuBar.add(this.networkMenu());
        }
        if (Cutter.input.debug || Cutter.input.dso_server.length() > 0) {
            menuBar.add(this.debugMenu());
        }
        templatesManager = new TemplatesManager(templateMenu);
        menuBar.add(this.templateMenu());
        saveAsTemplateItem.addActionListener(KDesktop.templatesManager.saveAsTemplateAction);
        menuBar.add(this.scriptMenu());
        menuBar.add(this.helpMenu());
        this.setVisible(true);
        if (Preferences.get(Preferences.DESKTOP_DOCUMENT_LAYOUT).equals(TabWindowsTool.TAB_LAYOUT)) {
            TabWindowsTool.init(tabbedItem).showSelf();
        }
        this.customizeForTeaching();
        this.customizeForTutorials();
        menuBar.initFontSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                KFocusManager.clearGlobalFocus_Owner();
                KFocusManager.setActiveWindow(Cutter.desktop);
                KFocusManager.setPermanentFocusOwner(KAbstractDesktop.desktopPane);
                KAbstractDesktop.desktopPane.grabFocus();
            }
        });
    }

    private KMenu fileMenu() {
        fileMenu.addMenuListener(new FileMenuListener());
        newItem = new JMenuItem("New");
        newItem.addActionListener(new KAbstractDesktop.NewDocAction());
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 512));
        fileMenu.add(newItem);
        openItem = new JMenuItem("Open...");
        openItem.addActionListener(new KAbstractDesktop.OpenDocAction());
        openItem.setAccelerator(KeyStroke.getKeyStroke(79, 512));
        fileMenu.add(openItem);
        ScriptRegistry.add(new OslScriptHandler());
        ScriptRegistry.add(new RibScriptHandler());
        ScriptRegistry.add(new MelScriptHandler());
        ScriptRegistry.add(new PythonScriptHandler());
        ScriptRegistry.add(new ArgsScriptHandler());
        ScriptRegistry.add(new RixPluginScriptHandler());
        ScriptRegistry.add(new LpeScriptHandler());
        ScriptRegistry.add(new SeeScriptHandler());
        ScriptRegistry.add(new JsonScriptHandler());
        ScriptRegistry.add(new RmanScriptHandler());
        ScriptRegistry.add(new MtdScriptHandler());
        ScriptRegistry.add(new HtmlScriptHandler());
        ScriptRegistry.add(new VflScriptHandler());
        ScriptRegistry.add(new IfdScriptHandler());
        ScriptRegistry.add(new TclScriptHandler());
        ScriptRegistry.add(new RifPluginScriptHandler());
        ScriptRegistry.add(new ProceduralPrimitiveScriptHandler());
        ScriptRegistry.add(new ImplicitPluginScriptHandler());
        ScriptRegistry.add(new PointCloudScriptHandler());
        ScriptRegistry.add(new BrickMapScriptHandler());
        ScriptRegistry.add(new DeepTextureScriptHandler());
        ScriptRegistry.add(new AiShaderScriptHandler());
        ScriptRegistry.add(new AssScriptHandler());
        ScriptRegistry.add(new CppScriptHandler());
        ScriptRegistry.add(new CScriptHandler());
        ScriptRegistry.add(new HScriptHandler());
        ScriptRegistry.add(new BatScriptHandler());
        ScriptRegistry.add(new JavaScriptHandler());
        ScriptRegistry.add(new PerlScriptHandler());
        if (Cutter.input.debug) {
            ScriptRegistry.add(new CutletScriptHandler());
        }
        ScriptRegistry.add(new MakeScriptHandler());
        ScriptRegistry.add(new KDefaultScriptHandler());
        closeItem = new JMenuItem("Close");
        closeItem.addActionListener(new KAbstractDesktop.CloseDocAction());
        closeItem.setAccelerator(KeyStroke.getKeyStroke(87, 512));
        closeItem.setEnabled(false);
        fileMenu.add(closeItem);
        fileMenu.addSeparator();
        fileMenu.add(openRecentItem);
        openSessionItem = new KMenuItem("Open Last Session");
        KAbstractDesktop.OpenPreviousSessionAction opsa = new KAbstractDesktop.OpenPreviousSessionAction();
        openSessionItem.addActionListener(opsa);
        String str = Preferences.get(Preferences.DOCUMENT_LAST_SESSION_PATHS);
        if (str == null || str.trim().length() == 0) {
            openSessionItem.setEnabled(false);
        } else {
            openSessionItem.setEnabled(true);
        }
        fileMenu.add(openSessionItem);
        String[] names = opsa.getNames();
        if (names != null && names.length > 0) {
            StringBuffer buff = new StringBuffer();
            for (int n = 0; n < names.length; ++n) {
                buff.append(names[n]).append("\n");
            }
            openSessionItem.setToolTipText(buff.toString());
        }
        openSessionToolItem = new JMenuItem("Show Session Tool");
        ActionListener sessionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDesktop.this.sessionTool.showSelf();
            }
        };
        openSessionToolItem.addActionListener(sessionAction);
        openSessionToolItem.setEnabled(true);
        fileMenu.add(openSessionToolItem);
        fileMenu.addSeparator();
        reloadDocItem = new JMenuItem("Reload Document");
        reloadDocItem.addActionListener(BBxt.reloadDocAction());
        reloadDocItem.setAccelerator(KeyStroke.getKeyStroke(82, 320));
        reloadDocItem.setEnabled(true);
        fileMenu.add(reloadDocItem);
        openClientWindow = new JMenuItem("Connect as Client...");
        openClientWindow.addActionListener(new KAbstractDesktop.OpenClientWindowAction());
        openClientWindow.setEnabled(true);
        fileMenu.add(openClientWindow);
        fileMenu.addSeparator();
        saveItem = new JMenuItem("Save");
        saveItem.addActionListener(new KAbstractDesktop.SaveDocAction());
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 512));
        saveItem.setEnabled(true);
        fileMenu.add(saveItem);
        saveAsItem = new JMenuItem("Save As...");
        saveAsItem.addActionListener(new KAbstractDesktop.SaveDocAsAction());
        saveAsItem.setEnabled(false);
        fileMenu.add(saveAsItem);
        saveCopyItem = new JMenuItem("Save A Copy As...");
        saveCopyItem.addActionListener(new KAbstractDesktop.SaveDocAsCopyAction());
        saveCopyItem.setEnabled(false);
        fileMenu.add(saveCopyItem);
        saveAsTemplateItem = new JMenuItem("Save As A Template...");
        saveAsTemplateItem.setEnabled(true);
        fileMenu.add(saveAsTemplateItem);
        fileMenu.addSeparator();
        journalItem = new KMenu("Journal");
        addToJournalItem = new JMenuItem("Add to Journal...");
        addToJournalItem.setAccelerator(KeyStroke.getKeyStroke(74, 512));
        addToJournalItem.setEnabled(false);
        addToJournalAction = new KJournalManager.AddToJournalAction(addToJournalItem);
        addToJournalItem.addActionListener(addToJournalAction);
        KJournalManager.OpenJournalAction openJournalAction = new KJournalManager.OpenJournalAction();
        openJournalItem = new JMenuItem("Open Journal in Browser");
        openJournalItem.addActionListener(openJournalAction);
        openJournalItem.setEnabled(false);
        journalItem.add(openJournalItem);
        journalItem.add(addToJournalItem);
        fileMenu.add(journalItem);
        exportAsHtmlItem = new JMenuItem("Export Selection As Html");
        exportAsHtmlItem.addActionListener(new KAbstractDesktop.ExportHtmlAction());
        exportAsHtmlItem.setEnabled(false);
        fileMenu.add(exportAsHtmlItem);
        if (Cutter.input.workshop) {
            sendFileItem = new JMenuItem("Send Document");
            sendFileItem.setEnabled(true);
            sendFileItem.addActionListener(new CutletCmd.SendFileAction());
            fileMenu.add(sendFileItem);
        }
        fileMenu.addSeparator();
        JMenuItem pageSetupItem = new JMenuItem("Page Setup...");
        pageSetupItem.addActionListener(new KAbstractDesktop.PageSetupAction());
        pageSetupItem.setEnabled(true);
        fileMenu.add(pageSetupItem);
        printItem = new JMenuItem("Print...");
        printItem.addActionListener(new KAbstractDesktop.PrintDocAction());
        printItem.setEnabled(true);
        fileMenu.add(printItem);
        fileMenu.addSeparator();
        quitItem = new JMenuItem("Quit");
        ActionListener quitAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExitManager.handleQuit();
            }
        };
        quitItem.addActionListener(quitAction);
        quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 512));
        fileMenu.add(quitItem);
        return fileMenu;
    }

    private KMenu editMenu() {
        editMenu.addMenuListener(new EditMenuListener());
        undoItem = new JMenuItem("Undo");
        undoItem.addActionListener(new UndoAction());
        undoItem.setEnabled(false);
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 512));
        editMenu.add(undoItem);
        redoItem = new JMenuItem("Redo");
        redoItem.addActionListener(new RedoAction());
        redoItem.setEnabled(false);
        redoItem.setAccelerator(KeyStroke.getKeyStroke(90, 576));
        editMenu.add(redoItem);
        editMenu.addSeparator();
        cutItem = new JMenuItem("Cut");
        cutItem.addActionListener(this.cutAction);
        cutItem.setEnabled(false);
        cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 512));
        editMenu.add(cutItem);
        copyItem = new JMenuItem("Copy");
        copyItem.addActionListener(this.copyAction);
        copyItem.setEnabled(false);
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 512));
        editMenu.add(copyItem);
        pasteItem = new JMenuItem("Paste");
        pasteItem.addActionListener(this.pasteAction);
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 512));
        editMenu.add(pasteItem);
        selectAllItem = new JMenuItem("Select All");
        selectAllItem.addActionListener(this.selectAllAction);
        selectAllItem.setEnabled(false);
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 512));
        editMenu.add(selectAllItem);
        editMenu.addSeparator();
        textShiftRightItem = new JMenuItem("Text Shift Right");
        textShiftRightItem.addActionListener(new TextShiftAction(2));
        textShiftRightItem.setEnabled(false);
        textShiftRightItem.setAccelerator(KeyStroke.getKeyStroke(93, 512));
        editMenu.add(textShiftRightItem);
        textShiftLeftItem = new JMenuItem("Text Shift Left");
        textShiftLeftItem.addActionListener(new TextShiftAction(1));
        textShiftLeftItem.setEnabled(false);
        textShiftLeftItem.setAccelerator(KeyStroke.getKeyStroke(91, 512));
        editMenu.add(textShiftLeftItem);
        KMenu commentsItem = new KMenu("Comments");
        addCommentsItem = new JMenuItem("Add");
        addCommentsItem.addActionListener(new AddCommentsAction());
        addCommentsItem.setEnabled(false);
        commentsItem.add(addCommentsItem);
        removeCommentsItem = new JMenuItem("Remove");
        removeCommentsItem.addActionListener(new RemoveCommentsAction());
        removeCommentsItem.setEnabled(false);
        commentsItem.add(removeCommentsItem);
        editMenu.addSeparator();
        editMenu.add(commentsItem);
        KMenu caseItem = new KMenu("Case");
        toUpperCaseItem = new JMenuItem("To Upper");
        toUpperCaseItem.addActionListener(new ToUpperCaseAction());
        toUpperCaseItem.setEnabled(false);
        toUpperCaseItem.setAccelerator(KeyStroke.getKeyStroke(38, 512));
        caseItem.add(toUpperCaseItem);
        toLowerCaseItem = new JMenuItem("To Lower");
        toLowerCaseItem.addActionListener(new ToLowerCaseAction());
        toLowerCaseItem.setAccelerator(KeyStroke.getKeyStroke(40, 512));
        toLowerCaseItem.setEnabled(false);
        caseItem.add(toLowerCaseItem);
        editMenu.add(caseItem);
        reverseSlashesItem = new JMenuItem("Reverse Slashes");
        reverseSlashesItem.addActionListener(new ReverseSlashesAction());
        reverseSlashesItem.setEnabled(true);
        editMenu.add(reverseSlashesItem);
        alphaSortItem = new JMenuItem("Sort Alphabetically");
        alphaSortItem.addActionListener(new AlphaSortAction());
        alphaSortItem.setEnabled(true);
        editMenu.add(alphaSortItem);
        reverseStrsItem = new JMenuItem("Reverse Strings");
        reverseStrsItem.addActionListener(new ReverseStringsAction());
        reverseStrsItem.setEnabled(true);
        if (Cutter.input.debug) {
            editMenu.add(reverseStrsItem);
        }
        wackItem = new JMenuItem("Remove Wackies");
        ActionListener wackAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.removeWackyCharacters();
            }
        };
        wackItem.addActionListener(wackAction);
        wackItem.setEnabled(false);
        editMenu.add(wackItem);
        editMenu.addSeparator();
        findReplaceItem = new JMenuItem("Show Find/Replace");
        findReplaceItem.addActionListener(new UI_FindReplaceAction());
        findReplaceItem.setAccelerator(KeyStroke.getKeyStroke(70, 512));
        findReplaceItem.setEnabled(true);
        editMenu.add(findReplaceItem);
        if (Preferences.get(Preferences.TOOL_FIND).equalsIgnoreCase("open")) {
            FindTool.init().setVisible(true);
            findReplaceItem.setText("Hide Find/Replace");
        }
        findNextItem = new JMenuItem("Find Next");
        findNextItem.addActionListener(new UI_FindNextAction());
        findNextItem.setAccelerator(KeyStroke.getKeyStroke(71, 512));
        findNextItem.setEnabled(true);
        editMenu.add(findNextItem);
        replaceFindItem = new JMenuItem("Replace & Find Again");
        replaceFindItem.addActionListener(new UI_ReplaceFindAction());
        replaceFindItem.setAccelerator(KeyStroke.getKeyStroke(76, 512));
        replaceFindItem.setEnabled(true);
        editMenu.add(replaceFindItem);
        colorEditItem = new JMenuItem("Edit Color...");
        if (colorEditAction == null) {
            colorEditAction = new ColorEditAction("Edit Color...");
        }
        if (saveDocAction == null) {
            saveDocAction = new KAbstractDesktop.SaveDocAction();
        }
        colorEditItem.addActionListener(colorEditAction);
        colorEditItem.setEnabled(false);
        colorEditItem.setAccelerator(KeyStroke.getKeyStroke(75, 512));
        editMenu.add(colorEditItem);
        editMenu.addSeparator();
        prefsGUIItem = new JMenuItem("Show Preferences");
        ActionListener prefsGUIAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsTool tool = PrefsTool.init(prefsGUIItem);
                tool.showSelf();
            }
        };
        prefsGUIItem.addActionListener(prefsGUIAction);
        prefsGUIItem.setEnabled(true);
        editMenu.add(prefsGUIItem);
        if (Preferences.get(Preferences.TOOL_PREFS).equalsIgnoreCase("open")) {
            PrefsTool tool = PrefsTool.init(prefsGUIItem);
            tool.showSelf();
        }
        return editMenu;
    }

    private KMenu toolMenu() {
        openRmanToolItem = new JMenuItem("Show RenderMan Tool");
        this.rmantool = RmanTool.init(openRmanToolItem);
        ActionListener openRmanToolsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDesktop.this.rmantool.showSelf();
            }
        };
        openRmanToolItem.addActionListener(openRmanToolsAction);
        toolMenu.add(openRmanToolItem);
        if (Preferences.get(Preferences.TOOL_RENDERMAN).equalsIgnoreCase("open")) {
            this.rmantool.setVisible(true);
            openRmanToolItem.setText("Hide RenderMan Tool");
        }
        transformToolItem = new JMenuItem("Show Transforms Tool");
        final TransformsTool transformsTool = TransformsTool.getInstance(transformToolItem);
        ActionListener matrixToolAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                transformsTool.showSelf();
            }
        };
        transformToolItem.addActionListener(matrixToolAction);
        transformToolItem.setEnabled(true);
        toolMenu.add(transformToolItem);
        if (Preferences.get(Preferences.TOOL_MATRIX).equalsIgnoreCase("open")) {
            transformsTool.showSelf();
        }
        htmlSearchItem = new JMenuItem("Show HTML Search Tool");
        final HTMLSearchTool tool = HTMLSearchTool.init(htmlSearchItem);
        ActionListener melSearchAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tool.showSelf();
            }
        };
        htmlSearchItem.addActionListener(melSearchAction);
        htmlSearchItem.setEnabled(true);
        toolMenu.add(htmlSearchItem);
        if (Preferences.get(Preferences.TOOL_HTML_SEARCH).equalsIgnoreCase("open")) {
            tool.setVisible(true);
            htmlSearchItem.setText("Hide HTML Search Tool");
        }
        lpeReaderItem = new JMenuItem("Show LPE Reader Tool");
        final ExprReaderTool lpetool = ExprReaderTool.init(lpeReaderItem);
        ActionListener lpeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                lpetool.showSelf();
            }
        };
        lpeReaderItem.addActionListener(lpeAction);
        lpeReaderItem.setEnabled(true);
        toolMenu.add(lpeReaderItem);
        if (Preferences.get(Preferences.TOOL_LPE).equalsIgnoreCase("open")) {
            lpetool.setVisible(true);
            lpeReaderItem.setText("Hide LPE Reader Tool");
        }
        zipperItem = new JMenuItem("Show Zipper Tool");
        final ZipperTool zipperTool = ZipperTool.init(zipperItem);
        ActionListener zipperAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                zipperTool.showSelf();
            }
        };
        zipperItem.addActionListener(zipperAction);
        zipperItem.setEnabled(true);
        toolMenu.add(zipperItem);
        if (Preferences.get(Preferences.TOOL_ZIPPER).equalsIgnoreCase("open")) {
            zipperTool.setVisible(true);
            zipperItem.setText("Hide Zipper Tool");
        }
        ccompilerItem = new JMenuItem("Show CC Options Tool");
        ActionListener ccompilerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CCompileTool ccompilerTool = CCompileTool.init(ccompilerItem);
                ccompilerTool.showSelf();
            }
        };
        ccompilerItem.addActionListener(ccompilerAction);
        ccompilerItem.setEnabled(true);
        toolMenu.add(ccompilerItem);
        if (Preferences.get(Preferences.TOOL_CCOMPILER).equalsIgnoreCase("open")) {
            CCompileTool ccompilerTool = CCompileTool.init(ccompilerItem);
            ccompilerTool.setVisible(true);
            ccompilerItem.setText("Hide CC Options Tool");
        }
        if (Cutter.input.debug) {
            netItem = new JMenuItem("Show Net Tool");
            final NetTool netTool = NetTool.init(netItem);
            ActionListener netAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    netTool.showSelf();
                }
            };
            netItem.addActionListener(netAction);
            netItem.setEnabled(true);
            toolMenu.add(netItem);
            if (Preferences.get(Preferences.TOOL_NET).equalsIgnoreCase("open")) {
                netTool.setVisible(true);
                netItem.setText("Hide Net Tool");
            }
        }
        processItem = new JMenuItem("Show Process Monitor");
        ActionListener processAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Monitor m = Monitor.getInstance();
                m.showSelf();
            }
        };
        processItem.addActionListener(processAction);
        processItem.setEnabled(true);
        toolMenu.add(processItem);
        this.sessionTool = SessionTool.init(openSessionToolItem);
        if (Cutter.input.debug) {
            xpmIconItem = new JMenuItem("Show XPM Icon Tool");
            final XPMIconTool xpmIconTool = XPMIconTool.init(xpmIconItem);
            ActionListener xpmIconAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    xpmIconTool.showSelf();
                }
            };
            xpmIconItem.addActionListener(xpmIconAction);
            xpmIconItem.setEnabled(true);
            toolMenu.add(xpmIconItem);
            if (Preferences.get(Preferences.TOOL_XPM).equalsIgnoreCase("open")) {
                xpmIconTool.showSelf();
            }
        }
        rifItem = new JMenuItem("Show Rif Tool");
        final RifTool rifTool = RifTool.init(rifItem);
        ActionListener rifAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                rifTool.showSelf();
            }
        };
        rifItem.addActionListener(rifAction);
        rifItem.setEnabled(true);
        toolMenu.add(rifItem);
        if (Preferences.get(Preferences.TOOL_RIF).equalsIgnoreCase("open")) {
            rifTool.showSelf();
        }
        remoteBuildItem = new JMenuItem("Show Remote Build Tool");
        final RemoteBuildTool remoteBuildTool = RemoteBuildTool.init(remoteBuildItem);
        ActionListener crossBuildAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                remoteBuildTool.showSelf();
            }
        };
        remoteBuildItem.addActionListener(crossBuildAction);
        toolMenu.add(remoteBuildItem);
        if (Preferences.get(Preferences.TOOL_REMOTEBUILD).equalsIgnoreCase("open")) {
            remoteBuildTool.setVisible(true);
            remoteBuildItem.setText("Hide Remote Build Tool");
        }
        if (Cutter.input.debug && !EnvUtils.isWinEnvironment()) {
            dsoServerItem = new JMenuItem("Show DsoServer Tool");
            final DsoServerTool dsoServerTool = DsoServerTool.init(dsoServerItem);
            ActionListener dsoServerAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    dsoServerTool.showSelf();
                }
            };
            dsoServerItem.addActionListener(dsoServerAction);
            toolMenu.add(dsoServerItem);
            if (Preferences.get(Preferences.TOOL_DSO_SERVER).equalsIgnoreCase("open")) {
                dsoServerTool.setVisible(true);
                dsoServerItem.setText("Hide DsoServer Tool");
            }
        }
        ftpSendItem = new JMenuItem("Show FtpSend Tool");
        final FtpSendTool ftpSendTool = FtpSendTool.init(ftpSendItem);
        ActionListener ftpSendAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ftpSendTool.showSelf();
            }
        };
        ftpSendItem.addActionListener(ftpSendAction);
        toolMenu.add(ftpSendItem);
        if (Preferences.get(Preferences.TOOL_FTPSEND).equalsIgnoreCase("open")) {
            ftpSendTool.setVisible(true);
            ftpSendItem.setText("Hide FtpSend Tool");
        }
        moverItem = new JMenuItem("Show Mover Tool");
        final MoverTool moverTool = MoverTool.init(moverItem);
        ActionListener moverAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                moverTool.showSelf();
            }
        };
        moverItem.addActionListener(moverAction);
        toolMenu.add(moverItem);
        if (Preferences.get(Preferences.TOOL_MOVER).equalsIgnoreCase("open")) {
            moverTool.setVisible(true);
            moverItem.setText("Hide Mover Tool");
        }
        return toolMenu;
    }

    private KMenu scriptMenu() {
        File rmsBinDir;
        scriptMenu.addMenuListener(new ScriptMenuListener());
        executeItem = new JMenuItem("Nothing to Execute");
        ActionListener executeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.execute();
            }
        };
        executeItem.setAccelerator(KeyStroke.getKeyStroke(69, 512));
        executeItem.addActionListener(executeAction);
        executeItem.setEnabled(false);
        scriptMenu.add(executeItem);
        makeItem = new JMenuItem("Make");
        makeItem.setAccelerator(KeyStroke.getKeyStroke(77, 512));
        makeItem.addActionListener(new ScriptRegistry.GenericMake());
        makeItem.setEnabled(false);
        scriptMenu.add(makeItem);
        runItem = new JMenuItem("Run");
        runItem.setAccelerator(KeyStroke.getKeyStroke(82, 512));
        runItem.addActionListener(new ScriptRegistry.GenericRun());
        runItem.setEnabled(false);
        scriptMenu.add(runItem);
        scriptMenu.addSeparator();
        boolean itExists = false;
        boolean slimExists = false;
        String path = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        if (path != null && (rmsBinDir = new File(path, "bin")).exists()) {
            slimExists = true;
            itExists = true;
            if (EnvUtils.isOSXEnvironment()) {
                this.pathToIt = new File(rmsBinDir, "it.app/Contents/MacOS/it").getPath();
                this.pathToSlim = new File(rmsBinDir, "slim.app/Contents/MacOS/slim").getPath();
            } else if (EnvUtils.isWinEnvironment()) {
                this.pathToIt = new File(rmsBinDir, "it").getPath();
                this.pathToSlim = new File(rmsBinDir, "slim").getPath();
            } else {
                this.pathToIt = new File(rmsBinDir, "it").getPath();
                this.pathToSlim = new File(rmsBinDir, "slim").getPath();
            }
        }
        KMenu pixarMenu = new KMenu("Pixar Applications");
        JMenuItem itItem = new JMenuItem("Launch \"it\"");
        ActionListener itAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Cutter.setLog("    Info:KDesktop.scriptMenu() - Launch \"it\" pathToIt \"" + KDesktop.this.pathToIt + "\"");
                ProcessManager fp = new ProcessManager("it");
                String[] cmd = new String[]{KDesktop.this.pathToIt};
                fp.launch(cmd, null, true, null, true);
            }
        };
        itItem.addActionListener(itAction);
        itItem.setEnabled(itExists);
        pixarMenu.add(itItem);
        scriptMenu.add(pixarMenu);
        return scriptMenu;
    }

    private KMenu windowsMenu() {
        windowMenu.addMenuListener(new WindowsMenuListener());
        tileItem = new JMenuItem("Tile");
        tileItem.addActionListener(new KAbstractDesktop.TileWindowsAction());
        tileItem.setEnabled(false);
        windowMenu.add(tileItem);
        cascadeItem = new JMenuItem("Cascade");
        cascadeItem.addActionListener(new KAbstractDesktop.CascadeWindowsAction());
        cascadeItem.setEnabled(false);
        windowMenu.add(cascadeItem);
        tabbedItem = new JMenuItem("Tab");
        tabbedItem.setEnabled(true);
        tabWindowsTool = TabWindowsTool.init(tabbedItem);
        ActionListener tabWindowsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                tabWindowsTool.showSelf();
            }
        };
        tabbedItem.addActionListener(tabWindowsAction);
        windowMenu.add(tabbedItem);
        windowMenu.addSeparator();
        logItem = new JMenuItem("Show Current Log");
        ActionListener logAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Cutter.setLog(logItem);
            }
        };
        logItem.addActionListener(logAction);
        logItem.setEnabled(true);
        logItem.setAccelerator(KeyStroke.getKeyStroke(76, 512));
        windowMenu.add(logItem);
        windowMenu.addSeparator();
        iconifyAllItem = new JMenuItem("Lower All");
        ActionListener iconifyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.iconifyAllTextWindows();
            }
        };
        iconifyAllItem.addActionListener(iconifyAction);
        windowMenu.add(iconifyAllItem);
        deIconfyAllItem = new JMenuItem("Raise All");
        ActionListener deIconifyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BBxt.deIconifyAllTextWindows();
            }
        };
        deIconfyAllItem.addActionListener(deIconifyAction);
        windowMenu.add(deIconfyAllItem);
        windowMenu.addSeparator();
        return windowMenu;
    }

    private KMenu historyMenu() {
        historyMenu.addMenuListener(new HistoryMenuListener());
        viewHistoryItem = new JMenuItem("Open History");
        viewHistoryItem.addActionListener(new KAbstractDesktop.OpenHistoryWindowAction());
        viewHistoryItem.setEnabled(false);
        viewHistoryItem.setAccelerator(KeyStroke.getKeyStroke(72, 512));
        historyMenu.add(viewHistoryItem);
        restoreHistoryItem = new JMenuItem("Restore From History...");
        restoreHistoryItem.addActionListener(new KAbstractDesktop.RestoreFromHistoryAction());
        restoreHistoryItem.setEnabled(true);
        historyMenu.add(restoreHistoryItem);
        historyMenu.addSeparator();
        openHistoryItem = new JMenuItem("Open History Prefs...");
        ActionListener openHistoryAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsTool.openTabPanel("UI Prefs", "History");
            }
        };
        openHistoryItem.addActionListener(openHistoryAction);
        openHistoryItem.setEnabled(true);
        historyMenu.add(openHistoryItem);
        return historyMenu;
    }

    private KMenu networkMenu() {
        networkMenu.addMenuListener(new NetworkMenuListener());
        sendMailItem = new JMenuItem("Show Send Mail");
        final SendMailTool mailTool = SendMailTool.getInstance(sendMailItem);
        ActionListener mailAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                mailTool.showSelf();
            }
        };
        sendMailItem.addActionListener(mailAction);
        sendMailItem.setEnabled(true);
        networkMenu.add(sendMailItem);
        networkMenu.addSeparator();
        JMenuItem openMailItem = new JMenuItem("Open Mail Prefs...");
        ActionListener openMailAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsTool.openTabPanel("UI Prefs", "Net");
            }
        };
        openMailItem.addActionListener(openMailAction);
        openMailItem.setEnabled(true);
        networkMenu.add(openMailItem);
        return networkMenu;
    }

    private KMenu templateMenu() {
        return templateMenu;
    }

    private KMenu helpMenu() {
        aboutItem = new JMenuItem("About Cutter...");
        ActionListener aboutAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String copyright = new String("\u00a9");
                JOptionPane.showMessageDialog(desktopPane, Cutter.INFO_COPYRIGHT + "Version: " + Cutter.version + "\nBuilt: " + Cutter.compiled + "\nInfo at: www.fundza.com\n\n", "About Cutter", 1);
            }
        };
        aboutItem.addActionListener(aboutAction);
        aboutItem.setEnabled(true);
        helpMenu.add(aboutItem);
        fundzaItem = new JMenuItem("www.fundza.com");
        ActionListener fundzaAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserUtils.open("http://www.fundza.com", true);
            }
        };
        fundzaItem.addActionListener(fundzaAction);
        fundzaItem.setEnabled(true);
        helpMenu.add(fundzaItem);
        helpMenu.addSeparator();
        indicesMenu.addMenuListener(new HelpMenuListener());
        pixar21IndexItem = new JMenuItem("Pixar - RenderMan Current");
        ActionListener pixar21Action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_DOCS_INDEX);
                if (path.trim().length() == 0) {
                    path = "https://rmanwiki.pixar.com/display/REN/RenderMan+Documentation";
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - renderman 21 index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        pixar21IndexItem.addActionListener(pixar21Action);
        indicesMenu.add(pixar21IndexItem);
        pixar20IndexItem = new JMenuItem("Pixar - RenderMan Legacy");
        ActionListener pixar20Action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = Preferences.get(Preferences.PATH_PIXAR_RENDERMAN_LEGACY_DOCS_INDEX);
                if (path.trim().length() == 0) {
                    path = "https://renderman.pixar.com/resources/RenderMan_20/home.html";
                }
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - renderman 20 index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        pixar20IndexItem.addActionListener(pixar20Action);
        indicesMenu.add(pixar20IndexItem);
        JMenuItem lpeItem = new JMenuItem("Pixar - LPE Documentation");
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String index = "https://rmanwiki.pixar.com/display/REN/Light+Path+Expressions#LightPathExpressions-LPETokens";
                try {
                    BrowserUtils.open(index);
                }
                catch (Exception e) {
                    Cutter.setLog("    Error:KDesktop.helpMenu() cannot load url \"" + index + "\"");
                }
            }
        };
        lpeItem.addActionListener(action);
        indicesMenu.add(lpeItem);
        indicesMenu.addSeparator();
        JMenuItem sonyLpeIndexItem = new JMenuItem("Sony - LPE Documentation");
        ActionListener sonyLpeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = "https://github.com/imageworks/OpenShadingLanguage/wiki/OSL-Light-Path-Expressions";
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - Sony LPE index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        sonyLpeIndexItem.addActionListener(sonyLpeAction);
        indicesMenu.add(sonyLpeIndexItem);
        oslIndexItem = new JMenuItem("Sony - Open Shading Language");
        ActionListener oslAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File cutter_help = new File(FileUtils.getPWDFile(), "Cutter_Help");
                File OSLDir = new File(cutter_help, "OSL");
                File oslDoc = new File(OSLDir, "osl-languagespec.pdf");
                String path = oslDoc.getPath();
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - osl index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        oslIndexItem.addActionListener(oslAction);
        indicesMenu.add(oslIndexItem);
        arnoldOSLindexItem = new JMenuItem("Arnold - Open Shading Language");
        ActionListener arnoldAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = "https://support.solidangle.com/display/A5ARP/OSL+Shaders";
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - arnold osl index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        arnoldOSLindexItem.addActionListener(arnoldAction);
        indicesMenu.add(arnoldOSLindexItem);
        arnoldCPPindexItem = new JMenuItem("Arnold - C++ Shader Writing");
        ActionListener arnoldCPPAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = "https://docs.arnoldrenderer.com/display/AFMUG/Technical";
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - arnold cpp index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        arnoldCPPindexItem.addActionListener(arnoldCPPAction);
        indicesMenu.add(arnoldCPPindexItem);
        seexprIndexItem = new JMenuItem("Disney - SeExpr Language");
        ActionListener seexprAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = "https://rmanwiki.pixar.com/display/REN/PxrSeExpr+Quick+Reference";
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - osl index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        seexprIndexItem.addActionListener(seexprAction);
        indicesMenu.add(seexprIndexItem);
        pyside2IndexItem = new JMenuItem("PySide2");
        ActionListener pysideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = Preferences.get(Preferences.PATH_PYSIDE2_DOCS);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - pyside2IndexItem path \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        pyside2IndexItem.addActionListener(pysideAction);
        indicesMenu.add(pyside2IndexItem);
        melIndexItem = new JMenuItem("Maya - Mel");
        ActionListener melAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = "http://help.autodesk.com/cloudhelp/2016/ENU/Maya-Tech-Docs/Commands";
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - mel index \"" + path + "\"");
                }
                BrowserUtils.open(path, true);
            }
        };
        melIndexItem.addActionListener(melAction);
        indicesMenu.add(melIndexItem);
        vflIndexItem = new JMenuItem("Houdini - Vfl");
        ActionListener vflAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserUtils.open(VflHelp.docsIndexURL, true);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - VflHelp.docsIndexURL\n          \"" + VflHelp.docsIndexURL + "\"");
                }
            }
        };
        vflIndexItem.addActionListener(vflAction);
        indicesMenu.add(vflIndexItem);
        tclIndexItem = new JMenuItem("Tcl/Tk");
        ActionListener tclAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = TclHelp.getcutrTclIndexURL();
                BrowserUtils.open(path, true);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:KDesktop.helpMenu() - TclHelp.docsIndexURL\n          \"" + path + "\"");
                }
            }
        };
        tclIndexItem.addActionListener(tclAction);
        indicesMenu.add(tclIndexItem);
        helpMenu.add(indicesMenu);
        return helpMenu;
    }

    private KMenu debugMenu() {
        JMenuItem buildItem = new JMenuItem("Remote Build");
        ActionListener buildAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File srcFile = BBxt.getWindowFile();
                StringBuffer buf = new StringBuffer();
                buf.append("build.write -src \"").append(srcFile.getPath()).append("\"");
                buf.append(" -target \"/Users/malcolm\" \n");
                String ipAddress = KClient.getLocalIP();
                buf.append(ipAddress).append("\n");
                File out = new File(FileUtils.getPWD(), "remote_build.cutlet");
                FileUtils.writeFile(out, buf.toString());
                String script = buf.toString().trim();
                Cutter.setLog(script + "\n------- End RemoteBuild Setup -------\n");
                CutletScriptHandler handler = new CutletScriptHandler();
                handler.execute(script);
            }
        };
        buildItem.addActionListener(buildAction);
        buildItem.setEnabled(true);
        debugMenu.add(buildItem);
        JMenuItem getMelDocItem = new JMenuItem("getDocsDBFor");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenFileDialog dialog = OpenFileDialog.getInstance(Cutter.desktop);
                File[] files = dialog.showSelf(new KFileFilter("html"), "Open", 2);
                if (files == null || files.length == 0) {
                    return;
                }
                MelHelp md = new MelHelp(null);
                md.debugGetPopupDB = true;
                String name = TextUtils.removeExtension(files[0].getName());
                md.getDocsDBFor(name, true);
            }
        };
        getMelDocItem.addActionListener(action);
        getMelDocItem.setEnabled(true);
        debugMenu.add(getMelDocItem);
        showCodesItem = new JMenuItem("Show As Asci Codes");
        showCodesItem.addActionListener(new KAbstractDesktop.TextToASCIAction());
        showCodesItem.setEnabled(true);
        debugMenu.add(showCodesItem);
        lookAtElementsItem = new JMenuItem("Show Elements");
        ActionListener lookAtElementsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KDesktop.dumpElements();
            }
        };
        lookAtElementsItem.addActionListener(lookAtElementsAction);
        lookAtElementsItem.setEnabled(true);
        debugMenu.add(lookAtElementsItem);
        debugMenu.addSeparator();
        JMenuItem getGlassPaneItem = new JMenuItem("Get Glasspane");
        ActionListener getGlassPaneAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Component comp = KDesktop.this.getGlassPane();
                Cutter.setLog(comp == null ? "glasspane is null" : "glasspane not null");
            }
        };
        getGlassPaneItem.addActionListener(getGlassPaneAction);
        getGlassPaneItem.setEnabled(true);
        debugMenu.add(getGlassPaneItem);
        JMenuItem forcExceptionItem = new JMenuItem("Force Exception");
        ActionListener forceExceptionAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] vec = new int[10];
                vec[10] = 37;
            }
        };
        forcExceptionItem.addActionListener(forceExceptionAction);
        forcExceptionItem.setEnabled(true);
        debugMenu.add(forcExceptionItem);
        JMenuItem testItem = new JMenuItem("test print");
        ActionListener testAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPEGUtils.printDocAsJPEG((JTextPane)BBxt.getTextPane());
            }
        };
        testItem.addActionListener(testAction);
        testItem.setEnabled(true);
        debugMenu.add(testItem);
        JMenuItem lineItem = new JMenuItem("showVerticalLine");
        ActionListener lineAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KAbstractWindow kaw = BBxt.frontWindow();
                ((KTextWindow)kaw).showLineMargin();
            }
        };
        lineItem.addActionListener(lineAction);
        lineItem.setEnabled(true);
        debugMenu.add(lineItem);
        JMenuItem shaderListItem = new JMenuItem("Open Prefs");
        ActionListener shaderListAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrefsTool.openTabPanel("UI Prefs", "History");
            }
        };
        shaderListItem.addActionListener(shaderListAction);
        shaderListItem.setEnabled(true);
        debugMenu.add(shaderListItem);
        JMenuItem reformatItem = new JMenuItem("Reformat");
        ActionListener reformatAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String[] result = RibUtils.reformat(BBxt.getWindowText());
                BBxt.newDocument("new", result[1]);
            }
        };
        reformatItem.addActionListener(reformatAction);
        reformatItem.setEnabled(true);
        debugMenu.add(reformatItem);
        JMenuItem xpmItem = new JMenuItem("XPM");
        ActionListener xpmAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        };
        xpmItem.addActionListener(xpmAction);
        xpmItem.setEnabled(true);
        debugMenu.add(xpmItem);
        return debugMenu;
    }

    public static void updateRecentMenu() {
        KDesktop.updateRecentMenu(false);
    }

    public static void updateRecentMenu(boolean exit) {
        if (!exit) {
            openRecentItem.menuSelected(null);
            return;
        }
        Object exitObj = new Object(){

            public String toString() {
                return "exit";
            }
        };
        MenuEvent event = new MenuEvent(exitObj);
        openRecentItem.menuSelected(event);
    }

    public static void saveRecentMenu() {
        openRecentItem.saveSelf();
    }

    public static void addWindowMenuItem(KAbstractWindow.WindowMenuItem item) {
        if (item == null) {
            return;
        }
        KAbstractWindow window = item.getAbstractWindow();
        if (window == null) {
            return;
        }
        windowMenu.remove(item);
        windowMenu.add(item);
    }

    public static void removeWindowMenuItem(JMenuItem item) {
        if (item == null) {
            Cutter.setLog("    KDesktop.removeWindowMenuItem() item is null");
            return;
        }
        windowMenu.remove(item);
        KAbstractWindow[] w = KDesktop.getAllWindows();
        if (w == null) {
            return;
        }
        if (w.length == 1) {
            TabWindowsTool.deleteAll();
        }
    }

    public static boolean closeAllWindows() {
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        if (windows == null) {
            return true;
        }
        openRecentItem.menuSelected(null);
        for (int n = 0; n < windows.length; ++n) {
            KAbstractWindow window = windows[n];
            window.saveHistory(window.getFile());
            if (!window.getTouched() || !window.getSaveable() || window.confirmSave("Save Document") != 2) continue;
            return false;
        }
        return true;
    }

    public static void saveSession() {
        int n;
        StringBuffer buffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        KAbstractWindow[] windows = KAbstractDesktop.getAllWindows();
        if (windows != null) {
            for (n = 0; n < windows.length; ++n) {
                if (windows[n] == null || windows[n].getFile() == null) continue;
                if (!windows[n].hasHistory()) {
                    windows[n].addToHistory();
                }
                windows[n].saveHistory(windows[n].getFile());
                if (!windows[n].isVisible()) continue;
                vector.addElement(windows[n].getFile().getPath());
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            buffer.append((String)vector.elementAt(n));
            buffer.append("'");
        }
        Preferences.write(Preferences.DOCUMENT_LAST_SESSION_PATHS, buffer.toString());
        Rectangle r = Cutter.desktop.getBounds();
        Preferences.write(Preferences.DESKTOP_BOUNDS, r.x + " " + r.y + " " + r.width + " " + r.height);
        Preferences.write(Preferences.DESKTOP_DOCUMENT_LAYOUT, TabWindowsTool.isActive() ? TabWindowsTool.TAB_LAYOUT : "");
    }

    private void handlePopupTrigger(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("New Text File");
        item.addActionListener(new KAbstractDesktop.NewDocAction());
        item.setAccelerator(KeyStroke.getKeyStroke(78, 512));
        popup.add(item);
        item = new JMenuItem("Open...");
        item.addActionListener(new KAbstractDesktop.OpenDocAction());
        item.setAccelerator(KeyStroke.getKeyStroke(79, 512));
        popup.add(item);
        JMenu openSpecialMenu = new JMenu("Open Special");
        JMenuItem[] menus = ScriptRegistry.getOpenFileMenuItems();
        if (menus != null) {
            for (int n = 0; n < menus.length; ++n) {
                if (menus[n] == null || menus[n].getText().equals("ShadeOp") || menus[n].getText().equals("RslPlugin") || menus[n].getText().equals("RifPlugin") || menus[n].getText().equals("ImplicitPlugin") || menus[n].getText().equals("MiC")) continue;
                openSpecialMenu.add(menus[n]);
            }
        }
        popup.add(new JSeparator());
        popup.add(new KRecentDocsMenu());
        popup.add(openSpecialMenu);
        popup.add(new JSeparator());
        item = new JMenuItem("Open Last Session");
        KAbstractDesktop.OpenPreviousSessionAction opsa = new KAbstractDesktop.OpenPreviousSessionAction();
        item.addActionListener(opsa);
        String str = Preferences.get(Preferences.DOCUMENT_LAST_SESSION_PATHS);
        if (str == null || str.trim().length() == 0) {
            item.setEnabled(false);
        } else {
            item.setEnabled(true);
        }
        String[] names = opsa.getNames();
        if (names != null && names.length > 0) {
            StringBuffer buff = new StringBuffer();
            for (int n = 0; n < names.length; ++n) {
                buff.append(names[n]).append("\n");
            }
            item.setToolTipText(buff.toString());
        }
        popup.add(item);
        item = new JMenuItem("Quit");
        ActionListener quitAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExitManager.handleQuit();
            }
        };
        item.addActionListener(quitAction);
        item.setAccelerator(KeyStroke.getKeyStroke(81, 512));
        popup.add(item);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(desktopPane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:SloHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    public static void addPropertyListener(PropertyChangeListener listener) {
        desktopPane.addPropertyChangeListener(listener);
    }

    private void addDefaultListeners() {
        this.addWindowListener(new ExitManager());
        desktopPane.addComponentListener(this);
        desktopPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    KDesktop.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || e.isAltDown()) {
                    KDesktop.this.handlePopupTrigger(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KTextWindow.addWindow(null, null);
                }
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (currentFrontWindow != BBxt.frontWindow()) {
                    return;
                }
                if (currentFrontWindow != null && currentFrontWindow instanceof KTextWindow) {
                    currentFrontWindow.requestFocusInWindow();
                    currentFrontWindow.setSelected(true);
                    KTextPane textpane = ((KTextWindow)currentFrontWindow).getTextPane();
                    if (EnvUtils.isLinuxEnvironment() && textpane != null) {
                        KKeyMaps.setDefaults(textpane);
                    }
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                currentEditorPane = BBxt.getTextPane();
                currentFrontWindow = BBxt.frontWindow();
                if (currentFrontWindow != null && currentFrontWindow instanceof KTextWindow) {
                    currentFrontWindow.setSelected(false);
                    KTextPane ktp = ((KTextWindow)currentFrontWindow).getTextPane();
                    if (ktp == null) {
                        return;
                    }
                    KCaret dc = ktp.getKCaret();
                    if (dc != null) {
                        dc.isFirstClick = true;
                    }
                }
            }
        });
    }

    @Override
    public void componentResized(ComponentEvent e) {
        KTools.repositionAll();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void propertyChange(PropertyChangeEvent e) {
        Cutter.setLog("KDesktop.propertyChange = " + e.getPropertyName());
    }

    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        String name = e.getPropertyName();
        if (e.getPropertyName().equals("closed") && (Boolean)e.getNewValue() == Boolean.TRUE) {
            if (!this.closeAllWindows()) {
                throw new PropertyVetoException("Cancelled by user", e);
            }
        }
    }

    public static void enableAllMenuItems() {
        Component[] comps = menuBar.getComponents();
        if (comps == null || comps.length == 0) {
            return;
        }
        for (int n = 0; n < comps.length; ++n) {
            if (comps[n] != null && comps[n] instanceof JMenu) {
                comps[n].setEnabled(true);
                continue;
            }
            Cutter.setLog("    Error: KDesktop.enableAllItems()");
        }
    }

    public static void disableAllMenuItems() {
        Component[] comps = menuBar.getComponents();
        if (comps == null || comps.length == 0) {
            return;
        }
        for (int n = 0; n < comps.length; ++n) {
            if (comps[n] != null && comps[n] instanceof JMenu) {
                comps[n].setEnabled(false);
                continue;
            }
            Cutter.setLog("    Error: KDesktop.enableAllItems()");
        }
    }

    public static Rectangle getPreferredDesktopBounds() {
        String[] tokens;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle out = new Rectangle(0, 0, d.width, d.height);
        String str = Preferences.get(Preferences.DESKTOP_BOUNDS);
        int x = -1;
        int y = -1;
        int width = -1;
        int height = -1;
        if (str != null && str.length() > 0 && (tokens = TextUtils.tokenize(str)).length == 4) {
            try {
                x = Integer.parseInt(tokens[0]);
                y = Integer.parseInt(tokens[1]);
                width = Integer.parseInt(tokens[2]);
                height = Integer.parseInt(tokens[3]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            out = new Rectangle(x, y, width, height);
        }
        return out;
    }

    public static void dumpElements() {
        JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
        if (textpane == null) {
            Cutter.setLog("KDesktop.dumpElements() - null textpane");
            return;
        }
        Cutter.setLog("Selection " + textpane.getSelectionStart() + " to " + textpane.getSelectionEnd());
        Document doc = textpane.getDocument();
        int[] b = DocumentUtils.getLineNumberAt(doc, textpane.getSelectionStart());
        int[] e = DocumentUtils.getLineNumberAt(doc, textpane.getSelectionEnd());
        Cutter.setLog("Selection " + textpane.getSelectionStart() + " to " + textpane.getSelectionEnd());
        Cutter.setLog("Line count " + b[0] + " to " + e[0]);
        Element[] ele = DocumentUtils.getElements(doc, b[1], e[2]);
        Cutter.setLog("Selection " + b[1] + " to " + e[2]);
        try {
            for (int n = 0; n < ele.length; ++n) {
                String str = doc.getText(ele[n].getStartOffset(), ele[n].getEndOffset() - ele[n].getStartOffset());
                Cutter.setLog(">" + str + "<");
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:KDesktop.dumpElements() " + ex.toString());
        }
    }

    private void registerKeyboardShortCuts() {
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.NewDocAction(), "", KeyStroke.getKeyStroke(78, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.NewDocAction(), "", KeyStroke.getKeyStroke(78, 256), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.OpenDocAction(), "", KeyStroke.getKeyStroke(79, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.OpenDocAction(), "", KeyStroke.getKeyStroke(79, 256), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.SaveDocAction(), "", KeyStroke.getKeyStroke(83, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.SaveDocAction(), "", KeyStroke.getKeyStroke(83, 512), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.SaveDocAction(), "", KeyStroke.getKeyStroke(83, 256), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.CloseDocAction(), "", KeyStroke.getKeyStroke(87, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.CloseDocAction(), "", KeyStroke.getKeyStroke(87, 512), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.CloseDocAction(), "", KeyStroke.getKeyStroke(87, 256), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.CloseDocAction(), "", KeyStroke.getKeyStroke(87, 320), 2);
        this.getRootPane().registerKeyboardAction(new KJournalManager.AddToJournalAction(addToJournalItem), "", KeyStroke.getKeyStroke(74, 128), 2);
        this.getRootPane().registerKeyboardAction(new KJournalManager.AddToJournalAction(addToJournalItem), "", KeyStroke.getKeyStroke(74, 512), 2);
        this.getRootPane().registerKeyboardAction(new KJournalManager.AddToJournalAction(addToJournalItem), "", KeyStroke.getKeyStroke(74, 256), 2);
        this.getRootPane().registerKeyboardAction(new ExitManager(), "", KeyStroke.getKeyStroke(81, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.PrintDocAction(), "", KeyStroke.getKeyStroke(80, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.PrintDocAction(), "", KeyStroke.getKeyStroke(80, 512), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.PrintDocAction(), "", KeyStroke.getKeyStroke(80, 256), 2);
        this.getRootPane().registerKeyboardAction(new UndoAction(), "", KeyStroke.getKeyStroke(90, 512), 2);
        this.getRootPane().registerKeyboardAction(new RedoAction(), "", KeyStroke.getKeyStroke(90, 576), 2);
        this.getRootPane().registerKeyboardAction(new UI_FindReplaceAction(), "", KeyStroke.getKeyStroke(70, 128), 2);
        this.getRootPane().registerKeyboardAction(new UI_FindReplaceAction(), "", KeyStroke.getKeyStroke(70, 256), 2);
        this.getRootPane().registerKeyboardAction(new ToLowerCaseAction(), "", KeyStroke.getKeyStroke(40, 128), 2);
        this.getRootPane().registerKeyboardAction(new ToLowerCaseAction(), "", KeyStroke.getKeyStroke(40, 256), 2);
        this.getRootPane().registerKeyboardAction(new ToUpperCaseAction(), "", KeyStroke.getKeyStroke(38, 128), 2);
        this.getRootPane().registerKeyboardAction(new ToUpperCaseAction(), "", KeyStroke.getKeyStroke(38, 256), 2);
        this.getRootPane().registerKeyboardAction(KRecentDocsMenu.openLastDocAction(), "", KeyStroke.getKeyStroke(112, 0), 2);
        this.getRootPane().registerKeyboardAction(KRecentDocsMenu.openLastDocAction(), "", KeyStroke.getKeyStroke(122, 0), 2);
        this.getRootPane().registerKeyboardAction(LogFrame.getExistingSyntaxAction(), "", KeyStroke.getKeyStroke(119, 0), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.OpenHistoryWindowAction(), "", KeyStroke.getKeyStroke(72, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.OpenHistoryWindowAction(), "", KeyStroke.getKeyStroke(72, 256), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteAction(), "", KeyStroke.getKeyStroke(69, 128), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteAction(), "", KeyStroke.getKeyStroke(69, 512), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteAction(), "", KeyStroke.getKeyStroke(69, 256), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericMake(), "", KeyStroke.getKeyStroke(77, 128), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericMake(), "", KeyStroke.getKeyStroke(77, 512), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericMake(), "", KeyStroke.getKeyStroke(77, 256), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericRun(), "", KeyStroke.getKeyStroke(82, 128), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericRun(), "", KeyStroke.getKeyStroke(82, 512), 2);
        this.getRootPane().registerKeyboardAction(new ScriptRegistry.GenericRun(), "", KeyStroke.getKeyStroke(82, 256), 2);
        this.getRootPane().registerKeyboardAction(BBxt.reloadDocAction(), "", KeyStroke.getKeyStroke(82, 192), 2);
        this.getRootPane().registerKeyboardAction(BBxt.reloadDocAction(), "", KeyStroke.getKeyStroke(82, 576), 2);
        this.getRootPane().registerKeyboardAction(BBxt.reloadDocAction(), "", KeyStroke.getKeyStroke(82, 320), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteShiftAction(true), "", KeyStroke.getKeyStroke(69, 192), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteShiftAction(true), "", KeyStroke.getKeyStroke(69, 576), 2);
        this.getRootPane().registerKeyboardAction(new KAbstractDesktop.ExecuteShiftAction(true), "", KeyStroke.getKeyStroke(69, 320), 2);
    }

    private void customizeForTeaching() {
        String s = FileUtils.getPWD();
        if (s != null) {
            String courseTitle = null;
            String baseUrlStr = null;
            if (FileUtils.isaSubDirOf(new File(s), "vsfx160", false)) {
                courseTitle = "Vsfx160";
                baseUrlStr = this.URL_VSFX160;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx319", false)) {
                courseTitle = "Vsfx319";
                baseUrlStr = this.URL_VSFX319;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx310", false)) {
                courseTitle = "Vsfx310";
                baseUrlStr = this.URL_VSFX310;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx419", false)) {
                courseTitle = "Vsfx419";
                baseUrlStr = this.URL_VSFX419;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx755", false)) {
                courseTitle = "Vsfx755";
                baseUrlStr = this.URL_VSFX755;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx705", false)) {
                courseTitle = "Vsfx705";
                baseUrlStr = this.URL_VSFX705;
            } else if (FileUtils.isaSubDirOf(new File(s), "vsfx502", false)) {
                courseTitle = "Vsfx502";
                baseUrlStr = this.URL_VSFX502;
            } else if (FileUtils.isaSubDirOf(new File(s), "tech312", false)) {
                courseTitle = "Tech312";
                baseUrlStr = this.URL_TECH312;
            }
            if (courseTitle != null && baseUrlStr != null) {
                KMenuBarMenu menu = new KMenuBarMenu(courseTitle);
                menuBar.add(menu);
                final String url = baseUrlStr;
                JMenuItem courseItem = new JMenuItem("Course Page");
                ActionListener courseAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        BrowserUtils.open(url);
                    }
                };
                courseItem.addActionListener(courseAction);
                courseItem.setEnabled(true);
                menu.add(courseItem);
                KMenu weekbyweekItem = new KMenu("Schedule");
                JMenuItem[] week = new JMenuItem[10];
                ActionListener[] action = new ActionListener[10];
                for (int n = 0; n < 10; ++n) {
                    final int num = n + 1;
                    week[n] = new JMenuItem("week " + num);
                    action[n] = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            BrowserUtils.open(url + "/weekbyweek.html#week" + num);
                        }
                    };
                    week[n].addActionListener(action[n]);
                    week[n].setEnabled(true);
                    weekbyweekItem.add(week[n]);
                }
                menu.add(weekbyweekItem);
                JMenuItem sandboxItem = new JMenuItem("Sandbox");
                ActionListener sandboxAction = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        BrowserUtils.open(url + "/sandbox");
                    }
                };
                sandboxItem.addActionListener(sandboxAction);
                sandboxItem.setEnabled(true);
                menu.add(sandboxItem);
            }
        }
    }

    private void customizeForTutorials() {
        try {
            tutorialMenu = new KTutorialMenu();
            if (KTutorialMenu.dbList.size() > 0) {
                menuBar.add(tutorialMenu);
            }
        }
        catch (Exception e) {
            Cutter.setLog("    Info: Cannot add tutorial menu to Cutter\n" + e.toString());
            tutorialMenu = null;
        }
    }

    public void _handleAbout() {
    }

    public void _handleQuit() {
        ExitManager.handleQuit();
    }

    static {
        openRecentItem = new KRecentDocsMenu();
        status = new StatusBar();
        currentEditorPane = null;
        currentFrontWindow = null;
        lastFileClosed = null;
    }

    class WindowMenuItem
    extends JMenuItem {
        private KTextWindow window;

        public WindowMenuItem(KTextWindow w) {
            super(w.getTitle());
            this.window = null;
            this.window = w;
        }

        public KTextWindow getWindowItem() {
            return this.window;
        }

        public boolean equals(KTextWindow w) {
            return w == this.window;
        }
    }
}

