/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.MenuItems;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Desktop.MenuItems.KMenuListenerAdapter;
import UI_Script.ScriptRegistry;
import UI_Tools.Find.FindTool;
import UI_Tools.KTools;
import Utilities.TextUtils;
import java.lang.reflect.Field;
import javax.swing.JEditorPane;
import javax.swing.event.MenuEvent;

public class EditMenuListener
extends KMenuListenerAdapter {
    public static boolean debug = false;

    @Override
    public void menuSelected(MenuEvent e) {
        int lngth = 0;
        String str = null;
        JEditorPane pane = KTools.getFocusedEditorPane();
        if (pane != null) {
            str = pane.getSelectedText();
            lngth = pane.getDocument().getLength();
        } else {
            JEditorPane textpane = BBxt.getTextPane(KAbstractDesktop.getFrontWindow());
            if (textpane == null) {
                if (debug) {
                    Cutter.setLog("    Error:EditMenuIListener.menuSelected() - textpane is null returning null");
                }
                return;
            }
            str = textpane.getSelectedText();
            lngth = textpane.getDocument().getLength();
        }
        KDesktop.undoItem.setEnabled(BBxt.canUndo());
        KDesktop.redoItem.setEnabled(BBxt.canRedo());
        if (BBxt.canUndo()) {
            KDesktop.undoItem.setText(BBxt.getUndoPresentationName());
        }
        if (BBxt.canRedo()) {
            KDesktop.redoItem.setText(BBxt.getRedoPresentationName());
        }
        KDesktop.cutItem.setEnabled(str != null);
        KDesktop.copyItem.setEnabled(str != null);
        KDesktop.pasteItem.setEnabled(true);
        KDesktop.textShiftRightItem.setEnabled(str != null);
        KDesktop.textShiftLeftItem.setEnabled(str != null);
        KDesktop.selectAllItem.setEnabled(lngth != 0);
        KDesktop.replaceFindItem.setEnabled(FindTool.init().canReplaceFind());
        KDesktop.toUpperCaseItem.setEnabled(str != null);
        KDesktop.toLowerCaseItem.setEnabled(str != null);
        KDesktop.reverseSlashesItem.setEnabled(str != null);
        if (Cutter.input.debug) {
            KDesktop.reverseStrsItem.setEnabled(str != null);
        }
        KDesktop.wackItem.setEnabled(BBxt.canReplaceText());
        if (str != null && str.trim().length() > 0) {
            String[] tokens = TextUtils.tokenize(str);
            if (tokens != null && tokens.length == 3) {
                KDesktop.colorEditItem.setEnabled(true);
            } else {
                KDesktop.colorEditItem.setEnabled(false);
            }
        } else {
            KDesktop.colorEditItem.setEnabled(false);
        }
        String ext = BBxt.getWindowExtension();
        if (BBxt.isSelection() && ext != null && ScriptRegistry.getHandlerForExtension(ext) != null) {
            KDesktop.addCommentsItem.setEnabled(true);
            KDesktop.removeCommentsItem.setEnabled(true);
        } else {
            KDesktop.addCommentsItem.setEnabled(false);
            KDesktop.removeCommentsItem.setEnabled(false);
        }
        KDesktop.alphaSortItem.setEnabled(BBxt.getSelectionLength() > 0);
    }

    static {
        try {
            Field[] fields = new Field[]{EditMenuListener.class.getDeclaredField("debug")};
            Cutter.addDebug(EditMenuListener.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: EditMenuIListener.static - " + ex.toString());
        }
    }
}

