/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.MenuItems;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenu;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.FileUtils;
import Utilities.HashTableUtils;
import Utilities.MenuUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class KRecentDocsMenu
extends KMenu
implements MenuListener {
    public static long AUTO_OPEN_MAX_FILE_SIZE = 102400L;
    private JMenuItem clearListItem = new ClearMenuItem();
    private static Hashtable<String, String> tableOfFilePaths = new Hashtable();

    public static ActionListener openLastDocAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String fullpath = Preferences.get(Preferences.DOCUMENT_LAST_OPEN);
                if (fullpath == null || fullpath.trim().length() == 0) {
                    return;
                }
                File file = new File(fullpath);
                if (KAbstractDesktop.windowExists(file)) {
                    if (Cutter.input.debug) {
                        Cutter.setLog("KRecentDocsMenu.openLastDocAction() window already open");
                    }
                    return;
                }
                long fileSize = new File(fullpath).length();
                if (fullpath != null && fullpath.length() > 0 && fileSize < AUTO_OPEN_MAX_FILE_SIZE) {
                    File f = new File(fullpath);
                    if (f.exists() && !f.isDirectory()) {
                        BBxt.newDocument(f);
                    } else {
                        Cutter.setLog("    Info: KRecentDocsMenu.openLastDocAction()\n          Cannot find the previously open document\n              " + fullpath);
                    }
                } else {
                    Cutter.setLog("    Info: KRecentDocsMenu.openLastDocAction()\n      The last doc open in the previous session was\n      larger than " + AUTO_OPEN_MAX_FILE_SIZE + " bytes in length.\n      Files of this size are not automatically opened.");
                }
            }
        };
    }

    public KRecentDocsMenu() {
        super("Open Recent");
        this.addMenuListener(this);
        this.addSeparator();
        super.add(this.clearListItem);
        String str = Preferences.get(Preferences.DOCUMENT_RECENT_PATHS);
        if (str == null || str.trim().length() == 0) {
            return;
        }
        String[] items = TextUtils.tokenize(str, "'");
        for (int n = 0; n < items.length; ++n) {
            FileUtils.applyFileSeparator(items[n]);
        }
        Vector<String> vector = new Vector<String>();
        for (int n = 0; n < items.length; ++n) {
            if (vector.contains(items[n])) continue;
            vector.addElement(items[n]);
        }
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            File file;
            String item = e.nextElement().toString();
            if (item == null || !(file = new File(item)).exists() || file.isDirectory()) continue;
            this.add(this.makeMenuItem(item));
        }
        this.clearListItem.setEnabled(true);
    }

    @Override
    public void removeAll() {
        tableOfFilePaths.clear();
        Component[] existingItems = this.getMenuComponents();
        if (existingItems == null) {
            return;
        }
        for (int n = existingItems.length - 2; n >= 0; --n) {
            String path;
            if (existingItems[n] instanceof JSeparator || (path = ((JMenuItem)existingItems[n]).getText()) == null || path.trim().length() == 0) continue;
            File file = new File(path);
            if (!KAbstractDesktop.windowExists(file)) {
                super.remove(n);
                continue;
            }
            tableOfFilePaths.put(path, path);
        }
        this.clearListItem.setEnabled(false);
        Preferences.write(Preferences.DOCUMENT_RECENT_PATHS, "");
    }

    public void removeItem(String name) {
        Component[] existingItems = this.getMenuComponents();
        if (existingItems == null) {
            return;
        }
        for (int n = existingItems.length - 2; n >= 0; --n) {
            String path;
            if (existingItems[n] instanceof JSeparator || (path = ((JMenuItem)existingItems[n]).getText()) == null || path.trim().length() == 0 || !path.equals(name)) continue;
            super.remove(n);
            return;
        }
    }

    private String getPathForLastItem() {
        Component[] item = this.getMenuComponents();
        if (item == null || item.length == 0) {
            return null;
        }
        for (int n = 0; n < item.length; ++n) {
            File file;
            String fullpath;
            if (item[n] instanceof JSeparator || item[n] instanceof ClearMenuItem || (fullpath = ((JMenuItem)item[n]).getText()) == null || fullpath.trim().length() == 0 || (file = new File(fullpath)) == null || KAbstractDesktop.windowExists(file)) continue;
            return ((JMenuItem)item[n]).getText();
        }
        return null;
    }

    private JMenuItem makeMenuItem(String fullpath) {
        JMenuItem item = new JMenuItem(fullpath);
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String path = ((JMenuItem)evt.getSource()).getText();
                if (path == null || path.trim().length() == 0) {
                    return;
                }
                File file = new File(path);
                if (file == null) {
                    return;
                }
                if (KAbstractDesktop.windowExists(file)) {
                    KAbstractWindow window = KAbstractDesktop.getWindowWithFile(file);
                    if (window == null) {
                        return;
                    }
                    KAbstractDesktop.toFront(window);
                    return;
                }
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cutter cannot locate the recently opened document:\n\t\t" + path, "Missing Document Error", 0);
                    return;
                }
                BBxt.newDocument(new File(path));
            }
        };
        item.addActionListener(action);
        return item;
    }

    public void saveSelf() {
        if (tableOfFilePaths == null) {
            return;
        }
        String[] keys = HashTableUtils.getKeysByTheirSortedValues_Str_Str(tableOfFilePaths);
        if (keys == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        for (int n = 0; n < keys.length; ++n) {
            buffer.append(tableOfFilePaths.get(keys[n]));
            buffer.append("'");
        }
        Preferences.write(Preferences.DOCUMENT_RECENT_PATHS, buffer.toString());
    }

    public File[] getListOfDirectories() {
        Component[] existingItems = this.getMenuComponents();
        if (existingItems == null) {
            return null;
        }
        Vector<File> listOfDirs = new Vector<File>();
        for (int n = 0; n < existingItems.length; ++n) {
            File file;
            String path;
            if (existingItems[n] == null || existingItems[n] instanceof JSeparator || existingItems[n] instanceof ClearMenuItem || (path = ((JMenuItem)existingItems[n]).getText()) == null || path.trim().length() == 0 || !(file = new File(path)).exists() || listOfDirs.contains(file.getParentFile())) continue;
            listOfDirs.addElement(file.getParentFile());
        }
        return VectorUtils.toFileArray(listOfDirs);
    }

    private int getMaxRecent() {
        String str = Preferences.get(Preferences.DOCUMENT_RECENT_MAX);
        int preferredMaxItems = 5;
        if (str != null && str.trim().length() > 0) {
            try {
                preferredMaxItems = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                preferredMaxItems = 5;
            }
        }
        return --preferredMaxItems;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
        Component[] existingItems = this.getMenuComponents();
        if (existingItems == null) {
            return;
        }
        for (int n = existingItems.length - 2; n >= 0; --n) {
            String path;
            if (existingItems[n] instanceof JSeparator || existingItems[n] instanceof ClearMenuItem || (path = ((JMenuItem)existingItems[n]).getText()) == null || path.trim().length() == 0) continue;
            tableOfFilePaths.put(path, path);
        }
    }

    @Override
    public void menuSelected(MenuEvent e) {
        String path;
        int n;
        String lastFilePath;
        int preferredMaxItems = this.getMaxRecent();
        int totalItems = 0;
        KAbstractWindow[] openWindows = KAbstractDesktop.getAllWindows();
        Component[] existingItems = this.getMenuComponents();
        String string = lastFilePath = KDesktop.lastFileClosed == null ? null : KDesktop.lastFileClosed.getPath();
        if (openWindows == null || existingItems == null) {
            return;
        }
        Vector<JMenuItem> listOfClosedItems = new Vector<JMenuItem>();
        for (n = 0; n < existingItems.length; ++n) {
            File f;
            Component c = existingItems[n];
            if (c == null || c instanceof JSeparator || c instanceof ClearMenuItem || (path = ((JMenuItem)c).getText()) == null || path.trim().length() == 0 || !(f = new File(path)).exists() || KDesktop.lastFileClosed != null && KDesktop.lastFileClosed.exists() && path.equals(lastFilePath) || KAbstractDesktop.windowExists(f)) continue;
            listOfClosedItems.addElement((JMenuItem)existingItems[n]);
        }
        listOfClosedItems = MenuUtils.sortMenuItemsByAlpha(listOfClosedItems);
        super.removeAll();
        if (lastFilePath != null) {
            super.add(this.makeMenuItem(lastFilePath));
            ++totalItems;
        }
        for (n = 0; n < openWindows.length && totalItems <= preferredMaxItems; ++n) {
            File file;
            File file2 = file = openWindows[n] == null ? null : openWindows[n].getFile();
            if (file == null || (path = file.getPath()) == null || path.trim().length() == 0) continue;
            super.add(this.makeMenuItem(path));
            ++totalItems;
        }
        for (n = 0; n < listOfClosedItems.size() && totalItems <= preferredMaxItems; ++n) {
            JMenuItem item = listOfClosedItems.elementAt(n);
            if (item == null) continue;
            super.add(item);
            ++totalItems;
        }
        this.addSeparator();
        super.add(this.clearListItem);
        if (totalItems > 0) {
            this.clearListItem.setEnabled(true);
        } else {
            this.clearListItem.setEnabled(false);
        }
    }

    private class ClearMenuItem
    extends JMenuItem {
        public ClearMenuItem() {
            super("Remove items not on the desktop");
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    KRecentDocsMenu.this.removeAll();
                    KRecentDocsMenu.this.saveSelf();
                }
            });
            this.setEnabled(false);
        }
    }
}

