/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.MenuItems;

import UI_BBXT.BBxt;
import UI_Components.KMenuBarMenu;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.BrowserUtils;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class KTutorialMenu
extends KMenuBarMenu
implements MenuListener {
    public static Vector<DBItem> dbList = new Vector();
    static final String DEFAULT_TUTORIAL_FILENAME = "tutorial.cdat";
    boolean usesLocalFileSystem = true;

    public KTutorialMenu() throws Exception {
        this.reload();
        this.addMenuListener(this);
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.reload();
    }

    @Override
    public void reload() {
        int n;
        Vector<String> v;
        dbList.removeAllElements();
        this.removeAll();
        String[] lines = null;
        File datFile = new File(FileUtils.getPWD(), DEFAULT_TUTORIAL_FILENAME);
        if (datFile.exists()) {
            String text = FileUtils.read(datFile);
            if (text == null || text.trim().length() == 0) {
                Cutter.setLog("    Warning: KTutorialMenu.reload() - tutorial.cdat does not exist");
                return;
            }
            lines = TextUtils.tokenize(text, '\n');
            if (lines == null || lines.length == 0) {
                Cutter.setLog("    Warning: KTutorialMenu.reload() - no data in tutorial.cdat");
                return;
            }
            v = new Vector<String>();
            for (int n2 = 0; n2 < lines.length; ++n2) {
                if (lines[n2].trim().length() <= 0) continue;
                v.addElement(lines[n2]);
            }
        } else {
            if (Cutter.input.debug) {
                Cutter.setLog("    Debug:KTutorialMenu.reload() could not read \"tutorial.cdat\"");
            }
            return;
        }
        lines = VectorUtils.toStringArray(v);
        this.setText(lines[0]);
        File baseDir = new File(lines[1]);
        final String baseUrlStr = lines[1];
        if (lines[1].startsWith(".")) {
            baseDir = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), lines[1]);
        } else if (lines[1].startsWith("http://")) {
            this.usesLocalFileSystem = false;
        }
        int numPrefixCount = 1;
        int beginAt = 2;
        boolean straightNumbering = true;
        if (lines[2].trim().equals("<reverse>")) {
            straightNumbering = false;
            beginAt = 3;
            numPrefixCount = 0;
            for (n = beginAt; n < lines.length; ++n) {
                if (lines[n].trim().charAt(0) == '-') continue;
                ++numPrefixCount;
            }
        }
        for (n = beginAt; n < lines.length; ++n) {
            String title;
            if (lines[n].trim().charAt(0) == '-') {
                DBItem dbItem = new DBItem();
                dbItem.isSeparator = true;
                dbList.addElement(dbItem);
                continue;
            }
            String prefix = "";
            String path = "";
            if (lines[n].startsWith("\t") || lines[n].startsWith(" ")) {
                prefix = "" + numPrefixCount;
                if (numPrefixCount < 10) {
                    prefix = "  " + prefix;
                }
                numPrefixCount += straightNumbering ? 1 : -1;
            }
            String rawLine = lines[n].trim();
            String[] tokens = TextUtils.tokenize(rawLine, '|');
            String subMenuParentName = null;
            if (tokens.length == 2) {
                subMenuParentName = tokens[0];
                path = tokens[1];
            } else {
                path = rawLine;
            }
            File f = new File(baseDir, path);
            if (path.startsWith("http:")) {
                f = new File(path);
            }
            if ((title = f.getName()).endsWith(".txt")) {
                title = title.substring(0, title.length() - 4);
            } else if (title.endsWith(".html")) {
                title = title.substring(0, title.length() - 5);
            }
            int numChars = prefix.trim().length();
            String spacer = "     ";
            spacer = numChars == 0 ? "" : spacer.substring(numChars, spacer.length() - 1);
            JMenuItem item = new JMenuItem(prefix + spacer + title);
            DBItem dbItem = new DBItem();
            dbItem.menuItem = item;
            dbItem.file = f;
            dbItem.isaSubMenuItem = subMenuParentName != null;
            dbItem.subMenuLabel = subMenuParentName;
            dbItem.relativePath = path;
            dbItem.isSeparator = false;
            dbList.addElement(dbItem);
        }
        boolean doSubMenu = false;
        JMenu subMenu = null;
        String activeSubMenuLabel = "";
        for (int n3 = 0; n3 < dbList.size(); ++n3) {
            final DBItem dbItem = dbList.elementAt(n3);
            if (dbItem.isSeparator) {
                if (subMenu != null) {
                    this.add(subMenu);
                    activeSubMenuLabel = "";
                    subMenu = null;
                }
                this.addSeparator();
                continue;
            }
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (dbItem.file.getName().endsWith(".html")) {
                        if (dbItem.file.getPath().startsWith("http:")) {
                            BrowserUtils.open(dbItem.file.getPath());
                        } else {
                            BrowserUtils.open("file:/" + dbItem.file.getPath());
                        }
                        return;
                    }
                    if (dbItem.file != null && KAbstractDesktop.windowExists(dbItem.file)) {
                        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(dbItem.file);
                        if (w != null) {
                            KAbstractDesktop.toFront(w);
                        }
                        return;
                    }
                    if (KTutorialMenu.this.usesLocalFileSystem) {
                        BBxt.newDocument(dbItem.file);
                    } else {
                        try {
                            BBxt.newDocument(new URL(baseUrlStr + dbItem.relativePath));
                        }
                        catch (MalformedURLException e) {
                            Cutter.setLog("    Exception: KTutorialMenu.reload()\n" + e.toString());
                        }
                    }
                }
            };
            dbItem.menuItem.addActionListener(action);
            if (this.usesLocalFileSystem && !dbItem.file.exists()) {
                dbItem.menuItem.setEnabled(false);
            }
            if (dbItem.file.getPath().startsWith("http:")) {
                dbItem.menuItem.setEnabled(true);
            }
            if (dbItem.isaSubMenuItem) {
                if (subMenu == null) {
                    subMenu = new JMenu(dbItem.subMenuLabel);
                    subMenu.add(dbItem.menuItem);
                    activeSubMenuLabel = dbItem.subMenuLabel;
                    continue;
                }
                if (activeSubMenuLabel.equals(dbItem.subMenuLabel)) {
                    subMenu.add(dbItem.menuItem);
                    continue;
                }
                if (activeSubMenuLabel.equals(dbItem.subMenuLabel)) continue;
                this.add(subMenu);
                subMenu = null;
                activeSubMenuLabel = "";
                subMenu = new JMenu(dbItem.subMenuLabel);
                activeSubMenuLabel = dbItem.subMenuLabel;
                subMenu.add(dbItem.menuItem);
                continue;
            }
            if (subMenu != null) {
                this.add(subMenu);
                activeSubMenuLabel = "";
                subMenu = null;
            }
            this.add(dbItem.menuItem);
        }
        if (subMenu != null) {
            this.add(subMenu);
        }
    }

    private class DBItem {
        boolean isSeparator = false;
        JMenuItem menuItem = null;
        File file = null;
        String relativePath = "";
        boolean isaSubMenuItem = false;
        String subMenuLabel = null;

        private DBItem() {
        }

        public String toString() {
            if (this.isSeparator) {
                return "-----------------------";
            }
            return "menuItem.label = " + (this.menuItem == null ? "null" : this.menuItem.getText()) + " isaSubMenuItem = " + this.isaSubMenuItem + " isSeparator = " + this.isSeparator;
        }
    }
}

