/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.MenuItems;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Desktop.MenuItems.KMenuListenerAdapter;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import java.io.File;
import java.lang.reflect.Field;
import javax.swing.event.MenuEvent;

public class ScriptMenuListener
extends KMenuListenerAdapter {
    public static boolean debug = false;
    public static final String DEFAULT_EXECUTE_TITLE = "Nothing to Execute";

    @Override
    public void menuSelected(MenuEvent e) {
        String ext = BBxt.getWindowExtension();
        KDesktop.executeItem.setText(DEFAULT_EXECUTE_TITLE);
        Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected()");
        if (BBxt.frontWindow() == null) {
            KDesktop.executeItem.setEnabled(false);
            Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() - BBxt.frontWindow() returned null!");
            return;
        }
        if (BBxt.getWindowTitle() == null) {
            KDesktop.executeItem.setEnabled(false);
            Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() - BBxt.getWindowTitle() returned null!");
            return;
        }
        if (BBxt.getWindowTitle().equalsIgnoreCase("Cutter Browser")) {
            KDesktop.executeItem.setEnabled(false);
            Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() - cannot execute the process or a html window");
            return;
        }
        KDesktop.executeItem.setEnabled(true);
        if (BBxt.getSelection() != null && BBxt.getSelection().length() >= 2) {
            KDesktop.executeItem.setText("Execute Selection");
            return;
        }
        int num = BBxt.countLineBreaks();
        Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() - BBxt.countLineBreaks() = " + num);
        if (num == 0) {
            int end = BBxt.getSelectionStart();
            BBxt.selectAll();
            if (BBxt.getSelection() != null && BBxt.getSelection().length() >= 2) {
                KDesktop.executeItem.setText("Execute Line");
                BBxt.setSelection(end, end);
                return;
            }
            BBxt.setSelection(end, end);
            KDesktop.executeItem.setEnabled(false);
            Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() return at 1");
            return;
        }
        File f = BBxt.getWindowFile();
        ScriptHandler handler = f != null ? ScriptRegistry.getHandlerForFile(f) : ScriptRegistry.getHandlerForExtension(ext);
        if (handler == null) {
            Cutter.setLog("    Debug:ScriptMenuListeners.menuSelected() - cannot find script handler.");
            return;
        }
        Cutter.setLog("     Debug:ScriptMenuListeners.menuSelected() - using handler \"" + handler.getClass().getName() + "\"");
        String execLabel = handler.getExecuteLabel();
        String makeLabel = handler.getMakeLabel();
        String runLabel = handler.getRunLabel();
        KDesktop.executeItem.setEnabled(false);
        KDesktop.makeItem.setEnabled(false);
        KDesktop.runItem.setEnabled(false);
        KDesktop.executeItem.setText("Execute");
        KDesktop.makeItem.setText("Make");
        KDesktop.runItem.setText("Run");
        if (!BBxt.isTextHistoryDocument() && execLabel != null) {
            KDesktop.executeItem.setText(execLabel);
            KDesktop.executeItem.setEnabled(true);
        }
        if (makeLabel != null) {
            KDesktop.makeItem.setText(makeLabel);
            KDesktop.makeItem.setEnabled(handler.isRunnableScript(BBxt.getFrontWindowFile()));
        }
        if (runLabel != null) {
            KDesktop.runItem.setText(runLabel);
            KDesktop.runItem.setEnabled(handler.isRunnableScript(BBxt.getFrontWindowFile()));
        }
    }

    static {
        try {
            Field[] fields = new Field[]{ScriptMenuListener.class.getDeclaredField("debug")};
            Cutter.addDebug(ScriptMenuListener.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ScriptMenuListener.static - " + ex.toString());
        }
    }
}

