/*
 * Decompiled with CFR 0.152.
 */
package UI_Desktop.TemplatesManager;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Desktop.MenuItems.KMenuListenerAdapter;
import UI_Script.Comment;
import UI_Script.Make.MakeScriptHandler;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptParser;
import UI_Script.ScriptParser.ScriptStructure;
import UI_Script.ScriptRegistry;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import kernal.Tokenizers.Tokenizer;
import kernal.Tokenizers.TokenizerRegistryItem;

public class TemplatesManager
extends KMenuListenerAdapter {
    public final String USER_TMP_DIRNAME = "custom_templates";
    public final String CUTR_TMP_DIRNAME = "templates";
    private JMenu menu;
    private TemplateMenu[] subMenus;
    private String userDirPath;
    private File[] userDirs;
    private File[] sysDirs;
    public SaveAsTemplateAction saveAsTemplateAction = null;
    private static boolean shaderWarningGiven = false;

    private File _getUserDirFor(String docName) {
        File f;
        String ext = FileUtils.getExtension(docName);
        String lowerCaseDocName = docName.toLowerCase();
        if (ext != null && ext.length() >= 1) {
            if (ext.equalsIgnoreCase(".py")) {
                ext = "Python";
            } else if (ext.equalsIgnoreCase(".pl")) {
                ext = "Perl";
            } else if (ext.equalsIgnoreCase(".c")) {
                ext = "C";
            } else if (ext.equalsIgnoreCase(".cpp")) {
                ext = "CPP";
            } else if (ext.equalsIgnoreCase(".cutlet")) {
                ext = "Cutlet";
            } else if (ext.equalsIgnoreCase(".h")) {
                ext = "H";
            } else if (ext.equalsIgnoreCase(".html")) {
                ext = "Html";
            } else if (ext.equalsIgnoreCase(".ifd")) {
                ext = "Ifd";
            } else if (ext.equalsIgnoreCase(".makefile")) {
                ext = "Makefile";
            } else if (lowerCaseDocName.startsWith("makefile")) {
                ext = "Makefile";
            } else if (ext.equalsIgnoreCase(".mel")) {
                ext = "Mel";
            } else if (ext.equalsIgnoreCase(".mi")) {
                ext = "Mi";
            } else if (ext.equalsIgnoreCase(".rib")) {
                ext = "Rib";
            } else if (ext.equalsIgnoreCase(".shk")) {
                ext = "Shake";
            } else if (ext.equalsIgnoreCase(".sl")) {
                ext = "Sl";
            } else if (ext.equalsIgnoreCase(".slim")) {
                ext = "Slim";
            } else if (ext.equalsIgnoreCase(".tcl")) {
                ext = "Tcl";
            } else if (ext.equalsIgnoreCase(".txt")) {
                ext = "Txt";
            } else if (ext.equalsIgnoreCase(".vfl")) {
                ext = "Vfl";
            }
            f = new File(this.userDirPath, TextUtils.remove(ext, '.'));
        } else {
            f = new File(this.userDirPath);
        }
        return f;
    }

    private File getUserDirFor(ScriptHandler handler) {
        if (handler == null) {
            return new File(this.userDirPath);
        }
        String scriptDirName = handler.getScriptName();
        if (scriptDirName == null) {
            return new File(this.userDirPath);
        }
        return new File(this.userDirPath, scriptDirName);
    }

    public TemplatesManager(JMenu menu) {
        this.menu = menu;
        menu.addMenuListener(this);
        this.userDirPath = Preferences.get(Preferences.TEMPLATES_USER_DIR_PATH);
        if (this.userDirPath.trim().equals("") || this.userDirPath.trim().equals("./") || this.userDirPath.trim().equals(".\\") || !FileUtils.exists(this.userDirPath)) {
            this.userDirPath = new File(FileUtils.getPWD(), "custom_templates").getPath();
        }
        this.userDirs = this.initDirectories(this.userDirPath);
        File helpDir = new File(FileUtils.getPWD(), "Cutter_Help");
        String cutrDirPath = new File(helpDir, "templates").getPath();
        this.sysDirs = this.initDirectories(cutrDirPath);
        this.readMenuSubItems();
        this.saveAsTemplateAction = new SaveAsTemplateAction();
    }

    public void readMenuSubItems() {
        int n;
        String[] scriptnames = ScriptRegistry.getScriptsNames();
        String[] tmp = new String[scriptnames.length + 1];
        for (int n2 = 0; n2 < scriptnames.length; ++n2) {
            tmp[n2] = scriptnames[n2];
        }
        tmp[scriptnames.length] = "Misc";
        scriptnames = tmp;
        TemplateMenu[] out = new TemplateMenu[scriptnames.length];
        for (n = 0; n < scriptnames.length; ++n) {
            out[n] = new TemplateMenu(scriptnames[n]);
            out[n].addMenuListener(this);
        }
        this.subMenus = out;
        for (n = 0; n < this.subMenus.length; ++n) {
            this.subMenus[n].addSearchPaths(this.userDirs, this.sysDirs);
            this.menu.add(this.subMenus[n]);
        }
    }

    private File[] initDirectories(String path) {
        File dir;
        String[] scriptnames = ScriptRegistry.getScriptsNames();
        File[] out = new File[scriptnames.length];
        for (int n = 0; n < scriptnames.length; ++n) {
            File dir2;
            out[n] = dir2 = new File(path, scriptnames[n]);
            if (dir2.exists()) continue;
            FileUtils.makeDirectories(dir2);
        }
        File[] tmp = new File[out.length + 1];
        for (int n = 0; n < out.length; ++n) {
            tmp[n] = out[n];
        }
        tmp[out.length] = dir = new File(path, "Misc");
        if (!dir.exists()) {
            FileUtils.makeDirectories(dir);
        }
        return tmp;
    }

    @Override
    public void menuSelected(MenuEvent e) {
        for (int n = 0; n < this.subMenus.length; ++n) {
            if (this.subMenus[n].getPaths() == null) {
                this.subMenus[n].setEnabled(false);
                continue;
            }
            this.subMenus[n].setEnabled(true);
        }
    }

    public class SaveAsTemplateAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            KAbstractWindow window = BBxt.frontWindow();
            if (window != null && window instanceof KTextWindow) {
                ScriptHandler handler = ScriptRegistry.getHandlerForFile(window.getFile());
                File templateDir = TemplatesManager.this.getUserDirFor(handler);
                Cutter.setLog("    Info:TemplatesManager.SaveAsTemplateAction() - user templatesDir is " + templateDir.getPath());
                File chooserPrevFile = ((KTextWindow)window).prevFile;
                File windowFile = BBxt.getWindowFile();
                ((KTextWindow)window).prevFile = templateDir;
                ((KTextWindow)window).saveFile(4);
                ((KTextWindow)window).prevFile = chooserPrevFile;
                BBxt.setWindowFile(windowFile);
            } else {
                Cutter.setLog("    Warning: KAbstractDesktop.SaveDocAction.actionPerformed() - BBxt cannot find a front window to save!");
            }
        }
    }

    private class TemplateMenu
    extends JMenu
    implements MenuListener {
        public String[] searchPath;

        public TemplateMenu(String label) {
            super(label);
            this.searchPath = new String[]{"", ""};
            this.addMenuListener(this);
        }

        public void addSearchPaths(File[] paths1, File[] paths2) {
            int n;
            String label = this.getText();
            for (n = 0; n < paths1.length; ++n) {
                if (!paths1[n].getName().equalsIgnoreCase(label)) continue;
                this.searchPath[0] = paths1[n].getPath();
            }
            for (n = 0; n < paths2.length; ++n) {
                if (!paths2[n].getName().equalsIgnoreCase(label)) continue;
                this.searchPath[1] = paths2[n].getPath();
            }
        }

        public String[] getPaths() {
            if (this.getText().equalsIgnoreCase("Python")) {
                String[] allB;
                String[] allA = FileUtils.getListOfFileNames(new File(this.searchPath[0]));
                if (allA != null) {
                    for (int n = 0; n < allA.length; ++n) {
                        allA[n] = new File(this.searchPath[0], allA[n]).getPath();
                    }
                }
                if ((allB = FileUtils.getListOfFileNames(new File(this.searchPath[1]))) != null) {
                    for (int n = 0; n < allB.length; ++n) {
                        allB[n] = new File(this.searchPath[1], allB[n]).getPath();
                    }
                }
                String[] allAB = VectorUtils.toStringArray(allA, allB);
                Vector<String> sorted = new Vector<String>();
                if (allAB != null) {
                    for (int n = 0; n < allAB.length; ++n) {
                        File f = new File(allAB[n]);
                        String ext = FileUtils.getExtension(f);
                        if (!ext.equalsIgnoreCase(".ui") && !ext.equalsIgnoreCase(".py")) continue;
                        sorted.addElement(allAB[n]);
                    }
                }
                if (sorted.size() > 0) {
                    return VectorUtils.toStringArray(sorted);
                }
            } else if (this.getText().equalsIgnoreCase("Makefile")) {
                String[] allB;
                String[] allA = FileUtils.getListOfFileNames(new File(this.searchPath[0]));
                if (allA != null) {
                    for (int n = 0; n < allA.length; ++n) {
                        allA[n] = new File(this.searchPath[0], allA[n]).getPath();
                    }
                }
                if ((allB = FileUtils.getListOfFileNames(new File(this.searchPath[1]))) != null) {
                    for (int n = 0; n < allB.length; ++n) {
                        allB[n] = new File(this.searchPath[1], allB[n]).getPath();
                    }
                }
                String[] allAB = VectorUtils.toStringArray(allA, allB);
                Vector<String> sorted = new Vector<String>();
                if (allAB != null) {
                    for (int n = 0; n < allAB.length; ++n) {
                        File f = new File(allAB[n]);
                        if (!f.getName().startsWith("makefile") && !f.getName().startsWith("Makefile")) continue;
                        sorted.addElement(allAB[n]);
                    }
                }
                if (sorted.size() > 0) {
                    return VectorUtils.toStringArray(sorted);
                }
            } else {
                int n;
                String label = this.getText();
                String e = ScriptRegistry.getExtensionForScriptName(label);
                if (e == null) {
                    int n2;
                    String[] a = FileUtils.getListOfFileNames(new File(this.searchPath[0]));
                    String[] b = FileUtils.getListOfFileNames(new File(this.searchPath[1]));
                    if (a != null) {
                        for (n2 = 0; n2 < a.length; ++n2) {
                            a[n2] = new File(this.searchPath[0], a[n2]).getPath();
                        }
                    }
                    if (b != null) {
                        for (n2 = 0; n2 < b.length; ++n2) {
                            b[n2] = new File(this.searchPath[1], b[n2]).getPath();
                        }
                    }
                    return VectorUtils.toStringArray(a, b);
                }
                String[] ext = new String[]{e};
                String[] a = FileUtils.getListOfFileNames(new File(this.searchPath[0]), ext);
                String[] b = FileUtils.getListOfFileNames(new File(this.searchPath[1]), ext);
                if (a != null) {
                    for (n = 0; n < a.length; ++n) {
                        a[n] = new File(this.searchPath[0], a[n]).getPath();
                    }
                }
                if (b != null) {
                    for (n = 0; n < b.length; ++n) {
                        b[n] = new File(this.searchPath[1], b[n]).getPath();
                    }
                }
                return VectorUtils.toStringArray(a, b);
            }
            return null;
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            ToolTipManager.sharedInstance().setInitialDelay(750);
        }

        @Override
        public void menuSelected(MenuEvent e) {
            String[] paths = this.getPaths();
            super.removeAll();
            if (paths == null) {
                return;
            }
            String firstComment = "No Description Available";
            for (int n = 0; n < paths.length; ++n) {
                String[] line;
                File file = new File(paths[n]);
                String bodyText = FileUtils.read(file);
                String ext = FileUtils.getExtension(file);
                firstComment = null;
                firstComment = "No Description Available";
                if (ext != null && ext.length() > 1) {
                    TokenizerRegistryItem tgi = Tokenizer.getMemberWithExt(ext.substring(1));
                    if (tgi != null) {
                        Tokenizer tok = tgi.getTokenizer();
                        if (tgi != null && tok != null) {
                            String[] com;
                            ScriptParser parser;
                            ScriptStructure struct;
                            Comment[] cmnt = tgi.cmnt;
                            if (bodyText != null && cmnt != null && (struct = (parser = new ScriptParser(tok, bodyText)).getStructure()) != null && (com = struct.getComments()) != null && com.length >= 1) {
                                firstComment = com[0];
                            }
                        }
                    }
                } else {
                    line = TextUtils.tokenize(bodyText, "\n");
                    if (line != null && line[0].trim().length() > 0) {
                        firstComment = line[0];
                    }
                }
                if (this.getText().equalsIgnoreCase("txt") && (line = TextUtils.tokenize(bodyText, "\n")) != null && line[0].trim().length() > 0) {
                    firstComment = line[0];
                }
                this.add(new TemplateMenuItem(file, firstComment));
            }
        }
    }

    private class TemplateMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private MultiLineToolTip tip;

        public TemplateMenuItem(final File file, String popupText) {
            super(file.getName());
            this.tip = null;
            String tiptext = TextUtils.format(popupText, MultiLineToolTip.DEFAULT_TIP_TEXT_WIDTH);
            if (file.getPath().startsWith(TemplatesManager.this.userDirPath)) {
                Font f = this.getFont();
                this.setFont(new Font(f.getName(), 3, f.getSize()));
                this.setForeground(new Color(62, 62, 118));
            }
            this.tip = new MultiLineToolTip(tiptext);
            this.setToolTipText(tiptext);
            ToolTipManager.sharedInstance().setInitialDelay(100);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (file != null) {
                        String text = FileUtils.read(file);
                        if (text == null) {
                            return;
                        }
                        String ext = FileUtils.getExtension(file);
                        ScriptHandler handler = ScriptRegistry.getHandlerForExtension(ext);
                        if (handler != null) {
                            text = handler.preprocessTemplateText(text);
                        }
                        if (handler == null && file.getName().startsWith("makefile") || file.getName().startsWith("Makefile")) {
                            MakeScriptHandler msh = new MakeScriptHandler();
                            text = msh.preprocessTemplateText(text);
                            BBxt.newDocument("Makefile.untitled", text);
                            return;
                        }
                        if (ext == null || ext.trim().length() == 0) {
                            BBxt.newDocument("untitled", text);
                        } else if (ext != null && ext.equalsIgnoreCase(".ui")) {
                            BBxt.newDocument(file.getName(), text);
                        } else {
                            BBxt.newDocument("untitled" + ext, text);
                        }
                    }
                }
            };
            this.addActionListener(action);
        }

        @Override
        public JToolTip createToolTip() {
            return this.tip;
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            int ourwidth = this.getBounds().width;
            int tipwidth = this.tip.get_Width();
            int x = tipwidth - ourwidth;
            int offset = ourwidth + x;
            return new Point(-offset + 5, 8);
        }
    }
}

