/*
 * Decompiled with CFR 0.152.
 */
package UI_Dialogs;

import UI_Components.Dialog.AbstractDialog;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EditHistoryDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private EditHistoryPanel editPanel;
    private KAbstractTextWindow srcWindow;
    private KTextHistoryWindow historyWindow;

    public EditHistoryDialog(KAbstractTextWindow srcWindow, KTextHistoryWindow historyWindow) {
        super(Cutter.desktop, "Edit", true, false);
        this.srcWindow = srcWindow;
        this.historyWindow = historyWindow;
        this.editPanel = new EditHistoryPanel();
        this.editPanel.setFrom(1);
        this.editPanel.setTo(srcWindow.getHistoryMarker() + 1);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.cancelButton, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 12, 11, new Insets(5, 10, 5, 10)));
        buttonPanel.add((Component)this.okButton, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 11, new Insets(5, 10, 5, 10)));
        this.contentPane.add((Component)this.editPanel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 11, new Insets(5, 10, 5, 10)));
        this.contentPane.add((Component)buttonPanel, new GBC(0, 1, 2, 1, 1.0, 0.0, 0, 0, 12, 2, new Insets(5, 2, 5, 2)));
        this.pack();
    }

    @Override
    public void showSelf() {
        Dimension desksize = KAbstractDesktop.desktopPane.getSize();
        Dimension dialogsize = this.getSize();
        int x = desksize.width / 2 - dialogsize.width / 2;
        int y = desksize.height / 2 - dialogsize.height / 2;
        this.setBounds(x, y, dialogsize.width, dialogsize.height);
        this.setVisible(true);
    }

    @Override
    public void enterKeyPressed() {
        if (this.srcWindow.removeHistoryFromTo(this.editPanel.getFrom(), this.editPanel.getTo())) {
            String[] history = this.srcWindow.getHistoryAt(this.srcWindow.getHistoryMarker());
            this.historyWindow.deleteAllText();
            this.historyWindow.setText(history[0]);
            this.historyWindow.setSelection(0, 0);
            this.setVisible(false);
        }
    }

    @Override
    public void escKeyPressed() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.enterKeyPressed();
        } else {
            this.setVisible(false);
        }
    }

    public class EditHistoryPanel
    extends KTitledPanel {
        private static final long serialVersionUID = 1L;
        private JLabel fromLabel;
        private JLabel toLabel;
        private KTextField fromField;
        private KTextField toField;

        public EditHistoryPanel() {
            super(" Remove History Items ");
            this.fromLabel = new JLabel("From ");
            this.toLabel = new JLabel(" to ");
            this.fromField = new KTextField(3);
            this.toField = new KTextField(3);
            this.setLayout(new GridBagLayout());
            this.fromField.setMargin(new Insets(1, 0, 1, 0));
            this.toField.setMargin(new Insets(1, 0, 1, 0));
            this.fromField.setMinimumSize(this.fromField.getPreferredSize());
            this.toField.setMinimumSize(this.toField.getPreferredSize());
            this.fromLabel.setFont(Cutter.defaultFont.font);
            this.toLabel.setFont(Cutter.defaultFont.font);
            this.fromLabel.setMinimumSize(this.fromLabel.getPreferredSize());
            this.toLabel.setMinimumSize(this.toLabel.getPreferredSize());
            this.add(this.fromLabel, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 10, 5, 0)));
            this.add(this.fromField, new GBC(2, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 0, 5, 0)));
            this.add(this.toLabel, new GBC(3, 0, 1, 1, 0.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 5, 0)));
            this.add(this.toField, new GBC(4, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(1, 2, 5, 10)));
        }

        public void setFrom(int n) {
            this.fromField.setText("" + n);
        }

        public void setTo(int n) {
            this.toField.setText("" + n);
        }

        public String getFrom() {
            return this.fromField.getText();
        }

        public String getTo() {
            return this.toField.getText();
        }
    }
}

