/*
 * Decompiled with CFR 0.152.
 */
package UI_Dialogs;

import History.KAbstractHistory;
import UI_Components.Dialog.AbstractDialog;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextHistoryWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrefsHistoryDialog
extends AbstractDialog {
    private MaxSizesPanel localPrefsPanel;
    private MaxSizesPanel globalPrefsPanel;
    private KAbstractTextWindow srcWindow;
    private KTextHistoryWindow historyWindow;

    public PrefsHistoryDialog(KAbstractTextWindow srcWindow, KTextHistoryWindow historyWindow) {
        super(Cutter.desktop, "Preferences", true, false);
        this.srcWindow = srcWindow;
        this.historyWindow = historyWindow;
        this.localPrefsPanel = new MaxSizesPanel(" Local Settings ");
        this.globalPrefsPanel = new MaxSizesPanel(" Global Settings ");
        this.localPrefsPanel.maxCountField.setText("" + srcWindow.getMaxHistoryCount());
        this.localPrefsPanel.maxBytesField.setText("" + srcWindow.getMaxHistoryBytes());
        this.globalPrefsPanel.maxCountField.setText("" + KAbstractHistory.GLOBAL_MAX_ITEMS);
        this.globalPrefsPanel.maxBytesField.setText("" + KAbstractHistory.GLOBAL_MAX_BYTES);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.cancelButton, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 12, 11, new Insets(5, 10, 5, 10)));
        buttonPanel.add((Component)this.okButton, new GBC(3, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 11, new Insets(5, 10, 5, 10)));
        this.contentPane.add((Component)this.localPrefsPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 11, new Insets(10, 10, 5, 10)));
        this.contentPane.add((Component)this.globalPrefsPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 11, new Insets(5, 10, 15, 10)));
        this.pack();
    }

    @Override
    public void showSelf() {
        Dimension desksize = KAbstractDesktop.desktopPane.getSize();
        Dimension dialogsize = this.getSize();
        int x = desksize.width / 2 - dialogsize.width / 2;
        int y = desksize.height / 2 - dialogsize.height / 2;
        this.setBounds(x, y, dialogsize.width, dialogsize.height);
        this.setVisible(true);
    }

    @Override
    public void enterKeyPressed() {
    }

    @Override
    public void escKeyPressed() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.localPrefsPanel.setButton) {
            try {
                this.srcWindow.setMaxHistoryCount(Integer.parseInt(this.localPrefsPanel.maxCountField.getText()));
                this.srcWindow.setMaxHistoryBytes(Integer.parseInt(this.localPrefsPanel.maxBytesField.getText()));
            }
            catch (NumberFormatException ex) {
                Cutter.setLog("    Error: PrefsHistoryDialog.actionPerformed() " + ex);
            }
            return;
        }
        if (e.getSource() == this.globalPrefsPanel.setButton) {
            try {
                KAbstractHistory.GLOBAL_MAX_ITEMS = Integer.parseInt(this.globalPrefsPanel.maxCountField.getText());
                KAbstractHistory.GLOBAL_MAX_BYTES = Integer.parseInt(this.globalPrefsPanel.maxBytesField.getText());
            }
            catch (NumberFormatException ex) {
                Cutter.setLog("    Error: PrefsHistoryDialog.actionPerformed() " + ex);
            }
            return;
        }
    }

    public class MaxSizesPanel
    extends KTitledPanel {
        private JLabel maxCountLabel;
        private JLabel maxBytesLabel;
        public KTextField maxCountField;
        public KTextField maxBytesField;
        public JButton setButton;

        public MaxSizesPanel(String title) {
            super(title);
            this.maxCountLabel = new JLabel("Maximum Items ");
            this.maxBytesLabel = new JLabel("Maximum Bytes ");
            this.maxCountField = new KTextField(3);
            this.maxBytesField = new KTextField(5);
            this.setButton = new JButton("Set");
            this.setLayout(new GridBagLayout());
            this.maxCountField.setMargin(new Insets(1, 0, 1, 0));
            this.maxBytesField.setMargin(new Insets(1, 0, 1, 0));
            this.maxCountField.setMinimumSize(this.maxCountField.getPreferredSize());
            this.maxBytesField.setMinimumSize(this.maxBytesField.getPreferredSize());
            this.maxCountLabel.setFont(Cutter.defaultFont.font);
            this.maxBytesLabel.setFont(Cutter.defaultFont.font);
            this.maxCountLabel.setMinimumSize(this.maxCountLabel.getPreferredSize());
            this.maxBytesLabel.setMinimumSize(this.maxBytesLabel.getPreferredSize());
            this.setButton.setMargin(new Insets(0, 10, 0, 10));
            this.setButton.addActionListener(PrefsHistoryDialog.this);
            this.add(this.maxCountLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 17, 11, new Insets(1, 10, 5, 0)));
            this.add(this.maxCountField, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(1, 0, 5, 5)));
            this.add(this.maxBytesLabel, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 17, 11, new Insets(1, 10, 5, 0)));
            this.add(this.maxBytesField, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(1, 2, 5, 5)));
            this.add(this.setButton, new GBC(1, 2, 1, 1, 1.0, 1.0, 0, 0, 13, 11, new Insets(1, 2, 5, 5)));
        }
    }
}

