/*
 * Decompiled with CFR 0.152.
 */
package UI_DragDrop;

import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_DragDrop.DnDFileResponder;
import UI_DragDrop.DragDropUtils;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;

public class DnDGlassPane
extends JComponent
implements DnDFileResponder {
    private static final long serialVersionUID = 1L;
    private boolean dropInProgress = false;
    private Color hiliteColor = new Color(49, 4, 165);
    public static DnDGlassPane dndGlassPane = null;
    private static DragDropUtils dndUtils;
    private static JFrame frame;
    private static JDesktopPane pane;
    private static boolean isSuspended;

    public static void setup(JFrame f) {
        if (isSuspended) {
            return;
        }
        frame = f;
        dndGlassPane = new DnDGlassPane();
        dndGlassPane.setEnabled(true);
        frame.setGlassPane(dndGlassPane);
        dndGlassPane.setOpaque(false);
        dndGlassPane.setVisible(true);
        dndUtils = new DragDropUtils(dndGlassPane);
    }

    public static void suspendDnD() {
        if (dndUtils == null) {
            Cutter.setLog("    Error: DnDGlassPane.disableDnD() - dndUtils is null");
            return;
        }
        dndUtils.suspendGlassPaneListener();
        isSuspended = true;
    }

    public static void resumeDnD() {
        if (dndUtils == null) {
            Cutter.setLog("    Error: DnDGlassPane.disableDnD() - dndUtils is null");
            return;
        }
        dndUtils.resumeGlassPaneListener();
        isSuspended = false;
    }

    private DnDGlassPane() {
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paint(g);
        Dimension d = this.getSize();
        if (this.dropInProgress) {
            Rectangle square = new Rectangle(0, 0, d.width - 2, d.height - 2);
            g2.setPaint(this.hiliteColor);
            g2.setStroke(new BasicStroke(4.0f));
            g2.draw(square);
            return;
        }
    }

    @Override
    public void dropInProgress(boolean b) {
        this.dropInProgress = b;
        this.repaint();
    }

    @Override
    public void dropStringHappened(String str) {
        if (str == null || str.length() == 0) {
            return;
        }
        if (str.startsWith("file:/")) {
            String s = str.substring(6, str.length() - 1);
            s = TextUtils.trim(s, "/");
            s = "/" + s;
            File f = new File(s);
            if (f.exists() && f.isDirectory()) {
                this.openDocShowingDirListing(f);
                return;
            }
            if (f.exists()) {
                KTextWindow.addWindow(new File(s), true, true, true, true);
            }
            return;
        }
        KTextWindow.addWindow("untitled", str, true, true, true, true);
    }

    private void openDocShowingDirListing(File f) {
        if (f.exists() && f.isDirectory()) {
            FileUtils fu = new FileUtils();
            fu.setSearch(24, f, null);
            fu.doSearch();
            String[] list = fu.getSearchResults();
            StringBuffer b = new StringBuffer();
            for (int n = 0; n < list.length; ++n) {
                b.append(list[n]).append("\n");
            }
            KTextWindow.addWindow(f.getName(), b.toString(), true, true, true, true);
        } else {
            Cutter.setLog("    Error:DnDGlassPane.openDocShowingDirListing() - directory does not exist");
        }
    }

    @Override
    public void dropFilesHappened(File[] files) {
        if (files != null && files.length == 1 && files[0].isDirectory()) {
            this.openDocShowingDirListing(files[0]);
            return;
        }
        for (int n = 0; n < files.length; ++n) {
            if (files[n].isDirectory() || KAbstractDesktop.windowExists(files[n])) continue;
            KTextWindow.addWindow(files[n], true, true, true, true);
        }
    }

    static {
        isSuspended = false;
    }
}

