/*
 * Decompiled with CFR 0.152.
 */
package UI_DragDrop;

import UI_Desktop.Cutter;
import UI_DragDrop.DnDFileResponder;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.List;
import java.util.Vector;

public class DragDropUtils {
    DropTarget target = null;
    KDropTargetListener listener = null;
    DnDFileResponder comp;

    public DragDropUtils(DnDFileResponder comp) {
        this.comp = comp;
        this.listener = new KDropTargetListener(comp);
        this.target = new DropTarget((Component)((Object)comp), this.listener);
    }

    public void suspendGlassPaneListener() {
        this.target.setComponent(null);
    }

    public void resumeGlassPaneListener() {
        this.target = new DropTarget((Component)((Object)this.comp), this.listener);
    }

    private class KDropTargetListener
    implements DropTargetListener {
        private DnDFileResponder comp = null;

        public KDropTargetListener(DnDFileResponder comp) {
            this.comp = comp;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.comp.dropInProgress(false);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (this.isAcceptable(dtde)) {
                this.comp.dropInProgress(true);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            this.comp.dropInProgress(false);
            this.getData(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        private boolean isAcceptable(DropTargetDragEvent dtde) {
            return this.isAcceptable(dtde.getCurrentDataFlavors());
        }

        private boolean isAcceptable(DropTargetDropEvent dtde) {
            return this.isAcceptable(dtde.getCurrentDataFlavors());
        }

        private boolean isAcceptable(DataFlavor[] df) {
            for (int n = 0; n < df.length; ++n) {
                if (df[n].equals(DataFlavor.javaFileListFlavor)) {
                    return true;
                }
                if (!df[n].equals(DataFlavor.stringFlavor)) continue;
                return true;
            }
            return false;
        }

        private void getData(DropTargetDropEvent event) {
            event.acceptDrop(1);
            Transferable trans = event.getTransferable();
            DataFlavor[] flavors = trans.getTransferDataFlavors();
            Vector<File> listOfFiles = new Vector<File>();
            for (int n = 0; n < flavors.length; ++n) {
                DataFlavor d = flavors[n];
                try {
                    if (d.equals(DataFlavor.stringFlavor)) {
                        this.comp.dropStringHappened((String)trans.getTransferData(d));
                        continue;
                    }
                    if (!d.equals(DataFlavor.javaFileListFlavor)) continue;
                    List filelist = (List)trans.getTransferData(d);
                    for (File f : filelist) {
                        listOfFiles.addElement(f);
                    }
                    if (listOfFiles.size() <= 0) continue;
                    this.comp.dropFilesHappened(FileUtils.toFileArray(listOfFiles));
                    continue;
                }
                catch (Exception ex) {
                    Cutter.setLog("    Exception:DragDropUtils.getData() " + ex.toString());
                    return;
                }
            }
        }
    }
}

