/*
 * Decompiled with CFR 0.152.
 */
package UI_Net;

import UI_Desktop.Cutter;
import UI_Net.TCPEventListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;

public class AbstractTCPListener
extends Thread {
    private StringBuffer stringBuffer = new StringBuffer(1024);
    private boolean canListen = true;
    private TCPEventListener listener = null;
    private InternalThread thread = null;
    private ServerSocket listeningSocket = null;
    private boolean threadStop = false;

    public AbstractTCPListener(int portID, TCPEventListener listener) throws IOException {
        super("AbstractTCPListener");
        this.listener = listener;
        try {
            this.listeningSocket = new ServerSocket(portID);
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: AbstrctTCPListener() - constructor \n" + e.toString());
            throw e;
        }
        if (this.listeningSocket == null) {
            Cutter.setLog("    Error: AbstrctTCPListener() - constructor failed to get listeningSocket on port " + portID);
        }
        this.listeningSocket.setReuseAddress(true);
        this.canListen = true;
    }

    public void stopListening() {
        this.canListen = false;
    }

    @Override
    public void run() {
        try {
            while (this.canListen) {
                if (this.listeningSocket == null) {
                    Cutter.setLog("    Error: AbstrctTCPListener.run() - the listeningSocket has become unexpectedly set to null!");
                }
                this.thread = new InternalThread(this.listeningSocket.accept());
                this.thread.start();
            }
            this.threadStop = true;
            this.listeningSocket.close();
            this.canListen = false;
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: AbstrctTCPListener.run()\n" + e.toString());
        }
    }

    private class InternalThread
    extends Thread {
        private BufferedReader instream = null;
        private Socket socket = null;
        private String hostName = "unknown";

        public InternalThread(Socket socket) {
            this.socket = socket;
            socket.getRemoteSocketAddress();
            InetAddress ia = socket.getInetAddress();
            if (ia != null) {
                this.hostName = ia.getHostName();
            }
            AbstractTCPListener.this.listener.tcpConnectionHappened(this.hostName);
        }

        @Override
        public void run() {
            try {
                this.instream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String text = this.instream.readLine();
                while (text != null && !AbstractTCPListener.this.threadStop) {
                    final String str = text;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractTCPListener.this.listener.tcpEventHappened(str);
                        }
                    });
                    text = this.instream.readLine();
                }
                this.instream.close();
                this.socket.close();
            }
            catch (IOException e) {
                Cutter.setLog("    Exception: AbstrctTCPListener.TCPListener.run()");
                Cutter.setLog("        " + e.toString());
            }
        }
    }
}

