/*
 * Decompiled with CFR 0.152.
 */
package UI_Net.TCPListener;

import ClientServer.ClientServer.server.ListeningThread;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractTextWindow;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TCPListener
extends Thread {
    public static boolean asciiCodes = false;
    private ServerSocket ssocket = null;
    private static Vector<Thread> listOfListeners;
    public static final int DEFAULT_PORT = 4444;
    private StringBuffer stringBuffer = new StringBuffer(1024);
    private volatile boolean canListen = false;
    private KAbstractTextWindow window = null;

    public TCPListener(int portID, KAbstractTextWindow window) throws IOException {
        super("TCPListener");
        this.window = window;
        try {
            this.ssocket = new ServerSocket(portID);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The following I/O error has occured\n" + e.toString() + ".", "Error -  Cannot act as a tcp listener", 0);
            throw e;
        }
        this.ssocket.setReuseAddress(true);
        this.canListen = true;
    }

    public void stopAll() {
        for (int n = 0; n < listOfListeners.size(); ++n) {
            if (!(listOfListeners.elementAt(n) instanceof ListeningThread)) continue;
            ((ListeningThread)TCPListener.listOfListeners.elementAt((int)n)).stop = true;
            ((ListeningThread)listOfListeners.elementAt(n)).doStop();
        }
    }

    @Override
    public void run() {
        listOfListeners.removeAllElements();
        try {
            while (this.canListen) {
                TCPListenerThread lt = new TCPListenerThread(this.ssocket.accept());
                listOfListeners.addElement(lt);
                lt.start();
            }
            this.ssocket.close();
            this.canListen = false;
            for (int n = 0; n < listOfListeners.size(); ++n) {
                ((TCPListenerThread)TCPListener.listOfListeners.elementAt((int)n)).doStop = true;
            }
        }
        catch (IOException e) {
            Cutter.setLog("    Exception: TCPListener.run()\n" + e.toString());
        }
    }

    public void doStop() {
        this.canListen = false;
    }

    private static void remove(TCPListener l) {
        listOfListeners.removeElement(l);
    }

    static {
        try {
            Field[] fields = new Field[]{TCPListener.class.getDeclaredField("asciiCodes")};
            Cutter.addDebug(TCPListener.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: TCPListener.static - " + ex.toString());
        }
        listOfListeners = new Vector();
    }

    private class TCPListenerThread
    extends Thread {
        private BufferedReader instream = null;
        private Socket socket = null;
        public boolean doStop = false;
        private String hostName = "unknown";

        public TCPListenerThread(Socket socket) {
            this.socket = socket;
            socket.getRemoteSocketAddress();
            InetAddress ia = socket.getInetAddress();
            if (ia != null) {
                this.hostName = ia.getHostName();
            }
            Cutter.setLog("    Info:TCPListenerThread.TCPListenerThread() is " + this.hostName + "\n");
        }

        @Override
        public void run() {
            try {
                this.instream = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String text = this.instream.readLine();
                while (text != null && !this.doStop) {
                    if (asciiCodes) {
                        for (int n = 0; n < text.length(); ++n) {
                            Cutter.setLog(text.charAt(n) + "");
                        }
                    }
                    final String str = text;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TCPListener.this.window.appendText(str + "\n");
                        }
                    });
                    text = this.instream.readLine();
                }
                this.instream.close();
                this.socket.close();
            }
            catch (IOException e) {
                Cutter.setLog("    Exception: TCPListenerThread.run()");
                Cutter.setLog("    e.toString()");
            }
        }
    }
}

