/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.ArgsUtils;
import Utilities.DateTimeUtils;
import Utilities.EnumUtils;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;

public class ArgNodeidData {
    public String nodeid;
    public int nodeidInt = -1;
    public String argfilePath;
    public boolean argfileExists = false;
    public File argfile;
    public File dupfile;
    public boolean sorted = false;

    private ArgNodeidData(File argsfile) throws Exception {
        if (argsfile == null || !argsfile.exists()) {
            throw new Exception();
        }
        this.argfile = argsfile;
        this.argfilePath = argsfile.getPath();
        this.nodeid = ArgsUtils.getNodeidValue(this.argfile);
        if (this.nodeid == null) {
            throw new Exception();
        }
        try {
            this.nodeidInt = this.nodeid.trim().length() == 0 ? MayaNodeIdUtils.getMinNodeId() : NumberUtils.strToInt(this.nodeid);
        }
        catch (NumberFormatException nfe) {
            this.nodeidInt = -1;
        }
    }

    public static ArgNodeidData getInstance(File argsfile) {
        if (argsfile == null || !argsfile.exists()) {
            if (argsfile != null && !argsfile.exists()) {
                Cutter.setLog("    Debug: ArgNodeidData.getInstance(File) - argsfile \"" + argsfile.getPath() + "\" is null");
            }
            return null;
        }
        try {
            ArgNodeidData argData = new ArgNodeidData(argsfile);
            return argData;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Vector<ArgNodeidData> getInstances(Vector<File> listOfIniArgsFiles) {
        Vector<ArgNodeidData> listOfIniNodeData = new Vector<ArgNodeidData>();
        Vector<String> listOfIniNodeids = new Vector<String>();
        if (listOfIniArgsFiles == null || listOfIniArgsFiles.size() == 0) {
            Cutter.setLog("    Debug: ArgNodeidData.getInstances() - listOfIniArgsFiles is null.");
            return null;
        }
        for (int n = 0; n < listOfIniArgsFiles.size(); ++n) {
            File argFile = listOfIniArgsFiles.elementAt(n);
            ArgNodeidData argData = ArgNodeidData.getInstance(argFile);
            if (argData != null) {
                listOfIniNodeData.add(argData);
                listOfIniNodeids.add(argData.nodeid);
                continue;
            }
            Cutter.setLog("    Debug: ArgNodeidData.getInstance is null " + argFile.getPath());
        }
        if (listOfIniNodeData.size() == 0 || listOfIniNodeids.size() == 0) {
            Cutter.setLog("    Debug: ArgNodeidData.getInstances() - listOfIniNodeData is null.");
            return null;
        }
        String[] unsorted = VectorUtils.toStringArray(listOfIniNodeids);
        String[] sorted = TextUtils.sortByAlpha(unsorted);
        Vector<ArgNodeidData> outlist = new Vector<ArgNodeidData>();
        for (int n = 0; n < sorted.length; ++n) {
            String idStr = sorted[n];
            for (int i = 0; i < listOfIniNodeData.size(); ++i) {
                ArgNodeidData nd = (ArgNodeidData)listOfIniNodeData.elementAt(i);
                if (!nd.nodeid.equals(idStr) || nd.sorted) continue;
                outlist.add(nd);
                nd.sorted = true;
            }
        }
        return outlist;
    }

    public boolean sameAs(ArgNodeidData nd) {
        return nd.nodeid.equals(this.nodeid) && !nd.argfile.getPath().equals(this.argfile.getPath());
    }

    public static boolean entryExistsInList(ArgNodeidData nd, Vector<ArgNodeidData> list) {
        for (int n = 0; n < list.size(); ++n) {
            ArgNodeidData item = list.elementAt(n);
            if (!item.sameAs(nd)) continue;
            return true;
        }
        return false;
    }

    public String toFullString() {
        return "nodeid = " + this.nodeid + ": \"" + this.argfile.getPath() + "\"  dup: " + (this.dupfile == null ? "" : this.dupfile.getName());
    }

    public String toString() {
        return this.nodeid + ": \"" + this.argfile.getName() + "\"";
    }

    private String getEditedArgsText() {
        if (this.argfile == null || !this.argfile.exists()) {
            return null;
        }
        Enumeration<String> e = FileUtils.readLines(this.argfile.getPath());
        if (e == null) {
            Cutter.setLog("    Error: ArgNodeidData.getEditedArgsText() - FileUtils.readLines(this.argfile) returned null.");
            return null;
        }
        String[] lines = EnumUtils.toStringArray(e);
        if (lines == null || lines.length == 0) {
            Cutter.setLog("    Error: ArgNodeidData.getEditedArgsText() - EnumUtils.toStringArray(e) returned null.");
            return null;
        }
        StringBuffer b = new StringBuffer();
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n];
            if (line.trim().startsWith("<rfmdata")) {
                String[] tokens = TextUtils.tokenize(line, '=');
                if (tokens == null || tokens.length < 3) {
                    Cutter.setLog("    Error: ArgNodeidData.getEditedArgsText() - 1 cannot tokenize:");
                    Cutter.setLog("    " + line);
                    return null;
                }
                String[] t = TextUtils.tokenize(tokens[1]);
                if (t == null || t.length < 2) {
                    Cutter.setLog("    Error: ArgNodeidData.getEditedArgsText() - 2 cannot tokenize:");
                    Cutter.setLog("    " + line);
                    return null;
                }
                b.append(tokens[0]).append("=\"").append(this.nodeid).append("\" ").append(t[1]).append("=").append(tokens[2]);
                continue;
            }
            b.append(line);
        }
        return b.toString();
    }

    public static boolean updateArgsFile(ArgNodeidData nd, KTextPane textpane) {
        String text = nd.getEditedArgsText();
        if (text == null) {
            return false;
        }
        if (textpane == null) {
            FileUtils.writeFile(nd.argfile, text);
        } else {
            textpane.setText(text);
            textpane.parseAll();
        }
        return true;
    }

    public static boolean updateIniFile(File inifile, ArgNodeidData desktopArg) {
        StringBuffer outbuf = new StringBuffer();
        StringBuffer loadExtBuf = new StringBuffer();
        StringBuffer logMsgBuf = new StringBuffer();
        String desktopArgName = desktopArg.argfile.getName();
        String desktopArgID = desktopArg.nodeid;
        String desktopArgFilePath = desktopArg.argfilePath;
        boolean messageLogDone = false;
        boolean registrationDone = false;
        logMsgBuf.append("::RMS::LogMsg INFO \"Loading nodeid:").append(desktopArgID).append(" ").append(desktopArgName).append("\"");
        if (ArgsUtils.lastLoadExtensionFormat != null) {
            String subtext = ArgsUtils.lastLoadExtensionFormat.replace("__ARG_NAME__", desktopArgName);
            loadExtBuf.append("LoadExtension args ").append(subtext).append("\n");
        } else {
            loadExtBuf.append("LoadExtension args \"").append(desktopArgFilePath).append("\"\n");
        }
        String[] lines = null;
        final KAbstractWindow iniWindow = KAbstractDesktop.getWindowWithFile(inifile);
        if (iniWindow != null) {
            iniWindow.saveFile(1);
        }
        if ((lines = FileUtils.readLinesAsArray(inifile.getPath())) == null || lines.length == 0) {
            lines = new String[]{"# Created " + DateTimeUtils.getDateStamp() + "\n"};
        }
        Vector<String> temp = new Vector<String>();
        String targetName = TextUtils.removeExtension(desktopArgName);
        int foundTargetAt = -1;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n].trim();
            boolean doCopy = true;
            if (((line = line.replace('/', ' ')).startsWith("::RMS::LogMsg") || line.startsWith("::RAT::LogMsg")) && TextUtils.contains(line.replace('.', ' '), targetName, false)) {
                doCopy = false;
            }
            if (line.startsWith("LoadExtension") && TextUtils.contains(line.replace('.', ' '), targetName, false)) {
                doCopy = false;
                foundTargetAt = n;
            }
            if (!doCopy) continue;
            temp.add(lines[n]);
        }
        if (foundTargetAt != -1) {
            Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() - did not find an existing LoadExtension for \"" + desktopArgName + "\"");
        }
        if (temp.size() > 0) {
            if (foundTargetAt != -1) {
                String[] tmp = VectorUtils.toStringArray(temp);
                Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() - lines length " + lines.length);
                Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() - tmp length " + tmp.length);
                int delta = Math.abs(lines.length - tmp.length);
                foundTargetAt -= delta;
                Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() -  modified foundTargetAt to " + ++foundTargetAt);
            }
            lines = VectorUtils.toStringArray(temp);
        }
        int lastLoadExtension = 0;
        for (int n = 0; n < lines.length; ++n) {
            String[] tokens;
            String line = lines[n].trim();
            if (line.startsWith("LoadExtension") && (tokens = TextUtils.tokenize(line)) != null && tokens.length > 0 && tokens[1].equals("args")) {
                lastLoadExtension = n;
            }
            if (!line.startsWith("::RMS::LogMsg INFO") || !line.endsWith("has been loaded\"")) continue;
            lastLoadExtension = n;
        }
        Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() - original lastLoadExtension " + lastLoadExtension);
        lastLoadExtension = lastLoadExtension == 0 ? (foundTargetAt == -1 ? lines.length - 0 : foundTargetAt) : ++lastLoadExtension;
        Cutter.setLog("    Debug:ArgNodeidData.updateIniFile() - modified lastLoadExtension " + lastLoadExtension + " total line count is " + lines.length);
        boolean bufHasBeenAppended = false;
        for (int n = 0; n < lines.length; ++n) {
            if (n == lastLoadExtension) {
                outbuf.append("\n");
                outbuf.append(logMsgBuf.toString()).append("\n");
                outbuf.append(loadExtBuf.toString());
                bufHasBeenAppended = true;
            }
            if (lines[n].endsWith("\n")) {
                outbuf.append(lines[n]);
                continue;
            }
            outbuf.append(lines[n]).append("\n");
        }
        if (!bufHasBeenAppended) {
            outbuf.append("\n").append(logMsgBuf.toString()).append("\n");
            outbuf.append(loadExtBuf.toString());
        }
        final String text = ArgNodeidData.removeEmpytLines(outbuf.toString());
        if (iniWindow != null) {
            final JEditorPane editorpane = BBxt.getTextPane(iniWindow);
            if (editorpane != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        editorpane.selectAll();
                        editorpane.replaceSelection(text);
                        iniWindow.saveFile(1);
                    }
                });
            }
        } else {
            FileUtils.writeFile(inifile, text);
        }
        return true;
    }

    private boolean writeToIni(File inifile, KAbstractWindow iniWindow, final String text) {
        if (iniWindow != null) {
            return false;
        }
        final JEditorPane editorpane = BBxt.getTextPane(iniWindow);
        if (editorpane != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    editorpane.selectAll();
                    editorpane.replaceSelection(text);
                }
            });
        }
        return true;
    }

    private static String removeEmpytLines(String str) {
        Vector<String> list = new Vector<String>();
        if (!str.endsWith("\n")) {
            str = str + "\n";
        }
        int index = str.indexOf(10);
        boolean prelineEmpty = false;
        while (index != -1) {
            String s;
            if ((s = str.substring(0, ++index)).trim().length() != 0 || !prelineEmpty) {
                list.add(s);
            }
            str = str.substring(index);
            index = str.indexOf(10);
            prelineEmpty = s.trim().length() == 0;
        }
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < list.size(); ++n) {
            buf.append((String)list.elementAt(n));
        }
        return buf.toString();
    }
}

