/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsHtmlWriter;
import UI_Script.Args.ArgsItemParser;
import UI_Script.Args.ArgsRegAction;
import UI_Script.Args.ArgsStrings;
import UI_Script.Help.KAbstractHelp;
import UI_Script.Html.HtmlTokenizer;
import UI_Script.PixarDev.RixPlugins.RixCppWriter;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import Utilities.BrowserUtils;
import Utilities.DialogUtils;
import Utilities.DocumentUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.TextUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;

public class ArgsHelp
extends KAbstractHelp
implements PopupMenuListener {
    private final String FLOAT_SLIDER = "slider";
    private final String INT_SLIDER = "slider";
    private final String CHECKBOX = "checkbox";
    private final String MENU = "menu";
    private final String STRING = "text";
    private final String SWATCH = "swatch";
    final File int_slider = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/int_slider.arg");
    final File int_mapper = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/int_mapper.arg");
    final File int_checkbox = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/int_checkbox.arg");
    final File float_slider = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/float_slider.arg");
    final File string_text = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/string.arg");
    final File string_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/file.arg");
    final File vector_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/vector.arg");
    final File normal_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/normal.arg");
    final File manifold_file = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/manifold.arg");
    final File result_color = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/resultColor.arg");
    final File result_float = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/resultFloat.arg");
    final File result_normal = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/resultXYZ.arg");
    final File result_struct = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/resultStruct.arg");
    final File color = new File(FileUtils.getPWDFile(), "/Cutter_Help/ris/args/color.arg");
    protected static ArgsHelp argshelp = null;
    KAbstractHelp.KPopupMenuItem exportAsCpp = this.addExportCPP();
    private static boolean warning_no_shaderType = false;

    public boolean showDocFor(String item, boolean shiftDown) {
        this.useCutterBrowser = !shiftDown;
        return this.launchBrowser(item);
    }

    @Override
    public boolean showDocFor(String item, MouseEvent e) {
        return false;
    }

    public ArgsHelp(KTextPane textpane) {
        super(textpane);
        this.completer.completionDeActivate();
    }

    @Override
    public void setCompletorListeners() {
        this.completer.setListeners(this.textpane, this);
        this.completer.completionDeActivate();
    }

    public static void _initPaths() {
    }

    private boolean isaArgsKeyword(String item) {
        if (item == null || item.trim().length() == 0) {
            return false;
        }
        if (item.equals("RSLFunction") || item.equals("RSLDefine") || item.equals("RSLInclude") || item.equals("RSLMain") || item.equals("RSLDeclare") || item.equals("RSLClass") || item.equals("RSLMain") || item.equals("varying") || item.equals("output")) {
            return true;
        }
        HtmlTokenizer tok = new HtmlTokenizer();
        tok.setBuffer(item);
        return false;
    }

    @Override
    public void lookup(String item) {
    }

    @Override
    public void popupTypingCompletion(Point pnt, String textToComplete, int insertAt, MouseEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupOnlineHelp(Point pnt, String selection, int insertAt, MouseEvent e) {
        int begin = insertAt - selection.length();
        KAbstractHelp.KPopupMenu popup = new KAbstractHelp.KPopupMenu(this);
        PopupMenuListener[] pops = popup.getPopupMenuListeners();
        if (pops != null) {
            for (int n = 0; n < pops.length; ++n) {
                popup.removePopupMenuListener(pops[n]);
            }
        }
        popup.addPopupMenuListener(this);
        JMenu defaultMenu = new JMenu("General Options");
        JComponent[] items = this.getDefaultPopupItems(e, selection, insertAt - selection.length(), insertAt);
        for (int n = 0; n < items.length; ++n) {
            if (items[n] == null || items[n] instanceof KAbstractHelp.KPopupMenuItem && ((KAbstractHelp.KPopupMenuItem)items[n]).getText().contains("Completion")) continue;
            defaultMenu.add(items[n]);
        }
        JMenu pmenu = new JMenu("Params/Inputs");
        JMenu menu = this.addParam_Float(selection, insertAt);
        if (menu != null) {
            pmenu.add(menu);
        }
        if ((menu = this.addParam_Int(selection, insertAt)) != null) {
            pmenu.add(menu);
        }
        if ((menu = this.addParam_Color(selection, insertAt)) != null) {
            pmenu.add(menu);
        }
        if ((menu = this.addParam_String(selection, insertAt)) != null) {
            pmenu.add(menu);
        }
        if ((menu = this.addParam_VecNorm(selection, insertAt)) != null) {
            pmenu.add(menu);
        }
        if ((menu = this.addParam_Misc(selection, insertAt)) != null) {
            pmenu.add(menu);
        }
        popup.add(pmenu);
        JMenu rmenu = new JMenu("Results/Outputs");
        KAbstractHelp.KPopupMenuItem mi = this.addResult_Color(selection, insertAt);
        rmenu.add(mi);
        mi = this.addResult_Float(selection, insertAt);
        rmenu.add(mi);
        mi = this.addResult_Normal(selection, insertAt);
        rmenu.add(mi);
        mi = this.addResult_Manifold(selection, insertAt);
        rmenu.add(mi);
        if (RenderInfo.prmanMajorVersionNumber() >= 21) {
            rmenu.add(this.addResult_Vstruct(selection, insertAt));
        }
        popup.add(rmenu);
        popup.add(new JSeparator());
        if (this.exportAsCpp == null) {
            this.exportAsCpp = this.addExportCPP();
        }
        popup.add(this.exportAsCpp);
        KMenuItem registerItem = new KMenuItem("Register ...");
        File winfile = BBxt.getWindowFile();
        registerItem.setEnabled(winfile != null);
        if (winfile != null) {
            BBxt.save();
            registerItem.setText("Register \"" + winfile.getName() + "\"");
        }
        if (this.textpane != null) {
            registerItem.addActionListener(new ArgsRegAction(this.textpane));
            popup.add(registerItem);
        } else {
            Cutter.setLog("ArgsHelp line 320 textpane is null!!");
        }
        KAbstractHelp.KPopupMenuItem nodeIdReportItem = new KAbstractHelp.KPopupMenuItem(this, "Generate NodeID Report");
        nodeIdReportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MayaNodeIdUtils.writeFullReport();
            }
        });
        popup.add(nodeIdReportItem);
        KAbstractHelp.KPopupMenuItem previsUiItem = new KAbstractHelp.KPopupMenuItem(this, "Open UI Preview in Browser");
        previsUiItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArgsHelp.this.openPreViewInBrowser();
            }
        });
        popup.add(previsUiItem);
        popup.add(new JSeparator());
        popup.add(defaultMenu);
        if (popup != null) {
            popup.setRequestFocusEnabled(false);
            try {
                popup.show(this.textpane, e.getX(), e.getY());
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:ArgsHelp.popupOnlineHelp()\n      " + ex.toString());
            }
        }
    }

    private KAbstractHelp.KPopupMenuItem addExportCPP() {
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Create C++ Code");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File argsFile = BBxt.getFrontWindowFile();
                if (argsFile == null) {
                    String[] msg = new String[]{"The .args document,", "    \"" + BBxt.getWindowTitle() + "\"", "must be saved before C++ can be generated."};
                    DialogUtils.showInfoMessage("Error: Args File Not Saved", msg);
                    return;
                }
                RixCppWriter writer = RixCppWriter.getInstance(argsFile);
                if (writer != null) {
                    writer.createDoc();
                }
            }
        });
        return mi;
    }

    private JMenu addParam_Float(String sel, int at) {
        JMenu menu = new JMenu("float");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "slider");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.float_slider), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu addParam_VecNorm(String sel, int at) {
        JMenu menu = new JMenu("vector|normal");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "vector");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.vector_file), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem(this, "normal");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.normal_file), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private JMenu addParam_Int(String sel, int at) {
        JMenu menu = new JMenu("int");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "slider");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.int_slider), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem(this, "checkbox");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.int_checkbox), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem(this, "menu");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.int_mapper), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private int _countTabStops() {
        Document doc = BBxt.getWindowDocument();
        if (doc == null) {
            Cutter.setLog("    Error:SlimHelp.addCollectionBlock() - cannot get front windows document!");
            return 0;
        }
        int[] offsets = DocumentUtils.getElementOffsets(doc, BBxt.getSelectionStart());
        BBxt.setSelection(offsets[1], BBxt.getSelectionEnd());
        String sel = BBxt.getSelection();
        int numTabs = 0;
        for (int i = 0; i < sel.length(); ++i) {
            if (sel.charAt(i) == '\t') {
                ++numTabs;
            }
            if (sel.charAt(i) >= ' ') break;
        }
        return numTabs;
    }

    private JMenu addParam_String(String sel, int at) {
        JMenu menu = new JMenu("string");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "file");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.string_file), begin, end);
            }
        });
        menu.add(mi);
        mi = new KAbstractHelp.KPopupMenuItem(this, "text");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.string_text), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem addParam_Vstruct(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "vstruct");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(ArgsStrings.vstruct_param, begin, end);
            }
        });
        return mi;
    }

    private JMenu addParam_Misc(String sel, int at) {
        JMenu menu = new JMenu("misc");
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "manifold");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.manifold_file), begin, end);
            }
        });
        menu.add(mi);
        if (RenderInfo.prmanMajorVersionNumber() >= 21) {
            menu.add(this.addParam_Vstruct(sel, at));
        }
        return menu;
    }

    private JMenu addParam_Color(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        JMenu menu = new JMenu("color");
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "swatch");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.color), begin, end);
            }
        });
        menu.add(mi);
        return menu;
    }

    private KAbstractHelp.KPopupMenuItem addResult_Color(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Color");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.result_color), begin, end);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem addResult_Float(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Float");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.result_float), begin, end);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem addResult_Normal(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Vector|Normal|Point");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.result_normal), begin, end);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem addResult_Manifold(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Manifold");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(FileUtils.read(ArgsHelp.this.result_struct), begin, end);
            }
        });
        return mi;
    }

    private KAbstractHelp.KPopupMenuItem addResult_Vstruct(String sel, int at) {
        final int begin = at - sel.length();
        final int end = at;
        KAbstractHelp.KPopupMenuItem mi = new KAbstractHelp.KPopupMenuItem(this, "Vstuct");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArgsHelp.this.insertParamStr(ArgsStrings.vstruct_output, begin, end);
            }
        });
        return mi;
    }

    private boolean _replaceExistingText() {
        String[] msgs = new String[]{"This action will replace all existing text.\n", "Do you wish to proceed?\n"};
        BBxt.selectAll();
        if (BBxt.getSelectionLength() == 0) {
            return true;
        }
        return DialogUtils.confirm("Insert Template Code", "ignored", msgs);
    }

    private void insertParamStr(String str, int begin, int end) {
        try {
            this.textpane.setSelectionStart(begin);
            this.textpane.setSelectionEnd(end);
            this.textpane.replaceSelection(str);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:SlimHelp.insertParamStr()\n        " + e.toString());
            return;
        }
    }

    private String _grabNextString(String head, String str) {
        String tail;
        try {
            tail = str.substring(head.length()).trim();
        }
        catch (IndexOutOfBoundsException e) {
            Cutter.setLog("    Exeception:RmanHelp.grabNextString()\n        " + e.toString());
            return "";
        }
        tail = TextUtils.trimLeadingChar(tail, '\"');
        tail = TextUtils.trimTrailingChar(tail, '\"');
        tail = TextUtils.trimLeadingChar(tail, '{');
        tail = TextUtils.trimTrailingChar(tail, '}');
        return tail;
    }

    public void openPreViewInBrowser() {
        String title = BBxt.getWindowTitle();
        if (title.endsWith(" [NOT EDITABLE]")) {
            title = title.substring(0, title.length() - " [NOT EDITABLE]".length());
        }
        title = TextUtils.removeExtension(title);
        File dir = new File(FileUtils.getPWDFile(), "previs_" + title);
        File indexF = new File(dir, "index.html");
        ArgsHtmlWriter.createHostDir(indexF);
        try {
            ArgsHtmlWriter writer = new ArgsHtmlWriter(indexF);
            writer.writeHeader();
            ArgsItemParser argsParser = new ArgsItemParser();
            String allScript = FileUtils.read(BBxt.getWindowFile());
            if (allScript == null) {
                return;
            }
            ArgsItemParser.ArgsDB db = argsParser.getDB(allScript);
            writer.writeParams(db);
            writer.writeTail();
            writer.writeSelf();
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:ArgsHelp.openPreViewInBrowser 1\n        " + ex.toString());
            return;
        }
        boolean isFirefox = false;
        if (Preferences.get(Preferences.WEB_BROWSER_PREFERRED).equalsIgnoreCase("firefox")) {
            isFirefox = true;
        }
        if (EnvUtils.getOSName().equalsIgnoreCase("Windows 7") && isFirefox) {
            String str = "file:\\" + indexF.getPath();
            BrowserUtils.open(str, true);
        } else {
            BrowserUtils.open(indexF);
        }
    }
}

