/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import UI_Components.KTile;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Tools.AssetManagement.HtmlWriter;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;

public class ArgsHtmlWriter
extends HtmlWriter {
    static File SRC_HTML_DIR = null;
    static File SRC_IMAGES_DIR = null;
    static File headerFile = null;
    static File pagePanelHeaderFile = null;
    static File tailFile = null;
    static String headerStr = null;
    static String tailStr = null;
    static File colorFile = null;
    static File connectionFile = null;
    static File fileFile = null;
    static File textFile = null;
    static File strFile = null;
    static File menuFile = null;
    static File sliderKnobFile = null;
    static File sliderFile = null;
    static File checkboxFile = null;
    static File checkboxOnFile = null;
    static File manifoldFile = null;
    static File vectorFile = null;
    static String colorStr = null;
    static String connectionStr = null;
    static String fileStr = null;
    static String textStr = null;
    static String strStr = null;
    static String menuStr = null;
    static String pagePanelHeaderStr = null;
    static String sliderStr = null;
    static String checkboxStr = null;
    static String checkboxOnStr = null;
    static String manifoldStr = null;
    static String vectorStr = null;
    static double rangeSliderConnected;
    static double rangeSliderNotConnected;
    static double rangeColorSlider;
    String fileButtonStr = "<img src=\"images/fileUI.png\" alt=\"\" border=\"0\">";

    public ArgsHtmlWriter(File file) throws IOException {
        super(file, SRC_IMAGES_DIR);
    }

    @Override
    public void writeHeader() {
        if (headerStr == null || headerStr.trim().length() == 0) {
            Cutter.setLog("    Error:ArgsHtmlWriter.writeHeader() - no header at        \"" + headerFile.getPath() + "\"");
            return;
        }
        this.buff.append(headerStr.replaceAll("(_TITLE_)", this.tightHostDirName));
    }

    @Override
    public void writeSelf() throws IOException {
        this.write(this.buff.toString());
        this.flush();
        this.close();
    }

    private Color convertToColor(String input) {
        float b;
        float g;
        float r;
        if (input == null || input.trim().length() == 0) {
            return Color.black;
        }
        String[] tokens = TextUtils.tokenize(input, " ");
        if (tokens.length != 3) {
            return Color.white;
        }
        try {
            r = (float)NumberUtils.strToDouble(tokens[0]);
            g = (float)NumberUtils.strToDouble(tokens[1]);
            b = (float)NumberUtils.strToDouble(tokens[2]);
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:ArgsHtmlWriter.convertToColor() " + input);
            return Color.red;
        }
        r = (double)r > 1.0 ? 1.0f : r;
        g = (double)g > 1.0 ? 1.0f : g;
        b = (double)b > 1.0 ? 1.0f : b;
        return new Color(r, g, b);
    }

    private String getFloatFormat(String numStr) {
        Double d = NumberUtils.strToDouble(numStr);
        return NumberUtils.clip(d, 3);
    }

    private String writeColorPng(String srcPngName, Rectangle bbox, ArgsItem item) {
        KTile tile;
        File colorUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(colorUI_PNG);
        }
        catch (Exception ex) {
            String path = colorUI_PNG.getPath();
            Cutter.setLog("    Error: ArgsHtmlWriter.writeColorPng() - cannot find \"" + path + "\"");
            return "";
        }
        tile.fill(this.convertToColor(item.defaultValue), bbox);
        String outName = tile.colorToOuputName() + ".png";
        File outFile = new File(this.hostImagesDir, outName);
        tile.write(outFile, "png");
        return outName;
    }

    private String writeStringPng(String srcPngName, Rectangle bbox, ArgsItem item) {
        return this.writeStringPng(srcPngName, bbox, item, 14);
    }

    private String writeStringPng(String srcPngName, Rectangle bbox, ArgsItem item, int baseLineHt) {
        KTile tile;
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error: ArgsHtmlWriter.writeStringPng() - cannot find \"" + path + "\"");
            return "";
        }
        String dv = item.getArgDataType().equals("float") ? this.getFloatFormat(item.defaultValue) : item.defaultValue;
        tile.setText(dv, bbox, 11, baseLineHt);
        String outName = tile.textToOuputName() + ".png";
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeMenuPng(String srcPngName, Rectangle bbox, ArgsItem item) {
        KTile tile;
        File numberUI_PNG = new File(this.srcImagesDir, srcPngName);
        try {
            tile = new KTile(numberUI_PNG);
        }
        catch (Exception ex) {
            String path = numberUI_PNG.getPath();
            Cutter.setLog("    Error: ArgsHtmlWriter.writeStringPng() - cannot find \"" + path + "\"");
            return "";
        }
        String label = "";
        if (item.mapperItems.size() > 0 && !item.defaultValue.equals("")) {
            label = item.mapperItems.get(item.defaultValue);
        }
        tile.setText(label, bbox, 11, 16, new Color(98, 98, 98));
        String outName = tile.textToOuputName() + ".png";
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String overlaySliderKnob(String dstPngName, ArgsItem item) {
        KTile tile;
        File dstPNG = new File(this.hostImagesDir, dstPngName);
        File knobPNG = new File(this.srcImagesDir, "knob.png");
        String outName = dstPngName;
        try {
            tile = new KTile(dstPNG);
        }
        catch (Exception ex) {
            Cutter.setLog("    Error: ArgsHtmlWriter.overlaySliderKnob() - cannot find \"" + dstPNG.getPath() + "\"");
            return outName;
        }
        if (item.getArgDataType().equals("float") || item.getArgDataType().equals("int")) {
            double val = NumberUtils.strToFloat(item.defaultValue);
            double min = item.min.equals("") ? 0.0 : (double)NumberUtils.strToFloat(item.min);
            double max = item.max.equals("") ? 1.0 : (double)NumberUtils.strToFloat(item.max);
            double delta = (val - min) / (max - min);
            delta = delta < 0.0 ? 0.0 : delta;
            delta = delta > 1.0 ? 1.0 : delta;
            double range = item.connectable ? rangeSliderConnected : rangeSliderNotConnected;
            int knobOffset = (int)(range * delta);
            outName = tile.overlay(knobPNG, knobOffset + 76, 2);
        }
        if (item.getArgDataType().equals("color")) {
            Color c = this.convertToColor(item.defaultValue);
            float[] comps = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            double delta = comps[2];
            delta = delta < 0.0 ? 0.0 : delta;
            delta = delta > 1.0 ? 1.0 : delta;
            int knobOffset = (int)(rangeColorSlider * delta);
            outName = tile.overlay(knobPNG, knobOffset + 76, 2);
        }
        tile.write(new File(this.hostImagesDir, outName), "png");
        return outName;
    }

    private String writeVectorPng(String srcPngName, Rectangle bbox, ArgsItem item) {
        return srcPngName;
    }

    public void writeParams(ArgsItemParser.ArgsDB argsDB) {
        String currentPage = "";
        if (argsDB == null) {
            Cutter.setLog("    Error:ArgsHtmlWriter.writeParams() - no params!");
            return;
        }
        for (int n = 0; n < argsDB.inputs.size(); ++n) {
            String pngName;
            String str = "";
            String destPngName = "";
            ArgsItem item = argsDB.inputs.elementAt(n);
            if (item.widget.equals("null")) continue;
            if (item.tags.startsWith("vstruct")) {
                item.setArgDataType("string");
                item.defaultValue = "";
            }
            if (!item.pageHolderName.equals("") && !item.pageHolderName.equals(currentPage)) {
                String panelLabel = TextUtils.removeQuotes(item.pageHolderName);
                this.buff.append(pagePanelHeaderStr.replaceAll("(_PAGENAME_)", panelLabel));
                currentPage = item.pageHolderName;
            }
            String string = item.label = item.label.equals("") ? item.name : item.label;
            if (item.getArgDataType().equals("color")) {
                str = colorStr.replaceAll("(LABEL)", item.label);
                destPngName = this.writeColorPng("colorUI.png", new Rectangle(5, 2, 72, 16), item);
                destPngName = this.overlaySliderKnob(destPngName, item);
                str = str.replaceAll("(IMAGE_PNG)", destPngName);
            } else if (item.getArgDataType().equals("float")) {
                str = sliderStr.replaceAll("(LABEL)", item.label);
                pngName = item.connectable ? "sliderConnectedUI.png" : "sliderNotConnectedUI.png";
                destPngName = this.writeStringPng(pngName, new Rectangle(5, 1, 72, 19), item);
                destPngName = this.overlaySliderKnob(destPngName, item);
                str = str.replaceAll("(NUMBER_PNG)", destPngName);
            } else if (item.getArgDataType().equals("string")) {
                if (item.widget.equals("fileInput")) {
                    str = fileStr.replaceAll("(LABEL)", item.label);
                    str = str.replaceAll("(DIR_BUTTON)", this.fileButtonStr);
                } else if (item.widget.equals("text")) {
                    str = textStr.replaceAll("(LABEL)", item.label);
                } else if (item.getArgDataType().equals("string") && item.widget.equalsIgnoreCase("mapper")) {
                    str = menuStr.replaceAll("(LABEL)", item.label);
                    destPngName = this.writeMenuPng("menuUI.png", new Rectangle(7, 5, 75, 20), item);
                    str = str.replaceAll("(MENU_PNG)", destPngName);
                } else {
                    str = strStr.replaceAll("(LABEL)", item.label);
                    destPngName = this.writeStringPng("stringUI.png", new Rectangle(5, 3, 209, 19), item, 15);
                    str = str.replaceAll("(TEXT_PNG)", destPngName);
                }
            } else if (item.getArgDataType().equals("int") && item.widget.equalsIgnoreCase("checkBox")) {
                str = item.defaultValue.trim().length() == 0 || item.defaultValue.equals("0") ? checkboxStr.replaceAll("(LABEL)", item.label) : checkboxOnStr.replaceAll("(LABEL)", item.label);
            } else if (item.getArgDataType().equals("int") && item.widget.equalsIgnoreCase("mapper")) {
                str = menuStr.replaceAll("(LABEL)", item.label);
                destPngName = this.writeMenuPng("menuUI.png", new Rectangle(7, 5, 75, 20), item);
                str = str.replaceAll("(MENU_PNG)", destPngName);
            } else if (item.getArgDataType().equals("int")) {
                str = sliderStr.replaceAll("(LABEL)", item.label);
                pngName = item.connectable ? "sliderConnectedUI.png" : "sliderNotConnectedUI.png";
                destPngName = this.writeStringPng(pngName, new Rectangle(5, 1, 72, 19), item);
                destPngName = this.overlaySliderKnob(destPngName, item);
                str = str.replaceAll("(NUMBER_PNG)", destPngName);
            } else if (item.getArgDataType().equals("struct")) {
                str = manifoldStr.replaceAll("(LABEL)", item.label);
            } else if (item.getArgDataType().equals("normal")) {
                str = manifoldStr.replaceAll("(LABEL)", item.label);
            } else if (item.getArgDataType().equals("vector")) {
                str = vectorStr.replaceAll("(LABEL)", item.label);
                destPngName = this.writeVectorPng("vectorUI.png", new Rectangle(7, 5, 75, 20), item);
                str = str.replaceAll("(VECTOR_PNG)", destPngName);
            }
            if (str.length() > 0) {
                this.buff.append(str);
                continue;
            }
            Cutter.setLog("    Warning:ArgsHmlWriter.writeParams() - no param text for " + item.name);
        }
    }

    @Override
    public void writeTail() {
        this.buff.append(tailStr);
    }

    static {
        SRC_HTML_DIR = new File(FileUtils.getPWDFile(), "Cutter_Help/ris/HTML");
        SRC_IMAGES_DIR = new File(SRC_HTML_DIR, "images");
        headerFile = new File(SRC_HTML_DIR, "header.html");
        headerStr = FileUtils.read(headerFile.getPath());
        pagePanelHeaderFile = new File(SRC_HTML_DIR, "pagePanelHeader.html");
        pagePanelHeaderStr = FileUtils.read(pagePanelHeaderFile.getPath());
        tailFile = new File(SRC_HTML_DIR, "tail.html");
        tailStr = FileUtils.read(tailFile.getPath());
        colorFile = new File(SRC_HTML_DIR, "color.html");
        connectionFile = new File(SRC_HTML_DIR, "connection.html");
        fileFile = new File(SRC_HTML_DIR, "file.html");
        textFile = new File(SRC_HTML_DIR, "text.html");
        strFile = new File(SRC_HTML_DIR, "string.html");
        menuFile = new File(SRC_HTML_DIR, "menu.html");
        vectorFile = new File(SRC_HTML_DIR, "vector.html");
        sliderFile = new File(SRC_HTML_DIR, "slider.html");
        checkboxFile = new File(SRC_HTML_DIR, "checkbox.html");
        checkboxOnFile = new File(SRC_HTML_DIR, "checkboxOn.html");
        manifoldFile = new File(SRC_HTML_DIR, "manifold.html");
        colorStr = FileUtils.read(colorFile.getPath());
        connectionStr = FileUtils.read(connectionFile.getPath());
        fileStr = FileUtils.read(fileFile.getPath());
        textStr = FileUtils.read(textFile.getPath());
        strStr = FileUtils.read(strFile.getPath());
        menuStr = FileUtils.read(menuFile.getPath());
        vectorStr = FileUtils.read(vectorFile.getPath());
        sliderStr = FileUtils.read(sliderFile.getPath());
        checkboxStr = FileUtils.read(checkboxFile.getPath());
        checkboxOnStr = FileUtils.read(checkboxOnFile.getPath());
        manifoldStr = FileUtils.read(manifoldFile.getPath());
        rangeSliderConnected = 79.0;
        rangeSliderNotConnected = 126.0;
        rangeColorSlider = 88.0;
    }
}

