/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import Utilities.TextUtils;
import java.util.Enumeration;
import java.util.Hashtable;

public class ArgsItem {
    public String name = "";
    public String pageHolderName = "";
    public String label = "";
    public String widget = "";
    public Hashtable<String, String> mapperItems = new Hashtable();
    public String defaultValue = "";
    public String min = "";
    public String max = "";
    public String argDataType = "";
    public String tags = "";
    public boolean connectable = true;
    private String rixType = "";
    private String rtType = "";
    public String rixIndexName = "";
    public String variableName = "";
    private String pointerName = "";
    public String insideLoopName = "";
    public boolean isVstructPlug = false;
    private String defaultVar = "";
    String id = "";

    public static boolean isDataType(String typestr) {
        if (typestr.equals("int")) {
            return true;
        }
        if (typestr.equals("float")) {
            return true;
        }
        if (typestr.equals("color")) {
            return true;
        }
        if (typestr.equals("string")) {
            return true;
        }
        if (typestr.equals("vector")) {
            return true;
        }
        if (typestr.equals("point")) {
            return true;
        }
        if (typestr.equals("normal")) {
            return true;
        }
        return typestr.equals("displayfilter");
    }

    public static String rtTypeLookup(String typestr) {
        if (typestr == null) {
            Cutter.setLog("    Error:ArgsItem.rtTypeLookup() - passed a null typestr.");
            return "RtError";
        }
        if (typestr.equals("int")) {
            return "RtInt";
        }
        if (typestr.equals("float")) {
            return "RtFloat";
        }
        if (typestr.equals("color")) {
            return "RtColorRGB";
        }
        if (typestr.equals("string")) {
            return "RtConstString";
        }
        if (typestr.equals("vector")) {
            return "RtVector3";
        }
        if (typestr.equals("normal")) {
            return "RtNormal3";
        }
        if (typestr.equals("point")) {
            return "RtPoint3";
        }
        if (typestr.equals("displayfilter")) {
            return "RixDisplayFilter";
        }
        return "RtError";
    }

    public static String rixTypeLookup(String typestr) {
        if (typestr == null) {
            Cutter.setLog("    Error:ArgsItem.rixTypeLookup() - passed a null typestr.");
            return "k_RixSCInvalidType";
        }
        if (typestr.equals("int")) {
            return "k_RixSCInteger";
        }
        if (typestr.equals("float")) {
            return "k_RixSCFloat";
        }
        if (typestr.equals("color")) {
            return "k_RixSCColor";
        }
        if (typestr.equals("string")) {
            return "k_RixSCString";
        }
        if (typestr.equals("vector")) {
            return "k_RixSCVector";
        }
        if (typestr.equals("normal")) {
            return "k_RixSCNormal";
        }
        if (typestr.equals("normal")) {
            return "k_RixSCPoint";
        }
        if (typestr.equals("displayfilter")) {
            return "k_RixSCDisplayFilter, k_RixSCInput, 0";
        }
        Cutter.setLog("    Error:ArgsItem.rixTypeLookup() - passed a \"" + typestr + "\" typestr.");
        return "k_RixSCInvalidType";
    }

    public ArgsItem(String idType) {
        this.id = idType;
    }

    public void set(String item, String value) {
        if (value == null) {
            return;
        }
        value = TextUtils.removeQuotes(value);
        value = TextUtils.remove(value, '\'');
        if (item.equals("name")) {
            this.name = value.trim();
            this.setVariableName();
            this.rixIndexName = "k_" + this.variableName;
        } else if (item.equals("default")) {
            this.defaultValue = value;
        } else if (item.equals("min")) {
            this.min = value;
        } else if (item.equals("max")) {
            this.max = value;
        } else if (item.equals("type")) {
            this.argDataType = value;
        } else if (item.equals("tag")) {
            this.tags = value;
        } else if (item.equals("input") && value.equalsIgnoreCase("False")) {
            this.connectable = false;
        } else if (item.equals("connectable") && value.equalsIgnoreCase("False")) {
            this.connectable = false;
        } else if (item.equals("label")) {
            this.label = value;
        } else if (item.equals("widget")) {
            this.widget = value;
        }
        if (item.equals("tag") && value.equals("vstruct")) {
            this.isVstructPlug = true;
        }
    }

    public String getMemberName() {
        return "m_" + this.variableName;
    }

    public String getDeclareDefaultAsRt() {
        if (this.argDataType.equals("string")) {
            return null;
        }
        if (this.defaultValue.trim().length() == 0) {
            Cutter.setLog("getDeclareDefaultAsRt");
            if (this.argDataType.equals("int")) {
                this.defaultValue = "0";
            } else if (this.argDataType.equals("float")) {
                this.defaultValue = "0f";
            } else if (this.argDataType.equals("color") || this.argDataType.equals("point") || this.argDataType.equals("vector") || this.argDataType.equals("normal")) {
                this.defaultValue = "0.0f 0.0f 0.0f";
            }
        }
        if (this.defaultValue.trim().length() > 0) {
            if (this.argDataType.equals("int")) {
                return this.defaultValue;
            }
            if (this.argDataType.equals("float")) {
                this.defaultValue = this.defaultValue.lastIndexOf(46) == -1 ? this.defaultValue + ".0" : this.defaultValue;
                return this.defaultValue + "f";
            }
            String commaSeparated = this.defaultValue.trim().replace(' ', ',');
            if (this.argDataType.equals("color") || this.argDataType.equals("point") || this.argDataType.equals("vector") || this.argDataType.equals("normal")) {
                return this.getRtType() + "(" + commaSeparated + ")";
            }
            return "ERROR - Cannot find a suitable value";
        }
        return this.toString();
    }

    public String getDeclareMemberDefaultValue() {
        if (this.defaultVar.trim().length() > 0) {
            return this.defaultVar;
        }
        if (this.defaultValue.equals("")) {
            if (this.argDataType.equals("int")) {
                this.defaultValue = "0";
            } else if (this.argDataType.equals("float")) {
                this.defaultValue = "0f";
            } else if (this.argDataType.equals("color")) {
                this.defaultValue = "1,0,0";
            } else if (this.argDataType.equals("string")) {
                this.defaultValue = "NULL";
            } else {
                this.defaultVar = "/* Error: unknown datatype for \"" + this.name + "\" */";
            }
        } else if (!(this.argDataType.equals("int") || this.argDataType.equals("float") || this.argDataType.equals("string"))) {
            StringBuffer buf = new StringBuffer();
            String[] tokens = TextUtils.tokenize(this.defaultValue);
            if (tokens != null && tokens.length > 0) {
                for (int n = 0; n < tokens.length; ++n) {
                    buf.append(tokens[n]).append(",");
                }
                this.defaultValue = buf.toString();
                this.defaultValue = TextUtils.trimTrailingChar(this.defaultValue, ',');
            }
        }
        this.defaultVar = this.getMemberName() + "(" + this.defaultValue + ")";
        return this.defaultVar;
    }

    public String getRixType() {
        if (this.rixType.trim().length() > 0) {
            return this.rixType;
        }
        this.rixType = ArgsItem.rixTypeLookup(this.getArgDataType());
        return this.rixType;
    }

    public String getRtType() {
        if (this.rtType.trim().length() > 0) {
            return this.rtType;
        }
        this.rtType = ArgsItem.rtTypeLookup(this.getArgDataType());
        return this.rtType;
    }

    public void setArgDataType(String t) {
        this.argDataType = t.trim();
    }

    public String getArgDataType() {
        if (this.argDataType.trim().length() > 0) {
            return this.argDataType;
        }
        if (this.tags.trim().length() == 0) {
            return "";
        }
        String[] tokens = TextUtils.tokenize(this.tags, '|');
        if (tokens == null || tokens.length == 0) {
            return "";
        }
        return tokens[0];
    }

    private void setVariableName() {
        char c = this.name.charAt(0);
        this.variableName = !Character.isLowerCase(c) ? Character.toLowerCase(c) + this.name.substring(1) : this.name;
    }

    public String getPointerName() {
        String varPrefix = Preferences.get(Preferences.DEVKIT_VARYING_POINTER_PREFIX);
        String varSuffix = Preferences.get(Preferences.DEVKIT_VARYING_POINTER_SUFFIX);
        String uniPrefix = Preferences.get(Preferences.DEVKIT_UNIFORM_POINTER_PREFIX);
        String uniSuffix = Preferences.get(Preferences.DEVKIT_UNIFORM_POINTER_SUFFIX);
        varPrefix = varPrefix.trim();
        varSuffix = varSuffix.trim();
        uniPrefix = uniPrefix.trim();
        uniSuffix = uniSuffix.trim();
        return !this.connectable ? uniPrefix + this.variableName + uniSuffix : varPrefix + this.variableName + varSuffix;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("id: ").append(this.id).append("\n");
        b.append("    name: ").append(this.name).append("\n");
        b.append("    pageHolderName: ").append(this.pageHolderName).append("\n");
        b.append("    label: ").append(this.label).append("\n");
        b.append("    widget: ").append(this.widget).append("\n");
        b.append("    defaultValue: ").append(this.defaultValue).append("\n");
        b.append("    min: ").append(this.min).append("\n");
        b.append("    max: ").append(this.max).append("\n");
        b.append("    argDataType: ").append(this.getArgDataType()).append("\n");
        b.append("    tags: ").append(this.tags).append("\n");
        b.append("    connectable: ").append(this.connectable).append("\n");
        b.append("    rixType: ").append(this.rixType).append("\n");
        b.append("    rtType: ").append(this.rtType).append("\n");
        b.append("    rixIndexName: ").append(this.rixIndexName).append("\n");
        b.append("    variableName: ").append(this.variableName).append("\n");
        b.append("    pointerName: ").append(this.pointerName).append("\n");
        b.append("    insideLoopName: ").append(this.insideLoopName).append("\n");
        if (this.widget.equals("mapper") && this.mapperItems.size() > 0) {
            b.append("    mapperItems: ").append("\n");
            Enumeration<String> e = this.mapperItems.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                b.append(this.mapperItems.get(key)).append(" ");
            }
        }
        return b.toString();
    }
}

