/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsTokenizer;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class ArgsItemParser {
    public ArgsDB getDB(String allScript) {
        String[] lines = this.conformTags(allScript);
        if (lines == null || lines.length == 0) {
            return null;
        }
        ArgsDB argsDB = new ArgsDB();
        Vector<String> listOfLines = VectorUtils.toVector(lines);
        ArrayDeque<String> ad = new ArrayDeque<String>(listOfLines);
        String currentPageName = "";
        while (!ad.isEmpty()) {
            String tagline;
            ArgsItem item;
            String line = ad.pop();
            if (ArgsTokenizer.isOpenPageTag(line = line.trim())) {
                currentPageName = ArgsTokenizer.getPageName(line);
            }
            if (ArgsTokenizer.isOpenParamTag(line)) {
                item = new ArgsItem("input");
                item.pageHolderName = currentPageName;
                if (!ArgsTokenizer.getParamTagItems(line, item)) continue;
                if (item.widget.equals("mapper")) {
                    String ln;
                    while (!ad.isEmpty() && !ArgsTokenizer.getMapperLabels((ln = ad.pop()).trim(), item)) {
                    }
                }
                if (!ad.isEmpty() && ArgsTokenizer.isOpenTagsTag(ad.peek())) {
                    tagline = ad.pop();
                    while (!ArgsTokenizer.isCloseTagsTag(tagline)) {
                        this.setTagValue(item, tagline);
                        tagline = ad.pop();
                    }
                }
                argsDB.inputs.add(item);
                continue;
            }
            if (!ArgsTokenizer.isOpenOutputTag(line) || !ArgsTokenizer.getParamTagItems(line, item = new ArgsItem("output"))) continue;
            if (!ad.isEmpty() && ArgsTokenizer.isOpenTagsTag(ad.peek())) {
                tagline = ad.pop();
                while (!ArgsTokenizer.isCloseTagsTag(tagline)) {
                    this.setTagValue(item, tagline);
                    tagline = ad.pop();
                }
            }
            argsDB.outputs.add(item);
        }
        return argsDB;
    }

    private String preTokenizeCleanup(String tagline) {
        if (tagline == null || tagline.trim().length() == 0) {
            return "";
        }
        String s = tagline.replace('<', ' ');
        s = s.replace('>', ' ');
        s = s.replace('/', ' ');
        return TextUtils.replace(s, "=", " = ");
    }

    private void setTagValue(ArgsItem item, String line) {
        line = this.preTokenizeCleanup(line);
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        tok.setBuffer(line);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        while (!s.equals("")) {
            if (s.equalsIgnoreCase("tag")) {
                s = tok.getNextStr();
            }
            if (s.equalsIgnoreCase("<tags>") && tok.peekNextStr().equalsIgnoreCase("<tag")) {
                tok.getNextStr();
                s = tok.getNextStr();
            }
            if (s.equalsIgnoreCase("value") && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                String value = TextUtils.removeQuotes(tok.getNextStr());
                item.set("tag", value);
                if (value.equalsIgnoreCase("__noconnection")) {
                    item.connectable = false;
                    return;
                }
                if (item.getArgDataType().trim().length() == 0 && ArgsItem.isDataType(value)) {
                    item.setArgDataType(value);
                }
            }
            s = tok.getNextStr();
        }
    }

    private String[] conformTags(String script) {
        ArgsTokenizer tok = new ArgsTokenizer();
        tok.setDefaultDelimitors();
        tok.setBuffer(script);
        String s = tok.getNextStr();
        Vector<String> lines = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        while (!s.equals("")) {
            String[] parts;
            if (TextUtils.contains(s, '\n') && (parts = TextUtils.tokenize(s, '\n')) != null) {
                buf.setLength(0);
                for (int n = 0; n < parts.length; ++n) {
                    buf.append(parts[n].trim()).append(" ");
                }
                s = buf.toString();
            }
            lines.add(s);
            s = tok.getNextStr();
        }
        return VectorUtils.toStringArray(lines);
    }

    public class ArgsDB {
        public Vector<ArgsItem> inputs = new Vector();
        public Vector<ArgsItem> outputs = new Vector();
        private String argsFileName = "";
        private File argsFile = null;
        private File argsParentDir = null;
        private String cppClassName = "";

        public void setArgsFileName(String name) {
            this.argsFileName = name;
        }

        public String getArgsFileName() {
            return this.argsFileName;
        }

        public void setArgsFile(File f) {
            this.argsFile = f;
        }

        public File getArgsFile() {
            return this.argsFile;
        }

        public void setCppClassName(String name) {
            this.cppClassName = name;
        }

        public String getCppClassName() {
            return this.cppClassName;
        }

        public void setArgsParentDir(File d) {
            this.argsParentDir = d;
        }

        public File getArgsParentDir() {
            return this.argsParentDir;
        }

        public void resetDB() {
            this.inputs = new Vector();
            this.outputs = new Vector();
        }

        public String toString() {
            ArgsItem item;
            int n;
            StringBuffer b = new StringBuffer();
            b.append("INPUTS: ");
            for (n = 0; n < this.inputs.size(); ++n) {
                item = this.inputs.elementAt(n);
                b.append(item.toString());
            }
            b.append("\n");
            b.append("OUTPUTS: ");
            for (n = 0; n < this.outputs.size(); ++n) {
                item = this.outputs.elementAt(n);
                b.append(item.toString());
            }
            b.append("\n");
            return b.toString();
        }

        public ArgsItem getOutputOfType(String type) {
            for (int n = 0; n < this.outputs.size(); ++n) {
                ArgsItem item = this.outputs.elementAt(n);
                String t = item.getArgDataType();
                if (t == null) {
                    return null;
                }
                if (!t.equals(type)) continue;
                return item;
            }
            return null;
        }

        public ArgsItem getInputOfType(String type) {
            for (int n = 0; n < this.inputs.size(); ++n) {
                ArgsItem item = this.inputs.elementAt(n);
                String t = item.getArgDataType();
                if (t == null) {
                    return null;
                }
                if (!t.equals(type)) continue;
                return item;
            }
            return null;
        }
    }
}

