/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsSyntax;
import UI_Script.Args.ArgsTokenizer;
import UI_Script.Comment;
import UI_Script.Syntax;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import UI_Text.Style.StyleEdits;
import Utilities.DocumentUtils;
import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import kernal.Tokenizers.Tokenizer;

public class ArgsListener
extends SyntaxListener {
    private Syntax syntax = null;
    private String str = "";
    private int selectionOffset;
    private int selectionCount;
    private int index;
    private int begin;

    public ArgsListener(KTextPane textpane) {
        super(textpane, new ArgsTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        char[] begin = new char[]{'#'};
        textpane.removeWordDelimitors(begin, null);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_HTML_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_HTML_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_HTML_TAG_IMAGE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_HTML_TAG_HREF));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_HTML_TAG_GENERAL));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_HTML_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle1, false);
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, false);
        Color href = Preferences.getColor(Preferences.TEXT_COLOR_HTML_TAG_HREF);
        Color img = Preferences.getColor(Preferences.TEXT_COLOR_HTML_TAG_IMAGE);
        Color str = Preferences.getColor(Preferences.TEXT_COLOR_HTML_STRING);
        int[] hrefRGB = new int[3];
        int[] imgRGB = new int[3];
        int[] strRGB = new int[3];
        int[] imgStrRGB = new int[3];
        int[] hrefStrRGB = new int[3];
        strRGB[0] = str.getRed();
        strRGB[1] = str.getGreen();
        strRGB[2] = str.getBlue();
        hrefRGB[0] = href.getRed();
        hrefRGB[1] = href.getGreen();
        hrefRGB[2] = href.getBlue();
        imgRGB[0] = img.getRed();
        imgRGB[1] = img.getGreen();
        imgRGB[2] = img.getBlue();
        int maxHREFIndex = hrefRGB[0] > hrefRGB[1] ? 0 : 1;
        maxHREFIndex = hrefRGB[maxHREFIndex] > hrefRGB[2] ? maxHREFIndex : 2;
        int minHREFIndex = hrefRGB[0] < hrefRGB[1] ? 0 : 1;
        minHREFIndex = hrefRGB[maxHREFIndex] < hrefRGB[2] ? minHREFIndex : 2;
        int maxIMGIndex = imgRGB[0] > imgRGB[1] ? 0 : 1;
        maxIMGIndex = imgRGB[maxIMGIndex] > imgRGB[2] ? maxIMGIndex : 2;
        int minIMGIndex = imgRGB[0] < imgRGB[1] ? 0 : 1;
        minIMGIndex = imgRGB[minIMGIndex] < imgRGB[2] ? minIMGIndex : 2;
        int hdiff = hrefRGB[maxHREFIndex] - hrefRGB[minHREFIndex];
        int idiff = imgRGB[maxIMGIndex] - imgRGB[minIMGIndex];
        for (int n = 0; n < 3; ++n) {
            imgStrRGB[n] = strRGB[n];
            hrefStrRGB[n] = strRGB[n];
        }
        int n = maxIMGIndex;
        imgStrRGB[n] = imgStrRGB[n] + idiff / 4;
        int n2 = maxHREFIndex;
        hrefStrRGB[n2] = hrefStrRGB[n2] + hdiff / 4;
        if (imgStrRGB[maxIMGIndex] > 255) {
            imgStrRGB[maxIMGIndex] = 255;
        }
        if (hrefStrRGB[maxHREFIndex] > 255) {
            hrefStrRGB[maxHREFIndex] = 255;
        }
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, new Color(imgStrRGB[0], imgStrRGB[1], imgStrRGB[2]));
        StyleConstants.setForeground(textpane.styleContext.stringStyle3, new Color(hrefStrRGB[0], hrefStrRGB[1], hrefStrRGB[2]));
    }

    @Override
    protected Syntax getSyntax(Document doc, Tokenizer tok, int preUpdate, int postUpdate) {
        return new ArgsSyntax(doc, tok, preUpdate, postUpdate);
    }

    @Override
    protected synchronized void parse(Segment segment, int offset) {
        if (!this.doColoration || segment == null || segment.count == 0) {
            return;
        }
        this.tok.setBuffer(segment);
        this.str = this.tok.getNextStr();
        if (this.str == null) {
            Cutter.setLog("HTMLSyntaxListener.parse() - initial getNextStr() returned a null string");
            return;
        }
        this.editList = new StyleEdits(this);
        while (!this.str.equals("")) {
            this.index = this.tok.getBufferIndex() - 1 < 0 ? 0 : this.tok.getBufferIndex();
            this.index += offset;
            this.begin = this.index - this.str.length();
            if (this.tok.isComment(this.str)) {
                this.editList.addEdit(this.begin, this.str.length(), this.textpane.styleContext.commentStyle1, true);
            } else if (ArgsTokenizer.isOpenParamTag(this.str) || ArgsTokenizer.isCloseParamTag(this.str)) {
                this.colorInnerQuotes(this.editList, this.str, this.begin, this.textpane.styleContext.keywordStyle1, this.textpane.styleContext.plainStyle);
            } else if (ArgsTokenizer.isOpenOutputTag(this.str) || ArgsTokenizer.isCloseOutputTag(this.str)) {
                this.colorInnerQuotes(this.editList, this.str, this.begin, this.textpane.styleContext.keywordStyle2, this.textpane.styleContext.plainStyle);
            } else if (ArgsTokenizer.isArgsFormatTag(this.str)) {
                this.colorInnerQuotes(this.editList, this.str, this.begin, this.textpane.styleContext.keywordStyle2, this.textpane.styleContext.plainStyle);
            } else if (ArgsTokenizer.isTag(this.str)) {
                this.colorInnerQuotes(this.editList, this.str, this.begin, this.textpane.styleContext.keywordStyle3, this.textpane.styleContext.plainStyle);
            } else {
                this.editList.addEdit(this.begin, this.str.length(), this.textpane.styleContext.plainStyle, true);
            }
            this.str = this.tok.getNextStr();
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArgsListener.this.editList.applyEdits((DefaultStyledDocument)ArgsListener.this.textpane.getDocument());
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected int[] getInsertParseSpan(DocumentEvent evt, Syntax syntax) {
        String inserted;
        int updateAt = evt.getOffset();
        int begin = syntax.beginParse;
        int end = -1;
        int docLength = this.textpane.getDocument().getLength();
        if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 0) {
            this.msg.append("[PLAIN/PLAIN HTML] insertion at " + updateAt);
            begin = updateAt;
            inserted = this.getStringFromTo(updateAt, updateAt + evt.getLength());
            if (updateAt == 0) {
                end = this.findLineEnd(updateAt + evt.getLength());
            } else if (inserted != null && this.containsOpenTag(inserted)) {
                begin = updateAt;
                end = this.findClosingTag(updateAt + evt.getLength());
            } else {
                int tag;
                end = this.findWordBreak(updateAt + evt.getLength(), this.findLineEnd(updateAt + evt.getLength()));
                if (end > (tag = this.findOpeningTag(updateAt))) {
                    end = tag;
                }
            }
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 10 || syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 0 || syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 10) {
            this.msg.append("[PLAIN/STRING or STRING/PLAIN HTML or STRING/STRING] ");
            begin = updateAt;
            end = updateAt + evt.getLength();
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            this.msg.append("[STRING/TAG HTML] (string) insertion within a tag ");
            begin = ((ArgsSyntax)syntax).tagOpenAt;
            end = this.findClosingTag(updateAt + evt.getLength());
        } else if (syntax.preUpdateStyleID == ArgsSyntax.TAG_ID && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            begin = ((ArgsSyntax)syntax).tagOpenAt;
            end = this.findClosingTag(updateAt + evt.getLength());
            this.msg.append("[TAG/TAG HTML] insertion within a tag ");
        } else if (syntax.preUpdateStyleID == ArgsSyntax.TAG_ID && syntax.postUpdateStyleID == 0) {
            begin = ((ArgsSyntax)syntax).tagOpenAt;
            end = this.findClosingTag(updateAt + evt.getLength());
            this.msg.append("[TAG/PLAIN HTML] close tag insertion ");
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            inserted = this.getStringFromTo(updateAt, updateAt + evt.getLength());
            if (inserted != null && this.containsOpenTag(inserted)) {
                begin = updateAt;
                end = this.findClosingTag(updateAt + evt.getLength());
                this.msg.append("[PLAIN/TAG HTML] open tag inserted ");
            } else {
                int tag;
                end = this.findWordBreak(updateAt, this.findLineEnd(updateAt));
                if (end > (tag = this.findOpeningTag(updateAt))) {
                    end = tag;
                }
                this.msg.append("[PLAIN/TAG HTML] ");
            }
        } else {
            return super.getInsertParseSpan(evt, syntax);
        }
        end = end == -1 ? docLength : end;
        int[] out = new int[]{begin, end};
        return out;
    }

    @Override
    protected int[] getRemoveParseSpan(DocumentEvent evt, Syntax syntax) {
        String strRemoved = this.textpane.stringRemoved();
        if (strRemoved == null || strRemoved.length() == 0) {
            return null;
        }
        int begin = syntax.beginParse;
        int end = -1;
        int updateAt = evt.getOffset();
        int docLength = this.textpane.getDocument().getLength();
        if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            this.msg.append("[STRING/TAG HTML] ");
            begin = ((ArgsSyntax)syntax).tagOpenAt;
            end = this.findClosingTag(updateAt);
        } else if (syntax.preUpdateStyleID == 10 && syntax.postUpdateStyleID == 10) {
            this.msg.append("[STRING/STRING HTML] ");
            end = this.findWordBreak(updateAt, this.findLineEnd(updateAt));
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 10) {
            this.msg.append("[TAG/TAG HTML] (string) removed part of a tag");
            end = this.findWordBreak(updateAt, this.findLineEnd(updateAt));
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            int tag;
            end = this.findWordBreak(updateAt, this.findLineEnd(updateAt));
            if (end > (tag = this.findOpeningTag(updateAt))) {
                end = tag;
            }
            this.msg.append("[PLAIN/TAG HTML] ");
        } else if (syntax.preUpdateStyleID == ArgsSyntax.TAG_ID && syntax.postUpdateStyleID == ArgsSyntax.TAG_ID) {
            Comment cmnt = new Comment("<!--", "-->");
            begin = ((ArgsSyntax)syntax).tagOpenAt;
            if (this.tok.isPartialOpenComment(strRemoved)) {
                this.msg.append("[TAG/TAG HTML] removed part of an open comment");
                end = syntax.findClosingComment(cmnt, updateAt);
            } else {
                this.msg.append("[TAG/TAG HTML] within tag removal ");
                end = this.findClosingTag(updateAt);
            }
        } else if (syntax.preUpdateStyleID == 0 && syntax.postUpdateStyleID == 0) {
            Comment cmnt = new Comment("<!--", "-->");
            cmnt = this.openCmntRemoved(updateAt);
            if (cmnt != null) {
                this.msg.append("[PLAIN/PLAIN HTML] removed open comment");
                end = syntax.findClosingComment(cmnt, updateAt + 1);
            } else if (new Comment("<!--", "-->").isPartialOpenComment(strRemoved)) {
                this.msg.append("[PLAIN/PLAIN HTML] removed part of an open comment] ");
                end = this.findOpeningTag(updateAt);
            } else if (this.containsOpenTag(strRemoved)) {
                this.msg.append("[PLAIN/PLAIN HTML] removed open tag] ");
                end = this.findOpeningTag(updateAt);
            } else {
                this.msg.append("[PLAIN/PLAIN HTML] ");
                end = this.findWordBreak(updateAt, this.findLineEnd(updateAt));
                int tag = this.findOpeningTag(updateAt);
                if (end > tag) {
                    end = tag;
                }
            }
        } else {
            return super.getRemoveParseSpan(evt, syntax);
        }
        end = end == -1 ? docLength : end;
        int[] out = new int[]{begin, end};
        return out;
    }

    protected boolean containsOpenTag(String src) {
        return src.indexOf(60) != -1;
    }

    protected void colorInnerQuotes(StyleEdits edit, String str, int begin, Style basestyle, Style stringstyle) {
        boolean quotes = false;
        int prev = 0;
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) == '\"' && !quotes) {
                edit.addEdit(begin + prev, n - prev, basestyle, true);
                prev = n;
                quotes = true;
                continue;
            }
            if (str.charAt(n) != '\"' || !quotes) continue;
            edit.addEdit(begin + prev, n - prev + 1, stringstyle, true);
            prev = n + 1;
            quotes = false;
        }
        edit.addEdit(begin + prev, str.length() - prev, basestyle, true);
    }

    protected int findOpeningTag(int begin) {
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, this.textpane.getDocument().getLength() - begin);
        for (int n = 0; n < this.segment.count; ++n) {
            char c0 = this.segment.array[n + this.segment.offset];
            if (c0 != '<') continue;
            return begin + n;
        }
        return -1;
    }

    protected int findClosingTag(int begin) {
        this.segment = DocumentUtils.getSegment(this.textpane.getDocument(), begin, this.textpane.getDocument().getLength() - begin);
        for (int n = 0; n < this.segment.count; ++n) {
            char c0 = this.segment.array[n + this.segment.offset];
            if (c0 != '>') continue;
            return begin + n + 1;
        }
        return -1;
    }

    private int[] getEnclosingTag(DocumentEvent evt) {
        int relativeIndex;
        int n;
        int tagBegin = -1;
        int tagEnd = -1;
        int updateAt = evt.getOffset();
        Segment segment = new Segment();
        int[] out = new int[2];
        int segmentBegin = DocumentUtils.getSegment(this.textpane.getDocument(), evt, segment);
        if (segment == null) {
            return null;
        }
        for (n = relativeIndex = updateAt - segmentBegin; n >= 0 && tagBegin == -1; --n) {
            if (segment.array[n + segment.offset] != '<') continue;
            tagBegin = n;
        }
        for (n = relativeIndex; n < segment.count && tagEnd == -1; ++n) {
            if (segment.array[n + segment.offset] != '>') continue;
            tagEnd = ++n;
            break;
        }
        out[0] = tagBegin == -1 ? -1 : segmentBegin + tagBegin;
        out[1] = tagEnd == -1 ? -1 : segmentBegin + tagEnd;
        return out;
    }

    private int findNextTag(DocumentEvent evt) {
        int relativeAt;
        Segment segment = new Segment();
        int segmentBegin = DocumentUtils.getSegment(this.textpane.getDocument(), evt, segment);
        int updateAt = evt.getOffset();
        if (segment == null) {
            return -1;
        }
        for (int n = relativeAt = updateAt - segmentBegin; n < segment.count; ++n) {
            if (segment.array[n + segment.offset] != '<') continue;
            return n + segmentBegin;
        }
        return -1;
    }
}

