/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgNodeidData;
import UI_Tools.Rman.RenderInfo;
import Utilities.ArgsUtils;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtilsDB;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;

public class ArgsNodeIdInfo {
    private static Vector<File> getArgsFilesInUseBy22() {
        String argsDirPath = Preferences.get(Preferences.PATH_USER_ARGS);
        if (argsDirPath.trim().length() == 0) {
            Cutter.setLog("    Debug:ArgsNodeIdInfo.getArgsFilesInUseBy22() - argsDirPath is an empty string");
            return null;
        }
        if (!new File(argsDirPath).exists()) {
            Cutter.setLog("    Debug:ArgsNodeIdInfo.getArgsFilesInUseBy22() - argsDirPath \"" + argsDirPath + "\" does not exist.");
            return null;
        }
        String[] ext = new String[]{".args"};
        String[] names = FileUtils.getListOfFileNames(new File(argsDirPath), ext);
        if (names == null || names.length == 0) {
            return null;
        }
        Vector<File> listOfArgsFiles = new Vector<File>();
        for (int n = 0; n < names.length; ++n) {
            listOfArgsFiles.add(new File(argsDirPath, names[n]));
        }
        return listOfArgsFiles;
    }

    public static Vector<File> getArgsFilesInUse() {
        if (RenderInfo.prmanMajorVersionNumber() >= 22) {
            return ArgsNodeIdInfo.getArgsFilesInUseBy22();
        }
        String inipath = Preferences.get(Preferences.PATH_USER_RFM_INI);
        if (inipath.trim().length() == 0 || !new File(inipath).exists()) {
            return null;
        }
        String argspath = Preferences.get(Preferences.PATH_USER_ARGS);
        if (argspath.trim().length() == 0 || !new File(argspath).exists()) {
            return null;
        }
        File iniFile = ArgsUtils.getRfM_iniFile();
        if (iniFile == null) {
            return null;
        }
        Vector<File> listOfArgsFiles = ArgsUtils.getListOfArgFiles(iniFile);
        if (listOfArgsFiles == null) {
            return null;
        }
        Vector<File> badfiles = new Vector<File>();
        Vector<File> temp = new Vector<File>();
        for (int n = 0; n < listOfArgsFiles.size(); ++n) {
            File ff = listOfArgsFiles.elementAt(n);
            if (!ff.exists()) {
                badfiles.add(ff);
                continue;
            }
            temp.add(ff);
        }
        listOfArgsFiles = VectorUtils.copyFiles(temp);
        if (listOfArgsFiles == null || listOfArgsFiles.size() == 0) {
            String[] ext = new String[]{".args"};
            String[] paths = FileUtils.getListOfFileNames(new File(argspath), ext);
            listOfArgsFiles = new Vector();
            for (int n = 0; n < paths.length; ++n) {
                listOfArgsFiles.add(new File(argspath, paths[n]));
            }
        }
        return listOfArgsFiles;
    }

    public static String writeReport(Vector<File> listOfArgsFiles, MayaNodeIdUtilsDB mayaNodeDB) {
        StringBuffer buf = new StringBuffer();
        StringBuffer header = new StringBuffer();
        String inipath = Preferences.get(Preferences.PATH_USER_RFM_INI);
        File rfmIniFile = new File(inipath);
        Vector<ArgNodeidData> listOfIniArgData = ArgNodeidData.getInstances(listOfArgsFiles);
        if (listOfIniArgData == null) {
            Cutter.setLog("    Info: ArgReportAction.generateReport() - listOfIniArgData is null");
            String errorMsg = "";
            if (RenderInfo.rfmMajorVersionNumber() < 22) {
                return "Unable to read any .args files. The paths to the:\n    Args dir\n    Plugins dir, and\n    RenderMan_for_Maya.ini\nMust be set correctly in Preferences.\n";
            }
            return "Unable to read any .args files. The paths to the:\n    Args dir and the\n    nodes dir, and\nMust be set correctly in Preferences.\n";
        }
        Vector<File> listOfBadArgFiles = ArgsUtils.listOfBadArgFiles(listOfArgsFiles);
        header.append("--------------------------------------------------------------\n");
        header.append("PIXAR RENDERMAN PLUGINS\n");
        header.append("Custom nodes written in the c++ language such as patterns,\n");
        header.append("bxdfs and filters have corresponding \"args\" files. Each args\n");
        if (RenderInfo.rfmMajorVersionNumber() < 22) {
            header.append("file must specify a unique \"nodeid\". Nodeids are registered\n");
            header.append("with Maya by the users custom \"RenderMan_for_Maya.ini\" file.\n\n");
            header.append("This report about c++ plugins is based on the following ini file:\n");
            header.append(rfmIniFile.getParent() + "/RenderMan_for_Maya.ini\n\n");
        } else {
            header.append("file must specify a unique \"nodeid\".\n");
            header.append("This report about c++ plugins is based .args files found in:\n");
            String argsDirPath = Preferences.get(Preferences.PATH_USER_ARGS);
            header.append("    \"" + argsDirPath + "\"\n\n");
        }
        if (listOfBadArgFiles.size() > 0) {
            for (int n = 0; n < listOfBadArgFiles.size(); ++n) {
                header.append("Info: Ignoring the .args file : " + listOfBadArgFiles.elementAt(n) + "\n");
            }
            header.append("\n");
        }
        header.append("Nodeid's assigned to the users args files:\n");
        String pupPath = Preferences.get(Preferences.PATH_USER_PLUGINS);
        String pupParent = null;
        if (!pupPath.equals("")) {
            File pupDir = new File(pupPath);
            pupParent = pupDir.getName();
        }
        String argspath = Preferences.get(Preferences.PATH_USER_ARGS);
        for (int n = 0; n < listOfIniArgData.size(); ++n) {
            String tabStr;
            ArgNodeidData nd = listOfIniArgData.elementAt(n);
            mayaNodeDB.addItem(nd.nodeid, nd.argfile.getName() + ".args", argspath);
            String string = tabStr = nd.nodeidInt > 99 ? "\t\"" : "\t\t\"";
            if (pupParent == null) {
                buf.append(nd.nodeid).append(":").append(tabStr).append(nd.argfile.getName()).append("\"\n");
                continue;
            }
            buf.append(nd.nodeid).append(":").append(tabStr).append(nd.argfile.getName()).append("\"\n");
        }
        if (buf.length() > 0) {
            header.append(buf);
        }
        return header.toString();
    }
}

