/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Args.ArgNodeidData;
import UI_Script.Args.ArgsTokenizer;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Rman.RenderInfo;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.ArgsUtils;
import Utilities.DialogUtils;
import Utilities.FileUtils;
import Utilities.MayaNodeIdUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public class ArgsRegAction
implements ActionListener {
    static final String[] msgNoArgsDir = new String[]{"Registration of a RIS pattern plugin can only be  ", "done if the path to RIS pattern .args files are set  ", "in the Preferences Tool->Rman->User panel."};
    static final String[] msgAreadyReg = new String[]{"The Plugin is already registered. "};
    static final String[] msgNodeidOK = new String[]{"The plugin has been registered with the users custom ", "\"RenderMan_for_Maya.ini\" file."};
    static final String[] msgRegistered = new String[]{"The plugin has been registered with the users custom ", "\"RenderMan_for_Maya.ini\" file."};
    static final String[] msgNotRegistered = new String[]{"The plugin has NOT been registered with the users   ", "custom \"RenderMan_for_Maya.ini\" file. "};
    static final String[] msgArgsReadErr = new String[]{"Cannot find \"<rfmdata nodeid\" tag. Check the  ", "formatting of the args document.  "};
    static final String[] msgArgsWriteErr = new String[]{"An error occured when writing the value of the .args  ", "file \"<rfmdata nodeid\" tag. Carefully check the  ", "formatting of the .args document.  "};
    static final String[] msgIllegalID = new String[]{"The following .args files registered by the ", "\"RenderMan_for_Maya.ini\" file use nodeids  ", "less than the minimum nodeid specified in prefs."};
    static final String[] msgBadArgsFile = new String[]{"The \"RenderMan_for_Maya.ini\" file refers to ", "the following non-existant .args files:"};
    static final String[] msgNoIniFile = new String[]{"The path to the users \"RenderMan_for_Maya.ini\"  ", "file does not exist. The path must be set it the:", "    Preferences Tool->Rman->User panel."};
    public static String userArgsDir;
    private KTextPane textpane;

    public ArgsRegAction(KTextPane textpane) {
        this.textpane = textpane;
    }

    private String[] getDuplicateRegistrationMsg(int num) {
        String[] msg = new String[]{"Several plugins have the same \"nodeid\" registration values.  ", "The value of a \"nodeid\" can only be used once. "};
        return msg;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int id;
        int[] ids;
        Vector<File> listOfBadIniFiles;
        Vector<ArgNodeidData> listOfIniArgsData;
        Vector<File> listOfIniArgsFiles;
        String argspath = Preferences.get(Preferences.PATH_USER_ARGS);
        if (argspath.trim().length() == 0 || !new File(argspath).exists()) {
            DialogUtils.showErrorMessage("Preferences Error", msgNoArgsDir);
            return;
        }
        File argsDir = new File(argspath);
        File desktopArgsFile = BBxt.getWindowFile();
        ArgNodeidData desktopArgData = ArgNodeidData.getInstance(desktopArgsFile);
        if (desktopArgData == null) {
            DialogUtils.showErrorMessage("", msgArgsReadErr);
            return;
        }
        File iniFile = null;
        if (RenderInfo.prmanMajorVersionNumber() >= 22) {
            String[] names = FileUtils.getListOfFileNames(argsDir, ".args");
            listOfIniArgsFiles = new Vector();
            if (names != null || names.length > 0) {
                for (int n = 0; n < names.length; ++n) {
                    listOfIniArgsFiles.add(new File(argsDir, names[n]));
                }
            }
        } else {
            iniFile = ArgsUtils.getRfM_iniFile();
            if (iniFile == null) {
                DialogUtils.showErrorMessage("Preferences Error", msgNoIniFile);
                return;
            }
            listOfIniArgsFiles = ArgsUtils.getListOfArgFiles(iniFile);
            if (listOfIniArgsFiles.size() == 0) {
                Cutter.setLog("    Debug:ArgsRegAction.actionPerformed() - no LoadExtension args found in .ini file.");
                Cutter.setLog("          " + desktopArgData.toFullString());
                ArgNodeidData.updateIniFile(iniFile, desktopArgData);
                DialogUtils.showInfoMessage("Plugin has been Registered", msgRegistered);
                return;
            }
        }
        if ((listOfIniArgsData = ArgNodeidData.getInstances(listOfIniArgsFiles)) == null || listOfIniArgsData.size() == 0) {
            // empty if block
        }
        if ((listOfBadIniFiles = ArgsUtils.listOfBadArgFiles(listOfIniArgsFiles)) != null && listOfBadIniFiles.size() > 0) {
            File[] files = VectorUtils.toFileArray(listOfBadIniFiles);
            String[] filenames = FileUtils.toNamesArray(files, false);
            String[] msg = VectorUtils.toStringArray(msgBadArgsFile, filenames);
            DialogUtils.showErrorMessage("Non-Existant .args Error", msg);
            MayaNodeIdUtils.writeFullReport();
            return;
        }
        Vector<ArgNodeidData> listOfDupIniData = ArgsUtils.getDuplicateNodeids(desktopArgData, listOfIniArgsData);
        if (listOfDupIniData != null && listOfDupIniData.size() == 2 && desktopArgData.dupfile != null) {
            int[] ids2 = MayaNodeIdUtils.getAllUsedNodeIds();
            int id2 = MayaNodeIdUtils.getFirstAvailable(ids2);
            desktopArgData.nodeid = id2 + "";
            boolean success = ArgNodeidData.updateArgsFile(desktopArgData, this.textpane);
            if (success && RenderInfo.prmanMajorVersionNumber() < 22) {
                ArgNodeidData.updateIniFile(iniFile, desktopArgData);
            }
            if (success) {
                DialogUtils.showInfoMessage("Plugin has been Registered", msgRegistered);
                KAbstractWindow argswindow = KAbstractDesktop.getWindowWithFile(desktopArgsFile);
                argswindow.saveFile(1);
            }
            return;
        }
        if (listOfDupIniData != null && listOfDupIniData.size() > 0) {
            String[] msg = this.getDuplicateRegistrationMsg(listOfDupIniData.size());
            DialogUtils.showErrorMessage("Duplicate \"nodeid\" Error", msg);
            MayaNodeIdUtils.writeFullReport();
            return;
        }
        int min = MayaNodeIdUtils.getMinNodeId();
        Vector<File> illegals = ArgsUtils.getFilesWithNodeidLessThan(min, listOfIniArgsData);
        if (illegals != null && illegals.size() == 1 && illegals.elementAt(0).getPath().equals(desktopArgData.argfilePath)) {
            ids = MayaNodeIdUtils.getAllUsedNodeIds();
            id = MayaNodeIdUtils.getFirstAvailable(ids);
            desktopArgData.nodeid = id + "";
        } else if (illegals != null && illegals.size() > 0) {
            File[] files = VectorUtils.toFileArray(illegals);
            String[] filenames = FileUtils.toNamesArray(files, false);
            String[] msg = VectorUtils.toStringArray(msgIllegalID, filenames);
            DialogUtils.showErrorMessage("Illegal \"nodeid\" Value", msg);
            MayaNodeIdUtils.writeFullReport();
            return;
        }
        ids = MayaNodeIdUtils.getAllUsedNodeIds();
        id = MayaNodeIdUtils.getFirstAvailable(ids);
        desktopArgData.nodeid = id + "";
        if (desktopArgData.nodeid == null) {
            DialogUtils.showErrorMessage("Plugin Not Registered", msgNotRegistered);
            MayaNodeIdUtils.writeFullReport();
            return;
        }
        if (!ArgNodeidData.updateArgsFile(desktopArgData, this.textpane)) {
            DialogUtils.showErrorMessage("Cannot Edit the .args Doc", msgArgsWriteErr);
            return;
        }
        if (ArgNodeidData.entryExistsInList(desktopArgData, listOfIniArgsData)) {
            DialogUtils.showInfoMessage("Plugin has been Registered", msgRegistered);
            KAbstractWindow argswindow = KAbstractDesktop.getWindowWithFile(desktopArgsFile);
            argswindow.saveFile(1);
            return;
        }
        if (RenderInfo.prmanMajorVersionNumber() < 22) {
            if (ArgNodeidData.updateIniFile(iniFile, desktopArgData)) {
                DialogUtils.showInfoMessage("Plugin has been Registered", msgRegistered);
                KAbstractWindow argswindow = KAbstractDesktop.getWindowWithFile(desktopArgsFile);
                argswindow.saveFile(1);
            } else {
                DialogUtils.showErrorMessage("Plugin Registered Error", msgNotRegistered);
            }
        }
    }

    private boolean __setNodeid(String str) {
        ArgsTokenizer tok = new ArgsTokenizer();
        tok.setDefaultDelimitors();
        tok.setBuffer(this.textpane.getText());
        String s = tok.getNextStr();
        while (!s.equals("")) {
            if ((s = s.toLowerCase()).startsWith("<rfmdata")) {
                int lineOffset = tok.getBufferIndex() - s.length();
                int openQuote = s.indexOf(34);
                if (openQuote == 0) {
                    Cutter.setLog("    Warning: IDSynchronizer.actionPerformed() - cannot find openQuote.");
                    return false;
                }
                int closeQuote = s.indexOf(34, openQuote + 1);
                if (closeQuote == 0) {
                    Cutter.setLog("    Warning: IDSynchronizer.actionPerformed() - cannot find closeQuote.");
                    return false;
                }
                int begin = lineOffset + openQuote + 1;
                int end = lineOffset + closeQuote;
                this.textpane.select(begin, end);
                BBxt.replaceSelection(str);
            }
            s = tok.getNextStr();
        }
        return true;
    }
}

