/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Args;

import UI_Desktop.Cutter;
import UI_Script.Args.ArgsItem;
import UI_Script.Args.ArgsItemParser;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.TextUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class ArgsTokenizer
extends Tokenizer {
    public static final double version = 1.0;
    public static final int COMMENT = 5;
    public static final int TAG = 6;
    public static final int NEWLINE = 7;
    public static final String[] SHADER_TYPE_NAMES = new String[]{"bxdf", "displacement", "displayfilter", "integrator", "light", "lightfilter", "pattern", "projection", "samplefilter"};
    public boolean ignoreTags = false;
    private Hashtable<String, String> tableOfPageNames = new Hashtable();
    String lastProcName = "";

    public ArgsTokenizer() {
        this.addComment("<!--", "-->");
        this.setSyntaxLength(4);
        String[] ext = new String[]{"args", "ARGS"};
        Tokenizer.addToRegistry(ArgsTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    private ArgsTokenizer(String path) throws FileNotFoundException, IOException {
        super(path);
        this.addComment("<!--", "-->");
        this.setSyntaxLength(4);
        String[] ext = new String[]{"args", "ARGS"};
        Tokenizer.addToRegistry(ArgsTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean lpGetClassInterfaceSpans() {
        ArgsItem item;
        int n;
        if (this.getBufferLength() <= 0) {
            return false;
        }
        this.tableOfPageNames.clear();
        ArgsItemParser p = new ArgsItemParser();
        ArgsItemParser.ArgsDB database = p.getDB(new String(this.getBuffer()));
        if (database == null) {
            return false;
        }
        for (n = 0; n < database.inputs.size(); ++n) {
            item = database.inputs.elementAt(n);
            this.tableOfPageNames.put(item.name, TextUtils.removeQuotes(item.pageHolderName));
        }
        for (n = 0; n < database.outputs.size(); ++n) {
            item = database.outputs.elementAt(n);
            this.tableOfPageNames.put(item.name, "OUTPUT");
        }
        return true;
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        int endIndex = this.getBufferIndex();
        int beginIndex = endIndex - str.length();
        if (token != null && token.length >= 2 && (token[0].equalsIgnoreCase("param") || token[0].equalsIgnoreCase("output") && token[1].equalsIgnoreCase("name"))) {
            this.setBufferIndex(beginIndex);
            char c = this.readChar();
            boolean found = false;
            while (c != '\u0000') {
                if (c == '\"') {
                    found = true;
                    break;
                }
                if (c == '>') break;
                c = this.readChar();
            }
            if (!found) {
                this.setBufferIndex(endIndex);
            }
            ProcDBItem out = new ProcDBItem();
            out.procNameOffset[0] = this.getBufferIndex();
            found = false;
            c = this.readChar();
            while (c != '\u0000') {
                if (c == '\"') {
                    found = true;
                    break;
                }
                if (c == '>') break;
                c = this.readChar();
            }
            if (!found) {
                this.setBufferIndex(endIndex);
            }
            out.procNameOffset[1] = this.getBufferIndex() - 1;
            int b = out.procNameOffset[0] - beginIndex;
            int e = out.procNameOffset[1] - beginIndex;
            if (b < 0 || e < b) {
                return null;
            }
            out.procName = str.substring(b, e);
            if (out.procName.equalsIgnoreCase(this.lastProcName)) {
                return null;
            }
            this.lastProcName = out.procName;
            String pagename = this.tableOfPageNames.get(out.procName);
            if (pagename != null && pagename.length() > 0) {
                out.procName = pagename + "::" + out.procName;
            }
            out.procOffset[0] = out.procNameOffset[0];
            out.procOffset[1] = out.procNameOffset[1];
            return out;
        }
        this.setBufferIndex(endIndex);
        return null;
    }

    public static boolean isHTTP(String path) {
        return path.startsWith("http:");
    }

    @Override
    public void setBuffer(String inStr) {
        super.setBuffer(inStr);
        this.getCR_Newlines = false;
    }

    public static int isOfType(String str) {
        boolean isHtmlComment = false;
        int len = str.length();
        if (len == 0) {
            return 0;
        }
        int n = 0;
        if (str.charAt(n) == '<') {
            if (str.charAt(n + 1) == '!' && str.charAt(n + 2) == '-' && str.charAt(n + 3) == '-') {
                isHtmlComment = true;
            }
            while (str.charAt(n) != '>') {
                if (++n != len) continue;
                System.out.println("error2");
                return 0;
            }
            if (isHtmlComment) {
                return 5;
            }
            return 6;
        }
        return Tokenizer.isOfType(str);
    }

    public String getShaderType() {
        int begin = this.findTag("<shaderType>", 0, true);
        if (begin == -1) {
            if (this.filepath != null) {
                // empty if block
            }
            return null;
        }
        int end = this.findTag("</shaderType>", begin, false);
        if (end == -1) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - cannot find </shaderType>");
            return null;
        }
        char[] chars = this.getBuffer(begin, end - 1);
        if (chars == null) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - cannot find tag");
            return null;
        }
        String tag = new String(chars).trim();
        if (!tag.trim().startsWith("<") || !tag.trim().endsWith(">")) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - 1 " + tag);
            return null;
        }
        String[] tokens = TextUtils.tokenize(tag, '=');
        if (tokens == null || tokens.length < 2 || !tokens[0].trim().endsWith("value")) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - 2 " + tag);
            return null;
        }
        tokens[1] = tokens[1].trim();
        if (tokens[1].length() < 4) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - 3 " + tag);
            return null;
        }
        String out = tokens[1].substring(1);
        int index = out.indexOf(34);
        if (index == -1) {
            Cutter.setLog("    Debug:ArgsTokenizer.getShaderType() - 4 " + tag);
            return null;
        }
        return out.substring(0, index);
    }

    public static boolean isOpenOutputTag(String str) {
        String s = str.replace('<', ' ').trim();
        return s.startsWith("output");
    }

    public static boolean isCloseOutputTag(String str) {
        String s = str.replace('<', ' ').trim();
        return s.startsWith("/output");
    }

    public static boolean getParamTagItems(String str, ArgsItem item) {
        if (str == null || str.trim().length() == 0) {
            return false;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        boolean isValidItem = false;
        while (!s.equals("")) {
            String value;
            int tempIndex = tok.getBufferIndex();
            if (s.equalsIgnoreCase("tag")) {
                if (tok.peekNextStr().equals("=")) {
                    tok.getNextStr();
                    value = tok.getNextStr();
                    String[] tokens = TextUtils.tokenize(value, " |");
                    if (tokens != null && tokens.length > 0) {
                        item.set("tag", tokens[0]);
                    }
                } else {
                    if (tok.peekNextStr().equals("value")) {
                        tempIndex = tok.getBufferIndex();
                        s = tok.getNextStr();
                        value = tok.getNextStr();
                        item.set("tag", value);
                        return isValidItem;
                    }
                    tok.setBufferIndex(tempIndex);
                }
            } else if ((s.equalsIgnoreCase("name") || s.equalsIgnoreCase("type") || s.equalsIgnoreCase("default") || s.equalsIgnoreCase("input") || s.equalsIgnoreCase("connectable") || s.equalsIgnoreCase("label") || s.equalsIgnoreCase("widget") || s.equalsIgnoreCase("min") || s.equalsIgnoreCase("max")) && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                value = tok.getNextStr();
                if (!value.equals("")) {
                    item.set(s, value);
                    isValidItem = true;
                } else {
                    isValidItem = false;
                }
            }
            s = tok.getNextStr();
        }
        return isValidItem;
    }

    public static boolean getMapperLabels(String line, ArgsItem item) {
        String name_value = null;
        String int_value = null;
        if (line == null || line.trim().length() == 0) {
            return true;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        line = line.replace('<', ' ');
        line = line.replace('>', ' ');
        line = line.replace('/', ' ');
        line = TextUtils.replace(line, "=", " = ");
        tok.setBuffer(line);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        while (!s.equals("")) {
            String value;
            if (s.equalsIgnoreCase("name")) {
                tok.getNextStr();
                value = tok.getNextStr();
                if (!value.equals("")) {
                    name_value = TextUtils.removeQuotes(value);
                }
            }
            if (s.equalsIgnoreCase("value")) {
                tok.getNextStr();
                value = tok.getNextStr();
                if (!value.equals("")) {
                    int_value = TextUtils.removeQuotes(value);
                }
            }
            if (s.equalsIgnoreCase("param")) {
                return true;
            }
            if (name_value != null && int_value != null) {
                item.mapperItems.put(int_value, name_value);
            }
            s = tok.getNextStr();
        }
        return false;
    }

    public static String getParamTagName(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        if (token.length >= 2 && token[0].equalsIgnoreCase("param") && token[1].equalsIgnoreCase("name")) {
            return token[1];
        }
        return null;
    }

    public static boolean isArgsFormatTag(String str) {
        String[] token = TextUtils.tokenize(str, "< =");
        if (token.length >= 2 && token[0].equalsIgnoreCase("args") && token[1].equalsIgnoreCase("format")) {
            return true;
        }
        return token.length > 0 && token[0].startsWith("/args");
    }

    public static String getPageName(String str) {
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        String out = "Untitled";
        while (!s.equals("")) {
            if (s.equalsIgnoreCase("name") && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                out = tok.getNextStr();
            }
            s = tok.getNextStr();
        }
        return out;
    }

    public static boolean isOpenPageTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).startsWith("page");
    }

    public static boolean isClosePageTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).startsWith("/page");
    }

    public static boolean isOpenParamTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).startsWith("param");
    }

    public static boolean isCloseParamTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).startsWith("/param");
    }

    public static boolean isOpenTagsTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).equalsIgnoreCase("tags");
    }

    public static boolean isCloseTagsTag(String str) {
        String s = str.replace('<', ' ');
        return (s = s.replace('>', ' ').trim()).equalsIgnoreCase("/tags");
    }

    public static boolean isTag(String str) {
        return str.length() > 0 && str.charAt(0) == '<' && str.charAt(str.length() - 1) == '>';
    }

    public static boolean _isClosingTag(String str) {
        return str.length() > 0 && str.charAt(0) == '<' && str.charAt(str.length() - 1) == '>';
    }

    @Override
    public boolean isComment(String str) {
        return str.length() >= 4 && str.charAt(0) == '<' && str.charAt(1) == '!' && str.charAt(2) == '-' && str.charAt(3) == '-';
    }

    @Override
    public String getNextStr() {
        boolean endOfPlainText = false;
        if (this.mEndOfBuffer) {
            return "";
        }
        char c = this.readChar();
        if (c == '\u0000') {
            return "";
        }
        this.outBuff.setLength(0);
        if (this.isSpace(c) && (c = this.removeSpace()) == '\u0000') {
            return "";
        }
        if (this.getCR_Newlines && c == '\n') {
            return "\n";
        }
        if (c == '<') {
            boolean tagOK = this.handleTag(c);
            if (!tagOK) {
                return "";
            }
            if (tagOK && !this.ignoreTags) {
                return this.outBuff.toString();
            }
            this.outBuff.setLength(0);
        } else if (c == '&' && this.ignoreTags) {
            if (this.handleEntity(c)) {
                this.outBuff.setLength(0);
                return this.getNextStr();
            }
        } else {
            this.outBuff.append(c);
        }
        block6: while (!endOfPlainText) {
            c = this.readChar();
            switch (c) {
                case '\u0000': {
                    return this.outBuff.toString();
                }
                case '&': {
                    if (!this.ignoreTags) break;
                    this.removeEntity(c);
                    if (this.isSpace(this.peekNextChar())) continue block6;
                    this.outBuff.append(" ");
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    if (!this.getCR_Newlines) {
                        this.ungetChar();
                        if (this.outBuff.length() == 0) {
                            return this.getNextStr();
                        }
                        return this.outBuff.toString();
                    }
                    if (this.outBuff.length() == 0) {
                        return this.getNextStr();
                    }
                    return this.outBuff.append(c).toString();
                }
                case '<': {
                    this.ungetChar();
                    if (this.outBuff.length() == 0) {
                        return this.getNextStr();
                    }
                    return this.outBuff.toString();
                }
            }
            this.outBuff.append(c);
        }
        return this.outBuff.toString();
    }

    private boolean removeEntity(char c) {
        StringBuffer buff = new StringBuffer();
        buff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(buff);
                return false;
            }
            if (c == ';') {
                return true;
            }
            buff.append(c);
        }
        this.outBuff.append(buff);
        return false;
    }

    private boolean handleEntity(char c) {
        this.outBuff.append(c);
        while ((c = this.readChar()) != '\u0000') {
            if (this.isSpace(c)) {
                this.outBuff.append(c);
                return false;
            }
            if (c == ';') {
                return true;
            }
            this.outBuff.append(c);
        }
        return false;
    }

    private boolean handleTag(char c) {
        boolean isHtmlComment = false;
        this.outBuff.append(c);
        c = this.readChar();
        if (c == '\u0000') {
            Cutter.setLog("    Info: HtmlTokenizer.handleTag(char) readChar() == 0 at buffer index " + this.getBufferIndex());
            return false;
        }
        if (c == '!') {
            char[] next = this.peekNextChars(2);
            if (next == null) {
                return false;
            }
            if (next[0] == '-' && next[1] == '-') {
                isHtmlComment = true;
            }
        }
        while (c != '\u0000') {
            this.outBuff.append(c);
            char[] ahead2 = this.peekNextChars(2);
            if (isHtmlComment && c == '-' && ahead2 != null && ahead2[0] == '-' && ahead2[1] == '>') {
                this.outBuff.append(this.readChar()).append(this.readChar());
                return true;
            }
            if (!isHtmlComment && c == '>') {
                return true;
            }
            c = this.readChar();
        }
        return true;
    }

    public int searchBodyTextFor(int fromIndex, char ch) {
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = true;
        this.setBufferIndex(fromIndex);
        String str = this.getNextStr();
        while (str != "") {
            Cutter.setLog("HtmlTokenizer.searchBodyTextFor(char) >" + str + "<");
            for (int n = 0; n < str.length(); ++n) {
                if (str.charAt(n) != ch) continue;
                this.ignoreTags = oldFlag;
                int offset = this.getBufferIndex();
                return offset - str.length() + n;
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        return -1;
    }

    public int searchBodyTextFor(int fromIndex, String pattern, boolean ignoreCase) {
        boolean oldFlag = this.ignoreTags;
        boolean match = true;
        int matchIndex = -1;
        this.ignoreTags = true;
        this.setBufferIndex(fromIndex);
        String str = this.getNextStr();
        while (!str.equals("")) {
            for (int n = 0; n < str.length(); ++n) {
                if (str.charAt(n) != pattern.charAt(0)) continue;
                match = true;
                if (str.length() - n < pattern.length() || !str.regionMatches(ignoreCase, n, pattern, 0, pattern.length())) continue;
                this.ignoreTags = oldFlag;
                int offset = this.getBufferIndex();
                return offset - str.length() + n;
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        return -1;
    }

    public String getBodyText() {
        StringBuffer buffer = new StringBuffer();
        boolean oldFlag = this.ignoreTags;
        int oldIndex = this.getBufferIndex();
        this.ignoreTags = true;
        this.setBufferIndex(0);
        String str = this.getNextStr();
        while (!str.equals("")) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(String beginStr, String endStr) {
        if (beginStr == null || endStr == null) {
            return this.getBodyText();
        }
        int begin = this.searchBodyTextFor(0, beginStr, false);
        if (begin == -1) {
            return null;
        }
        int end = this.searchBodyTextFor(begin, endStr, false);
        if (end == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin + beginStr.length());
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(int begin, String endStr) {
        if (endStr == null || begin == -1) {
            return null;
        }
        int end = this.searchBodyTextFor(begin, endStr, true);
        if (end == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin);
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String getBodyTextBetween(int begin, int end) {
        if (end == -1 || begin == -1) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.setBufferIndex(begin);
        this.ignoreTags = true;
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            buffer.append(str + " ");
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return buffer.toString();
    }

    public String[] getHRefsBetween(String beginStr, String endStr) {
        int end;
        int begin;
        if (beginStr == null) {
            begin = 0;
        } else {
            begin = this.searchBodyTextFor(0, beginStr, false);
            if (begin == -1) {
                Cutter.setLog("getHRefsBetween cannot find " + beginStr);
                return null;
            }
        }
        if (endStr == null) {
            end = this.getBufferLength();
        } else {
            end = this.searchBodyTextFor(begin, endStr, false);
            if (end == -1) {
                Cutter.setLog("getHRefsBetween cannot find " + endStr);
                return null;
            }
        }
        Vector<String> list = new Vector<String>();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        if (beginStr == null) {
            this.setBufferIndex(0);
        } else {
            this.setBufferIndex(begin + beginStr.length());
        }
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            String link;
            if (ArgsTokenizer.isOpenOutputTag(str) && (link = TextUtils.getInnerQuotedString(str)) != null) {
                list.addElement(link);
            }
            str = this.getNextStr();
        }
        String[] out = new String[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String)list.elementAt(n);
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return out;
    }

    public String[] getHRefsBetween(int begin, int end) {
        if (begin == -1 || end == -1) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        this.setBufferIndex(begin);
        String str = this.getNextStr();
        while (!str.equals("") && this.getBufferIndex() < end) {
            String link;
            if (ArgsTokenizer.isOpenOutputTag(str) && (link = TextUtils.getInnerQuotedString(str)) != null) {
                list.addElement(link);
            }
            str = this.getNextStr();
        }
        String[] out = new String[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String)list.elementAt(n);
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return out;
    }

    public int findTag(String tagStr, int begin, boolean findEndOf) {
        int oldIndex = this.getBufferIndex();
        this.setBufferIndex(begin);
        int offset = this.searchFor(tagStr, findEndOf);
        this.setBufferIndex(oldIndex);
        return offset;
    }

    @Override
    public int searchFor(String pattern, boolean findEndOf) {
        String str = this.getNextStr();
        while (ArgsTokenizer.isOfType(str) != 0) {
            if (pattern.equalsIgnoreCase(str)) {
                if (!findEndOf) {
                    for (int i = 0; i < pattern.length(); ++i) {
                        this.ungetChar();
                    }
                    return this.getBufferIndex();
                }
                return this.getBufferIndex();
            }
            str = this.getNextStr();
        }
        return -1;
    }

    public int findArgsFormat(int begin, String name) {
        Vector list = new Vector();
        int oldIndex = this.getBufferIndex();
        boolean oldFlag = this.ignoreTags;
        this.ignoreTags = false;
        this.setBufferIndex(begin);
        String str = this.getNextStr();
        while (!str.equals("")) {
            if (ArgsTokenizer.isArgsFormatTag(str)) {
                String[] tokens = TextUtils.tokenize(str, "=>");
                if (tokens == null || tokens.length == 0) continue;
                for (int n = 0; n < tokens.length; ++n) {
                    if (!TextUtils.removeQuotes(tokens[n]).equalsIgnoreCase(name)) continue;
                    int offset = this.getBufferIndex();
                    this.ignoreTags = oldFlag;
                    this.setBufferIndex(oldIndex);
                    return offset;
                }
            }
            str = this.getNextStr();
        }
        this.ignoreTags = oldFlag;
        this.setBufferIndex(oldIndex);
        return -1;
    }
}

