/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Bat;

import Processes.ProcListener;
import Processes.ProcessManager;
import UI_Script.Bat.BatListener;
import UI_Script.Bat.BatTokenizer;
import UI_Script.Bat.OpenBatAction;
import UI_Script.ScriptHandler;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.Monitor.Monitor;
import UI_Window.KWindow.KTextHistoryWindow;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import java.io.File;
import javax.swing.JMenuItem;

public class BatScriptHandler
extends ScriptHandler
implements ProcListener {
    @Override
    public boolean canRunSelection() {
        return true;
    }

    public BatScriptHandler() {
        this.ext = new String[2];
        this.ext[0] = ".bat";
        this.ext[1] = ".BAT";
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new BatTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.bat");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "Bat";
    }

    @Override
    public String getExecuteLabel() {
        return null;
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public String getRunLabel() {
        return null;
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
    }

    @Override
    public void execute(File file) {
        if (EnvUtils.isWinEnvironment()) {
            String[] item1 = new String[]{"cmd", "/Q", "/C", file.getPath()};
            ProcessManager fp1 = new ProcessManager("bat");
            File dir = file.getParentFile();
            fp1.launch(item1, dir, true, this, false);
        }
    }

    @Override
    public void execute(String str) {
        File file = new File(FileUtils.getPWD(), "temp.bat");
        FileUtils.writeFile(file, str);
        this.execute(file);
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("bat", "Bat completed:\n");
    }

    @Override
    public void executeFromHistory(KTextHistoryWindow window) {
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return BatListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("Bat");
        item.addActionListener(new OpenBatAction());
        return item;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("bat", "Windows Bat Script");
        return filter;
    }
}

