/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Bat;

import UI_Desktop.Cutter;
import UI_Script.Bat.BatLanguageRsrc;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kernal.Tokenizers.Tokenizer;

public class BatTokenizer
extends Tokenizer {
    private static ResourceBundle BatLanguageRes;
    private static Hashtable<String, String> language;
    public boolean getComments = false;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = BatLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((BatLanguageRsrc)BatLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read BatLanguageRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < BatTokenizer.numLanguageItems(); ++i) {
            language.put(((BatLanguageRsrc)BatLanguageRes).getKey(i), ((BatLanguageRsrc)BatLanguageRes).getContent(i));
        }
    }

    public BatTokenizer() {
        this.addQuotation("\"", "\"", '\\');
        this.addComment("rem", "\n");
        this.setSyntaxLength(3);
        this.setDefaultDelimitors();
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        String[] ext = new String[]{"bat", "BAT"};
        Tokenizer.addToRegistry(BatTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    private void ___QUERRY__METHODS________() {
    }

    @Override
    public boolean isUserVariable(String str) {
        return str.charAt(0) == '$';
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equalsIgnoreCase("language");
        }
        return super.isLanguageType(str);
    }

    static {
        language = new Hashtable();
        try {
            BatLanguageRes = ResourceBundle.getBundle("UI_Script.Bat.BatLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: BatLanguageRsrc = " + mre);
        }
        BatTokenizer.initHashTable();
    }
}

