/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.C;

import Preferences.Preferences;
import UI_Script.C.CTokenizer;
import UI_Script.SyntaxListener;
import UI_Text.KTextPane.KTextPane;
import java.awt.Color;
import javax.swing.text.StyleConstants;

public class CListener
extends SyntaxListener {
    private static char[] beginners = new char[]{'[', ']', '(', ')', '<', '>', '+', '-', ':', ';', '/', '*', '=', '#', '%', '^', '&', '?', '@', ',', '`'};
    private static char[] enders = new char[]{'[', ']', '(', ')', '<', '>', '+', '-', ':', ';', '/', '*', '=', '#', '%', '^', '&', '?', '@', ',', '`'};

    public CListener(KTextPane textpane) {
        super(textpane, new CTokenizer());
        this.initDelimitors(textpane);
        this.initStyles(textpane);
    }

    @Override
    public void initDelimitors(KTextPane textpane) {
        textpane.addWordDelimitors(beginners, enders);
    }

    @Override
    public void initStyles(KTextPane textpane) {
        super.initStyles(textpane);
        StyleConstants.setForeground(textpane.styleContext.languageStyle, Color.blue);
        StyleConstants.setForeground(textpane.styleContext.plainStyle, Preferences.getColor(Preferences.TEXT_COLOR_C_PLAIN));
        StyleConstants.setForeground(textpane.styleContext.commentStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_COMMENT));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_FUNCTION));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_DATATYPE));
        StyleConstants.setForeground(textpane.styleContext.keywordStyle3, Preferences.getColor(Preferences.TEXT_COLOR_C_VARIABLE));
        StyleConstants.setForeground(textpane.styleContext.stringStyle1, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setForeground(textpane.styleContext.stringStyle2, Preferences.getColor(Preferences.TEXT_COLOR_C_STRING));
        StyleConstants.setUnderline(textpane.styleContext.stringStyle2, true);
    }

    @Override
    public void addComments() {
        this.addComments("/*", "*/");
    }
}

