/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.C;

import Preferences.Preferences;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.C.CHelp;
import UI_Script.C.CListener;
import UI_Script.C.CTokenizer;
import UI_Script.C.OpenCAction;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ProjectManagement.CProjectManager.CProjectManager;
import UI_Script.ProjectManagement.MultipleMainException;
import UI_Script.ProjectManagement.NoMainFunctionException;
import UI_Script.ProjectManagement.ProjectManager;
import UI_Script.ScriptHandler;
import UI_Script.ScriptParser.ScriptParser;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.DialogUtils;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kernal.Tokenizers.Tokenizer;

public class CScriptHandler
extends ScriptHandler {
    private static String compile_OSX = "Makefile.vanilla_OSX";
    private static String compile_LINUX = "Makefile.vanilla_LINUX";
    private static String compile_WIN = "Build_vanilla.bat";
    private String monitorInitText = null;
    private Tokenizer tok = null;

    @Override
    public boolean canRunSelection() {
        return false;
    }

    public CScriptHandler() {
        this.ext = new String[1];
        this.ext[0] = ".c";
        this.manager = new CProjectManager();
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new CTokenizer();
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(CHelp.class.getName(), textpane);
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.c");
        if (tmp.exists()) {
            tmp.delete();
        }
        String[] os = FileUtils.getListOfFileNames(new File(FileUtils.getPWD()), ".o");
        String[] objs = FileUtils.getListOfFileNames(new File(FileUtils.getPWD()), ".obj");
        String[] maps = FileUtils.getListOfFileNames(new File(FileUtils.getPWD()), ".map");
        String[] all = VectorUtils.toStringArray(os, objs);
        if ((all = VectorUtils.toStringArray(all, maps)) == null || all.length == 0) {
            return;
        }
        for (int n = 0; n < all.length; ++n) {
            File f = new File(FileUtils.getPWD(), all[n]);
            if (!f.exists()) continue;
            f.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "C Source";
    }

    @Override
    public String getExecuteLabel() {
        return "Build";
    }

    @Override
    public String getRunLabel() {
        return "Run";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public void execute(String str) {
    }

    @Override
    public void execute(File file) {
        CScriptHandler.common_execute(file);
    }

    public static void common_execute(File file) {
        BBxt.save();
        File srcFile = file;
        String srcName = srcFile.getName();
        String exeName = TextUtils.removeExtension(srcName);
        String srcExt = FileUtils.getExtension(srcFile);
        String scriptTypeName = srcExt.equals(".c") ? "C Source" : "C++ Source";
        File templateMakeFile = CScriptHandler.getTemplateMakefile();
        File makeFile = null;
        if (templateMakeFile == null) {
            Cutter.setLog("    Error:CScriptHandler.execute() - cannot find template file.");
            return;
        }
        String makefileName = !EnvUtils.isWinEnvironment() ? "Makefile." + exeName : "Build_" + exeName + ".bat";
        String makeStr = "";
        String userFlags = FileUtils.prefStrToFlaggedList("", Preferences.DEVKIT_USER_FLAGS);
        Hashtable<String, String> table = new Hashtable<String, String>();
        CScriptHandler.getLocalIncludes(srcFile, table);
        StringBuffer b = new StringBuffer();
        String ext = EnvUtils.isWinEnvironment() ? ".obj" : ".o";
        Enumeration<String> e = table.elements();
        while (e.hasMoreElements()) {
            String objname = e.nextElement().toString();
            objname = objname.substring(0, objname.length() - 2);
            objname = objname + ext;
            b.append(objname).append(" ");
        }
        String inferedObjs = b.toString().trim();
        Cutter.setLog("    Info:CScriptHandler inferedObjs >" + inferedObjs + "<");
        String inferedSources = CScriptHandler.inferSrcsFromIncludes(file.getParentFile(), table);
        Cutter.setLog("    Info:CScriptHandler inferedSources >" + inferedSources + "<");
        String otherObjs = "";
        if (EnvUtils.isWinEnvironment()) {
            String winEnvScript = CScriptHandler.getTemplateWinEnvScript();
            String batStr = FileUtils.read(templateMakeFile);
            batStr = batStr.replaceAll("(_SRC_FILENAME_)", srcName);
            batStr = batStr.replaceAll("(_EXE_NAME_)", exeName);
            batStr = batStr.replaceAll("(_OTHER_INCLUDE_DIRS_)", "");
            batStr = batStr.replaceAll("(_OTHER_OBJS_)", inferedObjs);
            batStr = inferedSources == null || inferedSources.trim().length() == 0 ? batStr.replaceAll("(_OTHER_SRCS_)", "") : batStr.replaceAll("(_OTHER_SRCS_)", inferedSources);
            File batFile = new File(file.getParentFile(), makefileName);
            String fullBatText = winEnvScript + "\n" + batStr.replace('/', '\\');
            FileUtils.writeFile(batFile, fullBatText);
            String[] item = new String[]{"cmd", "/Q", "/C", batFile.getName()};
            ProcessManager fp = new ProcessManager(scriptTypeName);
            fp.launch(item, file.getParentFile(), true, null, false);
            return;
        }
        makeStr = FileUtils.read(templateMakeFile);
        String compilerName = srcExt.equals(".c") ? "gcc" : "g++";
        makeStr = makeStr.replaceAll("(_EXE_NAME_)", exeName);
        makeStr = makeStr.replaceAll("(_COMPILER_)", compilerName);
        if (inferedObjs != null && inferedObjs.trim().length() > 0) {
            String target_exe = exeName + ".o";
            StringBuffer buf = new StringBuffer();
            String[] tokens = TextUtils.tokenize(inferedObjs);
            for (int n = 0; n < tokens.length; ++n) {
                String token = tokens[n].trim();
                if (token.equals(target_exe)) continue;
                buf.append(token).append(" ");
            }
            inferedObjs = buf.toString().trim();
            otherObjs = otherObjs + " " + inferedObjs;
        }
        makeStr = makeStr.replaceAll("(_OTHER_OBJS_)", otherObjs);
        makeFile = new File(file.getParentFile(), makefileName);
        Cutter.setLog("    Info:CScriptHandler.execute() - writing makefile \"" + makeFile.getPath() + "\"");
        FileUtils.writeFile(makeFile, makeStr);
        ProcessManager fp = new ProcessManager(scriptTypeName);
        String[] item = new String[]{"make", "-f", makeFile.getName()};
        Cutter.setLog("    Info:CScriptHandler.execute() - executing the following command:");
        Cutter.setLog(item);
        fp.launch(item, file.getParentFile(), true, null, false);
    }

    private static String __getTemplateWinEnvScript() {
        String path = Preferences.get(Preferences.PATH_CPP_VCVARSX86_AMD64_BAT);
        if (path.trim().length() == 0) {
            return "";
        }
        File f = new File(path);
        if (f == null || !f.exists()) {
            return "";
        }
        String str = FileUtils.read(f);
        return str == null ? "" : str;
    }

    private static String getTemplateWinEnvScript() {
        String WinEnvScript = null;
        String varspath = Preferences.get(Preferences.PATH_CPP_VCVARSX86_AMD64_BAT);
        if (varspath.trim().length() == 0) {
            String[] msg = new String[]{"To build an executable Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified in Cutter's Preferences", "    Languages->Cpp", "Or, the wrong path has been specified.\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat not Set in Prefs", msg);
            return "";
        }
        File f = new File(varspath);
        if (f == null || !f.exists()) {
            String[] msg = new String[]{"To build an executable Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file does NOT exist.\n"};
            DialogUtils.showErrorMessage("Cannot File vcvars bat", msg);
            return "";
        }
        if (f.isDirectory()) {
            String[] msg = new String[]{"To build an executable Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The path to this bat file has not been specified correctly in ", "Cutter's Preferences", "    Languages->Cpp", "The path incorrectly specified is,", "\"" + varspath + "\"\n"};
            DialogUtils.showErrorMessage("Path to vcvars bat Incorrectly Set in Prefs", msg);
            return "";
        }
        WinEnvScript = FileUtils.read(f);
        WinEnvScript = "@call \"" + varspath + "\"";
        if (WinEnvScript == null || WinEnvScript.trim().length() == 0) {
            String[] msg = new String[]{"To build an executable Cutter reads a vcvars bat file normally located at,", "\"Microsoft Visual Studio 14.0/VC/bin/amd64_x86/vcvarsamd64_x86.bat\"", "The file appears to be empty.\n"};
            DialogUtils.showErrorMessage("Empty vcvars bat ??", msg);
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(WinEnvScript);
        Cutter.setLog("    Info:CScriptHandler.getTemplateWinEnvScript() - WinEnvCommand is\n" + WinEnvScript + "\n");
        return WinEnvScript == null ? "" : buf.toString();
    }

    public static File getTemplateMakefile() {
        File pwd = FileUtils.getPWDFile();
        File f = null;
        if (EnvUtils.isWinEnvironment()) {
            f = new File(pwd, "custom_templates/Bat/" + compile_WIN);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/Bat/" + compile_WIN);
                if (f.exists()) {
                    Cutter.setLog("    Info:CScriptHandler.getTemplateMakefile() - using Cutter's default template.");
                }
            } else {
                Cutter.setLog("    Info:CScriptHandler.getTemplateMakefile() - using custom template.");
            }
        } else {
            String osScript = EnvUtils.isOSXEnvironment() ? compile_OSX : compile_LINUX;
            f = new File(pwd, "custom_templates/MakeFile/" + osScript);
            if (!f.exists()) {
                f = new File(pwd, "Cutter_Help/templates/MakeFile/" + osScript);
            } else {
                Cutter.setLog("    Info:CScriptHandler.getTemplateMakefile() - using custom template.");
            }
        }
        return !f.exists() ? null : f;
    }

    public static String inferSrcsFromIncludes(File parentDir, Hashtable<String, String> table) {
        StringBuffer b = new StringBuffer();
        Enumeration<String> e = table.elements();
        while (e.hasMoreElements()) {
            String srcname = e.nextElement().toString();
            String c_src = TextUtils.removeExtension(srcname) + ".c";
            String cpp_src = TextUtils.removeExtension(srcname) + ".cpp";
            File c_file = new File(parentDir, c_src);
            File cpp_file = new File(parentDir, cpp_src);
            if (c_file.exists()) {
                b.append(c_src).append(" ");
            }
            if (!cpp_file.exists()) continue;
            b.append(cpp_src).append(" ");
        }
        return b.toString().trim();
    }

    public static String inferSrcsFromIncludes(File srcFile) {
        CTokenizer tok = new CTokenizer();
        String[][] includes = null;
        ScriptParser sp = null;
        Vector<String> outList = new Vector<String>();
        try {
            sp = new ScriptParser(tok, FileUtils.read(srcFile));
            includes = sp.getImports();
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:DevkitScriptHandler.inferSrcsFromIncludes()\n        " + ee.toString());
            return "";
        }
        if (includes == null || includes[1] == null || includes[1].length == 0) {
            return "";
        }
        File parentDir = srcFile.getParentFile();
        for (int n = 0; n < includes[1].length; ++n) {
            includes[1][n] = TextUtils.removeExtension(includes[1][n]);
            File fc = new File(parentDir, includes[1][n] + ".c");
            File fcpp = new File(parentDir, includes[1][n] + ".cpp");
            if (fc.exists() && fcpp.exists()) {
                Cutter.setLog("    Warning:DevkitScriptHandler.inferSrcsFromIncludes()\n        a '.c' and a '.cpp' with the same name has been found in\n        \"" + parentDir.getPath() + "\". Cutter will add the '.c'\n        to the build and will ignore the '.cpp' source code file.");
            }
            if (fc.exists()) {
                outList.addElement(includes[1][n] + ".c");
                continue;
            }
            if (!fcpp.exists()) continue;
            outList.addElement(includes[1][n] + ".cpp");
        }
        return VectorUtils.vectorToSpacedString(outList);
    }

    public static int getLocalIncludes(File srcFile, Hashtable<String, String> outTable) {
        CTokenizer tok = new CTokenizer();
        String[][] includes = null;
        ScriptParser sp = null;
        try {
            sp = new ScriptParser(tok, FileUtils.read(srcFile));
            includes = sp.getImports();
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:DevkitScriptHandler.inferSrcsFromIncludes()\n        " + ee.toString());
            return 0;
        }
        if (includes == null || includes[1] == null || includes[1].length == 0) {
            return 0;
        }
        File parentDir = srcFile.getParentFile();
        for (int n = 0; n < includes[1].length; ++n) {
            includes[1][n] = TextUtils.removeExtension(includes[1][n]);
            File fc = new File(parentDir, includes[1][n] + ".c");
            File fcpp = new File(parentDir, includes[1][n] + ".cpp");
            if (fc.exists() && fcpp.exists()) {
                Cutter.setLog("    Warning:CScriptHandler.getLocalIncludes()\n        a '.c' and a '.cpp' with the same name has been found in\n        \"" + parentDir.getPath() + "\". Cutter will add the '.c'\n        to the build and will ignore the '.cpp' source code file.");
            }
            if (!fc.exists() && !fcpp.exists()) continue;
            String header = includes[1][n] + ".h";
            outTable.put(header, header);
            CScriptHandler.getLocalIncludes(new File(parentDir, header), outTable);
        }
        return 1;
    }

    public static String inferObjsFromIncludes(File srcFile) {
        CTokenizer tok = new CTokenizer();
        String[][] includes = null;
        ScriptParser sp = null;
        Vector<String> outList = new Vector<String>();
        try {
            sp = new ScriptParser(tok, FileUtils.read(srcFile));
            includes = sp.getImports();
        }
        catch (Exception ee) {
            Cutter.setLog("    Error:DevkitScriptHandler.inferSrcsFromIncludes()\n        " + ee.toString());
            return "";
        }
        if (includes == null || includes[1] == null || includes[1].length == 0) {
            return "";
        }
        File parentDir = srcFile.getParentFile();
        for (int n = 0; n < includes[1].length; ++n) {
            String ext;
            includes[1][n] = TextUtils.removeExtension(includes[1][n]);
            File fc = new File(parentDir, includes[1][n] + ".c");
            File fcpp = new File(parentDir, includes[1][n] + ".cpp");
            if (fc.exists() && fcpp.exists()) {
                Cutter.setLog("    Warning:CScriptHandler.inferObjsFromIncludes()\n        a '.c' and a '.cpp' with the same name has been found in\n        \"" + parentDir.getPath() + "\". Cutter will add the '.c'\n        to the build and will ignore the '.cpp' source code file.");
            }
            String string = ext = EnvUtils.isWinEnvironment() ? ".obj" : ".o";
            if (!fc.exists() && !fcpp.exists()) continue;
            outList.addElement(includes[1][n] + ext);
        }
        return VectorUtils.vectorToSpacedString(outList);
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
        Cutter.setLog("    Info: CScriptHandler.run()");
        CScriptHandler.common_run(this.manager);
    }

    public static void common_run(ProjectManager manager) {
        Cutter.setLog("    Info: CScriptHandler.common_run()");
        BBxt.save();
        File srcFile = null;
        try {
            KAbstractWindow w = manager.getWindowWithMain();
            if (w == null) {
                return;
            }
            w.saveFile();
            srcFile = w.getFile();
        }
        catch (MultipleMainException mm) {
            String[] messages = TextUtils.tokenize(mm.toString(), ":");
            String message = messages == null || messages.length != 2 ? mm.toString() : messages[1];
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, message, "More than one document implements main()", 0);
            return;
        }
        catch (NoMainFunctionException nm) {
            String[] messages = TextUtils.tokenize(nm.toString(), ":");
            String message = messages == null || messages.length != 2 ? nm.toString() : messages[1];
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, message, "Cannot find a window that implements main()", 0);
            return;
        }
        File parentDir = srcFile.getParentFile();
        String srcName = srcFile.getName();
        String exeName = TextUtils.removeExtension(srcName);
        File exeFile = new File(parentDir, exeName);
        final String exePath = exeFile.getPath();
        String osExePath = EnvUtils.isWinEnvironment() ? exePath + ".exe" : exePath;
        File osExeFile = new File(osExePath);
        if (osExePath == null) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cannot find the path to \"" + osExePath + "\".", "Cannot find path to the executable", 0);
            return;
        }
        final ProcessManager fp = new ProcessManager("Run");
        if (!osExeFile.exists()) {
            CScriptHandler.common_execute(srcFile);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (EnvUtils.isWinEnvironment()) {
                        String[] items = new String[]{"cmd", "/Q", "/C", exePath};
                        fp.launch(items, null, false, null, false);
                    } else {
                        String[] items = new String[]{exePath};
                        fp.launch(items, null, false, null, false);
                    }
                }
            });
        }
        if (!osExeFile.exists()) {
            Cutter.setLog("name of exe is \"" + osExeFile.getPath() + "\"");
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The recent build of \"" + osExeFile.getName() + "\" may have been unsuccessful. \nCorrect the errors reported in the Process \nMonitor and try again.", "Cannot find executable", 0);
            return;
        }
        if (EnvUtils.isWinEnvironment()) {
            String[] items = new String[]{"cmd", "/Q", "/C", osExePath};
            fp.launch(items, null, false, null, false);
            return;
        }
        String[] items = new String[]{osExePath};
        fp.launch(items, null, false, null, false);
    }

    @Override
    public boolean isRunnableScript(File file) {
        boolean cando = this.manager.isRunnableScript(file);
        Cutter.setLog("    Info: CScriptHandler.isRunnableScript() - " + file.getPath());
        Cutter.setLog("    Info: CScriptHandler.isRunnableScript() - cando = " + cando);
        return cando;
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return CListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("C");
        item.addActionListener(new OpenCAction());
        return item;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("c", "C Source Code");
        return filter;
    }
}

