/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.C;

import UI_Desktop.Cutter;
import UI_Script.C.CLanguageRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.HashTableUtils;
import Utilities.TextUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class CTokenizer
extends Tokenizer {
    private static ResourceBundle CLanguageRes;
    public static Hashtable<String, String> language;
    public static String[] ILLEGAL_PROC_NAMES;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = CLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((CLanguageRsrc)CLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read CFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < CTokenizer.numLanguageItems(); ++i) {
            language.put(((CLanguageRsrc)CLanguageRes).getKey(i), ((CLanguageRsrc)CLanguageRes).getContent(i));
        }
    }

    public CTokenizer() {
        this.commonInit();
    }

    public CTokenizer(String filename) throws FileNotFoundException, IOException {
        super(filename);
        this.commonInit();
    }

    public CTokenizer(Segment segment) {
        super(segment);
        this.commonInit();
    }

    protected void commonInit() {
        this.name = "CTokenizer";
        this.addComment("/*", "*/");
        this.addComment("//", "\n");
        this.addQuotation("\"", "\"", '\\');
        this.addQuotation("'", "'", '\\');
        this.addEscape("\\\"", "");
        this.addEscape("\\\\", "");
        this.addEscape("\\'", "");
        this.setSyntaxLength(2);
        this.setDefaultDelimitors();
        this.appendDelimitor("*-+=/");
        this.appendDelimitor("/$&?@%~!");
        String[] ext = new String[]{"c", "C"};
        Tokenizer.addToRegistry(CTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (str.equals("") || this.isComment(str)) {
            this.setBufferIndex(index);
            return null;
        }
        if (str.startsWith("#")) {
            int closeOfBlockOffset = this.findNewline(index);
            if (closeOfBlockOffset != -1) {
                this.setBufferIndex(closeOfBlockOffset + 1);
                return null;
            }
            this.setBufferIndex(index);
            return null;
        }
        if (str.equals("typedef") || str.equals("struct") || str.equals("extern")) {
            int closeOfBlockOffset = this.findForward(index, ';');
            if (closeOfBlockOffset != -1) {
                this.setBufferIndex(closeOfBlockOffset + 1);
                return null;
            }
            this.setBufferIndex(index);
            return null;
        }
        out.procType = str;
        str = this.getNextStr();
        while (!str.equals("") && (str.equals("[") || str.equals("]") || str.equals("*"))) {
            str = this.getNextStr();
        }
        if (str.equals("")) {
            this.setBufferIndex(index);
            return null;
        }
        out.procName = str;
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = this.getBufferIndex();
        out.procNameOffset[0] = out.procNameOffset[1] - str.length();
        String ptext = this.lpGrabProcParams("(", ")");
        if (ptext == null) {
            this.setBufferIndex(index);
            return null;
        }
        int[] offset = this.lpGrabProcBody("{", "}", null);
        if (offset == null) {
            this.setBufferIndex(index);
            return null;
        }
        out.procOffset[0] = out.procNameOffset[0];
        out.procOffset[1] = offset[1];
        for (int n = 0; n < ILLEGAL_PROC_NAMES.length; ++n) {
            if (!out.procName.equals(ILLEGAL_PROC_NAMES[n])) continue;
            return null;
        }
        if (TextUtils.contains("*-+=/", out.procName.charAt(0))) {
            return null;
        }
        if (offset != null) {
            return out;
        }
        this.setBufferIndex(index);
        return null;
    }

    @Override
    public boolean isFunction(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        return language.get(str).equals("function");
    }

    @Override
    public boolean isDataType(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        return language.get(str).equals("datatype");
    }

    @Override
    public String[] getDataTypes() {
        String[] list = HashTableUtils.getAllValuesWithKey(language, "datatype");
        return list;
    }

    @Override
    public boolean isDataModifier(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        return language.get(str).equals("datamodifier");
    }

    @Override
    public boolean isLanguageType(String str) {
        if (!language.containsKey(str)) {
            return false;
        }
        if (language.get(str).equals("language")) {
            return str.charAt(0) != '#' || str.length() != 1 && !Character.isWhitespace(str.charAt(1));
        }
        return false;
    }

    @Override
    public String[] getImportKeywords() {
        return new String[]{"#include"};
    }

    static {
        language = new Hashtable();
        ILLEGAL_PROC_NAMES = new String[]{"if", "while", "for", "<", ">", "defined", "["};
        try {
            CLanguageRes = ResourceBundle.getBundle("UI_Script.C.CLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: CTokenizer = " + mre);
        }
        CTokenizer.initHashTable();
    }
}

