/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.CommandPort;

import ClientServer.ClientServer.client.Client;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Script.Comment;
import UI_Script.SyntaxListener;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.UnixUtils;
import java.io.File;
import java.lang.reflect.Field;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class MayaCommandPort {
    public static boolean _textToPort = false;
    private KTextWindow window = null;
    private Client mayaClient = null;

    public MayaCommandPort(KTextWindow window, Client mayaClient) {
        this.window = window;
        this.mayaClient = mayaClient;
    }

    public void sendStr(String rawMelStr) {
        if (rawMelStr == null || rawMelStr.trim().length() == 0) {
            return;
        }
        PlainDocument doc = new PlainDocument();
        SyntaxListener syntaxListener = this.window.getTextPane().getSyntaxListener();
        Comment[] cmnt = this.window.getTextPane().getComments();
        boolean isPyMel = BBxt.isPyMelDocument();
        try {
            doc.insertString(0, rawMelStr, null);
            Position endMarker = doc.createPosition(doc.getLength());
        }
        catch (BadLocationException e) {
            Cutter.setLog("    Exception: MayaCommandPort.sendStr() " + e);
            return;
        }
        if (_textToPort) {
            Cutter.setLog("___________ The modified text that was sent to Maya ___________");
            Cutter.setLog(rawMelStr);
            Cutter.setLog("____________________________________________");
        }
        if (rawMelStr == null) {
            Cutter.setLog("    Error: MayaCommandPort.sendStr() - no mel text to send!");
            return;
        }
        File tmpFile = new File(FileUtils.getPWD(), "temp.mel");
        FileUtils.writeFile(tmpFile, rawMelStr);
        String unixpath = UnixUtils.path(tmpFile.getPath());
        String sourceStatement = "source \"" + unixpath + "\";";
        if (this.mayaClient == null) {
            Cutter.setLog("    Info: MayaCommandPort.sendStr() not connected to Maya but\n             the Mel command that would have been sent -\n            " + sourceStatement);
            return;
        }
        if (this.mayaClient != null) {
            this.mayaClient.sendMelString(sourceStatement);
        }
    }

    static {
        try {
            Field[] fields = new Field[]{MayaCommandPort.class.getDeclaredField("_textToPort")};
            Cutter.addDebug(MayaCommandPort.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: MayaCommandPort.static - " + ex.toString());
        }
    }
}

