/*
 * Decompiled with CFR 0.152.
 */
package UI_Script;

import UI_Desktop.Cutter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.text.Segment;

public class Comment {
    public static final String HTML_CMNT_NAME = "Html comment";
    public static boolean _isOpenComment = false;
    public static boolean _isCloseComment = false;
    public String openStr = null;
    public char[] openCmnt = null;
    public int openLen = 0;
    public String closeStr = null;
    public char[] closeCmnt = null;
    public int closeLen = 0;
    private static Hashtable<Comment, Comment> table;

    public static Comment getComment(String openStr, String closeStr) {
        Enumeration<Comment> e = table.elements();
        while (e.hasMoreElements()) {
            Comment cmnt = e.nextElement();
            if (cmnt == null) continue;
            if (openStr != null && cmnt.openStr.equals(openStr)) {
                return cmnt;
            }
            if (closeStr == null || !cmnt.closeStr.equals(closeStr)) continue;
            return cmnt;
        }
        return null;
    }

    public Comment(String open, String close) {
        int n;
        this.openStr = open;
        this.openLen = open.length();
        this.openCmnt = new char[this.openLen];
        for (n = 0; n < this.openLen; ++n) {
            this.openCmnt[n] = this.openStr.charAt(n);
        }
        this.closeStr = close;
        this.closeLen = close.length();
        this.closeCmnt = new char[this.closeLen];
        for (n = 0; n < this.closeLen; ++n) {
            this.closeCmnt[n] = this.closeStr.charAt(n);
        }
        table.put(this, this);
    }

    public String toString() {
        return "[" + this.openStr + "," + this.closeStr + "]";
    }

    public String getName() {
        if (this.openStr.equals("/*")) {
            return "C comment";
        }
        if (this.openStr.equals("//")) {
            return "C++ comment";
        }
        if (this.openStr.equals("<!--")) {
            return HTML_CMNT_NAME;
        }
        if (this.openStr.equals("#")) {
            return "Rib comment";
        }
        return "unknown [" + this.openStr + "]";
    }

    public int findOpenComment(String str) {
        if (str.length() < this.openLen) {
            return -1;
        }
        int offset = str.indexOf(this.openStr.charAt(0), 0);
        if (offset != -1 && offset + this.openLen < str.length() && (str = str.substring(offset, offset + 3)).equals(this.openStr)) {
            return offset;
        }
        return -1;
    }

    public String[] removeComment(String str) {
        String[] out = new String[]{"", str};
        if (str == null || str.trim().length() == 0) {
            return out;
        }
        Segment segment = new Segment(str.toCharArray(), 0, str.length());
        if (segment == null) {
            return out;
        }
        int begin = this.findOpenComment(segment, 0);
        if ((begin -= this.openLen) < 0) {
            return out;
        }
        int end = this.findCloseComment(segment, begin);
        if (end == -1) {
            return out;
        }
        String head = str.substring(0, begin);
        String tail = end == str.length() - 1 ? "" : str.substring(end);
        String remainder = head + " " + tail;
        out[0] = str.substring(begin, end);
        out[1] = remainder.trim();
        return out;
    }

    public int findOpenComment(Segment segment, int from) {
        if (from + this.openLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n < segment.count - this.openLen; ++n) {
            if (segment.array[n + segment.offset] != this.openCmnt[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.openLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.openCmnt[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.openLen;
        }
        return foundAt;
    }

    public int findCloseComment(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return -1;
        }
        int foundAt = -1;
        boolean match = false;
        for (int n = from; n <= segment.count - this.closeLen; ++n) {
            if (segment.array[n + segment.offset] != this.closeCmnt[0]) continue;
            foundAt = n;
            match = true;
            for (int j = 0; j < this.closeLen; ++j) {
                if (segment.array[n + j + segment.offset] == this.closeCmnt[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return foundAt + this.closeLen;
        }
        return -1;
    }

    public boolean isOpenComment(Segment segment, int from) {
        if (this.openLen == 1 && from + this.openLen >= segment.count || this.openLen > 1 && from + this.openLen > segment.count) {
            if (_isOpenComment) {
                Cutter.setLog("Comment.isOpenComment() from + openLen > segment.count returning false");
            }
            return false;
        }
        if (_isOpenComment) {
            Cutter.setLog("Comment.isOpenComment() from " + from);
            Cutter.setLog("Comment.isOpenComment() openLen " + this.openLen);
            Cutter.setLog("Comment.isOpenComment() segment.count " + segment.count);
        }
        for (int j = 0; j < this.openLen; ++j) {
            if (_isOpenComment) {
                Cutter.setLog("    compare >" + segment.array[from + j + segment.offset] + "< to >" + this.openCmnt[j] + "<");
            }
            if (segment.array[from + j + segment.offset] == this.openCmnt[j]) continue;
            return false;
        }
        return true;
    }

    public boolean isOpenComment(String str) {
        if (str == null) {
            return false;
        }
        if (this.openStr == null) {
            return false;
        }
        if ((str = str.trim()).length() < this.openStr.length()) {
            return false;
        }
        return str.substring(0, this.openStr.length()).equals(this.openStr);
    }

    public boolean isOpenComment(char[] chars) {
        return this.isOpenComment(new String(chars));
    }

    public boolean isCloseComment(Segment segment, int from) {
        if (from + this.closeLen > segment.count) {
            return false;
        }
        for (int j = 0; j < this.closeLen; ++j) {
            if (segment.array[from + j + segment.offset] == this.closeCmnt[j]) continue;
            return false;
        }
        return true;
    }

    public boolean _isCloseComment(Segment segment, int at) {
        at -= this.closeLen;
        for (int j = 0; j < this.closeLen; ++j) {
            if (_isCloseComment) {
                Cutter.setLog("    compare >" + segment.array[at + j + segment.offset] + "< to >" + this.closeCmnt[j] + "<");
            }
            if (segment.array[at + j + segment.offset] == this.closeCmnt[j]) continue;
            return false;
        }
        return true;
    }

    public boolean isCloseComment(String str) {
        if (str == null) {
            return false;
        }
        if (this.closeStr == null) {
            return false;
        }
        if (this.closeStr.length() > 1) {
            str = str.trim();
        }
        if (str.length() < this.closeStr.length()) {
            return false;
        }
        return str.substring(0, this.closeStr.length()).equals(this.closeStr);
    }

    public boolean isCloseComment(char[] chars) {
        return this.isCloseComment(new String(chars));
    }

    public boolean isPartialOpenComment(String str) {
        for (int n = 0; n < str.length(); ++n) {
            for (int i = 0; i < this.openStr.length(); ++i) {
                if (str.charAt(n) != this.openStr.charAt(i)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOpenComment(String str) {
        if (str.length() < this.openLen) {
            return false;
        }
        int offset = str.indexOf(this.openCmnt[0], 0);
        return offset != -1 && offset + this.openLen <= str.length() && (str = str.substring(offset, offset + this.openLen)).equals(this.openStr);
    }

    public boolean containsClosingComment(String str) {
        if (str.length() < this.closeLen) {
            return false;
        }
        int offset = str.indexOf(this.closeCmnt[0], 0);
        return offset != -1 && offset + this.closeLen <= str.length() && (str = str.substring(offset, offset + this.closeLen)).equals(this.closeStr);
    }

    static {
        try {
            Field[] fields = new Field[]{Comment.class.getDeclaredField("_isOpenComment"), Comment.class.getDeclaredField("_isCloseComment")};
            Cutter.addDebug(Comment.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: Comment.static - " + ex.toString());
        }
        table = new Hashtable();
    }
}

