/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Cpp;

import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.C.CScriptHandler;
import UI_Script.Cpp.CPPHelp;
import UI_Script.Cpp.CppListener;
import UI_Script.Cpp.CppTokenizer;
import UI_Script.Cpp.OpenCppAction;
import UI_Script.Help.KAbstractHelp;
import UI_Script.ProjectManagement.CPPProjectManager.CPPProjectManager;
import UI_Script.ProjectManagement.MultipleMainException;
import UI_Script.ProjectManagement.NoMainFunctionException;
import UI_Script.ProjectManagement.ProjectManager;
import UI_Script.ScriptHandler;
import UI_Text.KTextPane.KTextPane;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.EnvUtils;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class CppScriptHandler
extends ScriptHandler {
    @Override
    public boolean canRunSelection() {
        return false;
    }

    public CppScriptHandler() {
        this.ext = new String[1];
        this.ext[0] = ".cpp";
        this.manager = new CPPProjectManager();
        this.setTokenizer();
    }

    @Override
    protected void setTokenizer() {
        this.tokenizer = new CppTokenizer();
    }

    @Override
    public void deleteTmpFile() {
        File tmp = new File(FileUtils.getPWD(), "temp.cpp");
        if (tmp.exists()) {
            tmp.delete();
        }
    }

    @Override
    public String getScriptName() {
        return "C++ Source";
    }

    @Override
    public KAbstractHelp getHelper(KTextPane textpane) {
        KAbstractHelp.add(textpane.helper);
        return KAbstractHelp.getInstanceByName(CPPHelp.class.getName(), textpane);
    }

    @Override
    public String getExecuteLabel() {
        return "Build";
    }

    @Override
    public String getRunLabel() {
        return "Run";
    }

    @Override
    public String getMakeLabel() {
        return null;
    }

    @Override
    public void execute(String str) {
    }

    @Override
    public void execute(File file) {
        CScriptHandler.common_execute(file);
    }

    @Override
    protected void make(File srcDir) {
    }

    @Override
    protected void run() {
        Cutter.setLog("    Info: CppScriptHandler.run()");
        CppScriptHandler.common_run(this.manager);
    }

    public static void common_run(ProjectManager manager) {
        Cutter.setLog("    Info: CppScriptHandler.common_run()");
        BBxt.save();
        File srcFile = null;
        try {
            KAbstractWindow w = manager.getWindowWithMain();
            if (w == null) {
                return;
            }
            w.saveFile();
            srcFile = w.getFile();
        }
        catch (MultipleMainException mm) {
            String[] messages = TextUtils.tokenize(mm.toString(), ":");
            String message = messages == null || messages.length != 2 ? mm.toString() : messages[1];
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, message, "More than one document implements main()", 0);
            return;
        }
        catch (NoMainFunctionException nm) {
            String[] messages = TextUtils.tokenize(nm.toString(), ":");
            String message = messages == null || messages.length != 2 ? nm.toString() : messages[1];
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, message, "Cannot find a window that implements main()", 0);
            return;
        }
        File parentDir = srcFile.getParentFile();
        String srcName = srcFile.getName();
        String exeName = TextUtils.removeExtension(srcName);
        File exeFile = new File(parentDir, exeName);
        final String exePath = exeFile.getPath();
        String osExePath = EnvUtils.isWinEnvironment() ? exePath + ".exe" : exePath;
        File osExeFile = new File(osExePath);
        if (osExePath == null) {
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cannot find the path to \"" + osExePath + "\".", "Cannot find path to the executable", 0);
            return;
        }
        final ProcessManager fp = new ProcessManager("Run");
        if (!osExeFile.exists()) {
            CScriptHandler.common_execute(srcFile);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (EnvUtils.isWinEnvironment()) {
                        String[] items = new String[]{"cmd", "/Q", "/C", exePath};
                        fp.launch(items, null, false, null, false);
                    } else {
                        String[] items = new String[]{exePath};
                        fp.launch(items, null, false, null, false);
                    }
                }
            });
        }
        if (!osExeFile.exists()) {
            Cutter.setLog("name of exe is \"" + osExeFile.getPath() + "\"");
            JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The recent build of \"" + osExeFile.getName() + "\" may have been unsuccessful. \nCorrect the errors reported in the Process \nMonitor and try again.", "Cannot find executable", 0);
            return;
        }
        if (EnvUtils.isWinEnvironment()) {
            String[] items = new String[]{"cmd", "/Q", "/C", osExePath};
            fp.launch(items, null, false, null, false);
            return;
        }
        String[] items = new String[]{osExePath};
        fp.launch(items, null, false, null, false);
    }

    @Override
    public boolean isRunnableScript(File file) {
        boolean cando = this.manager.isRunnableScript(file);
        Cutter.setLog("    Info: CppScriptHandler.isRunnableScript() - " + file.getPath());
        Cutter.setLog("    Info: CppScriptHandler.isRunnableScript() - cando = " + cando);
        return cando;
    }

    @Override
    public String getSyntaxListenerClassName(KTextPane textpane) {
        return CppListener.class.getName();
    }

    @Override
    public JMenuItem getOpenFileMenuItem() {
        JMenuItem item = new JMenuItem("CPP");
        item.addActionListener(new OpenCppAction());
        return item;
    }

    @Override
    public KFileFilter getFileFilter() {
        KFileFilter filter = new KFileFilter("cpp", "C++ Source Code");
        return filter;
    }
}

