/*
 * Decompiled with CFR 0.152.
 */
package UI_Script.Cpp;

import UI_Desktop.Cutter;
import UI_Script.C.CTokenizer;
import UI_Script.Cpp.CPPLanguageRsrc;
import UI_Script.ScriptParser.ProcDBItem;
import Utilities.HashTableUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import kernal.Tokenizers.Tokenizer;

public class CppTokenizer
extends CTokenizer {
    private static ResourceBundle CPPLanguageRes;
    public static Hashtable<String, String> language;
    public static final double version = 1.0;
    public boolean getComments = false;

    private static String getLanguage(String nm) {
        String str;
        try {
            str = CPPLanguageRes.getObject(nm).toString();
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    private static int numLanguageItems() {
        int num = 0;
        try {
            num = ((CPPLanguageRsrc)CPPLanguageRes).getNumItems();
        }
        catch (MissingResourceException mre) {
            System.out.println("cannot read CPPFunctionsRsrc");
        }
        return num;
    }

    private static void initHashTable() {
        for (int i = 0; i < CppTokenizer.numLanguageItems(); ++i) {
            language.put(((CPPLanguageRsrc)CPPLanguageRes).getKey(i), ((CPPLanguageRsrc)CPPLanguageRes).getContent(i));
        }
    }

    public CppTokenizer() {
        String[] ext = new String[]{"cpp", "CPP"};
        Tokenizer.addToRegistry(CppTokenizer.class, ext, this.getComments(), this.getDelimitors());
    }

    @Override
    public boolean isFunction(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("function");
        }
        return super.isFunction(str);
    }

    @Override
    public boolean isDataType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("datatype");
        }
        return super.isDataType(str);
    }

    @Override
    public String[] getDataTypes() {
        String[] own = HashTableUtils.getAllValuesWithKey(language, "datatype");
        String[] supers = super.getDataTypes();
        Vector all = new Vector();
        return VectorUtils.toStringArray(own, supers);
    }

    @Override
    public boolean isDataModifier(String str) {
        return super.isDataModifier(str);
    }

    @Override
    public boolean isLanguageType(String str) {
        if (language.containsKey(str)) {
            return language.get(str).equals("language");
        }
        return super.isLanguageType(str);
    }

    @Override
    public ProcDBItem lpGrabProc(String str) {
        int openCurlyOffset;
        String ptext;
        int offsetOfParenthesis;
        boolean twoColonsNext;
        ProcDBItem out = new ProcDBItem();
        int index = this.getBufferIndex();
        if (str.equals("") || this.isComment(str)) {
            this.setBufferIndex(index);
            return null;
        }
        if (str.equals("using")) {
            int closeOfBlockOffset = this.findForward(index, ';');
            if (closeOfBlockOffset != -1) {
                this.setBufferIndex(closeOfBlockOffset + 1);
                return null;
            }
            this.setBufferIndex(index);
            return null;
        }
        String procType = null;
        String procName = null;
        String className = null;
        Object operatorName = null;
        String typeOrClassName = null;
        int typeOrClassNameOffset = -1;
        char[] chars = null;
        int nameEndOffset = 0;
        int nameBeginOffset = 0;
        int initialIndex = index;
        String initialStr = str;
        int offset = this.peekDoubleColon(index);
        boolean bl = twoColonsNext = offset != -1;
        if (!twoColonsNext) {
            procType = str;
            str = this.getNextStr();
            while (!str.equals("") && (str.equals("[") || str.equals("]") || str.equals("*") || str.equals("&"))) {
                str = this.getNextStr();
            }
            index = this.peekDoubleColon(this.getBufferIndex());
            boolean bl2 = twoColonsNext = index != -1;
            if (!twoColonsNext) {
                if (str.equals("operator")) {
                    nameEndOffset = this.getBufferIndex();
                    nameBeginOffset = nameEndOffset - 8;
                    index = this.getBufferIndex();
                    offsetOfParenthesis = this.findForward(index, '(');
                    if (offsetOfParenthesis == -1 || offsetOfParenthesis < index) {
                        this.setBufferIndex(index);
                        return null;
                    }
                    chars = this.getBuffer(index, offsetOfParenthesis - 1);
                    if (chars == null) {
                        this.setBufferIndex(index);
                        return null;
                    }
                    className = "";
                    procName = "operator" + new String(chars).trim();
                    nameEndOffset += new String(chars).trim().length();
                    this.setBufferIndex(offsetOfParenthesis);
                } else {
                    this.setBufferIndex(initialIndex);
                    return super.lpGrabProc(initialStr);
                }
            }
        }
        if (twoColonsNext) {
            typeOrClassName = str;
            typeOrClassNameOffset = initialIndex - str.length();
            this.setBufferIndex(index);
            offsetOfParenthesis = this.findForward(index, '(');
            if (offsetOfParenthesis == -1 || offsetOfParenthesis < index) {
                this.setBufferIndex(index);
                Cutter.setLog("    Debug: CppTokenizer.lpGrabProc() cannot find opening parenthesis at " + index);
                return null;
            }
            chars = this.getBuffer(index, offsetOfParenthesis - 1);
            if (chars == null) {
                this.setBufferIndex(index);
                Cutter.setLog("    Debug: CppTokenizer.lpGrabProc() cannot get text between " + index + " and " + (offsetOfParenthesis - 1));
                return null;
            }
            String[] token = TextUtils.tokenize(new String(chars));
            if (token == null) {
                this.setBufferIndex(index);
                Cutter.setLog("    Debug: CppTokenizer.lpGrabProc() could not tokenize chars");
                return null;
            }
            if (!(token.length <= 2 || token.length == 3 && token[1].startsWith("<") && token[1].endsWith(">"))) {
                int endOfStatement = this.findForward(index, ';');
                this.setBufferIndex(endOfStatement + 1);
                return null;
            }
            this.setBufferIndex(offsetOfParenthesis);
            switch (token.length) {
                case 0: {
                    return null;
                }
                case 1: {
                    className = typeOrClassName;
                    procType = procType == null ? "" : procType;
                    procName = token[0];
                    this.setBufferIndex(index);
                    int[] off = this.charSearch(procName, true);
                    if (off != null) {
                        nameBeginOffset = procName.startsWith("::") ? off[0] + 2 : off[0];
                        nameEndOffset = off[1];
                    }
                    this.setBufferIndex(offsetOfParenthesis);
                    break;
                }
                case 2: {
                    int[] off;
                    String s = TextUtils.trimLeadingChar(token[1], '&');
                    s = TextUtils.trimLeadingChar(s, '*');
                    if (s.startsWith("operator") || token[0].startsWith("::")) {
                        procType = typeOrClassName + "::" + TextUtils.trimLeadingChar(token[0], ':');
                        className = "";
                        procName = s;
                        this.setBufferIndex(index);
                        off = this.charSearch(procName, true);
                        if (off != null) {
                            nameBeginOffset = off[0];
                            nameEndOffset = off[1];
                        }
                        this.setBufferIndex(offsetOfParenthesis);
                    } else {
                        return super.lpGrabProc(str);
                    }
                }
                case 3: {
                    int[] off;
                    if (!token[1].startsWith("<") || !token[1].endsWith(">")) break;
                    String ss = TextUtils.trimLeadingChar(token[2], '&');
                    if ((ss = TextUtils.trimLeadingChar(ss, '*')).startsWith("operator") || token[0].startsWith("::")) {
                        procType = typeOrClassName + "::" + TextUtils.trimLeadingChar(token[0], ':');
                        className = "";
                        procName = ss;
                        this.setBufferIndex(index);
                        off = this.charSearch(procName, true);
                        if (off != null) {
                            nameBeginOffset = off[0];
                            nameEndOffset = off[1];
                        }
                        this.setBufferIndex(offsetOfParenthesis);
                        break;
                    }
                    return super.lpGrabProc(str);
                }
            }
        }
        if ((ptext = this.lpGrabProcParams("(", ")")) == null) {
            Cutter.setLog("    Info: CppTokenizer.lpGrabProc() cannot grab ( ) at " + this.getBufferIndex());
            this.setBufferIndex(index);
            return null;
        }
        index = this.getBufferIndex();
        str = this.getNextStr();
        if (!str.equals("const")) {
            this.setBufferIndex(index);
        }
        if ((openCurlyOffset = this.findForward(index, '{')) == -1) {
            Cutter.setLog("    Info: CppTokenizer.lpGrabProc() cannot find proc body at " + this.getBufferIndex());
            this.setBufferIndex(this.getBufferIndex());
            return null;
        }
        this.setBufferIndex(openCurlyOffset);
        int[] offsets = this.lpGrabProcBody("{", "}", null);
        if (offsets == null) {
            Cutter.setLog("    CppTokenizer.lpGrabProc() cannot grab { } at " + this.getBufferIndex());
            this.setBufferIndex(index);
            return null;
        }
        out.procOffset[0] = offsets == null ? 0 : (typeOrClassNameOffset != -1 ? typeOrClassNameOffset : nameBeginOffset);
        out.procOffset[1] = offsets == null ? 0 : offsets[1];
        out.procName = TextUtils.trimLeadingChar(procName, ':');
        if (out.procName.startsWith("operator")) {
            out.procName = "operator " + out.procName.substring(8);
        } else if (className != null && !className.equals("")) {
            out.procName = className + "::" + out.procName;
        }
        out.procNameOffset = new int[2];
        out.procNameOffset[1] = nameEndOffset;
        out.procNameOffset[0] = nameBeginOffset;
        return out;
    }

    static {
        language = new Hashtable();
        try {
            CPPLanguageRes = ResourceBundle.getBundle("UI_Script.Cpp.CPPLanguageRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Errr: CppTokenizer = " + mre);
        }
        CppTokenizer.initHashTable();
    }
}

